// full size=1368x684
// test size= 456x228
#version 3.0;                   // Change to 3.0 mode

#include "colors.inc"
#include "woods.inc"
camera
{
	right<2.25,0,0>
	location  <-10, 28.0,  -35.0>
	look_at   <-35.0, -3.0,  23.0>
//	translate <-13,3,2>
//	translate <-8,18,-15>
//	orthographic
//	translate <0,8,-10>
}

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
//  <2, 0, 1> <0, 2, 1/2> // lights spread out across this distance (x * z)
  <1.5, 0, .75> <0, 1.5, .75/2> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3... 
  jitter              // adds random softening of light
//  translate <7, 15, -10>   // <x y z> position of light
  translate <17, 15, -7>   // <x y z> position of light
}

#declare hearthalf=
difference{
	prism {
		linear_sweep // or conic_sweep for tapering to a point
		cubic_spline // linear_spline | quadratic_spline | cubic_spline
		-3,1,12,
		<0,0>,<0,1>,<0,3>,<.8,4.5>,<3,5>,<5.25,4.25>,
		<6,1>,<4,-4>,<1,-7.25>,<0-.2,-8>,<0,1>,<0,0>
	//	scale<1,-1,1>
	}
	box{<-0.01,-2,-10>,<-2,2,10>}
}

#declare heart0=union{
	object{hearthalf}
	object{hearthalf scale<-1,1,1>}
}

#declare heart=intersection{
	object{heart0}
	prism{
		linear_sweep linear_spline -6,6 5
		<2,5.2><0.25,-9><-.25,-9><-2,5.2><2,5.2>
		rotate<0,0,90> translate<0,-1,0>
	}
}

#declare blood=blob{
			threshold 0.6
			// drip from top of hole
			sphere{<0,0,0>,1,2 scale<2,1,1> translate<3.2,4,.5>}
			sphere{<0,0,0>,1,1 scale<1,1,1> translate<3.2,3,.5>}
			sphere{<0,0,0>,1,1.5 scale<1,1.25,1> translate<3.5,1.75,.5>}
			
			// drip from bottom of hole
			sphere{<0,0,0>,1,1 scale<1,2,2> translate<3.2,-2,0.25>}
			sphere{<0,0,0>,1,.75 scale<1,1,1> translate<3.0,-4.25,0.2>}
			sphere{<0,0,0>,1,1 scale<1,1.5,1> translate<3.2,-5.25,0.25>}
			
			// pool on floor
			sphere{<0,0,0>,1,1 scale<3,1,5> translate<4,-9+.25,0>}
			sphere{<0,0,0>,1,1 scale<2,1,2> translate<3,-9 +.25,1>}
			sphere{<0,0,0>,1,1 scale<1,1,3> translate<3.8,-9 +.25,-3>}

		pigment{
			gradient y
			color_map{
				[0 color <.75,0,.15,.25>]
				[1/8 color <1,.5,0,.25>]
				[2/8 color <1,1,0,.25>]
				[3/8 color <0,1,0,.25>]
				[4/8 color <0,0,1,.25>]
				[5/8 color <.25,0,.75,.25>]
				[6/8 color <.5,0,1,.25>]
		//		[1 color <0,0.25,1,.25>]
				[1 color <0,0,1>]
			}
			scale<1,13,1> translate<0,4-.25,0>
			turbulence .1
		}
		rotate<0,-13,0>
		translate<0,8,0>
	normal{bumps .75 scale .4}
	finish{specular .5 roughness .1 ambient .25}
}

union{
difference{
	object{heart rotate<-90,0,0>}
	union{
		//object{heart scale .95 rotate<-90,0,0> pigment{color<0.23,0.15,0.35>}}
	//	object{heart scale .5 rotate<-90,0,0> translate<2,0,-.5> pigment{color<0.23,0.15,0.35>}
		object{heart0 scale .5 rotate<-90,0,0> scale<1,1,2> translate<3.2,2,0> pigment{color<0,0,0.25>}
		normal{bumps 1 scale .2}}
	}
//	pigment{color<1,0,0>}
	pigment{
		gradient y
		color_map{
			[0.5 color rgbt<1,0,0,0>]
			[.75 color rgbt<.9,.9,.95,0>]
//			[1	 color rgbt<.9,.9,.95,.9>]
		}
		scale 15 translate<0,-9,0>
	}
	rotate<0,-13,0>
	translate<0,8,0>
	normal{bumps .25 scale 1}
}

object{blood}
rotate<0,-20,0>
}


//plane{<0,1,0>,0 pigment{color<0,1,1>}}
plane{<0,1,0>,-.75 
	texture{T_Wood14 scale <8,4,4> rotate<8,12,32> finish{ambient .25}}
}