//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 1 lights, 25 materials and 433 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 10/30/2006    (30.10.2006)
//


//Start of MorayPOV.inc 

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

//End of MorayPOV.inc 


/* // Scene Comment

Where is the light
Author: Daniel Volk
Created: 09/2006

Submission to the Internet Raytracing Competition irtc.org (round: September-October 2006 - topic: Absence)


*/ // End Scene Comment


// Scene Includes

#include "dv_light-ext_materials.inc"
#include "dv_light-ext_objects.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <0.0,0.0,0.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 5
  number_of_waves 10
  noise_generator 2
  charset ascii
  radiosity {
    brightness       1.0
    count            60
    error_bound      1.8
    gray_threshold   0.0
    low_error_factor 0.5
    minimum_reuse    0.015
    nearest_count    10
    recursion_limit  5
    #if (version>3.1)
      adc_bailout      0.01
      max_sample       -1.0
      media            on
      normal           on
      always_sample    1

      pretrace_start   0.08
      pretrace_end     0.002
    #end
  }
}

background { color <0.800,0.898,0.898> }

camera {  //  Camera Camera01
  location  <     80.946,      -7.234,       8.444>
  sky       <    0.00473,     0.05192,     0.99864> // Use right handed-system (rotated by 3.00 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <      1.819,       0.157,      15.409>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.1000
  media_attenuation on
  photons {
  }
  translate  <516.0004, -212.0166, 614.2369>
}


//
// ********  MATERIALS  *******
//

#include "dv_light.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr083 = object {
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 10.0>
    rotate 90.0*y
    translate  -5.0*x
    translate  9.140126*z
  }
}
#declare Cylndr086 = object {
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 10.0>
    rotate 90.0*y
    translate  -5.0*x
    rotate -30.0*z
    translate  13.4*z
  }
}
#declare Cylndr089 = object {
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 10.0>
    rotate 90.0*y
    translate  -5.0*x
    translate  17.930155*z
  }
}
#declare Cylndr092 = object {
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.5>
    rotate <-180.0, -90.0, 0.0>
    translate  -3.25*x
    material {
      Glass
    }
    translate  <0.0, 0.0, 9.14013>
  }
}
#declare Cylndr094 = object {
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.9>
    rotate <-180.0, -90.0, 0.0>
    translate  -2.95*x
    material {
      Glass
    }
    rotate -30.0*z
    translate  <0.0, 0.0, 13.4>
  }
}
#declare Cylndr096 = object {
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.6>
    rotate <-180.0, -90.0, 0.0>
    translate  -2.8*x
    material {
      Glass
    }
    translate  <0.0, 0.0, 17.93015>
  }
}
#declare Cylndr057 = object {
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 0.77>
    rotate 90.0*y
    translate  <-0.385, 0.0, 6.585>
  }
}
//
// Include file contains 'RotSweep002'
//
#include "dv_light.in1"
#declare RotSweep002 = object {
  RotSweep002_Raw
  translate  20.2*z
}
//
// Include file contains 'RotSweep003'
//
#include "dv_light.in2"
#declare RotSweep003 = object {
  RotSweep003_Raw
  translate  23.35*z
}
#declare CSG006 = difference {
  cylinder { // Hang1_Body
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 2.67>
    translate  <3.4, 0.0, -0.07>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.15>
    rotate 20.0*z
    translate  <3.970185, 0.208706, 1.0>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.15, 0.15>
    rotate -120.0*z
    translate  <3.701848, 0.536673, 1.5>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.15, 0.15>
    rotate -160.0*z
    translate  <3.970185, 0.178891, 1.5>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.15, 0.15>
    rotate -200.0*z
    translate  <3.970185, -0.238521, 1.5>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.15, 0.15>
    rotate -240.0*z
    translate  <3.672033, -0.536673, 1.5>
  }
  scale <1.0, 1.0, 1.15>
  translate  20.55*z
  material {
    MorayTrunkTopMaterial
    // Transform to parent space
  }
}
#declare CSG007 = union {
  object { CSG006 }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.2, 0.3, 0.15>
    rotate 20.0*z
    translate  <3.970185, 0.208706, 21.7>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.2, 0.15, 0.15>
    rotate -120.0*z
    translate  <3.701848, 0.536673, 22.2>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.2, 0.15, 0.15>
    rotate 120.0*z
    translate  <3.672033, -0.536673, 22.2>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.2, 0.15, 0.15>
    rotate 160.0*z
    translate  <3.970185, -0.238521, 22.2>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.2, 0.15, 0.15>
    rotate -160.0*z
    translate  <3.970185, 0.178891, 22.2>
  }
  scale <1.111111, 1.111111, 1.0>
  translate  -3.777778*x
}
#declare RotSweep007 = lathe {
  cubic_spline
  8  // control points
  <0.907359, 0.008393>,
  <1.010908, 0.01>,
  <1.028523, 0.023231>,
  <1.015604, 0.03265>,
  <1.006834, 0.049343>,
  <1.007462, 0.103836>,
  <1.099555, 0.15>,
  <1.229567, 0.150323>
  rotate <90,0,90>
  translate  20.2*z
}
#declare Hang1 = union {
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.1, 0.1, 0.07>
    translate  18.7*z
  }
  object { RotSweep002 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.05>
    translate  20.2*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.1>
    translate  20.35*z
  }
  torus { // Torus001
    1.1, 0.01  rotate -x*90
    translate  20.46*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <1.35, 1.35, 0.3>
    translate  23.65*z
  }
  object { RotSweep003 }
  torus { // Torus003
    1.0, 0.05  rotate -x*90
    translate  23.3*z
  }
  cylinder { // Floor1
    <0,0,1>, <0,0,0>, 1 
    material {
      TopFloor
    }
    scale <1.2, 1.2, 0.05>
    translate  23.95*z
  }
  object { CSG007 }
  cylinder { // Floor2
    <0,0,1>, <0,0,0>, 1 
    material {
      TopFloor
    }
    scale <1.4, 1.4, 0.00001>
    translate  23.95*z
  }
  object { RotSweep007 }
  scale <0.9, 0.9, 1.0>
  translate  3.4*x
  material {
    TrunkRed
  }
}
#declare WindowHole1 = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.4>
    translate  0.1*z
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    scale <1.0, 0.5, 0.5>
    translate  <0.5, 0.0, 0.5>
  }
  translate  2.45*x
  rotate -60.0*z
  translate  21.7*z
}
#declare CSG020 = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.4>
    translate  0.1*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    scale <1.0, 0.5, 0.5>
    translate  <0.5, 0.0, 0.5>
  }
}
#declare CSG019 = difference {
  object { CSG020 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.4, 0.35>
    translate  0.15*z
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    scale <1.1, 0.4, 0.4>
    translate  <0.55, 0.0, 0.5>
  }
}
#declare CSG022 = intersection {
  object { CSG019 }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <2.8, 2.8, 1.7>
    translate  <-2.299422, 0.0, -0.6>
  }
}
#declare WindowGlass1 = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 0.35>
    translate  0.15*z
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    scale <0.8, 0.4, 0.4>
    translate  <0.4, 0.0, 0.5>
  }
  material {
    Glass
  }
  translate  <0.058, 0.0, 0.0>
}
#declare Window1 = union {
  object { CSG022 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.35, 0.05>
    rotate -90.0*x
    translate  <-0.04108, 0.0, 0.1>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.45, 0.05>
    translate  <-0.041084, 0.0, 0.5>
  }
  object { WindowGlass1 }
  translate  2.37*x
  rotate -60.0*z
  translate  21.7*z
}
#declare Cube033 = object {
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.55>
    translate  <2.8, 0.5, 0.0>
    rotate -19.527182*z
    translate  0.55*z
  }
}
#declare Cube036 = object {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.55>
    translate  <2.8, -0.5, 0.0>
    rotate 19.52718*z
    translate  0.55*z
  }
}
#declare Cylndr020 = object {
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    translate  2.775*x
    scale <1.0, 1.0, 0.62>
    rotate -33.75*z
    translate  0.2*z
  }
}
#declare Cylndr031 = object {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    translate  2.775*x
    scale <1.0, 1.0, 0.95>
    rotate -37.5*z
    translate  0.1*z
  }
}
#declare Cylndr017 = object {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    translate  2.775*x
    scale <1.0, 1.0, 1.05>
    rotate -30.0*z
  }
}
#declare Cylndr033 = object {
  object { // Cylndr033 -> Cylndr031
    Cylndr031
    rotate -15.0*z
  }
}
#declare Cylndr034 = object {
  object { // Cylndr034 -> Cylndr033
    Cylndr033
    rotate -15.0*z
  }
}
#declare Cylndr027 = object {
  object { // Cylndr027 -> Cylndr020
    Cylndr020
    rotate -52.5*z
  }
}
#declare M_RailingPosts = union {
  object { Cylndr020 }
  object { Cylndr031 }
  object { Cylndr017 }
  object { // Cylndr018 -> Cylndr017
    Cylndr017
    rotate -30.0*z
    translate  0.0*z
  }
  object { // Cylndr019 -> Cylndr017
    Cylndr017
    rotate -60.0*z
    translate  0.0*z
  }
  object { // Cylndr032 -> Cylndr031
    Cylndr031
    rotate -7.5*z
  }
  object { Cylndr033 }
  object { Cylndr034 }
  object { // Cylndr035 -> Cylndr034
    Cylndr034
    rotate -7.5*z
  }
  object { // Cylndr036 -> Cylndr034
    Cylndr034
    rotate -15.0*z
  }
  object { // Cylndr021 -> Cylndr020
    Cylndr020
    rotate -7.5*z
  }
  object { // Cylndr022 -> Cylndr020
    Cylndr020
    rotate -15.0*z
  }
  object { // Cylndr023 -> Cylndr020
    Cylndr020
    rotate -22.5*z
  }
  object { // Cylndr024 -> Cylndr020
    Cylndr020
    rotate -30.0*z
  }
  object { // Cylndr025 -> Cylndr020
    Cylndr020
    rotate -37.5*z
  }
  object { // Cylndr026 -> Cylndr020
    Cylndr020
    rotate -45.0*z
  }
  object { Cylndr027 }
  object { // Cylndr053 -> Cylndr020
    Cylndr020
    rotate 7.5*z
  }
  object { // Cylndr054 -> Cylndr027
    Cylndr027
    rotate -7.5*z
  }
  object { // Cylndr125 -> Cylndr031
    Cylndr031
    rotate 15.0*z
  }
  object { // Cylndr130 -> Cylndr031
    Cylndr031
    rotate -60.0*z
  }
}
#declare Cylndr028 = object {
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    translate  0.875*x
    scale <1.0, 1.0, 1.05>
    rotate 90.0*z
  }
}
#declare Cylndr037 = object {
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    translate  0.875*x
    scale <1.0, 1.0, 0.62>
    rotate 78.75*z
    translate  0.2*z
  }
}
#declare Cylndr038 = object {
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    translate  0.875*x
    scale <1.0, 1.0, 0.95>
    rotate 67.75*z
    translate  0.1*z
  }
}
#declare Cylndr040 = object {
  object { // Cylndr040 -> Cylndr038
    Cylndr038
    rotate -45.0*z
  }
}
#declare Cylndr041 = object {
  object { // Cylndr041 -> Cylndr040
    Cylndr040
    rotate -45.0*z
  }
}
#declare Cylndr050 = object {
  object { // Cylndr050 -> Cylndr037
    Cylndr037
    rotate -157.5*z
  }
}
#declare O_RailingPosts = union {
  object { Cylndr028 }
  object { // Cylndr029 -> Cylndr028
    Cylndr028
    rotate -90.0*z
    translate  0.0*z
  }
  object { // Cylndr030 -> Cylndr028
    Cylndr028
    rotate 180.0*z
    translate  0.0*z
  }
  object { Cylndr037 }
  object { Cylndr038 }
  object { // Cylndr039 -> Cylndr038
    Cylndr038
    rotate -22.5*z
  }
  object { Cylndr040 }
  object { Cylndr041 }
  object { // Cylndr042 -> Cylndr040
    Cylndr040
    rotate -90.0*z
  }
  object { // Cylndr043 -> Cylndr041
    Cylndr041
    rotate -22.5*z
  }
  object { // Cylndr044 -> Cylndr037
    Cylndr037
    rotate -22.5*z
  }
  object { // Cylndr045 -> Cylndr037
    Cylndr037
    rotate -45.0*z
  }
  object { // Cylndr046 -> Cylndr037
    Cylndr037
    rotate -67.5*z
  }
  object { // Cylndr047 -> Cylndr037
    Cylndr037
    rotate -90.0*z
  }
  object { // Cylndr048 -> Cylndr037
    Cylndr037
    rotate -112.5*z
  }
  object { // Cylndr049 -> Cylndr037
    Cylndr037
    rotate -135.0*z
  }
  object { Cylndr050 }
  object { // Cylndr051 -> Cylndr050
    Cylndr050
    rotate -22.5*z
  }
  object { // Cylndr052 -> Cylndr037
    Cylndr037
    rotate 22.5*z
  }
  object { // Cylndr128 -> Cylndr038
    Cylndr038
    rotate -179.75*z
  }
  object { // Cylndr129 -> Cylndr038
    Cylndr038
    rotate 45.0*z
  }
  translate  3.4*x
}
#declare CSG002 = union {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.02>
    translate  0.8*z
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.02>
    translate  0.2*z
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.05>
    translate  1.0*z
  }
}
#declare CSG004 = difference {
  object { CSG002 }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.55>
    translate  <0.1, 0.2, 0.55>
    rotate 179.895996*z
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.55>
    translate  <0.1, -0.2, 0.55>
    rotate 82.204361*z
  }
  cone { // Cone003
    <0,0,0>, 0.36, <0,0,1>, 0.18
    scale <1.0, 1.0, 0.15>
    translate  0.95*z
  }
}
#declare Cylndr126 = object {
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    scale <1.0, 1.0, 0.62>
    rotate -3.75*z
    translate  <-0.262259, 0.069897, 0.2>
  }
}
#declare CSG005 = union {
  object { Cylndr126 }
  object { // Cylndr127 -> Cylndr126
    Cylndr126
    translate  <0.22591, 0.199071, -0.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    scale <1.0, 1.0, 0.95>
    rotate -37.5*z
    translate  <-0.17653, 0.204256, 0.1>
  }
  rotate 6.090724*z
}
#declare RailingEdge = union {
  object { CSG004 }
  object { CSG005 }
  translate  3.05*x
  rotate -19.584999*z
}
#declare CSG008 = union {
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.02>
    translate  0.8*z
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.02>
    translate  0.2*z
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.05>
    translate  1.0*z
  }
}
#declare CSG009 = difference {
  object { CSG008 }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.55>
    translate  <0.1, 0.2, 0.55>
    rotate -82.204361*z
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.55>
    translate  <0.1, -0.2, 0.55>
    rotate 179.895996*z
  }
  cone { // Cone006
    <0,0,0>, 0.36, <0,0,1>, 0.18
    scale <1.0, 1.0, 0.15>
    translate  0.95*z
  }
}
#declare CSG010 = union {
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    scale <1.0, 1.0, 0.95>
    rotate -37.5*z
    translate  <-0.17653, 0.204256, 0.1>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    scale <1.0, 1.0, 0.62>
    rotate -3.75*z
    translate  <-0.262259, 0.069897, 0.2>
  }
  object { // Cylndr133 -> Cylndr126
    Cylndr126
    translate  <0.22591, 0.199071, -0.0>
  }
  rotate 92.614555*z
}
#declare RailingEdge1 = union {
  object { CSG009 }
  object { CSG010 }
  translate  3.05*x
  rotate 19.584999*z
}
#declare BezPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.003127, -0.000057, -0.004153>, <-0.001032, -0.000057, -0.001384>, <0.001064, -0.000057, 0.001384>, <0.003159, -0.000057, 0.004153>, 
      <-0.032932, 0.047035, -0.016269>, <-0.010712, 0.047035, -0.005423>, <0.011507, 0.047035, 0.005423>, <0.033726, 0.047035, 0.016269>, 
      <-0.009467, 0.147339, -0.003487>, <-0.003145, 0.147339, -0.001162>, <0.003177, 0.147339, 0.001162>, <0.009499, 0.147339, 0.003487>, 
      <-0.000203, 0.298505, 0.000000>, <-0.000057, 0.298505, 0.000000>, <0.000089, 0.298505, 0.000000>, <0.000235, 0.298505, 0.000000>
    }
  }
  material {
    Black
  }
  rotate -120.330956*x
  translate  -0.08*x
}
#declare TransSweep051 = prism {
  linear_sweep
  linear_spline
  -0.65,-0.35
  7  // control points
  <-0.25, -0.3>,
  <0.25, -0.3>,
  <0.5, -0.1>,
  <0.5, 0.0>,
  <-0.5, -0.0>,
  <-0.5, -0.1>,
  <-0.25, -0.3>
  rotate -x*90
  rotate 90.0*x
  translate  0.5*y
}
#declare CSG034 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.3>
    translate  -0.4*x
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 0.3>
    translate  0.4*x
  }
  object { TransSweep051 }
  translate  3.5*z
}
#declare Cylndr084 = object {
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    translate  1.7*x
    scale <1.0, 1.0, 1.1>
    rotate 30.0*z
    translate  1.95*z
  }
}
#declare TransSweep019 = prism {
  linear_sweep
  cubic_spline
  -0.04,0.0
  11  // control points
  <2.030148, 0.343188>,
  <1.991208, 0.204978>,
  <1.971508, -0.022728>,
  <2.01175, -0.00792>,
  <2.029152, 0.208106>,
  <2.063848, 0.326896>,
  <2.118819, 0.403634>,
  <2.094513, 0.419725>,
  <2.030148, 0.343188>,
  <1.991208, 0.204978>,
  <1.971508, -0.022728>
  rotate -x*90
  rotate 90.0*x
  translate  0.02*y
}
#declare TransSweep003 = prism {
  linear_sweep
  cubic_spline
  -0.08,0.0
  11  // control points
  <1.7, 0.0>,
  <1.698196, -0.050499>,
  <1.7, -0.15>,
  <1.762936, -0.136336>,
  <1.806107, -0.060971>,
  <1.999933, -0.041149>,
  <1.999933, 0.013063>,
  <1.949967, -0.001011>,
  <1.7, 0.0>,
  <1.698196, -0.050499>,
  <1.7, -0.15>
  rotate -x*90
  rotate 90.0*x
  translate  0.04*y
}
#declare Cylndr134 = object {
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <2.02, 1.73, 0.05>
    rotate 90.0*y
    translate  -0.015*x
  }
}
#declare Cylndr106 = object {
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate 90.0*y
    scale <1.75, 1.0, 1.0>
    translate  <1.7, -1.342339, 0.39423>
  }
}
#declare Cylndr113 = object {
  object { // Cylndr113 -> Cylndr106
    Cylndr106
    translate  2.68468*y
  }
}
#declare TransSweep020 = prism {
  linear_sweep
  cubic_spline
  -0.04,0.0
  11  // control points
  <2.0303, 0.343188>,
  <1.99136, 0.204978>,
  <1.97166, -0.022728>,
  <2.011902, -0.00792>,
  <2.029304, 0.208106>,
  <2.064, 0.326896>,
  <2.118971, 0.403634>,
  <2.094665, 0.419725>,
  <2.0303, 0.343188>,
  <1.99136, 0.204978>,
  <1.97166, -0.022728>
  rotate -x*90
  rotate 90.0*x
  translate  0.02*y
  rotate -60.0*z
}
#declare TransSweep015 = prism {
  linear_sweep
  cubic_spline
  -0.08,0.0
  11  // control points
  <1.7, 0.0>,
  <1.698196, -0.050499>,
  <1.7, -0.15>,
  <1.762025, -0.138012>,
  <1.817652, -0.053471>,
  <1.999725, -0.041149>,
  <1.999725, 0.013063>,
  <1.949758, -0.001011>,
  <1.7, 0.0>,
  <1.698196, -0.050499>,
  <1.7, -0.15>
  rotate -x*90
  rotate 90.0*x
  translate  0.04*y
  rotate -60.0*z
}
#declare Cylndr161 = object {
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <1.81, 1.71, 0.03>
    rotate 90.0*y
    translate  -0.015*x
  }
}
#declare Cylndr136 = object {
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 0.6>
    rotate 90.0*y
    translate  <-0.3, 0.0, 3.5>
  }
}
#declare Cylndr147 = object {
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 0.6>
    rotate 90.0*y
    translate  <-0.3, 0.0, 0.3>
  }
}


#declare Cone011 = object {
  cone { // Cone011
    <0,0,0>, 0.2, <0,0,1>, 0.1
    scale <1.0, 1.0, 11.7>
    rotate -90.0*y
  }
}
#declare Group007 = union {
  object { Cone011 }
  object { // Cone012 -> Cone011
    Cone011
    scale <-1.0, 1.0, 1.0>
  }
  rotate -15.0*z
  translate  <0.0, -0.413843, 10.0>
}
#declare Group008 = object {
  object { // Group008 -> Group007
    Group007
    scale 0.9
    translate  <0.0, -0.041384, 10.0>
  }
}
#declare Group009 = object {
  object { // Group009 -> Group008
    Group008
    scale 0.9
    translate  <0.0, -0.004138, 10.0>
  }
}
#declare Group010 = object {
  object { // Group010 -> Group009
    Group009
    scale 0.9
    translate  <0.0, -0.000414, 10.0>
  }
}
#declare Group011 = object {
  object { // Group011 -> Group010
    Group010
    scale 0.9
    translate  <0.0, -0.000041, 10.0>
  }
}
#declare Cone013 = object {
  cone { // Cone013
    <0,0,0>, 0.2, <0,0,1>, 0.1
    scale <1.0, 1.0, 13.0>
    rotate -90.0*y
  }
}
#declare Group001 = union {
  object { Cone013 }
  object { // Cone014 -> Cone013
    Cone013
    scale -1.0
    rotate <-180.0, -0.0, 0.0>
    translate  0.0*x
  }
  rotate -15.0*z
  translate  <0.0, -0.4138, 10.0>
}
#declare Group002 = object {
  object { // Group002 -> Group001
    Group001
    scale 0.9
    translate  <0.0, -0.04138, 10.0>
  }
}
#declare Group003 = object {
  object { // Group003 -> Group002
    Group002
    scale 0.9
    translate  <0.0, -0.004138, 10.0>
  }
}
#declare Group004 = object {
  object { // Group004 -> Group003
    Group003
    scale 0.9
    translate  <0.0, -0.000414, 10.0>
  }
}
#declare Group005 = object {
  object { // Group005 -> Group004
    Group004
    scale 0.9
    translate  <0.0, -0.000041, 10.0>
  }
}
#declare Group006 = object {
  object { // Group006 -> Group005
    Group005
    scale 0.9
    translate  10.0*z
  }
}
#declare Group022 = object {
  object { // Group022 -> Group006
    Group006
    scale 0.9
    translate  10.0*z
  }
}
#declare Cone015 = object {
  cone { // Cone015
    <0,0,0>, 0.2, <0,0,1>, 0.1
    scale <1.0, 1.0, 11.7>
    rotate -90.0*y
  }
}
#declare Group012 = union {
  object { Cone015 }
  object { // Cone016 -> Cone015
    Cone015
    scale <-1.0, 1.0, 1.0>
  }
  rotate -15.0*z
  translate  <0.0, -0.413843, 10.0>
}
#declare Group013 = object {
  object { // Group013 -> Group012
    Group012
    scale 0.9
    translate  <0.0, -0.041384, 10.0>
  }
}
#declare Group014 = object {
  object { // Group014 -> Group013
    Group013
    scale 0.9
    rotate -0.0*z
    translate  <0.0, -0.004138, 10.0>
  }
}
#declare Group015 = object {
  object { // Group015 -> Group014
    Group014
    scale 0.9
    translate  <0.0, -0.000414, 10.0>
  }
}
#declare Group016 = object {
  object { // Group016 -> Group015
    Group015
    scale 0.9
    translate  <0.0, -0.000041, 10.0>
  }
}
#declare Cone018 = object {
  cone { // Cone018
    <0,0,0>, 0.2, <0,0,1>, 0.1
    scale <1.0, 1.0, 10.4>
    rotate -90.0*y
  }
}
#declare Group017 = union {
  object { Cone018 }
  object { // Cone019 -> Cone018
    Cone018
    scale <-1.0, 1.0, 1.0>
  }
  rotate -15.0*z
  translate  <0.0, -0.413843, 10.0>
}
#declare Group018 = object {
  object { // Group018 -> Group017
    Group017
    scale 0.9
    translate  <0.0, -0.041384, 10.0>
  }
}
#declare Group019 = object {
  object { // Group019 -> Group018
    Group018
    scale 0.9
    rotate -0.0*z
    translate  <0.0, -0.004138, 10.0>
  }
}
#declare Group020 = object {
  object { // Group020 -> Group019
    Group019
    scale 0.9
    translate  <0.0, -0.000414, 10.0>
  }
}
#declare BezPtch005 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.341921, -0.500000, -9.008015>, <-3.801931, -2.400325, -7.135761>, <3.738058, -2.400325, -7.135761>, <11.278048, -0.500000, -9.008015>, 
      <-11.341921, -2.557945, -4.771415>, <-3.801931, -4.148176, -4.771415>, <3.738058, -4.148176, -4.771415>, <11.278048, -2.557945, -4.771415>, 
      <-11.341921, -2.557945, -2.407070>, <-3.801931, -4.148176, -2.407070>, <3.738058, -4.148176, -2.407070>, <11.278048, -2.557945, -2.407070>, 
      <-11.341921, -0.500000, -0.042724>, <-3.801931, -0.500000, -0.042724>, <3.738058, -0.500000, -0.042724>, <11.278048, -0.500000, -0.042724>
    }
  }
  rotate -15.0*z
}
#declare BezPtch006 = object {
  object { // BezPtch006 -> BezPtch005
    BezPtch005
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch007 = object {
  object { // BezPtch007 -> BezPtch006
    BezPtch006
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch008 = object {
  object { // BezPtch008 -> BezPtch007
    BezPtch007
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch009 = object {
  object { // BezPtch009 -> BezPtch008
    BezPtch008
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch011 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.713792, -0.500000, -9.008015>, <-4.259222, -2.400325, -7.135761>, <4.195349, -2.400325, -7.135761>, <12.649919, -0.500000, -9.008015>, 
      <-12.713792, -2.557945, -4.771415>, <-4.259222, -4.148176, -4.771415>, <4.195349, -4.148176, -4.771415>, <12.649919, -2.557945, -4.771415>, 
      <-12.713792, -2.557945, -2.407070>, <-4.259222, -4.148176, -2.407070>, <4.195349, -4.148176, -2.407070>, <12.649919, -2.557945, -2.407070>, 
      <-12.713792, -0.500000, -0.042724>, <-4.259222, -0.500000, -0.042724>, <4.195349, -0.500000, -0.042724>, <12.649919, -0.500000, -0.042724>
    }
  }
  rotate -15.0*z
}
#declare BezPtch012 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.341921, -0.500000, -9.008015>, <-3.801931, -2.400325, -7.135761>, <3.738058, -2.400325, -7.135761>, <11.278048, -0.500000, -9.008015>, 
      <-11.341921, -2.557945, -4.771415>, <-3.801931, -4.148176, -4.771415>, <3.738058, -4.148176, -4.771415>, <11.278048, -2.557945, -4.771415>, 
      <-11.341921, -2.557945, -2.407070>, <-3.801931, -4.148176, -2.407070>, <3.738058, -4.148176, -2.407070>, <11.278048, -2.557945, -2.407070>, 
      <-11.341921, -0.500000, -0.042724>, <-3.801931, -0.500000, -0.042724>, <3.738058, -0.500000, -0.042724>, <11.278048, -0.500000, -0.042724>
    }
  }
  rotate -15.0*z
}
#declare BezPtch021 = object {
  object { // BezPtch021 -> BezPtch012
    BezPtch012
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch022 = object {
  object { // BezPtch022 -> BezPtch021
    BezPtch021
    scale 0.9
    rotate -0.0*z
    translate  9.0*z
  }
}
#declare BezPtch023 = object {
  object { // BezPtch023 -> BezPtch022
    BezPtch022
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch024 = object {
  object { // BezPtch024 -> BezPtch023
    BezPtch023
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch013 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.267289, -0.500000, -9.008015>, <-3.443721, -2.400325, -7.135761>, <3.379848, -2.400325, -7.135761>, <10.203416, -0.500000, -9.008015>, 
      <-10.267289, -2.557945, -4.771415>, <-3.443721, -4.148176, -4.771415>, <3.379848, -4.148176, -4.771415>, <10.203416, -2.557945, -4.771415>, 
      <-10.267289, -2.557945, -2.407070>, <-3.443721, -4.148176, -2.407070>, <3.379848, -4.148176, -2.407070>, <10.203416, -2.557945, -2.407070>, 
      <-10.267289, -0.500000, -0.042724>, <-3.443721, -0.500000, -0.042724>, <3.379848, -0.500000, -0.042724>, <10.203416, -0.500000, -0.042724>
    }
  }
  rotate -15.0*z
}
#declare BezPtch026 = object {
  object { // BezPtch026 -> BezPtch013
    BezPtch013
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch027 = object {
  object { // BezPtch027 -> BezPtch026
    BezPtch026
    scale 0.9
    rotate -0.0*z
    translate  9.0*z
  }
}
#declare BezPtch028 = object {
  object { // BezPtch028 -> BezPtch027
    BezPtch027
    scale 0.9
    translate  9.0*z
  }
}
#declare BezPtch030 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.143022, 10.308950, 16.646392>, <-5.268377, 6.298438, 13.601388>, <-5.268377, 2.934676, 10.646457>, <0.000000, 0.000416, 7.671728>, 
      <-2.572277, 7.155995, 26.670526>, <-5.575709, 3.196764, 22.362176>, <-6.926443, 1.125538, 20.735660>, <0.000000, 0.000416, 20.249870>, 
      <-0.503370, 4.662613, 34.798108>, <-4.299518, 2.321602, 32.921356>, <-5.114781, 0.776557, 32.672086>, <0.000000, 0.000416, 34.043684>, 
      <0.000000, 1.341507, 45.021177>, <0.000000, 0.911957, 46.077590>, <0.000000, 0.539359, 46.992558>, <0.000000, 0.000416, 48.537085>
    }
  }
  rotate <1.96455, -1.980289, 7.217426>
  translate  <-0.568466, -0.027076, -0.174632>
}
#declare BezPtch031 = object {
  object { // BezPtch031 -> BezPtch030
    BezPtch030
    rotate 15.657645*z
    translate  <-0.210735, -2.950291, 0.0>
  }
}
#declare BezPtch033 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -23.175177, 56.751921>, <0.000000, -22.856739, 54.678616>, <0.000000, -22.827012, 53.909055>, <0.000000, -22.797286, 53.139493>, 
      <0.000000, -27.640261, 53.530194>, <-6.994612, -31.230009, 51.101595>, <-6.994612, -30.826528, 48.087618>, <-6.994612, -30.213174, 43.763598>, 
      <0.000000, -34.991714, 48.225844>, <-6.994612, -37.514086, 46.343437>, <-6.994612, -35.037731, 41.713225>, <-6.994612, -32.561376, 37.083012>, 
      <0.000000, -45.352571, 40.750096>, <-5.423809, -40.689032, 36.528419>, <-8.070706, -36.385720, 35.097809>, <-8.834438, -30.468267, 33.667199>
    }
  }
}
#declare Canvas6 = union {
  object { BezPtch033 }
  object { // BezPtch034 -> BezPtch033
    BezPtch033
    translate  -7.0*z
  }
  object { // BezPtch035 -> BezPtch033
    BezPtch033
    translate  -14.0*z
  }
  material {
    Mat_Canvas
  }
}
#declare BezPtch004 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.000000, 0.000000, 10.000000>, <-11.616947, -0.000001, 2.907333>, <-11.266462, -0.000001, -3.585420>, <-10.920001, -0.000001, -10.000000>, 
      <-11.873228, 20.000000, 10.000000>, <-9.537531, 20.000000, 2.907333>, <-10.856968, 3.098701, 9.521710>, <-11.459814, 3.098701, -10.000000>, 
      <-12.340943, 30.000000, 10.000000>, <-7.476107, 30.000000, 2.907333>, <-10.856968, 8.959607, 9.521710>, <-2.001804, 3.425411, -10.000000>, 
      <0.000000, 30.000000, 10.000000>, <0.000000, 30.000000, 2.907333>, <0.000000, 8.959607, 9.521710>, <0.000000, 8.269758, -10.000000>
    }
  }
}
#declare BezPtch038 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.705394, -1.000000>, <0.000000, -0.908787, -0.333333>, <0.000000, -0.660853, 0.321470>, <0.000000, -1.000000, 1.000000>, 
      <0.121708, 0.207788, -1.000000>, <0.096917, 0.075512, -0.333333>, <-0.253176, -0.187669, 0.333333>, <-0.744211, -0.533937, 1.000000>, 
      <-0.907110, 0.689472, -1.000000>, <-0.855956, 0.609486, -0.314713>, <-0.895510, 0.501551, 0.334259>, <-0.955783, 0.481509, 1.000000>, 
      <-0.910000, 1.000000, -1.000000>, <-0.940030, 1.000000, -0.333333>, <-0.969968, 1.000000, 0.333333>, <-1.000000, 1.000000, 1.000000>
    }
  }
  translate  -1.0*y
  scale <12.0, 15.0, 10.0>
}


#declare Cone020 = object {
  cone { // Cone020
    <0,0,0>, 1.0, <0,0,1>, 0.986
    scale <0.473906, 0.47391, 0.04>
    rotate 90.0*y
    translate  0.38*x
  }
}
#declare Cone021 = object {
  cone { // Cone021
    <0,0,0>, 1.0, <0,0,1>, 0.967
    scale <0.42567, 0.42567, 0.04>
    rotate 90.0*y
    translate  0.58*x
  }
}
#declare Cone022 = object {
  cone { // Cone022
    <0,0,0>, 1.0, <0,0,1>, 0.94
    scale <0.377344, 0.37734, 0.04>
    rotate 90.0*y
    translate  0.7*x
  }
}




//
// ********  OBJECTS  *******
//

#declare HgtFld001 = object { 
  height_field {
    tga "waves_hf.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <3000.0, 4000.0, 5.0>
  rotate -50.0*z
  translate  <-4705.7004, -235.0374, 2.670527>
}
#declare Water = union {
  object { HgtFld001 }
  plane { // Plane001
    z,0
    translate  -10.0*z
  }
  material {
    MorayOceanMaterial
  }
}
#declare Ocean = union {
  plane { // DeepGround
    z,0
    material {
      Black
    }
    translate  -1000.0*z
  }
  object { Water }
}
union { // Environment
  object { Ocean }
  box { // Rain
    <-1, -1, -1>, <1, 1, 1>
    material {
      MorayRainMaterial
    }
    hollow
    scale <3000.0, 3000.0, 1000.0>
    translate  1000.0*z
  }
}


#declare TruncBody = lathe {
  cubic_spline
  7  // control points
  <5.903056, -3.175>,
  <4.603032, 1.5>,
  <3.567524, 6.175>,
  <3.184344, 10.85>,
  <2.9, 15.525>,
  <2.8, 20.2>,
  <2.8, 24.815>
  rotate <90,0,90>
}
#declare CSG011 = difference {
  object { TruncBody }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 3.3>
    translate  -4.0*y
    rotate <-11.0, -0.0, 30.0>
    translate  3.806607*z
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.9>
    translate  -3.3*y
    rotate <0.0, -0.0, 30.0>
    translate  8.65*z
  }
  object { Cylndr083 }
  object { // Cylndr085 -> Cylndr083
    Cylndr083
    rotate -120.0*z
  }
  object { Cylndr086 }
  object { // Cylndr087 -> Cylndr086
    Cylndr086
    rotate -60.0*z
  }
  object { // Cylndr088 -> Cylndr086
    Cylndr086
    rotate -120.0*z
  }
  object { Cylndr089 }
  object { // Cylndr090 -> Cylndr089
    Cylndr089
    rotate -60.0*z
  }
  object { // Cylndr091 -> Cylndr089
    Cylndr089
    rotate -120.0*z
  }
  material {
    MorayTrunkMaterial
  }
}
#declare Ladder = union {
  object { // Cylndr082 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -6.4>
  }
  object { // Cylndr058 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -0.4>
  }
  object { // Cylndr059 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -0.8>
  }
  object { // Cylndr060 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -1.2>
  }
  object { // Cylndr061 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -1.6>
  }
  object { // Cylndr062 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -2.0>
  }
  object { // Cylndr063 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -2.4>
  }
  object { // Cylndr064 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -2.8>
  }
  object { // Cylndr065 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -3.2>
  }
  object { // Cylndr066 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -3.6>
  }
  object { // Cylndr067 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -4.0>
  }
  object { // Cylndr076 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -4.4>
  }
  object { // Cylndr077 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -4.8>
  }
  object { // Cylndr078 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -5.2>
  }
  object { // Cylndr079 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -5.6>
  }
  object { // Cylndr080 -> Cylndr057
    Cylndr057
    rotate 0.0*y
    translate  <0.0, 0.0, -6.0>
  }
  object { Cylndr057 }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 6.6>
    translate  0.385*x
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 6.6>
    translate  -0.385*x
  }
  translate  -4.5*y
  material {
    BlackMaterial
  }
  rotate <-11.0, 0.0, 30.0>
  translate  0.408213*z
}
#declare RndCube003 = merge {
  sphere { <0.4500, 0.1500, 0.8500>, 0.0500 }
  sphere { <0.4500, -0.1500, 0.8500>, 0.0500 }
  sphere { <-0.4500, -0.1500, 0.8500>, 0.0500 }
  sphere { <-0.4500, 0.1500, 0.8500>, 0.0500 }
  sphere { <0.4500, 0.1500, -0.8500>, 0.0500 }
  sphere { <0.4500, -0.1500, -0.8500>, 0.0500 }
  sphere { <-0.4500, -0.1500, -0.8500>, 0.0500 }
  sphere { <-0.4500, 0.1500, -0.8500>, 0.0500 }
  cylinder { <0.4500, 0.1500, 0.8500>, <-0.4500, 0.1500, 0.8500>, 0.0500 }
  cylinder { <0.4500, -0.1500, 0.8500>, <-0.4500, -0.1500, 0.8500>, 0.0500 }
  cylinder { <0.4500, -0.1500, -0.8500>, <-0.4500, -0.1500, -0.8500>, 0.0500 }
  cylinder { <0.4500, 0.1500, -0.8500>, <-0.4500, 0.1500, -0.8500>, 0.0500 }
  cylinder { <0.4500, 0.1500, -0.8500>, <0.4500, 0.1500, 0.8500>, 0.0500 }
  cylinder { <0.4500, -0.1500, -0.8500>, <0.4500, -0.1500, 0.8500>, 0.0500 }
  cylinder { <-0.4500, -0.1500, -0.8500>, <-0.4500, -0.1500, 0.8500>, 0.0500 }
  cylinder { <-0.4500, 0.1500, -0.8500>, <-0.4500, 0.1500, 0.8500>, 0.0500 }
  cylinder { <0.4500, 0.1500, 0.8500>, <0.4500, -0.1500, 0.8500>, 0.0500 }
  cylinder { <0.4500, 0.1500, -0.8500>, <0.4500, -0.1500, -0.8500>, 0.0500 }
  cylinder { <-0.4500, 0.1500, -0.8500>, <-0.4500, -0.1500, -0.8500>, 0.0500 }
  cylinder { <-0.4500, 0.1500, 0.8500>, <-0.4500, -0.1500, 0.8500>, 0.0500 }
  box { <-0.4500, -0.1500, -0.9000> <0.4500, 0.1500, 0.9000> }
  box { <-0.4500, -0.2000, -0.8500> <0.4500, 0.2000, 0.8500> }
  box { <-0.5000, -0.1500, -0.8500> <0.5000, 0.1500, 0.8500> }
  translate  -2.95*y
  material {
    WhiteMaterial
  }
  rotate 30.0*z
  translate  8.65*z
}
#declare Socket = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9900, 0.9900, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1190, 0.1190, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.9800> translate 0.0100*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1090, 0.1090, 1.0200> translate -0.0000*z }
  }
  torus { 0.9900, 0.0100  rotate -x*90 translate  0.9900*z bounded_by { box { <-1.0002, -1.0002, 0.9798>, <1.0002, 1.0002, 1.0002> } } }
  torus { 0.9900, 0.0100  rotate -x*90 translate  0.0100*z bounded_by { box { <-1.0002, -1.0002, -0.0002>, <1.0002, 1.0002, 0.0202> } } }
  torus { 0.1190, 0.0100  rotate -x*90 translate  0.9900*z bounded_by { box { <-0.1292, -0.1292, 0.9798>, <0.1292, 0.1292, 1.0002> } } }
  torus { 0.1190, 0.0100  rotate -x*90 translate  0.0100*z bounded_by { box { <-0.1192, -0.1192, -0.0002>, <0.1192, 0.1192, 0.0102> } } }
  material {
    SocketBlack
  }
  scale <7.0, 7.0, 11.9>
  translate  -10.394*z
}
#declare Trunk = union {
  object { CSG011 }
  object { Cylndr092 }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    material {
      SocketBlack
    }
    scale <1.0, 1.0, 15.0>
    translate  4.236933*z
  }
  object { // Cylndr095 -> Cylndr092
    Cylndr092
    rotate -120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { Cylndr094 }
  object { Cylndr096 }
  object { // Cylndr097 -> Cylndr094
    Cylndr094
    rotate -60.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr098 -> Cylndr094
    Cylndr094
    rotate -120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr099 -> Cylndr096
    Cylndr096
    rotate -60.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr100 -> Cylndr096
    Cylndr096
    rotate -120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { Ladder }
  object { RndCube003 }
  object { Socket }
}
//
// Include file contains 'RotSweep004'
//
#include "dv_light.in3"
#declare RotSweep004 = object {
  RotSweep004_Raw
  translate  23.35*z
}
#declare TruncTopBody = difference {
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <2.8, 2.8, 3.1>
    translate  20.2*z
  }
  object { WindowHole1 }
  object { // WindowHole2 -> WindowHole1
    WindowHole1
    rotate -120.0*z
  }
  object { // WindowHole3 -> WindowHole1
    WindowHole1
    rotate 120.0*z
  }
  material {
    MorayTrunkTopMaterial
  }
}
#declare RotSweep001 = lathe {
  cubic_spline
  8  // control points
  <2.707804, 0.008393>,
  <2.811353, 0.01>,
  <2.828968, 0.023231>,
  <2.81605, 0.03265>,
  <2.807279, 0.049343>,
  <2.807907, 0.103836>,
  <2.9, 0.15>,
  <3.030012, 0.150323>
  rotate <90,0,90>
  translate  20.2*z
}
#declare TrunkTop = union {
  object { Hang1 }
  torus { // Torus002
    2.9, 0.01  rotate -x*90
    translate  20.46*z
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <2.9, 2.9, 0.1>
    translate  20.35*z
  }
  torus { // Torus004
    2.8, 0.05  rotate -x*90
    translate  23.3*z
  }
  object { RotSweep004 }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <3.15, 3.15, 0.3>
    translate  23.65*z
  }
  cylinder { // MainFloor
    <0,0,1>, <0,0,0>, 1 
    material {
      TopFloor
    }
    scale <3.0, 3.0, 0.05>
    translate  23.95*z
  }
  object { TruncTopBody }
  object { Window1 }
  object { // Window2 -> Window1
    Window1
    rotate -120.0*z
  }
  object { // Window3 -> Window1
    Window1
    rotate 120.0*z
  }
  object { // Hang2 -> Hang1
    Hang1
    rotate -120.0*z
  }
  object { // Hang3 -> Hang1
    Hang1
    rotate 120.0*z
  }
  cylinder { // MainFloor1
    <0,0,1>, <0,0,0>, 1 
    material {
      TopFloor
    }
    scale <3.2, 3.2, 0.00001>
    translate  23.95*z
  }
  object { RotSweep001 }
  cylinder { // Hang3_Body
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 2.67>
    translate  3.4*x
    rotate 120.0*z
    translate  20.48*z
  }
  material {
    TrunkRed
  }
}
#declare CSG031 = union {
  cone { // Cone001
    <0,0,0>, 2.75, <0,0,1>, 2.81
    scale <1.0, 1.0, 0.05>
    translate  1.0*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <2.8, 2.8, 0.02>
    translate  0.8*z
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <2.8, 2.8, 0.02>
    translate  0.2*z
  }
}
#declare M_Handrail = difference {
  object { CSG031 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <2.75, 2.75, 1.1>
  }
  object { Cube033 }
  object { Cube036 }
  object { // Cube037 -> Cube036
    Cube036
    rotate -120.0*z
  }
  object { // Cube044 -> Cube036
    Cube036
    rotate 119.999992*z
  }
  object { // Cube034 -> Cube033
    Cube033
    rotate -119.999992*z
  }
}
#declare Main_Railing = union {
  object { M_Handrail }
  object { M_RailingPosts }
  object { // CSG021 -> M_RailingPosts
    M_RailingPosts
    rotate -120.0*z
  }
  object { // CSG023 -> M_RailingPosts
    M_RailingPosts
    rotate -240.0*z
  }
}
#declare CSG003 = union {
  cone { // Cone007
    <0,0,0>, 0.85, <0,0,1>, 0.91
    scale <1.0, 1.0, 0.05>
    translate  1.0*z
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.02>
    translate  0.8*z
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.02>
    translate  0.2*z
  }
}
#declare O_Handrail1 = difference {
  object { CSG003 }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.85, 0.85, 1.1>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 0.55>
    translate  <0.4, 0.6, 0.55>
    rotate 152.672073*z
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 0.55>
    translate  <0.4, -0.6, 0.55>
    rotate -152.669998*z
  }
  translate  3.4*x
  rotate -120.0*z
}
#declare CSG001 = union {
  cone { // Cone002
    <0,0,0>, 0.85, <0,0,1>, 0.91
    scale <1.0, 1.0, 0.05>
    translate  1.0*z
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.02>
    translate  0.8*z
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.02>
    translate  0.2*z
  }
}
#declare O_Handrail = difference {
  object { CSG001 }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <0.85, 0.85, 1.1>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 0.55>
    translate  <0.4, 0.6, 0.55>
    rotate 152.672073*z
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 0.55>
    translate  <0.4, -0.6, 0.55>
    rotate -152.669998*z
  }
  translate  3.4*x
}
#declare Outer_Railing = union {
  object { O_Handrail1 }
  object { O_Handrail }
  object { O_RailingPosts }
  object { // CSG014 -> O_RailingPosts
    O_RailingPosts
    rotate -120.0*z
  }
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.024564, -0.046826>,
  <0.024564, 0.034628>,
  <-0.05689, 0.034628>,
  <0.006383, -0.040345>,
  <0.024564, -0.046826>
  rotate -x*90
  scale <1.0, 1.0, 0.005>
  rotate 90.0*x
  translate  <0.157861, 0.0, -0.038802>
}
#declare CSG033 = union {
  cone { // Cone008
    <0,0,0>, 0.02, <0,0,1>, 0.04
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.16>
    rotate 90.0*y
  }
  cone { // Cone009
    <0,0,0>, 0.0, <0,0,1>, 0.02
    scale <1.0, 1.0, 0.03>
    rotate -90.0*y
    translate  0.19*x
  }
  object { BezPtch001 }
  object { // BezPtch002 -> BezPtch001
    BezPtch001
    rotate -120.0*x
  }
  object { // BezPtch003 -> BezPtch001
    BezPtch001
    rotate 120.0*x
  }
  object { TransSweep001 }
  cone { // Cone010
    <0,0,0>, 0.005, <0,0,1>, 0.03
    material {
      Black
    }
    scale <1.0, 1.0, 0.05>
    rotate 90.0*y
    translate  -0.1*x
  }
  rotate 50.0*z
  translate  <4.225, 0.0, 3.8>
}
#declare CSG032 = union {
  object { CSG033 }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 3.8>
    translate  4.225*x
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.7>
    rotate <0.0, -117.0, 30.0>
    translate  <4.225, 0.0, 1.8>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.7>
    rotate <0.0, -117.0, -30.0>
    translate  <4.225, 0.0, 1.8>
  }
  material {
    Gray
  }
}
#declare Railing = union {
  object { Main_Railing }
  object { Outer_Railing }
  object { RailingEdge }
  object { RailingEdge1 }
  object { // RailingEdge2 -> RailingEdge1
    RailingEdge1
    rotate -120.0*z
  }
  object { // RailingEdge3 -> RailingEdge1
    RailingEdge1
    rotate 119.999992*z
  }
  object { // RailingEdge4 -> RailingEdge
    RailingEdge
    rotate -119.999992*z
  }
  object { CSG032 }
  material {
    RailingMat
  }
  translate  24.0*z
}
#declare RndCube001 = merge {
  sphere { <0.1500, 0.1500, 6.9000>, 0.1000 }
  sphere { <0.1500, -0.1500, 6.9000>, 0.1000 }
  sphere { <-0.1500, -0.1500, 6.9000>, 0.1000 }
  sphere { <-0.1500, 0.1500, 6.9000>, 0.1000 }
  sphere { <0.1500, 0.1500, -6.9000>, 0.1000 }
  sphere { <0.1500, -0.1500, -6.9000>, 0.1000 }
  sphere { <-0.1500, -0.1500, -6.9000>, 0.1000 }
  sphere { <-0.1500, 0.1500, -6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, 6.9000>, <-0.1500, 0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, -0.1500, 6.9000>, <-0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, -0.1500, -6.9000>, <-0.1500, -0.1500, -6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, -6.9000>, <-0.1500, 0.1500, -6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, -6.9000>, <0.1500, 0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, -0.1500, -6.9000>, <0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <-0.1500, -0.1500, -6.9000>, <-0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <-0.1500, 0.1500, -6.9000>, <-0.1500, 0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, 6.9000>, <0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, -6.9000>, <0.1500, -0.1500, -6.9000>, 0.1000 }
  cylinder { <-0.1500, 0.1500, -6.9000>, <-0.1500, -0.1500, -6.9000>, 0.1000 }
  cylinder { <-0.1500, 0.1500, 6.9000>, <-0.1500, -0.1500, 6.9000>, 0.1000 }
  box { <-0.1500, -0.1500, -7.0000> <0.1500, 0.1500, 7.0000> }
  box { <-0.1500, -0.2500, -6.9000> <0.1500, 0.2500, 6.9000> }
  box { <-0.2500, -0.1500, -6.9000> <0.2500, 0.1500, 6.9000> }
  translate  1.0*z
}
#declare Dolphin1 = union {
  object { CSG034 }
  object { // CSG035 -> CSG034
    CSG034
    translate  1.6*z
  }
  object { // CSG036 -> CSG034
    CSG034
    translate  3.2*z
  }
  object { RndCube001 }
  rotate 20.0*z
  translate  8.5*y
  rotate 10.0*z
}
#declare TransSweep052 = prism {
  linear_sweep
  linear_spline
  -0.65,-0.35
  7  // control points
  <-0.25, -0.3>,
  <0.25, -0.3>,
  <0.5, -0.1>,
  <0.5, 0.0>,
  <-0.5, -0.0>,
  <-0.5, -0.1>,
  <-0.25, -0.3>
  rotate -x*90
  rotate 90.0*x
  translate  0.5*y
}
#declare CSG037 = union {
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.3>
    translate  -0.4*x
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 open
    scale <0.1, 0.1, 0.3>
    translate  0.4*x
  }
  object { TransSweep052 }
  translate  3.5*z
}
#declare RndCube002 = merge {
  sphere { <0.1500, 0.1500, 6.9000>, 0.1000 }
  sphere { <0.1500, -0.1500, 6.9000>, 0.1000 }
  sphere { <-0.1500, -0.1500, 6.9000>, 0.1000 }
  sphere { <-0.1500, 0.1500, 6.9000>, 0.1000 }
  sphere { <0.1500, 0.1500, -6.9000>, 0.1000 }
  sphere { <0.1500, -0.1500, -6.9000>, 0.1000 }
  sphere { <-0.1500, -0.1500, -6.9000>, 0.1000 }
  sphere { <-0.1500, 0.1500, -6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, 6.9000>, <-0.1500, 0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, -0.1500, 6.9000>, <-0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, -0.1500, -6.9000>, <-0.1500, -0.1500, -6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, -6.9000>, <-0.1500, 0.1500, -6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, -6.9000>, <0.1500, 0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, -0.1500, -6.9000>, <0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <-0.1500, -0.1500, -6.9000>, <-0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <-0.1500, 0.1500, -6.9000>, <-0.1500, 0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, 6.9000>, <0.1500, -0.1500, 6.9000>, 0.1000 }
  cylinder { <0.1500, 0.1500, -6.9000>, <0.1500, -0.1500, -6.9000>, 0.1000 }
  cylinder { <-0.1500, 0.1500, -6.9000>, <-0.1500, -0.1500, -6.9000>, 0.1000 }
  cylinder { <-0.1500, 0.1500, 6.9000>, <-0.1500, -0.1500, 6.9000>, 0.1000 }
  box { <-0.1500, -0.1500, -7.0000> <0.1500, 0.1500, 7.0000> }
  box { <-0.1500, -0.2500, -6.9000> <0.1500, 0.2500, 6.9000> }
  box { <-0.2500, -0.1500, -6.9000> <0.2500, 0.1500, 6.9000> }
  translate  1.0*z
}
#declare Dolphin2 = union {
  object { CSG037 }
  object { // CSG038 -> CSG034
    CSG034
    translate  1.6*z
  }
  object { // CSG039 -> CSG034
    CSG034
    translate  3.2*z
  }
  object { RndCube002 }
  rotate -20.0*z
  translate  8.5*y
  rotate 50.0*z
}
#declare Dolphins = union {
  object { Dolphin1 }
  object { Dolphin2 }
  material {
    BlackMaterial
  }
}
#declare CSG015 = difference {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.7, 1.7, 3.5>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <2.0, 1.0, 0.55>
    rotate 60.0*z
    translate  <0.843023, -0.535273, 2.5>
  }
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-1.47224, -0.85>,
  <-0.85, -1.47224>,
  <0.0, -1.7>,
  <0.85, -1.47224>,
  <1.47224, -0.85>,
  <1.7, 0.0>,
  <1.69, 0.0>,
  <1.46358, -0.845>,
  <0.845, -1.46358>,
  <0.0, -1.69>,
  <-0.845, -1.46358>,
  <-1.46358, -0.845>,
  <-1.69, 0.0>,
  <-1.7, 0.0>,
  <-1.47224, -0.85>
  rotate -x*90
  material {
    Glass
  }
  scale <1.0, 1.0, 1.1>
  rotate 60.0*z
  translate  1.95*z
}
#declare Main_light = union {
  object { CSG015 }
  object { TransSweep002 }
  object { Cylndr084 }
  object { // Cylndr102 -> Cylndr084
    Cylndr084
    rotate -60.0*z
  }
  object { // Cylndr103 -> Cylndr084
    Cylndr084
    rotate -90.0*z
  }
  object { // Cylndr105 -> Cylndr084
    Cylndr084
    rotate -120.0*z
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.9>
    scale <1.0, 1.0, 1.5>
    rotate <-33.968327, 1.989805, -11.79139>
    translate  <1.493826, -0.780861, 1.939675>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.9>
    scale <1.0, 1.0, 1.5>
    rotate <24.007307, 25.010595, -28.64397>
    translate  <1.493778, 0.782464, 1.939675>
  }
  material {
    WhiteMaterial
  }
  translate  24.0*z
}
#declare CSG016 = difference {
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <2.7, 2.7, 1.85>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 1.1>
    translate  <-2.0, 0.0, 1.0>
    rotate 36.754257*z
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 1.1>
    translate  <0.0, 2.0, 1.0>
  }
  material {
    WhiteMaterial
  }
  rotate 0.0*z
}
#declare CSG030 = difference {
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 2.0>
    translate  3.4*x
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.5, 1.0, 0.4>
    translate  <3.9, 0.0, 1.5>
  }
  material {
    WhiteMaterial
  }
}
#declare TransSweep050 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-0.636396, -0.636396>,
  <0.0, -0.9>,
  <0.636396, -0.636396>,
  <0.9, 0.0>,
  <0.89, 0.0>,
  <0.629325, -0.629325>,
  <0.0, -0.89>,
  <-0.629325, -0.629325>,
  <-0.89, 0.0>,
  <-0.9, 0.0>,
  <-0.636396, -0.636396>
  rotate -x*90
  material {
    Glass
  }
  scale <1.0, 1.0, 0.8>
  rotate 90.0*z
  translate  <3.4, 0.0, 1.1>
}
#declare Small_light = union {
  object { CSG016 }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      WhiteMaterial
    }
    scale <1.0, 0.5, 1.0>
    translate  <2.0, 0.0, 1.0>
  }
  object { CSG030 }
  object { TransSweep050 }
  rotate 120.0*z
  translate  24.0*z
}
#declare MainLatice = union {
  torus { // Torus012
    2.0, 0.01  rotate -x*90
    translate  0.01*z
  }
  torus { // Torus009
    2.0, 0.01  rotate -x*90
    translate  0.112615*z
  }
  object { // TransSweep046 -> TransSweep019
    TransSweep019
    rotate 30.0*z
  }
  object { // TransSweep045 -> TransSweep019
    TransSweep019
    rotate 60.0*z
  }
  object { // TransSweep044 -> TransSweep019
    TransSweep019
    rotate 90.0*z
  }
  object { // TransSweep043 -> TransSweep019
    TransSweep019
    rotate 120.0*z
  }
  object { // TransSweep042 -> TransSweep019
    TransSweep019
    rotate 150.0*z
  }
  object { // TransSweep041 -> TransSweep019
    TransSweep019
    rotate 180.0*z
  }
  object { // TransSweep040 -> TransSweep019
    TransSweep019
    rotate -150.0*z
  }
  object { // TransSweep039 -> TransSweep019
    TransSweep019
    rotate -120.0*z
  }
  object { // TransSweep038 -> TransSweep019
    TransSweep019
    rotate -90.0*z
  }
  object { // TransSweep037 -> TransSweep019
    TransSweep019
    rotate -60.0*z
  }
  object { // TransSweep036 -> TransSweep019
    TransSweep019
    rotate -30.0*z
  }
  object { // TransSweep014 -> TransSweep003
    TransSweep003
    rotate 30.0*z
  }
  object { // TransSweep013 -> TransSweep003
    TransSweep003
    rotate 60.0*z
  }
  object { // TransSweep012 -> TransSweep003
    TransSweep003
    rotate 90.0*z
  }
  object { // TransSweep011 -> TransSweep003
    TransSweep003
    rotate 120.0*z
  }
  object { // TransSweep010 -> TransSweep003
    TransSweep003
    rotate 150.0*z
  }
  object { // TransSweep009 -> TransSweep003
    TransSweep003
    rotate 180.0*z
  }
  object { // TransSweep008 -> TransSweep003
    TransSweep003
    rotate -150.0*z
  }
  object { // TransSweep007 -> TransSweep003
    TransSweep003
    rotate -120.0*z
  }
  object { // TransSweep006 -> TransSweep003
    TransSweep003
    rotate -90.0*z
  }
  object { // TransSweep005 -> TransSweep003
    TransSweep003
    rotate -60.0*z
  }
  object { // TransSweep004 -> TransSweep003
    TransSweep003
    rotate -30.0*z
  }
  torus { // Torus008
    2.0, 0.01  rotate -x*90
    translate  0.210453*z
  }
  torus { // Torus007
    2.03, 0.01  rotate -x*90
    translate  0.312733*z
  }
  object { TransSweep019 }
  object { TransSweep003 }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      MorayLatticeMaterial
    }
    scale <2.0, 2.0, 0.02>
  }
  torus { // Torus005
    2.1, 0.01  rotate -x*90
    translate  0.39423*z
  }
}
#declare CSG012 = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale <1.7, 1.7, 2.0>
  }
  object { Cylndr134 }
  object { // Cylndr135 -> Cylndr134
    Cylndr134
    rotate <-0.0, 0.0, -30.0>
    translate  <-0.00134, -0.005, -0.0>
  }
  object { // Cylndr157 -> Cylndr134
    Cylndr134
    rotate <0.0, 0.0, -60.0>
    translate  <-0.005, -0.00866, -0.0>
  }
  object { // Cylndr158 -> Cylndr134
    Cylndr134
    rotate <0.0, 0.0, -90.0>
    translate  <-0.01, -0.01, -0.0>
  }
  object { // Cylndr159 -> Cylndr134
    Cylndr134
    rotate <0.0, 0.0, -120.0>
    translate  <-0.015, -0.00866, -0.0>
  }
  object { // Cylndr160 -> Cylndr134
    Cylndr134
    rotate <0.0, 0.0, -150.0>
    translate  <-0.01866, -0.005, -0.0>
  }
}
#declare CSG017 = difference {
  object { CSG012 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 1.8, 1.0>
    translate  -1.0*z
  }
}
//
// Include file contains 'RotSweep005'
//
#include "dv_light.in4"
#declare RotSweep005 = object {
  RotSweep005_Raw
  scale 2.0
  translate  1.962558*z
}
#declare MainRoof = union {
  object { MainLatice }
  object { CSG017 }
  object { RotSweep005 }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.3
    translate  2.528508*z
  }
  cone { // Cone004
    <0,0,0>, 0.01, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.5>
    translate  2.755448*z
  }
  material {
    MorayRoofMaterial
  }
  translate  27.5*z
}
#declare CSG028 = union {
  torus { // Torus017
    0.2, 0.01  rotate -x*90
    translate  <1.704235, -1.541822, 0.132179>
  }
  torus { // Torus018
    0.28, 0.01  rotate -x*90
    rotate <0.0, 0.0, -0.0>
    translate  <1.702543, -1.557427, 0.012616>
  }
  torus { // Torus019
    0.3, 0.01  rotate -x*90
    rotate <0.0, 0.0, -0.0>
    translate  <1.699375, -1.546523, -0.129374>
  }
  translate  <0.002696, 0.000722, -0.0>
}
#declare CSG029 = difference {
  object { CSG028 }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 1.0>
    rotate -43.656952*z
    translate  <1.486127, -1.747081, 0.0>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 1.0>
    translate  <2.003152, -1.574254, 0.0>
  }
  scale <1.0, -1.0, 1.0>
  translate  <0.0, -0.0, 0.262077>
}
#declare CSG026 = union {
  torus { // Torus006
    2.1, 0.01  rotate -x*90
    scale 0.52941
    rotate <-0.0, -0.0, -60.0>
    translate  <-1.7, 2.944486, 26.208709>
  }
  torus { // Torus011
    2.0, 0.01  rotate -x*90
    scale 0.52941
    rotate <-0.0, -0.0, -60.0>
    translate  <-1.7, 2.944486, 26.070116>
  }
  torus { // Torus010
    2.03, 0.01  rotate -x*90
    scale 0.52941
    rotate <-0.0, -0.0, -60.0>
    translate  <-1.7, 2.944486, 26.144914>
  }
}
#declare CSG027 = difference {
  object { CSG026 }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    rotate <-0.0, 0.0, -13.91154>
    translate  <-1.430614, 1.79648, 26.255119>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    rotate <0.0, 0.0, 73.615891>
    translate  <-0.879785, 2.148438, 26.25512>
  }
  scale 1.888895
  rotate <0.0, 0.0, 60.0>
  translate  <6.422244, -0.0, -49.111274>
}
#declare CSG024 = union {
  torus { // Torus014
    0.2, 0.01  rotate -x*90
    translate  <1.704235, -1.541822, 0.132179>
  }
  torus { // Torus015
    0.28, 0.01  rotate -x*90
    rotate <0.0, 0.0, -0.0>
    translate  <1.702543, -1.557427, 0.012616>
  }
  torus { // Torus016
    0.3, 0.01  rotate -x*90
    rotate <0.0, 0.0, -0.0>
    translate  <1.699375, -1.546523, -0.129374>
  }
  translate  <0.002696, 0.000722, -0.0>
}
#declare CSG025 = difference {
  object { CSG024 }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 1.0>
    rotate -43.656952*z
    translate  <1.486127, -1.747081, 0.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 1.0>
    translate  <2.003152, -1.574254, 0.0>
  }
  translate  <0.0, -0.0, 0.262077>
}
#declare SmallLatice = union {
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate 90.0*y
    scale <1.8, 1.0, 1.0>
    translate  <1.588892, 1.2, 0.01>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate 90.0*y
    scale <1.8, 1.0, 1.0>
    translate  <1.588892, -1.2, 0.01>
  }
  object { // Cylndr115 -> Cylndr113
    Cylndr113
    translate  <0.0, -0.097, -0.26151>
  }
  object { // Cylndr114 -> Cylndr113
    Cylndr113
    translate  <0.0, -0.066, -0.11953>
  }
  object { Cylndr113 }
  object { // TransSweep049 -> TransSweep020
    TransSweep020
    rotate 135.0*z
    translate  <2.9, -0.7, 0.0>
  }
  object { // TransSweep048 -> TransSweep020
    TransSweep020
    rotate 150.0*z
    translate  <1.7, -0.75, 0.0>
  }
  object { // TransSweep035 -> TransSweep015
    TransSweep015
    rotate 150.0*z
    translate  <1.7, -0.75, 0.0>
  }
  object { // TransSweep047 -> TransSweep015
    TransSweep015
    rotate 135.0*z
    translate  <2.9, -0.7, 0.0>
  }
  object { CSG029 }
  object { CSG027 }
  object { CSG025 }
  object { // Cylndr112 -> Cylndr106
    Cylndr106
    translate  <0.0, 0.097, -0.261514>
  }
  object { // Cylndr111 -> Cylndr106
    Cylndr106
    translate  <-0.000053, 0.066, -0.11953>
  }
  object { Cylndr106 }
  object { // TransSweep034 -> TransSweep015
    TransSweep015
    rotate -15.0*z
    translate  <2.9, 0.7, 0.0>
  }
  object { // TransSweep033 -> TransSweep020
    TransSweep020
    rotate -15.0*z
    translate  <2.9, 0.7, 0.0>
  }
  object { // TransSweep024 -> TransSweep020
    TransSweep020
    rotate -30.0*z
    translate  <1.7, 0.75, 0.0>
  }
  object { // TransSweep032 -> TransSweep015
    TransSweep015
    rotate -30.0*z
    translate  <1.7, 0.75, 0.0>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      MorayLatticeMaterial
    }
    scale <1.5, 1.2, 0.01>
    translate  2.5*x
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <1.7, 0.95, 4.0>
    rotate 90.0*y
    translate  0.1*x
  }
  torus { // Torus013
    2.0, 0.01  rotate -x*90
    translate  <0.0, 0.0, 0.01>
  }
  object { // TransSweep031 -> TransSweep020
    TransSweep020
    rotate 70.0*z
  }
  object { // TransSweep030 -> TransSweep020
    TransSweep020
    rotate -240.0*z
  }
  object { // TransSweep029 -> TransSweep020
    TransSweep020
    rotate -200.0*z
  }
  object { // TransSweep028 -> TransSweep020
    TransSweep020
    rotate -160.0*z
  }
  object { // TransSweep027 -> TransSweep020
    TransSweep020
    rotate -120.0*z
  }
  object { // TransSweep026 -> TransSweep020
    TransSweep020
    rotate -80.0*z
  }
  object { // TransSweep025 -> TransSweep020
    TransSweep020
    rotate -40.0*z
  }
  object { // TransSweep023 -> TransSweep015
    TransSweep015
    rotate -120.0*z
  }
  object { // TransSweep022 -> TransSweep015
    TransSweep015
    rotate -240.0*z
  }
  object { // TransSweep021 -> TransSweep015
    TransSweep015
    rotate -200.0*z
  }
  object { // TransSweep018 -> TransSweep015
    TransSweep015
    rotate -160.0*z
  }
  object { // TransSweep017 -> TransSweep015
    TransSweep015
    rotate -80.0*z
  }
  object { // TransSweep016 -> TransSweep015
    TransSweep015
    rotate -40.0*z
  }
  object { TransSweep020 }
  object { TransSweep015 }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      MorayLatticeMaterial
    }
    scale <2.0, 2.0, 0.02>
  }
}
#declare CSG013 = union {
  sphere { // Sphere004
    <0,0,0>,1
    scale <1.7, 1.7, 1.8>
  }
  object { Cylndr161 }
  object { // Cylndr162 -> Cylndr161
    Cylndr161
    rotate <0.0, -0.0, -45.0>
    translate  <-0.004393, -0.010607, 0.0>
  }
  object { // Cylndr163 -> Cylndr161
    Cylndr161
    rotate <0.0, -0.0, -90.0>
    translate  <-0.015, -0.015, 0.0>
  }
  object { // Cylndr164 -> Cylndr161
    Cylndr161
    rotate <0.0, -0.0, -135.0>
    translate  <-0.025607, -0.010607, 0.0>
  }
  object { // Cylndr165 -> Cylndr161
    Cylndr161
    rotate <0.0, -0.0, 180.0>
    translate  <-0.03, 0.0, 0.0>
  }
}
#declare CSG018 = difference {
  object { CSG013 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 1.8, 1.0>
    translate  -1.0*z
  }
}
//
// Include file contains 'RotSweep006'
//
#include "dv_light.in5"
#declare RotSweep006 = object {
  RotSweep006_Raw
  scale 2.0
  translate  1.70106*z
}
#declare SmallRoof = union {
  object { SmallLatice }
  object { CSG018 }
  object { RotSweep006 }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.3
    translate  2.26701*z
  }
  cone { // Cone005
    <0,0,0>, 0.01, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.5>
    translate  2.49395*z
  }
  scale 0.52941
  translate  -3.4*x
  material {
    MorayRoofMaterial
  }
  rotate -60.0*z
  translate  26.0*z
}
#declare TopLadder = union {
  object { Cylndr136 }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 3.5>
    translate  0.3*x
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 3.5>
    translate  -0.3*x
  }
  object { // Cylndr139 -> Cylndr136
    Cylndr136
    translate  -0.3*z
  }
  object { // Cylndr140 -> Cylndr136
    Cylndr136
    translate  -0.6*z
  }
  object { // Cylndr141 -> Cylndr136
    Cylndr136
    translate  -0.9*z
  }
  object { // Cylndr142 -> Cylndr136
    Cylndr136
    translate  -1.2*z
  }
  object { // Cylndr143 -> Cylndr136
    Cylndr136
    translate  -1.5*z
  }
  object { // Cylndr144 -> Cylndr136
    Cylndr136
    translate  -1.8*z
  }
  object { // Cylndr145 -> Cylndr136
    Cylndr136
    translate  -2.1*z
  }
  object { // Cylndr146 -> Cylndr136
    Cylndr136
    translate  -2.4*z
  }
  object { // Cylndr150 -> Cylndr136
    Cylndr136
    translate  -2.7*z
  }
  object { // Cylndr151 -> Cylndr136
    Cylndr136
    translate  -3.0*z
  }
  object { // Cylndr152 -> Cylndr136
    Cylndr136
    translate  -3.3*z
  }
  translate  -2.7*y
  material {
    WhiteMaterial
  }
  rotate 150.0*z
  translate  24.0*z
}
#include "flag_p.inc"

#declare Flag_Ref = object {
  P_obj_1
  material {
    FlagMaterial
  }
  scale 0.15
  rotate -110.0*z
  translate  <-0.325, 0.0, 2.498184>
}
#declare TopLadder1 = union {
  object { Cylndr147 }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.8>
    translate  0.3*x
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.8>
    translate  -0.3*x
  }
  object { // Cylndr153 -> Cylndr147
    Cylndr147
    translate  0.3*z
  }
  object { // Cylndr154 -> Cylndr147
    Cylndr147
    translate  0.6*z
  }
  object { // Cylndr155 -> Cylndr147
    Cylndr147
    translate  0.9*z
  }
  object { // Cylndr156 -> Cylndr147
    Cylndr147
    translate  1.2*z
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.4>
    rotate <-90.0, 0.0, -20.0>
    translate  <0.3, 0.0, 0.045>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.4>
    rotate <-90.0, 0.0, 20.0>
    translate  <-0.3, 0.0, 0.045>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.4>
    rotate -90.0*x
    translate  <-0.3, 0.0, 1.2>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.2>
    translate  <-0.3, 1.0, 0.0>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    material {
      Gray
    }
    scale <0.025, 0.025, 4.3>
    translate  <-0.325, 0.0, -0.5>
  }
  object { Flag_Ref }
  translate  -2.7*y
  material {
    MorayRoofMaterial
  }
  rotate 150.0*z
  translate  27.5*z
}
#declare Top = union {
  object { Main_light }
  object { Small_light }
  object { MainRoof }
  object { SmallRoof }
  object { TopLadder }
  object { TopLadder1 }
}
union { // Lighthouse
  object { Trunk }
  object { TrunkTop }
  object { Railing }
  object { Dolphins }
  object { Top }
}




#declare Trunk1 = union {
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 50.0>
  }
  object { Group007 }
  object { Group008 }
  object { Group009 }
  object { Group010 }
  object { Group011 }
  object { // Group021 -> Group011
    Group011
    scale 0.9
    translate  <0.0, 0.0, 10.0>
  }
  material {
    Mat_RigTrunk
  }
  rotate -51.0*y
  translate  <0.0, -50.0, 10.0>
}
#declare Trunk2 = union {
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 60.0>
  }
  object { Group001 }
  object { Group002 }
  object { Group003 }
  object { Group004 }
  object { Group005 }
  object { Group006 }
  object { Group022 }
  object { // Group023 -> Group022
    Group022
    scale 0.9
    translate  10.0*z
  }
  material {
    Mat_RigTrunk
  }
  translate  <0.0, -16.666667, 10.0>
}
#declare Trunk3 = union {
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 50.0>
  }
  object { Group012 }
  object { Group013 }
  object { Group014 }
  object { Group015 }
  object { Group016 }
  object { // Group024 -> Group016
    Group016
    scale 0.9
    translate  <0.0, 0.0, 10.0>
  }
  material {
    Mat_RigTrunk
  }
  rotate <27.0, 10.0, 0.0>
  translate  <0.0, 16.666667, 10.0>
}
#declare Trunk4 = union {
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 45.0>
  }
  object { Group017 }
  object { Group018 }
  object { Group019 }
  object { Group020 }
  object { // Group025 -> Group020
    Group020
    scale 0.9
    translate  <0.0, -0.000041, 10.0>
  }
  material {
    Mat_RigTrunk
  }
  translate  <0.0, 50.0, 10.0>
}
#declare Canvas1 = union {
  object { BezPtch005 }
  object { BezPtch006 }
  object { BezPtch007 }
  object { BezPtch008 }
  object { BezPtch009 }
  object { // BezPtch010 -> BezPtch009
    BezPtch009
    scale 0.9
    translate  9.0*z
  }
  material {
    Mat_Canvas
  }
  rotate -51.0*y
  translate  <-7.136515, -49.715523, 16.103519>
}
#declare Canvas2 = union {
  object { BezPtch011 }
  object { // BezPtch014 -> BezPtch011
    BezPtch011
    scale 0.9
    translate  9.0*z
  }
  object { // BezPtch015 -> BezPtch011
    BezPtch011
    scale 0.81
    rotate -0.0*z
    translate  17.0*z
  }
  object { // BezPtch016 -> BezPtch011
    BezPtch011
    scale 0.729
    rotate -0.0*z
    translate  24.4*z
  }
  object { // BezPtch017 -> BezPtch011
    BezPtch011
    scale 0.6561
    translate  30.9*z
  }
  object { // BezPtch018 -> BezPtch011
    BezPtch011
    scale 0.59049
    rotate <-99.007469, 12.304833, -8.903891>
    translate  36.8*z
  }
  material {
    Mat_Canvas
  }
  translate  <0.0, -16.666667, 20.0>
}
#declare Canvas3 = union {
  object { BezPtch012 }
  object { BezPtch021 }
  object { BezPtch022 }
  object { BezPtch023 }
  object { BezPtch024 }
  object { // BezPtch025 -> BezPtch024
    BezPtch024
    scale 0.9
    translate  9.0*z
  }
  material {
    Mat_Canvas
  }
  rotate <27.741707, 10.257295, 0.293537>
  translate  <1.667517, 12.761434, 18.747064>
}
#declare Canvas4 = union {
  object { BezPtch013 }
  object { BezPtch026 }
  object { BezPtch027 }
  object { BezPtch028 }
  object { // BezPtch029 -> BezPtch028
    BezPtch028
    scale 0.9
    translate  9.0*z
  }
  material {
    Mat_Canvas
  }
  translate  <0.0, 50.0, 20.0>
}
#declare Canvas5 = union {
  object { BezPtch030 }
  object { BezPtch031 }
  object { // BezPtch032 -> BezPtch031
    BezPtch031
    rotate 13.57934*z
    translate  <0.210735, -3.371762, 0.0>
  }
  material {
    Mat_Canvas
  }
  rotate <-53.782906, -36.799747, 14.673002>
  translate  <-2.107351, -87.384786, 6.503054>
}
#declare Canvas9 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.865837, 67.466165, 40.103035>, <-7.461164, 68.672815, 36.188491>, <-7.955145, 69.674052, 25.571087>, <-8.449127, 70.675290, 14.953683>, 
      <-4.572756, 62.818384, 42.260532>, <-11.517546, 60.303421, 36.298781>, <-11.517546, 60.303421, 25.571087>, <-4.791958, 63.262679, 14.843393>, 
      <-2.279674, 58.170603, 44.418028>, <-9.121567, 55.447080, 36.298781>, <-9.121567, 55.447080, 25.571087>, <-2.395979, 58.406339, 14.843393>, 
      <0.000000, 53.549999, 47.026475>, <0.000000, 53.549999, 36.298781>, <0.000000, 53.549999, 25.571087>, <0.000000, 53.549999, 14.843393>
    }
  }
  material {
    Mat_Canvas
  }
  rotate <0.0, 0.0, -0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare Rig = union {
  object { Trunk1 }
  object { Trunk2 }
  object { Trunk3 }
  cone { // Cone017
    <0,0,0>, 0.1, <0,0,1>, 0.25
    material {
      Mat_RigTrunk
    }
    scale <1.0, 1.0, 20.0>
    rotate -94.19767*x
    translate  <0.0, -92.444133, 11.029255>
  }
  object { Trunk4 }
  object { Canvas1 }
  object { Canvas2 }
  object { Canvas3 }
  object { Canvas4 }
  object { Canvas5 }
  object { Canvas6 }
  object { // Canvas7 -> Canvas6
    Canvas6
    scale <1.0, 0.547931, 0.547931>
    translate  <0.0, 15.596368, 8.529028>
  }
  object { // Canvas8 -> Canvas6
    Canvas6
    translate  <0.0, 66.57464, -6.374168>
  }
  object { Canvas9 }
}
#declare Stern = union {
  object { BezPtch004 }
  object { // BezPtch037 -> BezPtch004
    BezPtch004
    scale -1.0
    rotate -180.0*x
  }
  translate  50.0*y
}
#declare Prow = union {
  object { BezPtch038 }
  object { // BezPtch039 -> BezPtch038
    BezPtch038
    scale -1.0
    rotate -180.0*x
  }
  translate  -50.0*y
}
#declare TransSweep053 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.91, -1.0>,
  <0.91, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-0.91, -1.0>
  rotate -x*90
  rotate 90.0*x
  translate  0.5*y
  scale <12.0, 100.0, 10.0>
}
#declare TransSweep054 = prism {
  linear_sweep
  cubic_spline
  -0.2,0.0
  7  // control points
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.726728, -1.0>,
  <2.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.726728, -1.0>
  rotate -x*90
  translate  -0.1*z
  rotate 90.0*x
}
#declare Rudder = union {
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.1, 1.250021>
    translate  2.0*x
  }
  object { TransSweep054 }
  rotate -90.0*z
  scale <1.0, 5.0, 5.0>
  translate  <0.0, 61.0, -5.0>
}
#declare Body = union {
  object { Stern }
  object { Prow }
  object { TransSweep053 }
  object { Rudder }
  material {
    Mat_Body
  }
}
union { // Ship
  object { Rig }
  object { Body }
  rotate <12.498634, 16.444685, 164.026245>
  translate  <-1200.0, -92.459747, 5.0>
}


//
// Include file contains 'Body1'
//
#include "dv_light.in6"
#declare Body1 = object {
  Body1_Raw
  material {
    Mat_DarkOak
  }
  rotate -90.0*y
}
#declare CSG040 = union {
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.501, 0.501, 0.04>
    rotate -90.0*y
    translate  0.02*x
  }
  object { Cone020 }
  object { Cone021 }
  object { Cone022 }
  object { // Cone023 -> Cone020
    Cone020
    rotate <0.0, -0.0, -180.0>
  }
  object { // Cone024 -> Cone021
    Cone021
    rotate -180.0*z
    translate  0.0*y
  }
  object { // Cone025 -> Cone022
    Cone022
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
}
#declare Rings = difference {
  object { CSG040 }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <0.27136, 0.27136, 3.0>
    rotate -90.0*y
    translate  1.5*x
  }
  material {
    Mat_Rust
  }
}
union { // Barrel
  object { Body1 }
  object { Rings }
  rotate <-10.0, 0.0, 80.705269>
  translate  <42.582502, 5.14185, 3.97669>
}


