// Persistence Of Vision raytracer version 3.5 scene.
// File by fatima@natur.cuni.cz.
// Dedicated to the memory of -izd-
// Sorry for comments in Czech but I am not going to translate them.

#include "colors.inc" 
#include "stones.inc"  
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"  
  
background {color DarkSlateGray}

camera {
 location <-0, 160, -140>
 look_at  <20, 120,  0>
 }      
 
light_source {
   <-200, 500, 500>
   color White
  }
  
light_source {
   <50, 260, 50>
   color Goldenrod
  }      

box {
    <-150, -1, -150>,  // Near lower left corner
    < 250, 0, 250>   // Far upper right corner
    texture {
      T_Stone7     // floor
    }
  }
  
union {         // mistnost
box {
    <-180, 0, -150>,  // left wall
    <-150, 260, 250>   // Far upper right corner
  }  
box {
    <250, 0, -150>,  // right wall
    <280, 260, 250>   // Far upper right corner
  }         
box {
    <-150, 260, -150>,  // ceiling
    < 250, 261, 250>   // Far upper right corner
  }           
box {
    <-180, 0, 250>,  // spodni parapet
    <280, 90, 280>   // Far upper right corner
 }   
box {
    <-180, 240, 250>,  // horni parapet
    <280, 260, 280>   // Far upper right corner
  }                 
box {
    <-180, 0, 250>,  // leva strana
    <-100, 260, 280>   // Far upper right corner
  }        
box {
    <180, 0, 250>,  // prava strana
    <250, 260, 280>   // Far upper right corner
  }
box {
    <-180, 0, -160>,  // 
    <280, 260, -150>   // Far upper right corner
 }          
    pigment {color VLightGray}
    normal { bumps 0.2 scale 0.2 }
    finish { phong 0.1}
}

box {
    <-100, 0, -160>,  // 
    <-10, 205, -148>   // Far upper right corner    
    texture { T_Wood12 }
 } 
 
box {
    <-150, 0, 280>,  // Near lower left corner
    <250, 260, 280.5>   // Far upper right corner
    texture { T_Glass1 }  
    interior {I_Glass}
  }                    

box {
    <-100, 90, 245>,  // Near lower left corner
    <180, 93, 282>   // Far upper right corner
      texture { T_Stone8 }
  }

union {   // ram okna
box {
    <-100, 93, 276>,  // Near lower left corner
    <180, 101, 284>   // Far upper right corner
  } 
box {
    <-100, 232, 276>,  // Near lower left corner
    <180, 240, 284>   // Far upper right corner
  }
box {
    <-100, 93, 276>,  // Near lower left corner
    <-92, 240, 284>   // Far upper right corner
  }
box {
    <172, 93, 276>,  // Near lower left corner
    <180, 240, 284>   // Far upper right corner
  }
box {
    <36, 93, 276>,  // Near lower left corner
    <44, 240, 284>   // Far upper right corner
  } 
       texture { T_Wood12 }
 } 
 
cylinder {
    <32, 149, 274>,     // Center of one end
    <46, 151, 274>,     // Center of other end
    1.5            // Radius
    texture { pigment { P_Chrome1 } finish { F_MetalD } }
  }       

#declare Desk =
union {
 union {
  box {
  <0,0,0>,
  <50,12,80>  
  }   
  box {
  <130,0,0>,
  <180,12,80>  
  }
  texture { pigment { P_Brass2 } finish { F_MetalB } }
  }
 merge {
  box {
  <0,12,0>,
  <50,75,80>  
  }   
  box {
  <130,12,0>,
  <180,75,80>  
  }
  box {
  <-3,75,-4>,     // deska
  <183,77,83>  
  }    
  box {
  <50,65,-1>,      // suplata
  <130,75,80>  
  }
  box {
  <2,14,-1>,
  <48,34,80>  
  }
  box {
  <132,14,-1>,
  <178,34,80>  
  } 
  box {
  <2,36,-2.5>,
  <48,54,80>  
  }
  box {
  <132,36,-1>,
  <178,54,80>  
  } 
  box {
  <2,56,-2>,
  <48,74,80>  
  }
  box {
  <132,56,-1>,
  <178,74,80>  
  }
  texture {T_Wood5 }
  }
  union {
  sphere {
  <25,30,-2>,1.5}
  sphere {
  <155,30,-2>,1.5}
  sphere {
  <25,50,-3.5>,1.5}
  sphere {
  <155,50,-2>,1.5}
  sphere {
  <25,70,-3>,1.5}
  sphere {
  <155,70,-2>,1.5}
  sphere {
  <90,70,-2>,1.5}
  texture { pigment { P_Brass2 } finish { F_MetalB } }
  }
  }
   
object
{Desk
   rotate -10*y
   translate <-60, 0,100>
}

#declare Lamp =
union {
  union{
  cylinder {
    <0, 0, 0>,     // Center of one end
    <0, 3, 0>,     // Center of other end
    12            // Radius
  }  
  cylinder {
    <0, 6, 0>,     // Center of one end
    <0, 25, 0>,     // Center of other end
    1.5            // Radius
  }
  cone {
  <0,25,0>, 1.5
  <0,26,0>, 0} 
  texture { pigment { P_Silver1 } finish { F_MetalD } }  
  }
  cylinder {
    <0, 3, 0>,     // Center of one end
    <0, 6, 0>,     // Center of other end
    4            // Radius 
 texture { T_Stone3}
 } 
 light_source {
   <0, 30, 0>
   color Goldenrod
  } 
 difference {
 cone {
    <0, 24, 0>, 25    // Center and radius of one end
    <0, 59, 0>, 10    // Center and radius of other end
 }
 cone {
    <0, 23, 0>, 24.7    // Center and radius of one end
    <0, 60, 0>, 9.7    // Center and radius of other end
 }
 texture {pigment { color rgbf<0.95, 0.95, 0.95, 0.95> }
    finish  { F_Glass2 }}
    interior {I_Glass}
} 
}

object
{Lamp
   translate <-5, 77,160>
}    

//light_source {
//   <-5, 115, 160>
//   color Goldenrod
//  }

#declare Dymka =
union {
union {
difference {
cone {
<0,0,0>,2
<0,5,0>,3
}
cylinder {
<0,1,0>
<0,6,0>
2
} 
}
cylinder {
<0,1.5,0>
<0,1.5,5>
1.5
} 
texture { T_Wood9 } }
cone {
<0,1.5,5>,1.5
<0,1.5,12>,0.5
}
pigment {color Black}
    normal { bumps 0.1 scale 0.1 }
    finish { phong 0.9} 
    } 
     
    
object
{Dymka   
  rotate 130*y
  translate <60,77,160> 
  }

#declare Popelnik =
difference {
difference {
box {
<0,0,0>
<20,4,20>
}  
sphere {
<10,10,10>,8.5}
}   
cylinder {
<0,4,10>
<20,4,10>
1
}    
texture {T_Ruby_Glass} 
interior {I_Glass}
}

object
{Popelnik   
  translate <25,77,130> 
  }                         

#declare Shelf =
union {
union {
box {
<0,0,0>
<4,220,4>
}
box {
<36,0,0>
<40,220,4>
}      
box {
<0,0,90>
<4,220,94>
}
box {
<36,0,90>
<40,220,94>
}  
texture { pigment { P_Chrome2 } finish { F_MetalA } }   
}
union {
box {
<1,8,1>
<39,10,93>
}
box {
<1,48,1>
<39,50,93>
}      
box {
<1,88,1>
<39,90,93>
}
box {
<1,128,1>
<39,130,93>
} 
box {
<1,168,1>
<39,170,93>
}
box {
<1,208,1>
<39,210,93>
}  
texture { T_Wood13 }   
}
}
object
{Shelf   
  translate <208,0,150> 
  }
object
{Shelf   
  translate <208,0,-140> 
  }
object
{Shelf   
  translate <-148,0,150> 
  }         
  
box {
<214,50,-56>
<234,52,153> 
texture { T_Wood10 }   
} 

box {
<214,90,-55>
<234,92,152> 
texture { T_Wood10 }   
}                         

#declare Chair =
union {
box {
<0,43,0>
<45,46,45>
}
box {
<0,0,0>
<6,45,6>
}        
box {
<0,0,39>
<6,80,45>
}
box {
<39,0,39>
<45,80,45>
}
box {
<1.5,60,43.5>
<43.5,75,40.5>
}  
box {
<39,0,0>
<45,45,6> 
      }
texture {T_Wood7}}   
    
 

object
{Chair   
  rotate 145*y
  translate <0,0,80> 
  }             
  
  
#declare Kniha1 =
union {
union {
box {
<0,0,0>
<0.3,15,10>
} 
box {
<3.7,0,0>
<4,15,10>
}  

texture {T_Stone13} }    
box {
<0.3,0.3,0>
<3.7,14.7,9.7>
pigment {color DimGray}}  

cylinder {
<2,0,0>
<2,15,0>
2
pigment {color DimGray}
} 
  }


#declare Kniha2 =
union {
union {
box {
<0,0,0>
<0.3,20,12>
} 
box {
<3.7,0,0>
<4,20,12>
}  

texture {T_Stone5} }    
box {
<0.3,0.3,0>
<3.7,19.7,11.7>
pigment {color DkGreenCopper}}  

cylinder {
<2,0,0>
<2,20,0>
2
pigment {color DkGreenCopper}
} 
  }

object
{Kniha1   
  rotate 90*y
  translate <210,92,90> 
  }  
object
{Kniha1   
  rotate 90*y
  translate <210,92,86> 
  }
object
{Kniha1   
  rotate 90*y
  translate <222,90,160> 
  }      
object
{Kniha1   
  rotate 90*y
  translate <222,90,164> 
  }               
object
{Kniha1   
  rotate 90*y
  translate <222,90,168> 
  }  
object
{Kniha2   
  rotate 90*y
  translate <210,92,100> 
  }   
object
{Kniha2   
  rotate 270*y
  translate <-120,90,220> 
  }    
object
{Kniha1   
  rotate 270*y
  translate <-120,130,225> 
  }         
object
{Kniha2   
  rotate 90*y 
  rotate 90*x
  translate <-35, 77,125> 
  }    