#include "colors.inc"
#include "skies.inc"
#include "shapes.inc"
#include "metals.inc"

//=============================================================================================
#declare Radiosity=yes;
#declare Media=yes;
#declare InnerLight=no;
#declare LineOfFigures=yes;
//=============================================================================================
#global_settings{
  assumed_gamma 1
  max_trace_level 15
  #if (Radiosity)
    radiosity{
      pretrace_start 0.08
      pretrace_end 0.01
    }
  #end  
}

#default{finish{ambient 0}}
//=============================================================================================
// figures from %POVRAY_ROOT%\SCENES\ADVANCED\chess2.pov
#declare PawnBase =
union {
    intersection {
       sphere { <0, 0, 0>, 2.5 }
       plane { -y, 0 }
    }
    cylinder { 0, y*0.35, 2.5 pigment { DarkOliveGreen } normal{agate scale 0.01} finish{specular 0.1 roughness 0.01 crand 0.4}}
    
}


#declare PieceBase =
union {
    intersection {
       sphere { <0, 0, 0>, 3 }
       plane { -y, 0 }
    }
    cylinder { 0, y*0.35, 3.0 pigment { DarkOliveGreen } normal{agate scale 0.01} finish{specular 0.1 roughness 0.01 crand 0.4}}
    
}


#declare Pawn = union {
   sphere { <0, 7, 0>, 1.5 }

   sphere { <0, 0, 0>, 1
      scale <1.2, 0.3, 1.2>
      translate 5.5*y
   }

   intersection {
      plane { y, 5.5 }
      object {
         Hyperboloid_Y
         translate 5*y
         scale <0.5, 1, 0.5>
      }
      plane { -y, -2.5 }
   }

   sphere { <0, 0, 0>, 1
      scale <2, 0.5, 2>
      translate <0, 2.3, 0>
   }
   object { PawnBase }
}


#declare Rook = union {
   intersection {
      union {
         plane { +x, -0.5 }
         plane { -x, -0.5 }
         plane { y, 9 }
      }

      union {
         plane { +z, -0.5 }
         plane { -z, -0.5 }
         plane { y, 9 }
      }

      plane { y, 10 }
      object { Cylinder_Y scale <2, 1, 2> }
      object { Cylinder_Y scale <1.2, 1, 1.2> inverse }
      plane { -y, -8 }
   }

   intersection {
      plane { y, 8 }
      object { Hyperboloid_Y
         scale <1, 1.5, 1>
         translate 5.401924*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare Knight = union {
   intersection {
      object { Cylinder_Z
         scale <17.875, 17.875, 1>
         translate <-18.625, 7, 0>
         inverse
      }

      object { Cylinder_Z
         scale <17.875, 17.875, 1>
         translate <18.625, 7, 0>
         inverse
      }

      object { Cylinder_X
         scale <1, 5.1, 5.1>
         translate <0, 11.2, -5>
         inverse
      }

      union {
         plane { y, 0
            rotate 30*x
            translate 9.15*y
         }
         plane { z, 0
            rotate -20*x
            translate 10*y
         }
      }

      union {
         plane { -y, 0
            rotate 30*x
            translate 7.15*y
         }
         plane { y, 0
            rotate 60*x
            translate 7.3*y
         }
      }

      union {
         plane { y, 0
            rotate -45*z
         }
         plane { y, 0
            rotate 45*z
         }
         translate 9*y
      }

      object { Cylinder_Y scale <2, 1, 2> }
      sphere { <0, 7, 0>, 4 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate <0, 2.8, 0>
   }

   object { PieceBase }
}

#declare Bishop = union {
   sphere { <0, 10.8, 0>, 0.4 }

   intersection {
      union {
         plane { -z, -0.25 }
         plane { +z, -0.25 }
         plane { y, 0  }
         rotate 30*x
         translate 8.5*y
      }

      sphere { <0, 0, 0>, 1
         scale <1.4, 2.1, 1.4>
         translate 8.4*y
      }

      plane { -y, -7 }
   }

   sphere { <0, 0, 0>, 1
      scale <1.5, 0.4, 1.5>
      translate 7*y
   }

   intersection {
      plane { y, 7 }
      object {
         Hyperboloid_Y
         scale <0.6, 1.4, 0.6>
         translate 7*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare QueenAndKing = union {
   sphere { <0, 10.5, 0>, 1.5 }

   intersection {
      union {
         sphere { <1.75, 12, 0>, 0.9  rotate 150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 30*y }
         sphere { <1.75, 12, 0>, 0.9  }
         sphere { <1.75, 12, 0>, 0.9  rotate -30*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate  180*y }
         inverse
      }

      plane { y, 11.5 }

      object { QCone_Y
         scale <1, 3, 1>
         translate 5*y
      }

      plane { -y, -8 }
   }

   sphere { <0, 0, 0>, 1
      scale <1.8, 0.4, 1.8>
      translate 8*y
   }

   intersection {
      plane { y, 8 }
      object { Hyperboloid_Y
         scale <0.7, 1.6, 0.7>
         translate 7*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare Queen = union {
   sphere { <0, 12.3, 0>, 0.4 }
   object { QueenAndKing }
}

#declare King = union {
   intersection {
      union {
         intersection {
            plane { y, 13 }
            plane { -y, -12.5 }
         }

         intersection {
            plane { +x, 0.25 }
            plane { -x, 0.25 }
         }
      }

      plane { +z,  0.25 }
      plane { -z,  0.25 }
      plane { +x,  0.75 }
      plane { -x,  0.75 }
      plane { +y,  13.5  }
      plane { -y,  -11.5  }
   }

   object { QueenAndKing }
}
//=============================================================================================
#declare FigureScale=0.3;

#macro Figure(Obj)
  #local RndTurb=0.3*<rand(Rnd),rand(Rnd),rand(Rnd)>;
  #local RndOctaves=10*rand(Rnd);
  #local RndScale=<0.1+rand(Rnd),0.1+rand(Rnd),0.1+rand(Rnd)>;
  #local RndTrans=<2*rand(Rnd)-1,2*rand(Rnd)-1,2*rand(Rnd)-1>;
  #local RndAngle=360*<rand(Rnd),rand(Rnd),rand(Rnd)>;
  
  #local Pigment=pigment{
    wood
    turbulence RndTurb
    octaves RndOctaves
    scale RndScale
    translate RndTrans
    rotate RndAngle
  }
  
  #local Normal=normal{   
    wood
    turbulence RndTurb
    octaves RndOctaves
    scale RndScale
    translate RndTrans
    rotate RndAngle
    scale <3,1,3>
  }
  
  object{Obj 
    pigment{Pigment} 
    normal{average normal_map{[1 Normal] [1 crackle scale 0.01]} } 
    
    finish{reflection 0.01 specular 0.1 roughness 0.01 phong 0.9 phong_size 60 metallic} 
    scale FigureScale
  }  
#end    
//=============================================================================================

#declare TN_R=20;
#declare TN_WallD=1;
#declare TN_Width=3*TN_R;
#declare TN_HTorStep=5;

#declare TN_DoorW=0.5*TN_R;
#declare TN_DoorH=(1.2*TN_DoorW-3);

#declare StangeH=1.5;
#declare StangeR=0.02*StangeH;
#declare StangeDist=0.6*TN_HTorStep;

#declare Stand_W=3;
#declare Stand_H=6;
#declare Stand_Dist=1.5*Stand_W;

#macro ConnectLine(Dist,MajorR, MinorR)
  #if (MajorR<Dist)
    error "Aha!"
  #end
  
  #local T=torus{MajorR, MinorR rotate z*90}
  #local H=sqrt(pow(MajorR,2)-pow(0.5*Dist,2));
  
  intersection{
    object{T}
    box{<-2*MinorR,-(MajorR+2*MinorR),-0.5*Dist>,<2*MinorR,0,0.5*Dist>}
    translate y*H
  }  
#end

#declare Rnd=seed(753147);

#macro Standard(W,H, Color)
  #local T=text{ttf "povlogo.ttf" "P",1,0 rotate y*-90};
  #local T=object{T translate -0.5*max_extent(T) scale 0.7*min(W,H) translate <0.5,-0.5*H,0>}
  #local BSize=sqrt(2*pow(W,2));
  
  #local B=box{-BSize, BSize rotate x*45 scale <1,0.3,1>}
  
  #declare Normal=normal{
    average
    normal_map{
      [3 ripples scale 2 translate 3*W*<rand(Rnd),rand(Rnd),rand(Rnd)>]
      //[1 granite scale 0.1]
    }  
  }  
  #declare Finish=  finish{
    reflection 0.01
    specular 0.01
    roughness 1
  }
  
  #local R=0.01*H;
  union{
    difference{
      box{<0,0,-0.5*W>,<0.0001,-H,0.5*W>}
      object{B translate y*-H}
    }  
    cylinder{<0,0,-0.5*W>,<0,0,0.5*W>,R}
    union{
      sphere{<0,0,-0.5*W-2*R>,2*R}
      sphere{<0,0,0.5*W+2*R>,2*R}
      cylinder{<0,0,-0.5*W-2*R>,<0,2*TN_R,-0.5*W-2*R>,0.1*R}
      cylinder{<0,0,0.5*W+2*R>,<0,2*TN_R,-0.5*W-2*R>,0.1*R}
      texture{T_Gold_5E}
    }
    
    texture{
      object{object{T translate y*0.2*BSize}
        texture{pigment{Color} normal{Normal} finish{Finish}}
        texture{T_Gold_2A normal{Normal} finish{Finish}}
      }
    }
  }
#end

#declare Tunnel=union{
  #local HTor=torus{TN_R,TN_WallD rotate x*90 scale <1,(TN_R+1.05*TN_WallD)/TN_R,2>};
  
  #local Stange=union{
    cone{<0,0,0>,5*StangeR,<0,2*StangeR,0>,StangeR}
    cylinder{<0,0,0>,<0,StangeH,0>, StangeR}
    sphere{<0,StangeH,0>,2*StangeR}
    torus{0.6*StangeR,0.1*0.6*StangeR rotate x*90 translate <-2.5*StangeR,StangeH,0>}
 
    texture{T_Gold_5E}
    normal{bumps scale 0.5}
    
    
  }
  
  #local StangeLine=union{
    #local Pos=(2*TN_Width-(StangeDist*int(2*TN_Width/StangeDist)));
    #local Pos=TN_Width-0.5*Pos;
    #local XPos=0.45*TN_DoorW;
    #local PrevPos=Pos;
    
    #while (Pos>-TN_Width)
      object{Stange translate <XPos,0,Pos>}
      #if (PrevPos!=Pos)
        object{
          ConnectLine(StangeDist, 1.1*StangeDist, 0.5*StangeR) 
          translate <XPos-2.5*StangeR,StangeH,Pos+0.5*StangeDist>  
          pigment{Violet} 
          normal{granite scale 0.01}          
          finish{reflection 0.01 crand 0.1}
        }
      #end
      #local PrevPos=Pos;
      #local Pos=Pos-StangeDist;
      
    #end
  }
  
  #local StandardLine=union{
    #local Pos=(2*TN_Width-(Stand_Dist*int(2*TN_Width/Stand_Dist)));
    #local Pos=TN_Width-0.5*Pos;
    #local XPos=0.8*TN_DoorW;
    #local YPos=Stand_H+8;
    #local InvColor=yes;
    
    #while (Pos>-TN_Width)
      
      #if (InvColor)
        object{Standard(Stand_W, Stand_H, Violet) translate <XPos,YPos, Pos>}
        object{Standard(Stand_W, Stand_H, NavyBlue) translate <XPos+5,YPos-3, Pos>}
      #else
        object{Standard(Stand_W, Stand_H, NavyBlue) translate <XPos,YPos, Pos>}
        object{Standard(Stand_W, Stand_H, Violet) translate <XPos+5,YPos-3, Pos>}
      #end  
      
      #local Pos=Pos-Stand_Dist;
      #local InvColor=!InvColor;
    #end
  }
  
  difference{
    cylinder{<0,0,-TN_Width-TN_WallD>,<0,0,TN_Width+TN_WallD>,TN_R+TN_WallD}
    cylinder{<0,0,-TN_Width>,<0,0,TN_Width>,TN_R}
    box{<-0.5*TN_DoorW,-0.01,-2*TN_WallD>,<+0.5*TN_DoorW,TN_DoorH+0.01,2*TN_WallD> translate z*TN_Width}
    
    cylinder{<0,TN_DoorH,TN_Width-2*TN_WallD>,<0,TN_DoorH,TN_Width+2*TN_WallD>, 0.5*TN_DoorW}
    
    //#declare T=text{ttf "povlogo.ttf" "P",10,0 translate <0,-0.5,-0.5> scale 3 translate <0,5+TN_DoorH,TN_Width>};
    //object{T}
    
  }
  
  #local Pos=TN_Width;
  #while (Pos>-TN_Width)
    object{HTor translate z*Pos}
    #local Pos=Pos-TN_HTorStep;
  #end  
  // stange
  object{StangeLine}
  object{StangeLine rotate y*180}
  // standards
  object{StandardLine}
  object{StandardLine rotate y*180}
  // done
  pigment{
    gradient y
    pigment_map{
      [0.1 Black]
      [0.5 Gray50]
      [1 Gray80]
    }
    warp{turbulence 0.1}
    scale <1,TN_R+4*TN_WallD,1>
    translate y*-2*TN_WallD
  }
  
  normal{crackle scale 0.1}
  finish{
    reflection 0.01
    specular 0.1
    roughness 0.01
    crand 0.1
  }
}

#declare TunnelMedia=cylinder{
  <0,0,-TN_Width-TN_WallD>,<0,0,TN_Width+TN_WallD>,TN_R+TN_WallD
  //<0,0,0>,<0,1,0>,1
  pigment{rgbt 1}
  hollow
  interior
  { media{ 
      scattering { 2, 0.002 }
    }
  }
  
}

//=============================================================================================
#declare RugW=0.75*TN_DoorW;

#declare Rug=union{
  
  #declare T=text{ttf "povlogo.ttf" "P",1,0 rotate <90,90,0> translate <-0.3,0.5,0.5>};
  #declare T=union{
    object{T}
    object{T rotate y*180}  
  }
  #declare TLine=union{
    #declare Pos=TN_Width;
    #declare LogoStep=abs(max_extent(T).z-min_extent(T).z);
    #while (Pos>-TN_Width)
      object{T translate z*Pos}
      #local Pos=Pos-LogoStep;
    #end
  }  
  #declare PovLogo=union{
    #declare TLine=object{TLine translate x*-(0.5*RugW-1.2*max_extent(TLine).x)};
    
    object{TLine}
    object{TLine rotate y*180}
  }  
  
  #declare Normal=normal{
    average
    normal_map{
      [1 bumps scale 0.5]
      [1 granite scale 0.1]
    }  
  }  
  #declare Finish=  finish{
    reflection 0
    specular 0.01
    roughness 0.001
  }
  
  box{<-0.5*RugW,0,-TN_Width>,<0.5*RugW,0.001,TN_Width>}
  cylinder{<-0.5*RugW,0,-TN_Width>,<-0.5*RugW,0,TN_Width>,0.01}
  cylinder{<0.5*RugW,0,-TN_Width>,<0.5*RugW,0,TN_Width>,0.01}
  
  texture{
    object {
       PovLogo
       texture{pigment{Violet} normal{Normal} finish{Finish}}
       texture{T_Gold_1A normal{Normal} finish{Finish}}
    }
  }
  
}
//=============================================================================================
#macro Line(X1,Z1,X2,Z2,Dist)
  #if (X1>X2)
    #local Buff=X1;
    #local X1=X2;
    #local X2=Buff;
  #end
  #if (Z1>Z2)
    #local Buff=Z1;
    #local Z1=Z2;
    #local Z2=Buff;
  #end

  union{
    #local CurZ=Z1;
    #while (CurZ<Z2)
      #local CurX=X1;
      #while (CurX<X2)
        #if (int(2*rand(Rnd))=0)
          #local Obj=Figure(Pawn);
        #else
          #switch (int(3*rand(Rnd)))          
            #case (0)
              #local Obj=Figure(Knight);          
              #break;
            #case (1)
              #local Obj=Figure(Bishop);          
              #break;
            #case (2)
              #local Obj=Figure(Rook);          
              #break;
          #end  
        #end
      
        object{Obj translate x*0.3*Dist*rand(Rnd) rotate y*360*rand(Rnd) scale <1,1+0.1*rand(Rnd),1> translate <CurX,0,CurZ>}
        #local CurX=CurX+Dist;
      #end
      #local CurZ=CurZ+Dist;
    #end
  }  
#end
//=============================================================================================
#declare Floor=union{
  box{<-(TN_R+TN_WallD),0,-(TN_Width+TN_WallD)>,<(TN_R+TN_WallD),-1,(TN_Width+TN_WallD)>}
  
  texture{
    pigment{/*checker White Black*/White}  
    
    normal{checker}
    
    finish{
      reflection 0.1
      specular 0.1
      roughness 1
    }
    
    scale 2
  }  
  
}
//=============================================================================================

object{Tunnel}
object{Rug}
#if (Media)
  object{TunnelMedia}
#end  

object{Floor}

#if (InnerLight)
  light_source{5, White}
#end  

light_source{<0.1*TN_R,0.5*TN_R,4*TN_R>, White}
//light_source{<5*TN_R,10*TN_R*clock,50*TN_R>, White}

camera{location <-0.5*TN_DoorW,3,0> look_at<0,0,100>}
//camera{location 5 look_at 2.5}

//sky_sphere{S_Cloud2 rotate x*90}
sphere{0,1000 inverse pigment{LightBlue} finish{ambient 1}}

#if (LineOfFigures)
  #declare Rnd=seed(105742);
  Line(0.6*TN_DoorW, -(TN_Width-2), TN_R-2,TN_Width-2,3)
  object{Line(0.6*TN_DoorW, -(TN_Width-2), TN_R-2,TN_Width-2,3) rotate y*180}
#end  

object{Figure(King) translate <-1, 0, TN_Width> }
object{Figure(Queen) translate <1, 0, TN_Width> }


