/*************** Tree made by: ******************

Arbaro 2.0 - creates trees objects for rendering from xml parameter files
(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)


<?xml version='1.0' ?>

<arbaro>
  <species name='simplemoss'>
    <!-- general params -->
    <param name='Shape' value='3'/>
    <param name='Levels' value='1'/>
    <param name='Scale' value='0.39'/>
    <param name='ScaleV' value='0.2'/>
    <param name='BaseSize' value='0.875'/>
    <param name='Ratio' value='0.0050'/>
    <param name='RatioPower' value='0.5'/>
    <param name='Flare' value='0.0'/>
    <param name='Lobes' value='0'/>
    <param name='LobeDepth' value='0.0'/>
    <param name='Smooth' value='0.5'/>
    <param name='Leaves' value='0'/>
    <param name='LeafShape' value='sphere'/>
    <param name='LeafScale' value='0.0020'/>
    <param name='LeafScaleX' value='0.5'/>
    <param name='LeafQuality' value='1.0'/>
    <param name='LeafStemLen' value='-1.1'/>
    <param name='LeafDistrib' value='4'/>
    <param name='LeafBend' value='0.3'/>
    <param name='AttractionUp' value='0.0'/>
    <param name='PruneRatio' value='0.0'/>
    <param name='PrunePowerLow' value='0.5'/>
    <param name='PrunePowerHigh' value='0.5'/>
    <param name='PruneWidth' value='0.5'/>
    <param name='PruneWidthPeak' value='0.5'/>
    <param name='0Scale' value='1.0'/>
    <param name='0ScaleV' value='0.0'/>
    <param name='0BaseSplits' value='0'/>
    <!-- level 0 -->
    <param name='0DownAngle' value='10.0'/>
    <param name='0DownAngleV' value='30.0'/>
    <param name='0Rotate' value='130.0'/>
    <param name='0RotateV' value='60.0'/>
    <param name='0Branches' value='19'/>
    <param name='0BranchDist' value='0.05'/>
    <param name='0Length' value='1.0'/>
    <param name='0LengthV' value='0.0'/>
    <param name='0Taper' value='1.0'/>
    <param name='0SegSplits' value='0.0'/>
    <param name='0SplitAngle' value='0.0'/>
    <param name='0SplitAngleV' value='0.0'/>
    <param name='0CurveRes' value='8'/>
    <param name='0Curve' value='-5.0'/>
    <param name='0CurveBack' value='20.0'/>
    <param name='0CurveV' value='40.0'/>
    <!-- level 1 -->
    <param name='1DownAngle' value='20.0'/>
    <param name='1DownAngleV' value='0.0'/>
    <param name='1Rotate' value='0.0'/>
    <param name='1RotateV' value='0.0'/>
  </species>
</arbaro>
************************************************/
#declare simplemoss_13_height = 0.36441;
#declare simplemoss_13_stems = 
  mesh2 {
    vertex_vectors { 646
    /* stem 0*/ 
    /*0*/ <0.04113,0,0.00805>,
    /*1*/ <0.04157,0,0.00984>,<0.03949,0.00072,0.00846>,<0.04069,0,0.00627>,
            <0.04277,-0.00072,0.00765>,
    /*2*/ <0.0591,0.04226,0.00528>,<0.05728,0.0429,0.00407>,<0.05833,0.04226,0.00215>,
            <0.06016,0.04163,0.00336>,
    /*3*/ <0.07586,0.0849,0.00173>,<0.0743,0.08544,0.0007>,<0.07522,0.08495,-0.00095>,
            <0.07678,0.08441,0.00009>,
    /*4*/ <0.09301,0.12721,-0.00432>,<0.09169,0.12763,-0.00518>,<0.09243,0.12714,-0.00655>,
            <0.09374,0.12672,-0.00569>,
    /*5*/ <0.11266,0.16842,-0.00948>,<0.11164,0.16882,-0.01018>,<0.11223,0.16841,-0.01127>,
            <0.11325,0.16801,-0.01057>,
    /*6*/ <0.13463,0.20846,-0.01468>,<0.13389,0.20881,-0.0152>,<0.13431,0.20847,-0.01602>,
            <0.13506,0.20813,-0.01549>,
    /*7*/ <0.15999,0.24629,-0.02112>,<0.15951,0.24655,-0.02148>,<0.15977,0.24629,-0.02201>,
            <0.16024,0.24603,-0.02166>,
    /*8*/ <0.18865,0.2815,-0.0284>,<0.18842,0.28164,-0.02858>,<0.18854,0.2815,-0.02885>,
            <0.18877,0.28135,-0.02867>,
    /*9*/ <0.22019,0.31399,-0.03638>

    /* stem 0*/ 
    /*0*/ <0.00911,0,0.03526>,
    /*1*/ <0.00772,0,0.03407>,<0.01028,-0.00043,0.03391>,<0.01051,-0,0.03646>,
            <0.00795,0.00043,0.03662>,
    /*2*/ <0.01483,0.04473,0.02615>,<0.01707,0.04436,0.02601>,<0.01727,0.04473,0.02825>,
            <0.01503,0.04511,0.02839>,
    /*3*/ <0.02044,0.08879,0.0147>,<0.02237,0.08851,0.01457>,<0.02256,0.08898,0.01645>,
            <0.02063,0.08926,0.01658>,
    /*4*/ <0.02979,0.13237,0.00311>,<0.03137,0.13202,0.00303>,<0.03153,0.13241,0.0046>,
            <0.02995,0.13276,0.00468>,
    /*5*/ <0.03882,0.17554,-0.00981>,<0.04009,0.17526,-0.00987>,<0.04023,0.17561,-0.00862>,
            <0.03896,0.17589,-0.00856>,
    /*6*/ <0.04532,0.21983,-0.02029>,<0.04628,0.21968,-0.02035>,<0.04637,0.21989,-0.0194>,
            <0.04541,0.22005,-0.01934>,
    /*7*/ <0.04824,0.26537,-0.02603>,<0.04888,0.26532,-0.02608>,<0.04894,0.2654,-0.02544>,
            <0.04829,0.26545,-0.02539>,
    /*8*/ <0.0469,0.31132,-0.02697>,<0.04723,0.31133,-0.027>,<0.04725,0.31133,-0.02667>,
            <0.04693,0.31132,-0.02664>,
    /*9*/ <0.0405,0.35662,-0.02242>

    /* stem 0*/ 
    /*0*/ <0.01297,0,0.00746>,
    /*1*/ <0.01425,0,0.00878>,<0.01172,0.00058,0.00868>,<0.01168,0,0.00615>,
            <0.01421,-0.00058,0.00624>,
    /*2*/ <0.02453,0.0436,-0.00161>,<0.02231,0.04411,-0.00169>,<0.02228,0.0436,-0.00391>,
            <0.02449,0.04309,-0.00383>,
    /*3*/ <0.03485,0.08696,-0.01299>,<0.03296,0.0874,-0.01307>,<0.03292,0.08692,-0.01496>,
            <0.03481,0.08648,-0.01488>,
    /*4*/ <0.04665,0.12976,-0.0249>,<0.04508,0.13018,-0.02497>,<0.04504,0.12976,-0.02654>,
            <0.04661,0.12934,-0.02647>,
    /*5*/ <0.05702,0.17237,-0.03892>,<0.05575,0.17267,-0.03897>,<0.05571,0.17228,-0.04021>,
            <0.05697,0.17198,-0.04016>,
    /*6*/ <0.07061,0.21279,-0.05613>,<0.06968,0.21308,-0.05619>,<0.06962,0.21272,-0.05709>,
            <0.07055,0.21243,-0.05703>,
    /*7*/ <0.08641,0.25095,-0.07636>,<0.08581,0.25117,-0.07642>,<0.08575,0.25089,-0.077>,
            <0.08636,0.25066,-0.07694>,
    /*8*/ <0.10326,0.28648,-0.10022>,<0.10296,0.28661,-0.10025>,<0.10293,0.28644,-0.10053>,
            <0.10323,0.28632,-0.10049>,
    /*9*/ <0.12404,0.31705,-0.12757>

    /* stem 0*/ 
    /*0*/ <0.02428,0,0.01814>,
    /*1*/ <0.02258,0,0.01886>,<0.0236,-0.00058,0.01653>,<0.02597,-0,0.01742>,
            <0.02496,0.00058,0.01975>,
    /*2*/ <0.01718,0.04367,0.00552>,<0.01807,0.04317,0.00348>,<0.02015,0.04367,0.00426>,
            <0.01926,0.04417,0.0063>,
    /*3*/ <0.01096,0.08706,-0.00831>,<0.01172,0.08662,-0.01005>,<0.0135,0.08709,-0.0094>,
            <0.01274,0.08753,-0.00765>,
    /*4*/ <0.00196,0.13027,-0.02087>,<0.00258,0.12997,-0.02235>,<0.00405,0.13044,-0.02182>,
            <0.00343,0.13073,-0.02035>,
    /*5*/ <-0.00666,0.17285,-0.03604>,<-0.00615,0.17255,-0.0372>,<-0.00498,0.17293,-0.03678>,
            <-0.00549,0.17324,-0.03563>,
    /*6*/ <-0.01432,0.21726,-0.04501>,<-0.01395,0.21714,-0.04591>,<-0.01306,0.21737,-0.04558>,
            <-0.01343,0.21748,-0.04468>,
    /*7*/ <-0.02076,0.26248,-0.05026>,<-0.02053,0.26244,-0.05086>,<-0.01993,0.26256,-0.05064>,
            <-0.02016,0.26259,-0.05003>,
    /*8*/ <-0.02466,0.30809,-0.05475>,<-0.02454,0.30807,-0.05506>,<-0.02424,0.30811,-0.05494>,
            <-0.02435,0.30813,-0.05464>,
    /*9*/ <-0.02657,0.35402,-0.05611>

    /* stem 0*/ 
    /*0*/ <0.00067,0,-0.04738>,
    /*1*/ <-0.00026,0,-0.04897>,<0.00225,-0.00022,-0.04831>,<0.00161,-0,-0.0458>,
            <-0.0009,0.00022,-0.04646>,
    /*2*/ <0.0045,0.04566,-0.05151>,<0.00669,0.04548,-0.05093>,<0.00613,0.04566,-0.04874>,
            <0.00394,0.04585,-0.04931>,
    /*3*/ <0.01101,0.09098,-0.05564>,<0.01288,0.09076,-0.05514>,<0.01241,0.09101,-0.05326>,
            <0.01054,0.09122,-0.05376>,
    /*4*/ <0.01783,0.13632,-0.05933>,<0.01939,0.13612,-0.05892>,<0.019,0.13631,-0.05735>,
            <0.01744,0.13651,-0.05777>,
    /*5*/ <0.02493,0.18123,-0.06576>,<0.02618,0.18109,-0.06543>,<0.02588,0.18132,-0.06418>,
            <0.02463,0.18146,-0.06451>,
    /*6*/ <0.03096,0.22679,-0.06848>,<0.0319,0.22668,-0.06823>,<0.03166,0.22677,-0.06729>,
            <0.03072,0.22688,-0.06754>,
    /*7*/ <0.0319,0.27276,-0.06855>,<0.03253,0.27274,-0.06839>,<0.03237,0.27275,-0.06776>,
            <0.03174,0.27276,-0.06792>,
    /*8*/ <0.03066,0.31868,-0.06993>,<0.03098,0.31869,-0.06984>,<0.0309,0.3187,-0.06953>,
            <0.03058,0.31869,-0.06961>,
    /*9*/ <0.02589,0.36441,-0.06927>

    /* stem 0*/ 
    /*0*/ <0.00222,0,0.00527>,
    /*1*/ <0.0037,0,0.00637>,<0.00129,0.00098,0.00652>,<0.00075,0,0.00417>,
            <0.00315,-0.00098,0.00402>,
    /*2*/ <0.01813,0.03894,-0.01338>,<0.01603,0.03979,-0.01325>,<0.01555,0.03894,-0.0153>,
            <0.01766,0.03808,-0.01543>,
    /*3*/ <0.03134,0.07859,-0.0326>,<0.02951,0.07928,-0.03246>,<0.02911,0.07856,-0.03423>,
            <0.03094,0.07788,-0.03437>,
    /*4*/ <0.04394,0.11862,-0.0514>,<0.04241,0.11917,-0.05128>,<0.04208,0.11859,-0.05276>,
            <0.04361,0.11804,-0.05288>,
    /*5*/ <0.05856,0.158,-0.06999>,<0.05736,0.15849,-0.06992>,<0.0571,0.15803,-0.0711>,
            <0.0583,0.15755,-0.07118>,
    /*6*/ <0.07391,0.19437,-0.09367>,<0.07302,0.19477,-0.09364>,<0.07278,0.19433,-0.09447>,
            <0.07367,0.19393,-0.09451>,
    /*7*/ <0.08911,0.23042,-0.11785>,<0.08852,0.23069,-0.11782>,<0.08836,0.23039,-0.11838>,
            <0.08895,0.23012,-0.1184>,
    /*8*/ <0.10593,0.26363,-0.14484>,<0.10564,0.26378,-0.14484>,<0.10555,0.26362,-0.1451>,
            <0.10584,0.26347,-0.1451>,
    /*9*/ <0.12516,0.29552,-0.17179>

    /* stem 0*/ 
    /*0*/ <0.00333,0,0.01902>,
    /*1*/ <0.00256,0,0.02069>,<0.00167,0.00027,0.01826>,<0.00409,0,0.01734>,
            <0.00498,-0.00027,0.01977>,
    /*2*/ <0.00881,0.04548,0.02329>,<0.00803,0.04572,0.02116>,<0.01015,0.04548,0.02036>,
            <0.01093,0.04524,0.02248>,
    /*3*/ <0.01215,0.09139,0.02304>,<0.01146,0.09143,0.02121>,<0.01328,0.09131,0.02053>,
            <0.01397,0.09126,0.02235>,
    /*4*/ <0.01405,0.13729,0.02358>,<0.01348,0.13733,0.02206>,<0.015,0.13728,0.02149>,
            <0.01558,0.13724,0.02301>,
    /*5*/ <0.01293,0.18314,0.0257>,<0.01247,0.18319,0.02448>,<0.01369,0.18324,0.02402>,
            <0.01415,0.18319,0.02524>,
    /*6*/ <0.01566,0.22889,0.02938>,<0.01532,0.22899,0.02847>,<0.01623,0.22897,0.02812>,
            <0.01657,0.22887,0.02903>,
    /*7*/ <0.02306,0.27354,0.03734>,<0.02284,0.27369,0.03675>,<0.02344,0.27363,0.03651>,
            <0.02366,0.27349,0.03711>,
    /*8*/ <0.03483,0.3172,0.04577>,<0.03472,0.31728,0.04548>,<0.03502,0.31723,0.04536>,
            <0.03512,0.31714,0.04565>,
    /*9*/ <0.05041,0.35942,0.05518>

    /* stem 0*/ 
    /*0*/ <-0.01581,0,-0.00868>,
    /*1*/ <-0.01764,0,-0.00891>,<-0.0156,-0.00058,-0.01042>,<-0.01399,-0,-0.00846>,
            <-0.01602,0.00058,-0.00695>,
    /*2*/ <-0.01566,0.04361,-0.02333>,<-0.01388,0.04311,-0.02465>,<-0.01246,0.04361,-0.02294>,
            <-0.01424,0.04412,-0.02162>,
    /*3*/ <-0.01336,0.08696,-0.03854>,<-0.01183,0.08649,-0.03966>,<-0.01062,0.08694,-0.0382>,
            <-0.01215,0.08741,-0.03708>,
    /*4*/ <-0.00946,0.12987,-0.05472>,<-0.0082,0.12941,-0.05563>,<-0.00719,0.12979,-0.05441>,
            <-0.00845,0.13024,-0.0535>,
    /*5*/ <-0.00782,0.17144,-0.07415>,<-0.00681,0.17106,-0.07488>,<-0.00599,0.17147,-0.07395>,
            <-0.007,0.17184,-0.07322>,
    /*6*/ <-0.00619,0.21472,-0.08962>,<-0.00543,0.21449,-0.09018>,<-0.00482,0.21473,-0.08946>,
            <-0.00558,0.21496,-0.08889>,
    /*7*/ <-0.00201,0.2587,-0.10252>,<-0.00151,0.25854,-0.1029>,<-0.0011,0.25865,-0.1024>,
            <-0.00161,0.25881,-0.10202>,
    /*8*/ <0.00516,0.30357,-0.10974>,<0.00541,0.3035,-0.10993>,<0.00561,0.30352,-0.10968>,
            <0.00536,0.30359,-0.10948>,
    /*9*/ <0.00817,0.34933,-0.11289>

    /* stem 0*/ 
    /*0*/ <-0.02011,0,0.02991>,
    /*1*/ <-0.01827,0,0.02979>,<-0.02,-0.00054,0.03167>,<-0.02194,-0,0.03003>,
            <-0.02022,0.00054,0.02815>,
    /*2*/ <-0.01764,0.04399,0.04316>,<-0.01915,0.04352,0.0448>,<-0.02086,0.04399,0.04337>,
            <-0.01935,0.04446,0.04173>,
    /*3*/ <-0.01577,0.08829,0.05518>,<-0.01706,0.08796,0.05661>,<-0.01852,0.08836,0.05538>,
            <-0.01723,0.08869,0.05395>,
    /*4*/ <-0.01132,0.1328,0.06544>,<-0.01239,0.13263,0.06666>,<-0.0136,0.133,0.06564>,
            <-0.01254,0.13316,0.06443>,
    /*5*/ <-0.00931,0.17751,0.07625>,<-0.01017,0.17732,0.07721>,<-0.01114,0.17757,0.07639>,
            <-0.01028,0.17776,0.07543>,
    /*6*/ <-0.0104,0.22314,0.08229>,<-0.01104,0.22303,0.08302>,<-0.01177,0.2231,0.08238>,
            <-0.01113,0.22321,0.08165>,
    /*7*/ <-0.01153,0.26902,0.08504>,<-0.01196,0.26898,0.08553>,<-0.01245,0.269,0.0851>,
            <-0.01202,0.26904,0.08461>,
    /*8*/ <-0.01208,0.31498,0.08397>,<-0.01229,0.31498,0.08421>,<-0.01254,0.31498,0.084>,
            <-0.01232,0.31497,0.08375>,
    /*9*/ <-0.01305,0.36029,0.07623>

    /* stem 0*/ 
    /*0*/ <0.00813,0,0.03172>,
    /*1*/ <0.00634,0,0.03216>,<0.00771,-0.00061,0.03004>,<0.00991,-0,0.03128>,
            <0.00854,0.00061,0.03341>,
    /*2*/ <0.00291,0.04339,0.01733>,<0.00411,0.04285,0.01547>,<0.00603,0.04339,0.01656>,
            <0.00483,0.04392,0.01842>,
    /*3*/ <-0.00189,0.08579,0.00028>,<-0.00085,0.08528,-0.00129>,<0.00079,0.08584,-0.0004>,
            <-0.00024,0.08635,0.00118>,
    /*4*/ <-0.00678,0.1283,-0.01653>,<-0.00592,0.12789,-0.01785>,<-0.00455,0.12835,-0.0171>,
            <-0.00541,0.12876,-0.01579>,
    /*5*/ <-0.01518,0.16914,-0.03576>,<-0.01449,0.16879,-0.0368>,<-0.01341,0.16928,-0.03626>,
            <-0.0141,0.16962,-0.03521>,
    /*6*/ <-0.02418,0.2117,-0.05056>,<-0.02368,0.21152,-0.05138>,<-0.02287,0.21184,-0.05096>,
            <-0.02337,0.21202,-0.05014>,
    /*7*/ <-0.03162,0.25564,-0.06189>,<-0.0313,0.25556,-0.06245>,<-0.03074,0.25573,-0.06215>,
            <-0.03107,0.25582,-0.0616>,
    /*8*/ <-0.03784,0.30054,-0.06964>,<-0.03768,0.30052,-0.06992>,<-0.0374,0.30058,-0.06977>,
            <-0.03756,0.30061,-0.06949>,
    /*9*/ <-0.04115,0.34582,-0.07701>

    /* stem 0*/ 
    /*0*/ <-0.01978,0,-0.01655>,
    /*1*/ <-0.02056,0,-0.01822>,<-0.01845,0.00111,-0.01717>,<-0.01901,0,-0.01489>,
            <-0.02111,-0.00111,-0.01593>,
    /*2*/ <-0.04555,0.03672,-0.00633>,<-0.04371,0.03769,-0.00542>,<-0.0442,0.03672,-0.00341>,
            <-0.04604,0.03575,-0.00433>,
    /*3*/ <-0.06775,0.07509,0.0061>,<-0.0661,0.07581,0.00685>,<-0.06654,0.07501,0.00857>,
            <-0.06819,0.07429,0.00782>,
    /*4*/ <-0.08768,0.11498,0.01731>,<-0.08627,0.11552,0.01792>,<-0.08667,0.11491,0.01938>,
            <-0.08808,0.11437,0.01877>,
    /*5*/ <-0.10571,0.15632,0.0261>,<-0.10457,0.15672,0.02658>,<-0.10492,0.15632,0.02776>,
            <-0.10606,0.15591,0.02728>,
    /*6*/ <-0.12748,0.19556,0.03608>,<-0.12666,0.19592,0.03645>,<-0.1269,0.19557,0.03733>,
            <-0.12772,0.1952,0.03695>,
    /*7*/ <-0.1542,0.23191,0.04467>,<-0.1537,0.23222,0.04494>,<-0.15385,0.23197,0.04552>,
            <-0.15436,0.23166,0.04525>,
    /*8*/ <-0.18374,0.26564,0.05488>,<-0.1835,0.26581,0.05502>,<-0.18356,0.26567,0.0553>,
            <-0.1838,0.2655,0.05517>,
    /*9*/ <-0.21604,0.29688,0.06458>

    /* stem 0*/ 
    /*0*/ <-0.03161,0,0.0307>,
    /*1*/ <-0.03032,0,0.032>,<-0.0329,0.00029,0.03198>,<-0.03291,0,0.02939>,
            <-0.03033,-0.00029,0.02942>,
    /*2*/ <-0.02528,0.04539,0.02667>,<-0.02754,0.04565,0.02665>,<-0.02755,0.04539,0.02439>,
            <-0.02528,0.04514,0.02441>,
    /*3*/ <-0.02124,0.09099,0.0223>,<-0.02319,0.09117,0.02228>,<-0.02319,0.09099,0.02034>,
            <-0.02125,0.09081,0.02035>,
    /*4*/ <-0.01801,0.1367,0.01845>,<-0.01963,0.13682,0.01844>,<-0.01963,0.13669,0.01682>,
            <-0.01801,0.13657,0.01683>,
    /*5*/ <-0.01676,0.18253,0.01454>,<-0.01806,0.18257,0.01454>,<-0.01806,0.18247,0.01324>,
            <-0.01676,0.18243,0.01325>,
    /*6*/ <-0.01465,0.22799,0.00777>,<-0.01562,0.22804,0.00777>,<-0.01563,0.2279,0.0068>,
            <-0.01465,0.22785,0.0068>,
    /*7*/ <-0.01136,0.27281,-0.00204>,<-0.012,0.27286,-0.00205>,<-0.01201,0.27273,-0.00268>,
            <-0.01136,0.27268,-0.00268>,
    /*8*/ <-0.0048,0.31669,-0.01409>,<-0.00512,0.31674,-0.0141>,<-0.00513,0.31666,-0.01441>,
            <-0.0048,0.31661,-0.01441>,
    /*9*/ <0.00151,0.35921,-0.03049>

    /* stem 0*/ 
    /*0*/ <-0.01704,0,0.00966>,
    /*1*/ <-0.01888,0,0.00969>,<-0.01707,0.00075,0.00798>,<-0.0152,0,0.00964>,
            <-0.01702,-0.00075,0.01134>,
    /*2*/ <-0.01837,0.04203,0.02834>,<-0.01678,0.04268,0.02684>,<-0.01515,0.04203,0.02829>,
            <-0.01673,0.04138,0.02978>,
    /*3*/ <-0.01788,0.08566,0.04285>,<-0.01652,0.08609,0.04152>,<-0.01513,0.08566,0.0428>,
            <-0.01648,0.08522,0.04413>,
    /*4*/ <-0.01837,0.12914,0.0577>,<-0.01724,0.12953,0.0566>,<-0.01607,0.12919,0.05768>,
            <-0.01721,0.12879,0.05878>,
    /*5*/ <-0.01806,0.17368,0.0692>,<-0.01715,0.17391,0.0683>,<-0.01622,0.17368,0.06917>,
            <-0.01712,0.17345,0.07008>,
    /*6*/ <-0.018,0.21627,0.08651>,<-0.01732,0.21654,0.08586>,<-0.01662,0.21629,0.08649>,
            <-0.0173,0.21602,0.08714>,
    /*7*/ <-0.0156,0.25737,0.10706>,<-0.01515,0.25756,0.10664>,<-0.01468,0.25734,0.10703>,
            <-0.01513,0.25715,0.10746>,
    /*8*/ <-0.01064,0.29668,0.13045>,<-0.01042,0.29678,0.13024>,<-0.01018,0.29664,0.13043>,
            <-0.01041,0.29654,0.13064>,
    /*9*/ <-0.00528,0.33386,0.15698>

    /* stem 0*/ 
    /*0*/ <-0.033,0,0.01169>,
    /*1*/ <-0.03118,0,0.01139>,<-0.0327,-0.00009,0.0135>,<-0.03481,-0,0.01199>,
            <-0.0333,0.00009,0.00988>,
    /*2*/ <-0.03103,0.04592,0.0137>,<-0.03236,0.04584,0.01554>,<-0.03421,0.04592,0.01422>,
            <-0.03288,0.046,0.01237>,
    /*3*/ <-0.03066,0.09176,0.01738>,<-0.0318,0.09164,0.01896>,<-0.03338,0.09176,0.01782>,
            <-0.03225,0.09187,0.01624>,
    /*4*/ <-0.02882,0.13724,0.02366>,<-0.02977,0.1371,0.02497>,<-0.03108,0.13729,0.02404>,
            <-0.03014,0.13743,0.02272>,
    /*5*/ <-0.02595,0.18284,0.02853>,<-0.0267,0.18278,0.02958>,<-0.02776,0.18293,0.02884>,
            <-0.027,0.18299,0.02778>,
    /*6*/ <-0.021,0.22848,0.0276>,<-0.02156,0.22856,0.0284>,<-0.02235,0.22864,0.02783>,
            <-0.02179,0.22856,0.02704>,
    /*7*/ <-0.01587,0.27395,0.02318>,<-0.01624,0.27404,0.02371>,<-0.01677,0.27407,0.02333>,
            <-0.0164,0.27398,0.0228>,
    /*8*/ <-0.01113,0.31891,0.01483>,<-0.01131,0.31898,0.01509>,<-0.01157,0.31898,0.0149>,
            <-0.01139,0.31891,0.01464>,
    /*9*/ <-0.00392,0.36213,0.00093>

    /* stem 0*/ 
    /*0*/ <-0.0187,0,-0.01108>,
    /*1*/ <-0.02014,0,-0.00994>,<-0.01971,0.00083,-0.01237>,<-0.01725,0,-0.01222>,
            <-0.01768,-0.00083,-0.00979>,
    /*2*/ <-0.00706,0.04099,0.00629>,<-0.00668,0.04171,0.00416>,<-0.00453,0.04099,0.00429>,
            <-0.00491,0.04026,0.00642>,
    /*3*/ <0.00604,0.08245,0.02132>,<0.00634,0.08302,0.01949>,<0.00819,0.08241,0.0196>,
            <0.00788,0.08183,0.02144>,
    /*4*/ <0.01768,0.12403,0.03698>,<0.01795,0.12454,0.03546>,<0.0195,0.12407,0.03557>,
            <0.01924,0.12356,0.03709>,
    /*5*/ <0.02609,0.16705,0.05077>,<0.02629,0.16741,0.04954>,<0.02756,0.16713,0.04966>,
            <0.02736,0.16676,0.05089>,
    /*6*/ <0.03642,0.20849,0.06777>,<0.03658,0.20882,0.06687>,<0.03752,0.20856,0.06694>,
            <0.03736,0.20823,0.06785>,
    /*7*/ <0.04949,0.24717,0.08891>,<0.04961,0.24744,0.08834>,<0.05022,0.24722,0.08837>,
            <0.0501,0.24695,0.08894>,
    /*8*/ <0.0647,0.28362,0.11246>,<0.06477,0.28377,0.11218>,<0.06507,0.28364,0.11219>,
            <0.065,0.28349,0.11246>,
    /*9*/ <0.07928,0.31883,0.13816>

    /* stem 0*/ 
    /*0*/ <-0.02284,0,0.04203>,
    /*1*/ <-0.02131,0,0.04101>,<-0.022,0.00107,0.04327>,<-0.02436,0,0.04306>,
            <-0.02367,-0.00107,0.04079>,
    /*2*/ <-0.03645,0.03735,0.01888>,<-0.03706,0.03829,0.02086>,<-0.03912,0.03735,0.02067>,
            <-0.03852,0.03642,0.01869>,
    /*3*/ <-0.05105,0.07541,-0.00241>,<-0.05156,0.07619,-0.00069>,<-0.05334,0.07541,-0.00087>,
            <-0.05283,0.07464,-0.00258>,
    /*4*/ <-0.06499,0.11421,-0.02277>,<-0.0654,0.11482,-0.02133>,<-0.0669,0.11421,-0.02149>,
            <-0.06649,0.11359,-0.02294>,
    /*5*/ <-0.07532,0.15485,-0.0415>,<-0.07564,0.15532,-0.04032>,<-0.07686,0.15493,-0.04051>,
            <-0.07654,0.15446,-0.04168>,
    /*6*/ <-0.0876,0.19359,-0.06301>,<-0.08785,0.19399,-0.06216>,<-0.08876,0.19365,-0.06227>,
            <-0.08851,0.19325,-0.06312>,
    /*7*/ <-0.0996,0.22897,-0.08974>,<-0.0998,0.2293,-0.08921>,<-0.10039,0.22905,-0.08928>,
            <-0.1002,0.22872,-0.0898>,
    /*8*/ <-0.11211,0.26031,-0.12093>,<-0.11222,0.26051,-0.1207>,<-0.11252,0.26037,-0.12072>,
            <-0.11241,0.26018,-0.12095>,
    /*9*/ <-0.12621,0.28866,-0.15428>

    /* stem 0*/ 
    /*0*/ <0.00112,0,-0.01469>,
    /*1*/ <0.00214,0,-0.01316>,<-0.00034,-0.00054,-0.01371>,<0.0001,-0,-0.01621>,
            <0.00258,0.00054,-0.01566>,
    /*2*/ <-0.00916,0.04397,-0.00587>,<-0.01133,0.0435,-0.00635>,<-0.01095,0.04397,-0.00855>,
            <-0.00877,0.04444,-0.00807>,
    /*3*/ <-0.02271,0.08757,0.00022>,<-0.02455,0.08706,-0.00021>,<-0.02421,0.08744,-0.0021>,
            <-0.02238,0.08794,-0.00167>,
    /*4*/ <-0.03671,0.13112,0.0052>,<-0.03823,0.13068,0.00484>,<-0.03794,0.13096,0.00326>,
            <-0.03642,0.1314,0.00362>,
    /*5*/ <-0.0517,0.17418,0.01109>,<-0.05291,0.1738,0.0108>,<-0.05269,0.17406,0.00954>,
            <-0.05148,0.17444,0.00983>,
    /*6*/ <-0.06473,0.21817,0.01448>,<-0.06564,0.21792,0.01426>,<-0.06546,0.21805,0.01331>,
            <-0.06454,0.2183,0.01353>,
    /*7*/ <-0.07494,0.26281,0.01826>,<-0.07556,0.26269,0.01812>,<-0.07543,0.26277,0.01749>,
            <-0.07481,0.2629,0.01763>,
    /*8*/ <-0.08455,0.30781,0.01786>,<-0.08486,0.30774,0.01779>,<-0.08479,0.30776,0.01748>,
            <-0.08448,0.30782,0.01755>,
    /*9*/ <-0.0914,0.35327,0.01743>

    /* stem 0*/ 
    /*0*/ <0.02234,0,0.00335>,
    /*1*/ <0.0205,0,0.00347>,<0.02222,-0.00042,0.00156>,<0.02417,-0,0.00323>,
            <0.02246,0.00042,0.00514>,
    /*2*/ <0.02003,0.04477,-0.00698>,<0.02153,0.04441,-0.00865>,<0.02324,0.04477,-0.0072>,
            <0.02174,0.04514,-0.00553>,
    /*3*/ <0.02128,0.08975,-0.01674>,<0.02256,0.08941,-0.01816>,<0.02403,0.08965,-0.0169>,
            <0.02274,0.08999,-0.01547>,
    /*4*/ <0.02068,0.13505,-0.02425>,<0.02175,0.13487,-0.02546>,<0.02297,0.13507,-0.0244>,
            <0.0219,0.13525,-0.02319>,
    /*5*/ <0.01939,0.18024,-0.03257>,<0.02025,0.18009,-0.03353>,<0.02122,0.18028,-0.03269>,
            <0.02037,0.18043,-0.03173>,
    /*6*/ <0.02008,0.22586,-0.03853>,<0.02073,0.22576,-0.03926>,<0.02146,0.22584,-0.03862>,
            <0.02082,0.22594,-0.03789>,
    /*7*/ <0.02312,0.27167,-0.0416>,<0.02355,0.27161,-0.04209>,<0.02404,0.27161,-0.04166>,
            <0.02361,0.27167,-0.04117>,
    /*8*/ <0.02821,0.31735,-0.03978>,<0.02842,0.31734,-0.04003>,<0.02867,0.31731,-0.03981>,
            <0.02845,0.31732,-0.03957>,
    /*9*/ <0.03028,0.36274,-0.03279>

    /* stem 0*/ 
    /*0*/ <0.04083,0,0.01633>,
    /*1*/ <0.04076,0,0.0145>,<0.04261,0.00045,0.01626>,<0.0409,0,0.01817>,
            <0.03905,-0.00045,0.0164>,
    /*2*/ <0.02957,0.04459,0.01517>,<0.03119,0.04499,0.01671>,<0.02969,0.04459,0.01838>,
            <0.02807,0.0442,0.01684>,
    /*3*/ <0.0192,0.08939,0.01579>,<0.0206,0.0897,0.01712>,<0.01931,0.08939,0.01855>,
            <0.01791,0.08907,0.01722>,
    /*4*/ <0.00676,0.13354,0.0141>,<0.00789,0.13391,0.0152>,<0.00682,0.13366,0.01639>,
            <0.00568,0.13329,0.01529>,
    /*5*/ <-0.00635,0.17765,0.01363>,<-0.00544,0.17793,0.01451>,<-0.00629,0.17769,0.01547>,
            <-0.0072,0.17741,0.01459>,
    /*6*/ <-0.02124,0.22116,0.01348>,<-0.02056,0.22139,0.01414>,<-0.02119,0.22119,0.01486>,
            <-0.02187,0.22095,0.0142>,
    /*7*/ <-0.03792,0.26395,0.0165>,<-0.03746,0.2641,0.01694>,<-0.03786,0.26391,0.01742>,
            <-0.03831,0.26376,0.01698>,
    /*8*/ <-0.05893,0.30473,0.01959>,<-0.05872,0.30482,0.01982>,<-0.05891,0.30471,0.02005>,
            <-0.05912,0.30461,0.01983>,
    /*9*/ <-0.08376,0.34333,0.02235>

    }
    normal_vectors { 646
    /* stem 0*/ 
    /*0*/<-0.38257,-0.9191,0.09429>,
    /*1*/<0.24122,0.0046,0.97046>,<-0.89047,0.39861,0.21948>,<-0.2374,0.0046,-0.9714>,
            <0.8943,-0.38942,-0.22042>,
    /*2*/<0.23797,-0.00341,0.97127>,<-0.89494,0.38791,0.2205>,<-0.23417,0.01262,-0.97211>,
            <0.89866,-0.37868,-0.22137>,
    /*3*/<0.24431,0.01206,0.96962>,<-0.89509,0.38754,0.22053>,<-0.24067,-0.00284,-0.9706>,
            <0.89881,-0.37832,-0.2214>,
    /*4*/<0.2469,0.02126,0.96881>,<-0.88038,0.42244,0.21559>,<-0.24303,-0.01217,-0.96994>,
            <0.88435,-0.4134,-0.21684>,
    /*5*/<0.23851,0.00157,0.97114>,<-0.85668,0.47123,0.20987>,<-0.23409,0.00732,-0.97219>,
            <0.86118,-0.46245,-0.21097>,
    /*6*/<0.23812,0.00047,0.97124>,<-0.82079,0.53473,0.20092>,<-0.23315,0.00812,-0.97241>,
            <0.82591,-0.52633,-0.20211>,
    /*7*/<0.24123,0.00396,0.97046>,<-0.76909,0.61061,0.18882>,<-0.23552,0.00413,-0.97186>,
            <0.77493,-0.60273,-0.19025>,
    /*8*/<0.2417,0.0038,0.97034>,<-0.71237,0.67966,0.17492>,<-0.23529,0.00371,-0.97192>,
            <0.7189,-0.67233,-0.17652>,
    /*9*/<0.68711,0.70669,-0.16869>

    /* stem 0*/ 
    /*0*/<-0.15082,-0.97288,0.17538>,
    /*1*/<-0.75744,0.00486,-0.65289>,<0.63508,-0.22644,-0.73851>,<0.75895,0.00486,0.65114>,
            <-0.63358,0.23617,0.73675>,
    /*2*/<-0.76315,-0.03154,-0.64545>,<0.63253,-0.24568,-0.73454>,<0.76443,0.04115,0.6434>,
            <-0.63104,0.25534,0.73252>,
    /*3*/<-0.76367,-0.03915,-0.64442>,<0.62488,-0.29183,-0.72413>,<0.76515,0.04859,0.64202>,
            <-0.62341,0.30129,0.72151>,
    /*4*/<-0.76037,-0.02223,-0.64911>,<0.61908,-0.32756,-0.71375>,<0.76229,0.03162,0.64646>,
            <-0.61708,0.33694,0.71111>,
    /*5*/<-0.76352,-0.03693,-0.64473>,<0.62391,-0.2987,-0.72216>,<0.76529,0.04638,0.64201>,
            <-0.62225,0.30817,0.71961>,
    /*6*/<-0.76381,-0.03636,-0.64442>,<0.6378,-0.19618,-0.7448>,<0.76501,0.04608,0.64237>,
            <-0.63685,0.2058,0.74301>,
    /*7*/<-0.76407,-0.03378,-0.64425>,<0.64475,-0.06171,-0.7619>,<0.76443,0.04373,0.64323>,
            <-0.64461,0.07148,0.76116>,
    /*8*/<-0.76415,-0.03927,-0.64385>,<0.63864,0.08958,-0.76427>,<0.76352,0.04925,0.6439>,
            <-0.6395,-0.07976,0.76465>,
    /*9*/<-0.14298,0.98508,0.09575>

    /* stem 0*/ 
    /*0*/<-0.22698,-0.94819,0.2223>,
    /*1*/<0.70082,0.00474,0.71332>,<-0.67628,0.32245,0.66233>,<-0.69856,0.00474,-0.71554>,
            <0.67855,-0.31296,-0.66455>,
    /*2*/<0.70251,0.01171,0.71158>,<-0.67438,0.33036,0.66036>,<-0.70026,-0.00224,-0.71388>,
            <0.67668,-0.32091,-0.66266>,
    /*3*/<0.70241,0.01202,0.71167>,<-0.66856,0.35379,0.65411>,<-0.70002,-0.00262,-0.71412>,
            <0.67097,-0.34444,-0.65663>,
    /*4*/<0.70771,0.0306,0.70584>,<-0.66294,0.37425,0.64842>,<-0.7053,-0.02134,-0.70859>,
            <0.66548,-0.36498,-0.6511>,
    /*5*/<0.71388,0.05655,0.69798>,<-0.6485,0.42916,0.6287>,<-0.71143,-0.04743,-0.70116>,
            <0.65112,-0.42021,-0.63203>,
    /*6*/<0.71667,0.06284,0.69457>,<-0.61822,0.51851,0.59073>,<-0.71359,-0.05416,-0.69847>,
            <0.62142,-0.5101,-0.59467>,
    /*7*/<0.72722,0.08519,0.6811>,<-0.58596,0.59501,0.5501>,<-0.72376,-0.07703,-0.68574>,
            <0.5896,-0.58705,-0.55475>,
    /*8*/<0.73567,0.10018,0.66989>,<-0.53651,0.68957,0.48646>,<-0.73175,-0.09271,-0.67524>,
            <0.54062,-0.68241,-0.49198>,
    /*9*/<0.45556,0.66518,-0.5916>

    /* stem 0*/ 
    /*0*/<0.12208,-0.94976,0.28817>,
    /*1*/<-0.92138,0.00475,0.38862>,<-0.37108,-0.30821,-0.87596>,<0.92016,0.00475,-0.3915>,
            <0.36986,0.31771,0.87308>,
    /*2*/<-0.92064,-0.00104,0.39042>,<-0.36996,-0.31666,-0.87342>,<0.91934,0.01053,-0.39331>,
            <0.36868,0.32613,0.87047>,
    /*3*/<-0.9148,-0.03831,0.40209>,<-0.36906,-0.32494,-0.87075>,<0.9131,0.04768,-0.40493>,
            <0.36751,0.33438,0.86783>,
    /*4*/<-0.9115,-0.0555,0.40754>,<-0.36514,-0.34866,-0.8632>,<0.9096,0.06481,-0.41041>,
            <0.36311,0.35796,0.86024>,
    /*5*/<-0.91154,-0.05757,0.40715>,<-0.37306,-0.30733,-0.87543>,<0.9096,0.06692,-0.41006>,
            <0.37136,0.31662,0.87284>,
    /*6*/<-0.90814,-0.07766,0.4114>,<-0.3905,-0.19901,-0.89884>,<0.90647,0.08736,-0.41312>,
            <0.38897,0.20854,0.89734>,
    /*7*/<-0.91023,-0.05966,0.40979>,<-0.39883,-0.13765,-0.90664>,<0.90902,0.06951,-0.41092>,
            <0.39756,0.14746,0.90565>,
    /*8*/<-0.912,-0.03173,0.40896>,<-0.40552,-0.07891,-0.91068>,<0.91124,0.04166,-0.40975>,
            <0.40481,0.08885,0.91007>,
    /*9*/<-0.04617,0.99856,-0.02745>

    /* stem 0*/ 
    /*0*/<-0.10095,-0.99311,0.05953>,
    /*1*/<-0.50747,0.00497,-0.86166>,<0.85593,-0.11223,-0.50477>,<0.50848,0.00497,0.86106>,
            <-0.85492,0.12216,0.50418>,
    /*2*/<-0.50806,-0.0002,-0.86132>,<0.85324,-0.13754,-0.50305>,<0.50915,0.01012,0.86062>,
            <-0.85203,0.1474,0.50231>,
    /*3*/<-0.5078,0.00032,-0.86148>,<0.84988,-0.16317,-0.50107>,<0.50922,0.00953,0.86058>,
            <-0.84848,0.17298,0.50016>,
    /*4*/<-0.5106,-0.01764,-0.85964>,<0.84737,-0.1816,-0.49898>,<0.512,0.02745,0.85854>,
            <-0.84582,0.19141,0.49794>,
    /*5*/<-0.51059,-0.01285,-0.85973>,<0.84894,-0.1688,-0.50081>,<0.51211,0.02261,0.85862>,
            <-0.84762,0.17859,0.49965>,
    /*6*/<-0.509,0.01244,-0.86068>,<0.8576,-0.0757,-0.50872>,<0.50999,-0.00254,0.86017>,
            <-0.85687,0.08553,0.5084>,
    /*7*/<-0.5095,-0.0152,-0.86034>,<0.86028,-0.00032,-0.50982>,<0.5095,0.02519,0.8601>,
            <-0.86027,0.01021,0.50973>,
    /*8*/<-0.5076,-0.03995,-0.86067>,<0.85869,0.05734,-0.50928>,<0.50711,0.04992,0.86044>,
            <-0.85937,-0.04738,0.50916>,
    /*9*/<-0.10626,0.99429,0.01004>

    /* stem 0*/ 
    /*0*/<-0.31802,-0.8468,0.42638>,
    /*1*/<0.80317,0.00423,0.59574>,<-0.50469,0.53615,0.67664>,<-0.79999,0.00423,-0.6>,
            <0.50787,-0.52768,-0.6809>,
    /*2*/<0.80539,0.01056,0.59265>,<-0.50931,0.52356,0.683>,<-0.80231,-0.00206,-0.59691>,
            <0.51239,-0.51502,-0.68718>,
    /*3*/<0.80815,0.01923,0.58866>,<-0.51646,0.50352,0.69263>,<-0.80529,-0.0106,-0.59279>,
            <0.51931,-0.49487,-0.69672>,
    /*4*/<0.80332,0.00501,0.59553>,<-0.51493,0.50763,0.69077>,<-0.80036,0.00365,-0.59951>,
            <0.51785,-0.499,-0.69486>,
    /*5*/<0.80689,0.01027,0.59062>,<-0.49165,0.56859,0.65953>,<-0.80374,-0.00188,-0.59498>,
            <0.49503,-0.56044,-0.66396>,
    /*6*/<0.81817,0.03422,0.57396>,<-0.46782,0.61993,0.62995>,<-0.81483,-0.02636,-0.5791>,
            <0.47115,-0.61217,-0.63504>,
    /*7*/<0.82136,0.04056,0.56896>,<-0.44981,0.6595,0.60226>,<-0.81794,-0.03287,-0.57436>,
            <0.45335,-0.65199,-0.60777>,
    /*8*/<0.81501,0.02816,0.57877>,<-0.42414,0.70884,0.5636>,<-0.81109,-0.021,-0.58455>,
            <0.428,-0.70179,-0.56947>,
    /*9*/<0.42247,0.69374,-0.5833>

    /* stem 0*/ 
    /*0*/<-0.13391,-0.98911,-0.06107>,
    /*1*/<-0.41429,0.00495,0.91013>,<-0.89925,0.15212,-0.41014>,<0.41563,0.00495,-0.90952>,
            <0.90059,-0.14223,0.41075>,
    /*2*/<-0.41287,0.01985,0.91057>,<-0.90452,0.11041,-0.41189>,<0.41408,-0.00995,-0.91018>,
            <0.9055,-0.10058,0.41226>,
    /*3*/<-0.41272,0.02065,0.91062>,<-0.90871,0.0581,-0.41337>,<0.41331,-0.0107,-0.91053>,
            <0.90928,-0.04824,0.41338>,
    /*4*/<-0.41375,-0.02282,0.9101>,<-0.90997,0.02477,-0.41393>,<0.41392,0.03276,-0.90972>,
            <0.9101,-0.0148,0.41413>,
    /*5*/<-0.41327,-0.05033,0.90922>,<-0.91037,0.04697,-0.41112>,<0.41322,0.06027,-0.90864>,
            <0.91052,-0.03709,0.4118>,
    /*6*/<-0.41517,-0.07031,0.90702>,<-0.90311,0.15769,-0.3994>,<0.41596,0.0802,-0.90584>,
            <0.90422,-0.14802,0.40058>,
    /*7*/<-0.41573,-0.07803,0.90613>,<-0.88397,0.26813,-0.38302>,<0.41759,0.08769,-0.90439>,
            <0.88597,-0.25868,0.38489>,
    /*8*/<-0.4093,-0.05879,0.9105>,<-0.86089,0.35527,-0.36421>,<0.41207,0.0682,-0.9086>,
            <0.86382,-0.34598,0.36622>,
    /*9*/<0.33691,0.91801,0.20916>

    /* stem 0*/ 
    /*0*/<-0.03816,-0.94855,0.31433>,
    /*1*/<-0.99251,0.00474,-0.12209>,<0.1145,-0.31189,-0.94319>,<0.99289,0.00474,0.11894>,
            <-0.11412,0.32138,0.94005>,
    /*2*/<-0.9924,0.00697,-0.12287>,<0.11413,-0.32072,-0.94027>,<0.99281,0.0025,0.11968>,
            <-0.11373,0.33017,0.93705>,
    /*3*/<-0.99132,0.02415,-0.12925>,<0.11303,-0.34223,-0.93279>,<0.99193,-0.01476,0.1259>,
            <-0.11249,0.35159,0.92937>,
    /*4*/<-0.99218,0.0127,-0.12417>,<0.11072,-0.38768,-0.91512>,<0.99271,-0.00348,0.12047>,
            <-0.11002,0.39681,0.91128>,
    /*5*/<-0.99338,-0.00878,-0.11451>,<0.10942,-0.37712,-0.91968>,<0.99371,0.01789,0.1105>,
            <-0.10914,0.38624,0.91592>,
    /*6*/<-0.99182,0.02529,-0.12515>,<0.11191,-0.30926,-0.94437>,<0.99241,-0.01586,0.12194>,
            <-0.11148,0.31865,0.94129>,
    /*7*/<-0.9856,0.09401,-0.14056>,<0.11807,-0.22872,-0.9663>,<0.98681,-0.08444,0.13809>,
            <-0.11709,0.23836,0.96409>,
    /*8*/<-0.98548,0.09464,-0.14093>,<0.127,-0.12188,-0.98439>,<0.98657,-0.08484,0.13955>,
            <-0.12575,0.13166,0.98329>,
    /*9*/<0.06063,0.99576,-0.06922>

    /* stem 0*/ 
    /*0*/<-0.01867,-0.95672,-0.29042>,
    /*1*/<0.99802,0.00478,-0.06269>,<0.06146,-0.28623,0.95619>,<-0.99784,0.00478,0.06559>,
            <-0.06127,0.2958,-0.95328>,
    /*2*/<0.99773,-0.00912,-0.06673>,<0.06195,-0.27264,0.96012>,<-0.9974,0.0187,0.06955>,
            <-0.0617,0.28223,-0.95736>,
    /*3*/<0.99561,-0.05126,-0.07831>,<0.06417,-0.24234,0.96807>,<-0.99487,0.06086,0.08081>,
            <-0.06358,0.25199,-0.96564>,
    /*4*/<0.99538,-0.05321,-0.07996>,<0.06595,-0.22904,0.97118>,<-0.99463,0.06284,0.08222>,
            <-0.06507,0.23872,-0.96891>,
    /*5*/<0.9977,0.00242,-0.06781>,<0.06574,-0.17862,0.98172>,<-0.99753,0.00729,0.0699>,
            <-0.06544,0.18834,-0.97992>,
    /*6*/<0.99738,0.03047,-0.06554>,<0.06819,-0.08874,0.99372>,<-0.99756,-0.02057,0.06666>,
            <-0.06839,0.09855,-0.99278>,
    /*7*/<0.99762,0.01945,-0.06609>,<0.06681,-0.01202,0.99769>,<-0.99774,-0.00945,0.06647>,
            <-0.06698,0.02196,-0.99751>,
    /*8*/<0.99777,0.01027,-0.06594>,<0.06477,0.10207,0.99267>,<-0.99786,-0.00028,0.06534>,
            <-0.06489,-0.09218,-0.99363>,
    /*9*/<-0.01619,0.98554,-0.16867>

    /* stem 0*/ 
    /*0*/<0.0795,-0.9436,0.32139>,
    /*1*/<-0.97113,0.00472,0.23851>,<-0.22697,-0.32635,-0.91759>,<0.97033,0.00472,-0.24172>,
            <0.22618,0.33579,0.91438>,
    /*2*/<-0.97041,-0.00333,0.24143>,<-0.22438,-0.35362,-0.90808>,<0.9695,0.01272,-0.24476>,
            <0.22349,0.36291,0.90463>,
    /*3*/<-0.96944,-0.01288,0.24499>,<-0.2221,-0.37832,-0.89863>,<0.96834,0.02211,-0.24867>,
            <0.22101,0.3875,0.89498>,
    /*4*/<-0.96526,-0.04247,0.2578>,<-0.21686,-0.41182,-0.88508>,<0.96382,0.05159,-0.26152>,
            <0.21553,0.42085,0.88116>,
    /*5*/<-0.95696,-0.08666,0.27697>,<-0.22151,-0.4031,-0.88794>,<0.95498,0.09559,-0.28085>,
            <0.21969,0.41205,0.88428>,
    /*6*/<-0.95493,-0.09677,0.28061>,<-0.23747,-0.31732,-0.91811>,<0.95304,0.1061,-0.28364>,
            <0.23562,0.32659,0.91533>,
    /*7*/<-0.95633,-0.08716,0.279>,<-0.25242,-0.23516,-0.93861>,<0.95474,0.09678,-0.28126>,
            <0.25088,0.24474,0.93657>,
    /*8*/<-0.96006,-0.05542,0.27424>,<-0.26017,-0.18138,-0.94837>,<0.95896,0.06521,-0.27593>,
            <0.25895,0.19114,0.94679>,
    /*9*/<-0.07661,0.98432,-0.15892>

    /* stem 0*/ 
    /*0*/<0.54571,-0.79854,-0.25404>,
    /*1*/<-0.42475,0.00399,-0.9053>,<0.7212,0.60593,-0.33573>,<0.4193,0.00399,0.90784>,
            <-0.72666,-0.59794,0.33827>,
    /*2*/<-0.43407,0.01884,-0.90068>,<0.73761,0.58107,-0.34394>,<0.42881,-0.01078,0.90333>,
            <-0.74277,-0.57295,0.34644>,
    /*3*/<-0.44213,0.03283,-0.89635>,<0.76898,0.5284,-0.35982>,<0.43741,-0.02443,0.89893>,
            <-0.77352,-0.51999,0.36232>,
    /*4*/<-0.43504,0.0184,-0.90022>,<0.79824,0.471,-0.37545>,<0.43076,-0.00964,0.90242>,
            <-0.80231,-0.46226,0.37763>,
    /*5*/<-0.42646,-0.00003,-0.90451>,<0.79152,0.48362,-0.37365>,<0.4223,0.00891,0.90641>,
            <-0.7958,-0.47496,0.37564>,
    /*6*/<-0.40487,-0.03526,-0.9137>,<0.74255,0.56911,-0.35318>,<0.39978,0.04362,0.91557>,
            <-0.7477,-0.561,0.35529>,
    /*7*/<-0.38486,-0.06185,-0.9209>,<0.68723,0.64682,-0.33068>,<0.3789,0.0696,0.92282>,
            <-0.69331,-0.63928,0.33264>,
    /*8*/<-0.3746,-0.07329,-0.92428>,<0.63406,0.70674,-0.31383>,<0.36797,0.08049,0.92635>,
            <-0.64075,-0.6997,0.31602>,
    /*9*/<-0.70449,0.67906,0.20633>

    /* stem 0*/ 
    /*0*/<-0.11314,-0.9872,0.11242>,
    /*1*/<0.7054,0.00494,0.70879>,<-0.69971,0.16442,0.69525>,<-0.70427,0.00494,-0.70992>,
            <0.70084,-0.15455,-0.69637>,
    /*2*/<0.7054,0.00525,0.70879>,<-0.70141,0.14933,0.69694>,<-0.70433,0.00463,-0.70986>,
            <0.70243,-0.13945,-0.69796>,
    /*3*/<0.70549,0.0076,0.70868>,<-0.70387,0.12401,0.69942>,<-0.70463,0.00232,-0.70957>,
            <0.7047,-0.11411,-0.70027>,
    /*4*/<0.7064,0.0253,0.70737>,<-0.7057,0.09899,0.70156>,<-0.70582,-0.01537,-0.70822>,
            <0.70628,-0.08905,-0.70231>,
    /*5*/<0.70746,0.05643,0.7045>,<-0.70584,0.11282,0.69933>,<-0.70716,-0.04651,-0.70552>,
            <0.7063,-0.10293,-0.70039>,
    /*6*/<0.71003,0.0859,0.69891>,<-0.70165,0.17401,0.69095>,<-0.70953,-0.07607,-0.70056>,
            <0.70232,-0.16424,-0.69265>,
    /*7*/<0.71118,0.09277,0.69686>,<-0.69393,0.24879,0.67569>,<-0.71022,-0.08306,-0.69906>,
            <0.69501,-0.23919,-0.67805>,
    /*8*/<0.71576,0.11988,0.68798>,<-0.68418,0.32257,0.6541>,<-0.71444,-0.11042,-0.69093>,
            <0.68574,-0.31318,-0.65703>,
    /*9*/<0.14083,0.92495,-0.35303>

    /* stem 0*/ 
    /*0*/<-0.00621,-0.91404,-0.40558>,
    /*1*/<-0.99984,0.00457,0.01735>,<-0.01397,0.4102,-0.91189>,<0.9999,0.00457,-0.01329>,
            <0.01403,-0.40106,0.91595>,
    /*2*/<-0.99984,0.00491,0.01735>,<-0.01427,0.36561,-0.93066>,<0.9999,0.00433,-0.01352>,
            <0.01433,-0.35643,0.93421>,
    /*3*/<-0.99989,-0.00473,0.01374>,<-0.01458,0.32406,-0.94592>,<0.99984,0.0142,-0.01056>,
            <0.01458,-0.31474,0.94907>,
    /*4*/<-0.9999,-0.00592,0.01317>,<-0.01464,0.2915,-0.95646>,<0.99983,0.01543,-0.01013>,
            <0.01452,-0.28199,0.95931>,
    /*5*/<-0.9999,-0.00044,0.01437>,<-0.01419,0.31869,-0.94775>,<0.99988,0.01003,-0.01154>,
            <0.0142,-0.30941,0.95082>,
    /*6*/<-0.99955,0.0186,0.02372>,<-0.01301,0.4169,-0.90886>,<0.99976,-0.00943,-0.01978>,
            <0.0131,-0.40799,0.91289>,
    /*7*/<-0.99672,0.06417,0.0494>,<-0.01131,0.48474,-0.87458>,<0.99746,-0.05536,-0.04479>,
            <0.01192,-0.47604,0.87934>,
    /*8*/<-0.99366,0.09021,0.06715>,<-0.00629,0.55133,-0.83427>,<0.99473,-0.08178,-0.0619>,
            <0.00734,-0.54303,0.83968>,
    /*9*/<0.11162,0.80901,0.5771>

    /* stem 0*/ 
    /*0*/<-0.00814,-0.99875,-0.04931>,
    /*1*/<0.98669,0.00499,-0.16253>,<0.16261,-0.04498,0.98566>,<-0.98661,0.00499,0.16302>,
            <-0.16253,0.05497,-0.98517>,
    /*2*/<0.9867,0.005,-0.16249>,<0.16248,-0.06014,0.98488>,<-0.9866,0.00498,0.16306>,
            <-0.16238,0.0701,-0.98424>,
    /*3*/<0.98652,-0.00612,-0.16352>,<0.16155,-0.10595,0.98116>,<-0.98625,0.01607,0.16445>,
            <-0.16131,0.11582,-0.98008>,
    /*4*/<0.98558,-0.03064,-0.16643>,<0.16171,-0.12324,0.97911>,<-0.985,0.04053,0.1677>,
            <-0.16122,0.13309,-0.9779>,
    /*5*/<0.98243,-0.07681,-0.17009>,<0.16841,-0.05198,0.98435>,<-0.98148,0.0867,0.1708>,
            <-0.16769,0.06182,-0.9839>,
    /*6*/<0.97858,-0.11814,-0.16862>,<0.17513,0.04331,0.98359>,<-0.9774,0.12802,0.16821>,
            <-0.17405,-0.03355,-0.98417>,
    /*7*/<0.97727,-0.13032,-0.16723>,<0.18356,0.1228,0.97531>,<-0.9761,0.14018,0.16604>,
            <-0.18247,-0.11302,-0.97669>,
    /*8*/<0.97251,-0.17145,-0.15755>,<0.19591,0.2198,0.95567>,<-0.97111,0.18111,0.15539>,
            <-0.19476,-0.21021,-0.95806>,
    /*9*/<0.1615,0.93918,-0.3031>

    /* stem 0*/ 
    /*0*/<-0.28059,-0.89136,-0.35603>,
    /*1*/<-0.78399,0.00446,0.62075>,<-0.55032,0.45775,-0.69829>,<0.7868,0.00446,-0.61719>,
            <0.55313,-0.44884,0.70185>,
    /*2*/<-0.78173,0.01174,0.62351>,<-0.55356,0.44765,-0.70227>,<0.78456,-0.0028,-0.62004>,
            <0.55633,-0.43869,0.70573>,
    /*3*/<-0.7841,0.00419,0.62062>,<-0.55781,0.43336,-0.70784>,<0.78676,0.00481,-0.61724>,
            <0.56053,-0.42434,0.71116>,
    /*4*/<-0.7917,-0.02474,0.6104>,<-0.56882,0.39192,-0.72308>,<0.79396,0.03385,-0.60703>,
            <0.57101,-0.38278,0.72625>,
    /*5*/<-0.79593,-0.04358,0.60382>,<-0.56924,0.39461,-0.72128>,<0.7978,0.05285,-0.6006>,
            <0.57123,-0.38555,0.7246>,
    /*6*/<-0.79821,-0.05262,0.60007>,<-0.54486,0.48909,-0.68111>,<0.80055,0.0615,-0.5961>,
            <0.54735,-0.48051,0.68521>,
    /*7*/<-0.79884,-0.05554,0.59897>,<-0.51532,0.577,-0.63366>,<0.80177,0.06384,-0.59421>,
            <0.51831,-0.56894,0.63849>,
    /*8*/<-0.80484,-0.07039,0.58931>,<-0.49587,0.6261,-0.60175>,<0.80799,0.07824,-0.58398>,
            <0.49914,-0.61833,0.60706>,
    /*9*/<0.3131,0.76558,0.56201>

    /* stem 0*/ 
    /*0*/<0.32513,-0.8124,0.48405>,
    /*1*/<0.82849,0.00406,-0.55999>,<0.45134,0.58716,0.67196>,<-0.83174,0.00406,0.55515>,
            <-0.45459,-0.57904,-0.6768>,
    /*2*/<0.82844,0.00426,-0.56007>,<0.45567,0.57631,0.67841>,<-0.83166,0.0039,0.55527>,
            <-0.45886,-0.56812,-0.68315>,
    /*3*/<0.82853,0.00424,-0.55992>,<0.46448,0.55323,0.69152>,<-0.83163,0.00408,0.55531>,
            <-0.46753,-0.54489,-0.69607>,
    /*4*/<0.83496,-0.0156,-0.55009>,<0.48044,0.50522,0.71689>,<-0.83766,0.02413,0.54566>,
            <-0.48311,-0.49665,-0.72107>,
    /*5*/<0.84043,-0.03476,-0.54081>,<0.48162,0.50569,0.71577>,<-0.84274,0.04349,0.53656>,
            <-0.484,-0.49717,-0.72011>,
    /*6*/<0.84966,-0.06237,-0.52362>,<0.45645,0.5895,0.66644>,<-0.85213,0.0706,0.51855>,
            <-0.45917,-0.58154,-0.67155>,
    /*7*/<0.86597,-0.10605,-0.48872>,<0.42264,0.68114,0.59785>,<-0.86846,0.1135,0.48259>,
            <-0.42533,-0.67397,-0.60403>,
    /*8*/<0.87266,-0.12217,-0.47279>,<0.39177,0.75337,0.52816>,<-0.87543,0.12882,0.46586>,
            <-0.3946,-0.74693,-0.53515>,
    /*9*/<-0.30225,0.61593,-0.72751>

    /* stem 0*/ 
    /*0*/<0.24299,-0.95631,-0.16258>,
    /*1*/<0.55485,0.00478,0.83194>,<-0.79602,-0.28758,0.53258>,<-0.55728,0.00478,-0.83031>,
            <0.79359,0.29714,-0.53096>,
    /*2*/<0.54839,0.02802,0.83575>,<-0.7925,-0.30074,0.53056>,<-0.551,-0.01851,-0.8343>,
            <0.7899,0.31025,-0.52896>,
    /*3*/<0.53738,0.06308,0.84098>,<-0.78993,-0.31155,0.52816>,<-0.54034,-0.05366,-0.83974>,
            <0.787,0.32101,-0.52686>,
    /*4*/<0.53397,0.07298,0.84235>,<-0.78615,-0.32391,0.52635>,<-0.53703,-0.06355,-0.84116>,
            <0.78302,0.33332,-0.52514>,
    /*5*/<0.53142,0.08114,0.84321>,<-0.792,-0.30598,0.52831>,<-0.53458,-0.07172,-0.84207>,
            <0.78902,0.3154,-0.52722>,
    /*6*/<0.53441,0.0719,0.84216>,<-0.80751,-0.24973,0.53438>,<-0.53701,-0.0623,-0.84127>,
            <0.80497,0.25931,-0.53365>,
    /*7*/<0.53109,0.08559,0.84298>,<-0.8209,-0.19671,0.53612>,<-0.53334,-0.07589,-0.84249>,
            <0.81887,0.20645,-0.53556>,
    /*8*/<0.52899,0.10402,0.84223>,<-0.83016,-0.14105,0.53939>,<-0.53086,-0.09422,-0.84221>,
            <0.82836,0.15087,-0.53951>,
    /*9*/<-0.14626,0.98923,-0.0052>

    /* stem 0*/ 
    /*0*/<0.01518,-0.97376,0.22707>,
    /*1*/<-0.99784,0.00487,0.06555>,<-0.06501,-0.2227,-0.97272>,<0.99769,0.00487,-0.06782>,
            <0.06486,0.23244,0.97045>,
    /*2*/<-0.99785,0.02249,0.06162>,<-0.06493,-0.21377,-0.97472>,<0.99788,-0.01277,-0.06385>,
            <0.06488,0.22353,0.97254>,
    /*3*/<-0.99793,0.01885,0.06145>,<-0.06438,-0.1821,-0.98117>,<0.99795,-0.0091,-0.06343>,
            <0.06451,0.19188,0.9793>,
    /*4*/<-0.99769,-0.00904,0.06729>,<-0.06473,-0.1684,-0.98359>,<0.99744,0.01886,-0.06896>,
            <0.06451,0.17821,0.98188>,
    /*5*/<-0.99784,0.00378,0.06555>,<-0.06498,-0.15054,-0.98647>,<0.99772,0.00606,-0.06724>,
            <0.06476,0.16038,0.98493>,
    /*6*/<-0.99697,0.04682,0.06218>,<-0.06562,-0.09049,-0.99373>,<0.99731,-0.03692,-0.06332>,
            <0.06586,0.10039,0.99277>,
    /*7*/<-0.99409,0.0891,0.06204>,<-0.06173,-0.00311,-0.99809>,<0.9949,-0.07916,-0.06244>,
            <0.06247,0.01301,0.99796>,
    /*8*/<-0.99554,0.07237,0.06055>,<-0.05477,0.10543,-0.99292>,<0.99625,-0.06243,-0.05986>,
            <0.05567,-0.09559,0.99386>,
    /*9*/<0.03997,0.98751,0.15243>

    /* stem 0*/ 
    /*0*/<0.24355,-0.96984,-0.00961>,
    /*1*/<-0.04064,0.00485,-0.99916>,<0.96786,0.24858,-0.03818>,<0.0382,0.00485,0.99926>,
            <-0.97029,-0.23888,0.03828>,
    /*2*/<-0.04057,0.00468,-0.99917>,<0.9701,0.23966,-0.03827>,<0.03818,0.00503,0.99926>,
            <-0.97245,-0.22995,0.03836>,
    /*3*/<-0.03406,-0.02076,-0.9992>,<0.96679,0.25259,-0.03881>,<0.03169,0.03044,0.99903>,
            <-0.96927,-0.24293,0.03877>,
    /*4*/<-0.03192,-0.03371,-0.99892>,<0.95867,0.28169,-0.04012>,<0.02919,0.04327,0.99864>,
            <-0.96144,-0.27213,0.03977>,
    /*5*/<-0.03617,-0.01865,-0.99917>,<0.95033,0.30863,-0.04019>,<0.03322,0.02819,0.99905>,
            <-0.95337,-0.29912,0.04006>,
    /*6*/<-0.04898,0.01535,-0.99868>,<0.93626,0.34903,-0.03996>,<0.04566,-0.00595,0.99894>,
            <-0.93969,-0.33967,0.04006>,
    /*7*/<-0.06297,0.04456,-0.99702>,<0.90769,0.41783,-0.03888>,<0.05912,-0.03538,0.99762>,
            <-0.91178,-0.40878,0.0395>,
    /*8*/<-0.06017,0.03865,-0.99744>,<0.86193,0.50597,-0.03277>,<0.05538,-0.02989,0.99802>,
            <-0.86689,-0.49738,0.03338>,
    /*9*/<-0.54017,0.83977,0.05487>

    }
    face_indices { 1216
    /* stem 0*/ 
    /*0*/ <0,1,2>,<0,2,3>,<0,3,4>,<0,4,1>,
    /*1*/ <1,5,2>,<2,5,6>,<2,6,3>,<3,6,7>,<3,7,4>,
            <4,7,8>,<4,8,1>,<1,8,5>,
    /*2*/ <5,9,6>,<6,9,10>,<6,10,7>,<7,10,11>,<7,11,8>,
            <8,11,12>,<8,12,5>,<5,12,9>,
    /*3*/ <9,13,10>,<10,13,14>,<10,14,11>,<11,14,15>,<11,15,12>,
            <12,15,16>,<12,16,9>,<9,16,13>,
    /*4*/ <13,17,14>,<14,17,18>,<14,18,15>,<15,18,19>,<15,19,16>,
            <16,19,20>,<16,20,13>,<13,20,17>,
    /*5*/ <17,21,18>,<18,21,22>,<18,22,19>,<19,22,23>,<19,23,20>,
            <20,23,24>,<20,24,17>,<17,24,21>,
    /*6*/ <21,25,22>,<22,25,26>,<22,26,23>,<23,26,27>,<23,27,24>,
            <24,27,28>,<24,28,21>,<21,28,25>,
    /*7*/ <25,29,26>,<26,29,30>,<26,30,27>,<27,30,31>,<27,31,28>,
            <28,31,32>,<28,32,25>,<25,32,29>,
    /*8*/ <29,33,30>,<30,33,31>,<31,33,32>,<32,33,29>

    /* stem 0*/ 
    /*0*/ <34,35,36>,<34,36,37>,<34,37,38>,<34,38,35>,
    /*1*/ <35,39,36>,<36,39,40>,<36,40,37>,<37,40,41>,<37,41,38>,
            <38,41,42>,<38,42,35>,<35,42,39>,
    /*2*/ <39,43,40>,<40,43,44>,<40,44,41>,<41,44,45>,<41,45,42>,
            <42,45,46>,<42,46,39>,<39,46,43>,
    /*3*/ <43,47,44>,<44,47,48>,<44,48,45>,<45,48,49>,<45,49,46>,
            <46,49,50>,<46,50,43>,<43,50,47>,
    /*4*/ <47,51,48>,<48,51,52>,<48,52,49>,<49,52,53>,<49,53,50>,
            <50,53,54>,<50,54,47>,<47,54,51>,
    /*5*/ <51,55,52>,<52,55,56>,<52,56,53>,<53,56,57>,<53,57,54>,
            <54,57,58>,<54,58,51>,<51,58,55>,
    /*6*/ <55,59,56>,<56,59,60>,<56,60,57>,<57,60,61>,<57,61,58>,
            <58,61,62>,<58,62,55>,<55,62,59>,
    /*7*/ <59,63,60>,<60,63,64>,<60,64,61>,<61,64,65>,<61,65,62>,
            <62,65,66>,<62,66,59>,<59,66,63>,
    /*8*/ <63,67,64>,<64,67,65>,<65,67,66>,<66,67,63>

    /* stem 0*/ 
    /*0*/ <68,69,70>,<68,70,71>,<68,71,72>,<68,72,69>,
    /*1*/ <69,73,70>,<70,73,74>,<70,74,71>,<71,74,75>,<71,75,72>,
            <72,75,76>,<72,76,69>,<69,76,73>,
    /*2*/ <73,77,74>,<74,77,78>,<74,78,75>,<75,78,79>,<75,79,76>,
            <76,79,80>,<76,80,73>,<73,80,77>,
    /*3*/ <77,81,78>,<78,81,82>,<78,82,79>,<79,82,83>,<79,83,80>,
            <80,83,84>,<80,84,77>,<77,84,81>,
    /*4*/ <81,85,82>,<82,85,86>,<82,86,83>,<83,86,87>,<83,87,84>,
            <84,87,88>,<84,88,81>,<81,88,85>,
    /*5*/ <85,89,86>,<86,89,90>,<86,90,87>,<87,90,91>,<87,91,88>,
            <88,91,92>,<88,92,85>,<85,92,89>,
    /*6*/ <89,93,90>,<90,93,94>,<90,94,91>,<91,94,95>,<91,95,92>,
            <92,95,96>,<92,96,89>,<89,96,93>,
    /*7*/ <93,97,94>,<94,97,98>,<94,98,95>,<95,98,99>,<95,99,96>,
            <96,99,100>,<96,100,93>,<93,100,97>,
    /*8*/ <97,101,98>,<98,101,99>,<99,101,100>,<100,101,97>

    /* stem 0*/ 
    /*0*/ <102,103,104>,<102,104,105>,<102,105,106>,<102,106,103>,
    /*1*/ <103,107,104>,<104,107,108>,<104,108,105>,<105,108,109>,<105,109,106>,
            <106,109,110>,<106,110,103>,<103,110,107>,
    /*2*/ <107,111,108>,<108,111,112>,<108,112,109>,<109,112,113>,<109,113,110>,
            <110,113,114>,<110,114,107>,<107,114,111>,
    /*3*/ <111,115,112>,<112,115,116>,<112,116,113>,<113,116,117>,<113,117,114>,
            <114,117,118>,<114,118,111>,<111,118,115>,
    /*4*/ <115,119,116>,<116,119,120>,<116,120,117>,<117,120,121>,<117,121,118>,
            <118,121,122>,<118,122,115>,<115,122,119>,
    /*5*/ <119,123,120>,<120,123,124>,<120,124,121>,<121,124,125>,<121,125,122>,
            <122,125,126>,<122,126,119>,<119,126,123>,
    /*6*/ <123,127,124>,<124,127,128>,<124,128,125>,<125,128,129>,<125,129,126>,
            <126,129,130>,<126,130,123>,<123,130,127>,
    /*7*/ <127,131,128>,<128,131,132>,<128,132,129>,<129,132,133>,<129,133,130>,
            <130,133,134>,<130,134,127>,<127,134,131>,
    /*8*/ <131,135,132>,<132,135,133>,<133,135,134>,<134,135,131>

    /* stem 0*/ 
    /*0*/ <136,137,138>,<136,138,139>,<136,139,140>,<136,140,137>,
    /*1*/ <137,141,138>,<138,141,142>,<138,142,139>,<139,142,143>,<139,143,140>,
            <140,143,144>,<140,144,137>,<137,144,141>,
    /*2*/ <141,145,142>,<142,145,146>,<142,146,143>,<143,146,147>,<143,147,144>,
            <144,147,148>,<144,148,141>,<141,148,145>,
    /*3*/ <145,149,146>,<146,149,150>,<146,150,147>,<147,150,151>,<147,151,148>,
            <148,151,152>,<148,152,145>,<145,152,149>,
    /*4*/ <149,153,150>,<150,153,154>,<150,154,151>,<151,154,155>,<151,155,152>,
            <152,155,156>,<152,156,149>,<149,156,153>,
    /*5*/ <153,157,154>,<154,157,158>,<154,158,155>,<155,158,159>,<155,159,156>,
            <156,159,160>,<156,160,153>,<153,160,157>,
    /*6*/ <157,161,158>,<158,161,162>,<158,162,159>,<159,162,163>,<159,163,160>,
            <160,163,164>,<160,164,157>,<157,164,161>,
    /*7*/ <161,165,162>,<162,165,166>,<162,166,163>,<163,166,167>,<163,167,164>,
            <164,167,168>,<164,168,161>,<161,168,165>,
    /*8*/ <165,169,166>,<166,169,167>,<167,169,168>,<168,169,165>

    /* stem 0*/ 
    /*0*/ <170,171,172>,<170,172,173>,<170,173,174>,<170,174,171>,
    /*1*/ <171,175,172>,<172,175,176>,<172,176,173>,<173,176,177>,<173,177,174>,
            <174,177,178>,<174,178,171>,<171,178,175>,
    /*2*/ <175,179,176>,<176,179,180>,<176,180,177>,<177,180,181>,<177,181,178>,
            <178,181,182>,<178,182,175>,<175,182,179>,
    /*3*/ <179,183,180>,<180,183,184>,<180,184,181>,<181,184,185>,<181,185,182>,
            <182,185,186>,<182,186,179>,<179,186,183>,
    /*4*/ <183,187,184>,<184,187,188>,<184,188,185>,<185,188,189>,<185,189,186>,
            <186,189,190>,<186,190,183>,<183,190,187>,
    /*5*/ <187,191,188>,<188,191,192>,<188,192,189>,<189,192,193>,<189,193,190>,
            <190,193,194>,<190,194,187>,<187,194,191>,
    /*6*/ <191,195,192>,<192,195,196>,<192,196,193>,<193,196,197>,<193,197,194>,
            <194,197,198>,<194,198,191>,<191,198,195>,
    /*7*/ <195,199,196>,<196,199,200>,<196,200,197>,<197,200,201>,<197,201,198>,
            <198,201,202>,<198,202,195>,<195,202,199>,
    /*8*/ <199,203,200>,<200,203,201>,<201,203,202>,<202,203,199>

    /* stem 0*/ 
    /*0*/ <204,205,206>,<204,206,207>,<204,207,208>,<204,208,205>,
    /*1*/ <205,209,206>,<206,209,210>,<206,210,207>,<207,210,211>,<207,211,208>,
            <208,211,212>,<208,212,205>,<205,212,209>,
    /*2*/ <209,213,210>,<210,213,214>,<210,214,211>,<211,214,215>,<211,215,212>,
            <212,215,216>,<212,216,209>,<209,216,213>,
    /*3*/ <213,217,214>,<214,217,218>,<214,218,215>,<215,218,219>,<215,219,216>,
            <216,219,220>,<216,220,213>,<213,220,217>,
    /*4*/ <217,221,218>,<218,221,222>,<218,222,219>,<219,222,223>,<219,223,220>,
            <220,223,224>,<220,224,217>,<217,224,221>,
    /*5*/ <221,225,222>,<222,225,226>,<222,226,223>,<223,226,227>,<223,227,224>,
            <224,227,228>,<224,228,221>,<221,228,225>,
    /*6*/ <225,229,226>,<226,229,230>,<226,230,227>,<227,230,231>,<227,231,228>,
            <228,231,232>,<228,232,225>,<225,232,229>,
    /*7*/ <229,233,230>,<230,233,234>,<230,234,231>,<231,234,235>,<231,235,232>,
            <232,235,236>,<232,236,229>,<229,236,233>,
    /*8*/ <233,237,234>,<234,237,235>,<235,237,236>,<236,237,233>

    /* stem 0*/ 
    /*0*/ <238,239,240>,<238,240,241>,<238,241,242>,<238,242,239>,
    /*1*/ <239,243,240>,<240,243,244>,<240,244,241>,<241,244,245>,<241,245,242>,
            <242,245,246>,<242,246,239>,<239,246,243>,
    /*2*/ <243,247,244>,<244,247,248>,<244,248,245>,<245,248,249>,<245,249,246>,
            <246,249,250>,<246,250,243>,<243,250,247>,
    /*3*/ <247,251,248>,<248,251,252>,<248,252,249>,<249,252,253>,<249,253,250>,
            <250,253,254>,<250,254,247>,<247,254,251>,
    /*4*/ <251,255,252>,<252,255,256>,<252,256,253>,<253,256,257>,<253,257,254>,
            <254,257,258>,<254,258,251>,<251,258,255>,
    /*5*/ <255,259,256>,<256,259,260>,<256,260,257>,<257,260,261>,<257,261,258>,
            <258,261,262>,<258,262,255>,<255,262,259>,
    /*6*/ <259,263,260>,<260,263,264>,<260,264,261>,<261,264,265>,<261,265,262>,
            <262,265,266>,<262,266,259>,<259,266,263>,
    /*7*/ <263,267,264>,<264,267,268>,<264,268,265>,<265,268,269>,<265,269,266>,
            <266,269,270>,<266,270,263>,<263,270,267>,
    /*8*/ <267,271,268>,<268,271,269>,<269,271,270>,<270,271,267>

    /* stem 0*/ 
    /*0*/ <272,273,274>,<272,274,275>,<272,275,276>,<272,276,273>,
    /*1*/ <273,277,274>,<274,277,278>,<274,278,275>,<275,278,279>,<275,279,276>,
            <276,279,280>,<276,280,273>,<273,280,277>,
    /*2*/ <277,281,278>,<278,281,282>,<278,282,279>,<279,282,283>,<279,283,280>,
            <280,283,284>,<280,284,277>,<277,284,281>,
    /*3*/ <281,285,282>,<282,285,286>,<282,286,283>,<283,286,287>,<283,287,284>,
            <284,287,288>,<284,288,281>,<281,288,285>,
    /*4*/ <285,289,286>,<286,289,290>,<286,290,287>,<287,290,291>,<287,291,288>,
            <288,291,292>,<288,292,285>,<285,292,289>,
    /*5*/ <289,293,290>,<290,293,294>,<290,294,291>,<291,294,295>,<291,295,292>,
            <292,295,296>,<292,296,289>,<289,296,293>,
    /*6*/ <293,297,294>,<294,297,298>,<294,298,295>,<295,298,299>,<295,299,296>,
            <296,299,300>,<296,300,293>,<293,300,297>,
    /*7*/ <297,301,298>,<298,301,302>,<298,302,299>,<299,302,303>,<299,303,300>,
            <300,303,304>,<300,304,297>,<297,304,301>,
    /*8*/ <301,305,302>,<302,305,303>,<303,305,304>,<304,305,301>

    /* stem 0*/ 
    /*0*/ <306,307,308>,<306,308,309>,<306,309,310>,<306,310,307>,
    /*1*/ <307,311,308>,<308,311,312>,<308,312,309>,<309,312,313>,<309,313,310>,
            <310,313,314>,<310,314,307>,<307,314,311>,
    /*2*/ <311,315,312>,<312,315,316>,<312,316,313>,<313,316,317>,<313,317,314>,
            <314,317,318>,<314,318,311>,<311,318,315>,
    /*3*/ <315,319,316>,<316,319,320>,<316,320,317>,<317,320,321>,<317,321,318>,
            <318,321,322>,<318,322,315>,<315,322,319>,
    /*4*/ <319,323,320>,<320,323,324>,<320,324,321>,<321,324,325>,<321,325,322>,
            <322,325,326>,<322,326,319>,<319,326,323>,
    /*5*/ <323,327,324>,<324,327,328>,<324,328,325>,<325,328,329>,<325,329,326>,
            <326,329,330>,<326,330,323>,<323,330,327>,
    /*6*/ <327,331,328>,<328,331,332>,<328,332,329>,<329,332,333>,<329,333,330>,
            <330,333,334>,<330,334,327>,<327,334,331>,
    /*7*/ <331,335,332>,<332,335,336>,<332,336,333>,<333,336,337>,<333,337,334>,
            <334,337,338>,<334,338,331>,<331,338,335>,
    /*8*/ <335,339,336>,<336,339,337>,<337,339,338>,<338,339,335>

    /* stem 0*/ 
    /*0*/ <340,341,342>,<340,342,343>,<340,343,344>,<340,344,341>,
    /*1*/ <341,345,342>,<342,345,346>,<342,346,343>,<343,346,347>,<343,347,344>,
            <344,347,348>,<344,348,341>,<341,348,345>,
    /*2*/ <345,349,346>,<346,349,350>,<346,350,347>,<347,350,351>,<347,351,348>,
            <348,351,352>,<348,352,345>,<345,352,349>,
    /*3*/ <349,353,350>,<350,353,354>,<350,354,351>,<351,354,355>,<351,355,352>,
            <352,355,356>,<352,356,349>,<349,356,353>,
    /*4*/ <353,357,354>,<354,357,358>,<354,358,355>,<355,358,359>,<355,359,356>,
            <356,359,360>,<356,360,353>,<353,360,357>,
    /*5*/ <357,361,358>,<358,361,362>,<358,362,359>,<359,362,363>,<359,363,360>,
            <360,363,364>,<360,364,357>,<357,364,361>,
    /*6*/ <361,365,362>,<362,365,366>,<362,366,363>,<363,366,367>,<363,367,364>,
            <364,367,368>,<364,368,361>,<361,368,365>,
    /*7*/ <365,369,366>,<366,369,370>,<366,370,367>,<367,370,371>,<367,371,368>,
            <368,371,372>,<368,372,365>,<365,372,369>,
    /*8*/ <369,373,370>,<370,373,371>,<371,373,372>,<372,373,369>

    /* stem 0*/ 
    /*0*/ <374,375,376>,<374,376,377>,<374,377,378>,<374,378,375>,
    /*1*/ <375,379,376>,<376,379,380>,<376,380,377>,<377,380,381>,<377,381,378>,
            <378,381,382>,<378,382,375>,<375,382,379>,
    /*2*/ <379,383,380>,<380,383,384>,<380,384,381>,<381,384,385>,<381,385,382>,
            <382,385,386>,<382,386,379>,<379,386,383>,
    /*3*/ <383,387,384>,<384,387,388>,<384,388,385>,<385,388,389>,<385,389,386>,
            <386,389,390>,<386,390,383>,<383,390,387>,
    /*4*/ <387,391,388>,<388,391,392>,<388,392,389>,<389,392,393>,<389,393,390>,
            <390,393,394>,<390,394,387>,<387,394,391>,
    /*5*/ <391,395,392>,<392,395,396>,<392,396,393>,<393,396,397>,<393,397,394>,
            <394,397,398>,<394,398,391>,<391,398,395>,
    /*6*/ <395,399,396>,<396,399,400>,<396,400,397>,<397,400,401>,<397,401,398>,
            <398,401,402>,<398,402,395>,<395,402,399>,
    /*7*/ <399,403,400>,<400,403,404>,<400,404,401>,<401,404,405>,<401,405,402>,
            <402,405,406>,<402,406,399>,<399,406,403>,
    /*8*/ <403,407,404>,<404,407,405>,<405,407,406>,<406,407,403>

    /* stem 0*/ 
    /*0*/ <408,409,410>,<408,410,411>,<408,411,412>,<408,412,409>,
    /*1*/ <409,413,410>,<410,413,414>,<410,414,411>,<411,414,415>,<411,415,412>,
            <412,415,416>,<412,416,409>,<409,416,413>,
    /*2*/ <413,417,414>,<414,417,418>,<414,418,415>,<415,418,419>,<415,419,416>,
            <416,419,420>,<416,420,413>,<413,420,417>,
    /*3*/ <417,421,418>,<418,421,422>,<418,422,419>,<419,422,423>,<419,423,420>,
            <420,423,424>,<420,424,417>,<417,424,421>,
    /*4*/ <421,425,422>,<422,425,426>,<422,426,423>,<423,426,427>,<423,427,424>,
            <424,427,428>,<424,428,421>,<421,428,425>,
    /*5*/ <425,429,426>,<426,429,430>,<426,430,427>,<427,430,431>,<427,431,428>,
            <428,431,432>,<428,432,425>,<425,432,429>,
    /*6*/ <429,433,430>,<430,433,434>,<430,434,431>,<431,434,435>,<431,435,432>,
            <432,435,436>,<432,436,429>,<429,436,433>,
    /*7*/ <433,437,434>,<434,437,438>,<434,438,435>,<435,438,439>,<435,439,436>,
            <436,439,440>,<436,440,433>,<433,440,437>,
    /*8*/ <437,441,438>,<438,441,439>,<439,441,440>,<440,441,437>

    /* stem 0*/ 
    /*0*/ <442,443,444>,<442,444,445>,<442,445,446>,<442,446,443>,
    /*1*/ <443,447,444>,<444,447,448>,<444,448,445>,<445,448,449>,<445,449,446>,
            <446,449,450>,<446,450,443>,<443,450,447>,
    /*2*/ <447,451,448>,<448,451,452>,<448,452,449>,<449,452,453>,<449,453,450>,
            <450,453,454>,<450,454,447>,<447,454,451>,
    /*3*/ <451,455,452>,<452,455,456>,<452,456,453>,<453,456,457>,<453,457,454>,
            <454,457,458>,<454,458,451>,<451,458,455>,
    /*4*/ <455,459,456>,<456,459,460>,<456,460,457>,<457,460,461>,<457,461,458>,
            <458,461,462>,<458,462,455>,<455,462,459>,
    /*5*/ <459,463,460>,<460,463,464>,<460,464,461>,<461,464,465>,<461,465,462>,
            <462,465,466>,<462,466,459>,<459,466,463>,
    /*6*/ <463,467,464>,<464,467,468>,<464,468,465>,<465,468,469>,<465,469,466>,
            <466,469,470>,<466,470,463>,<463,470,467>,
    /*7*/ <467,471,468>,<468,471,472>,<468,472,469>,<469,472,473>,<469,473,470>,
            <470,473,474>,<470,474,467>,<467,474,471>,
    /*8*/ <471,475,472>,<472,475,473>,<473,475,474>,<474,475,471>

    /* stem 0*/ 
    /*0*/ <476,477,478>,<476,478,479>,<476,479,480>,<476,480,477>,
    /*1*/ <477,481,478>,<478,481,482>,<478,482,479>,<479,482,483>,<479,483,480>,
            <480,483,484>,<480,484,477>,<477,484,481>,
    /*2*/ <481,485,482>,<482,485,486>,<482,486,483>,<483,486,487>,<483,487,484>,
            <484,487,488>,<484,488,481>,<481,488,485>,
    /*3*/ <485,489,486>,<486,489,490>,<486,490,487>,<487,490,491>,<487,491,488>,
            <488,491,492>,<488,492,485>,<485,492,489>,
    /*4*/ <489,493,490>,<490,493,494>,<490,494,491>,<491,494,495>,<491,495,492>,
            <492,495,496>,<492,496,489>,<489,496,493>,
    /*5*/ <493,497,494>,<494,497,498>,<494,498,495>,<495,498,499>,<495,499,496>,
            <496,499,500>,<496,500,493>,<493,500,497>,
    /*6*/ <497,501,498>,<498,501,502>,<498,502,499>,<499,502,503>,<499,503,500>,
            <500,503,504>,<500,504,497>,<497,504,501>,
    /*7*/ <501,505,502>,<502,505,506>,<502,506,503>,<503,506,507>,<503,507,504>,
            <504,507,508>,<504,508,501>,<501,508,505>,
    /*8*/ <505,509,506>,<506,509,507>,<507,509,508>,<508,509,505>

    /* stem 0*/ 
    /*0*/ <510,511,512>,<510,512,513>,<510,513,514>,<510,514,511>,
    /*1*/ <511,515,512>,<512,515,516>,<512,516,513>,<513,516,517>,<513,517,514>,
            <514,517,518>,<514,518,511>,<511,518,515>,
    /*2*/ <515,519,516>,<516,519,520>,<516,520,517>,<517,520,521>,<517,521,518>,
            <518,521,522>,<518,522,515>,<515,522,519>,
    /*3*/ <519,523,520>,<520,523,524>,<520,524,521>,<521,524,525>,<521,525,522>,
            <522,525,526>,<522,526,519>,<519,526,523>,
    /*4*/ <523,527,524>,<524,527,528>,<524,528,525>,<525,528,529>,<525,529,526>,
            <526,529,530>,<526,530,523>,<523,530,527>,
    /*5*/ <527,531,528>,<528,531,532>,<528,532,529>,<529,532,533>,<529,533,530>,
            <530,533,534>,<530,534,527>,<527,534,531>,
    /*6*/ <531,535,532>,<532,535,536>,<532,536,533>,<533,536,537>,<533,537,534>,
            <534,537,538>,<534,538,531>,<531,538,535>,
    /*7*/ <535,539,536>,<536,539,540>,<536,540,537>,<537,540,541>,<537,541,538>,
            <538,541,542>,<538,542,535>,<535,542,539>,
    /*8*/ <539,543,540>,<540,543,541>,<541,543,542>,<542,543,539>

    /* stem 0*/ 
    /*0*/ <544,545,546>,<544,546,547>,<544,547,548>,<544,548,545>,
    /*1*/ <545,549,546>,<546,549,550>,<546,550,547>,<547,550,551>,<547,551,548>,
            <548,551,552>,<548,552,545>,<545,552,549>,
    /*2*/ <549,553,550>,<550,553,554>,<550,554,551>,<551,554,555>,<551,555,552>,
            <552,555,556>,<552,556,549>,<549,556,553>,
    /*3*/ <553,557,554>,<554,557,558>,<554,558,555>,<555,558,559>,<555,559,556>,
            <556,559,560>,<556,560,553>,<553,560,557>,
    /*4*/ <557,561,558>,<558,561,562>,<558,562,559>,<559,562,563>,<559,563,560>,
            <560,563,564>,<560,564,557>,<557,564,561>,
    /*5*/ <561,565,562>,<562,565,566>,<562,566,563>,<563,566,567>,<563,567,564>,
            <564,567,568>,<564,568,561>,<561,568,565>,
    /*6*/ <565,569,566>,<566,569,570>,<566,570,567>,<567,570,571>,<567,571,568>,
            <568,571,572>,<568,572,565>,<565,572,569>,
    /*7*/ <569,573,570>,<570,573,574>,<570,574,571>,<571,574,575>,<571,575,572>,
            <572,575,576>,<572,576,569>,<569,576,573>,
    /*8*/ <573,577,574>,<574,577,575>,<575,577,576>,<576,577,573>

    /* stem 0*/ 
    /*0*/ <578,579,580>,<578,580,581>,<578,581,582>,<578,582,579>,
    /*1*/ <579,583,580>,<580,583,584>,<580,584,581>,<581,584,585>,<581,585,582>,
            <582,585,586>,<582,586,579>,<579,586,583>,
    /*2*/ <583,587,584>,<584,587,588>,<584,588,585>,<585,588,589>,<585,589,586>,
            <586,589,590>,<586,590,583>,<583,590,587>,
    /*3*/ <587,591,588>,<588,591,592>,<588,592,589>,<589,592,593>,<589,593,590>,
            <590,593,594>,<590,594,587>,<587,594,591>,
    /*4*/ <591,595,592>,<592,595,596>,<592,596,593>,<593,596,597>,<593,597,594>,
            <594,597,598>,<594,598,591>,<591,598,595>,
    /*5*/ <595,599,596>,<596,599,600>,<596,600,597>,<597,600,601>,<597,601,598>,
            <598,601,602>,<598,602,595>,<595,602,599>,
    /*6*/ <599,603,600>,<600,603,604>,<600,604,601>,<601,604,605>,<601,605,602>,
            <602,605,606>,<602,606,599>,<599,606,603>,
    /*7*/ <603,607,604>,<604,607,608>,<604,608,605>,<605,608,609>,<605,609,606>,
            <606,609,610>,<606,610,603>,<603,610,607>,
    /*8*/ <607,611,608>,<608,611,609>,<609,611,610>,<610,611,607>

    /* stem 0*/ 
    /*0*/ <612,613,614>,<612,614,615>,<612,615,616>,<612,616,613>,
    /*1*/ <613,617,614>,<614,617,618>,<614,618,615>,<615,618,619>,<615,619,616>,
            <616,619,620>,<616,620,613>,<613,620,617>,
    /*2*/ <617,621,618>,<618,621,622>,<618,622,619>,<619,622,623>,<619,623,620>,
            <620,623,624>,<620,624,617>,<617,624,621>,
    /*3*/ <621,625,622>,<622,625,626>,<622,626,623>,<623,626,627>,<623,627,624>,
            <624,627,628>,<624,628,621>,<621,628,625>,
    /*4*/ <625,629,626>,<626,629,630>,<626,630,627>,<627,630,631>,<627,631,628>,
            <628,631,632>,<628,632,625>,<625,632,629>,
    /*5*/ <629,633,630>,<630,633,634>,<630,634,631>,<631,634,635>,<631,635,632>,
            <632,635,636>,<632,636,629>,<629,636,633>,
    /*6*/ <633,637,634>,<634,637,638>,<634,638,635>,<635,638,639>,<635,639,636>,
            <636,639,640>,<636,640,633>,<633,640,637>,
    /*7*/ <637,641,638>,<638,641,642>,<638,642,639>,<639,642,643>,<639,643,640>,
            <640,643,644>,<640,644,637>,<637,644,641>,
    /*8*/ <641,645,642>,<642,645,643>,<643,645,644>,<644,645,641>

    }
  }
#declare simplemoss_13_leaves = sphere {<0,0,0>,0}
