global_settings {
   adc_bailout 0.0039216
   max_trace_level 10
   noise_generator 2
   
   radiosity {
      adc_bailout 0.005
      count 200
      error_bound 0.5
      nearest_count 10
      pretrace_end 0.01
      recursion_limit 3
      always_sample off
      load_file "radio.rad"
   }
}

#declare Luces = union {
   light_source {
      <-2.6399, 17.346, 20.721>, rgb <3, 3, 3>
      area_light <10, 0, 0>, <0, 10, 0>, 10, 10
      circular
   }
   
   light_source {
      <-1000, 2000, 4000>, rgb <3, 3, 3>
      area_light <60, 0, 0>, <0, 60, 0>, 5, 5
      circular
   }
}

#declare LucesPrueba = union {
   light_source {
      <-1000, 2000, 4000>, rgb <2, 2, 2>
   }
   
   light_source {
      <0, 18, 0>, rgb <1, 1, 1>
   }
   
   light_source {
      <-9.53043, 18, -25.1257>, rgb <1, 1, 1>
   }
}

object {
   Luces
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}


camera {
   perspective
   location <-5.0884, 11.621, -20.451>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <3.45273, 6.03429, -5.98474>
   angle 50
}

sky_sphere {
   pigment {
      gradient y
      turbulence .3
      color_map {
         [ 0 color rgb <0.882353, 0.952941, 1>       ]
         [ 0.1 color rgb <0.741176, 0.894118, 1>     ]
         [ 0.2 color rgb <0.643137, 0.815686, 1>     ]
         [ 0.5 color rgb <0.360784, 0.458824, 1>     ]
         [ 1 color rgb <0.882353, 0.952941, 1>       ]
      }
   }
}

#declare CanalesTex = texture {
   pigment {
      color rgb <0.568627, 0.568627, 0.568627>
   }
   
   finish {
      specular 1
      roughness 0.03
      reflection {
         rgb <0.1, 0.1, 0.1>
      }
   }
}

#declare AzulejoTex = texture {
   pigment {
      bozo
      turbulence 1
      
      color_map {
         [ 0 color rgb <0.796078, 0.929412, 1>          ]
         [ 0.33 color rgb <0.694118, 0.862745, 1>       ]
         [ 0.6 color rgb <0.572549, 0.698039, 0.870588> ]
         [ 1 color rgb <0.643137, 0.807843, 1>          ]
      }
   }
}

texture {
   pigment {
      wrinkles
      scale 0.6
      
      color_map {
         [ 0 color rgbt <0.76863, 0.82353, 1, 0.4>         ]
         [ 0.1 color rgbt <0.83922, 0.85098, 0.90196, 0.4> ]
         [ 0.2 color rgbt <0.43137, 0.50196, 0.90196, 0.5> ]
         [ 0.2 color rgbt <1, 1, 1, 1>         ]
         [ 1 color rgbt <1, 1, 1, 1>           ]
      }
      frequency 3
   }
}

texture {
   pigment {
      bozo
      turbulence 1
      scale 0.5
      
      color_map {
         [ 0 color rgbt <0.65882, 0.65882, 0.65882, 0.2>         ]
         [ 0.2 color rgbt <0.66275, 0.68235, 0.84706, 0.6>       ]
         [ 0.4 color rgbt <0.364706, 0.364706, 0.635294, 0.7>    ]
         [ 0.7 color rgbt <1, 1, 1, 1>       ]
         [ 1 color rgbt <1, 1, 1, 1>         ]
      }
   }
   
   finish {
      specular 0.5
      roughness 0.02
      
      reflection {
         rgb <0.1, 0.11, 0.12>
      }
   }
   
   normal {
      bumps
      0.07
      scale 0.4
   }
}

#declare LosaTex = texture {
   pigment {
      color rgb <0.964706, 0.984314, 1>
   }
   
   finish {
      specular 1
      roughness 0.005
      
      reflection {
         rgb <0.0901961, 0.0901961, 0.0901961>
      }
   }
}

#declare PisoTex = texture {
   pigment {
      cells
      turbulence 1
      octaves 8
      omega 0.8
      
      color_map {
         [ 0 color rgb <0.792157, 0.827451, 0.85098>
         ]
         [ 0.3 color rgb <0.94902, 0.980392, 1>
         ]
         [ 0.6 color rgb <0.733333, 0.905882, 1>
         ]
         [ 1 color rgb <0.807843, 0.854902, 0.921569>
         ]
      }
   }
}

texture {
   pigment {
      granite
      
      color_map {
         [ 0 color rgbt <0.85882, 0.9098, 1, 0.5>     ]
         [ 0.2 color rgbt <0.92941, 0.92157, 1, 0.4>  ]
         [ 0.4 color rgbt <0.84706, 0.88235, 1, 0.4>  ]
         [ 0.4 color rgbt <1, 1, 1, 1>     ]
         [ 1 color rgbt <1, 1, 1, 1>       ]
      }
   }
   
   finish {
      specular 1
      roughness 0.02
      
      reflection {
         rgb <0.1, 0.11, 0.12>
      }
   }
   
   normal {
      bumps
      0.1
      scale 0.4
   }
}

#declare Enchap = texture {
   brick
   
   texture {
      pigment {
         color rgb <1.5, 1.5, 1.5>
      }
   }
   
   texture {
      AzulejoTex
   }
   brick_size <4, 6, 3>
   mortar 0.05
}

#declare BombaTex = texture {
   pigment {
      cells
      turbulence 1
      octaves 8
      omega 0.8
      lambda 2.5
      
      color_map {
         [ 0 color rgb <0.831373, 0.729412, 0.603922>    ]
         [ 0.5 color rgb <0.623529, 0.545098, 0.45098>   ]
         [ 1 color rgb <0.505882, 0.415686, 0.305882>    ]
      }
   }
}

texture {
   pigment {
      cells
      turbulence 1
      octaves 7
      omega 0.8
      lambda 2.5
      
      color_map {
         [ 0 color rgb <0.494118, 0.615686, 0.501961>    ]
         [ 0.3 color rgb <0.533333, 0.678431, 0.537255>  ]
         [ 0.6 color rgb <0.34902, 0.435294, 0.341176>   ]
         [ 0.6 color rgbt <1, 1, 1, 1>    ]
         [ 1 color rgbt <1, 1, 1, 1>      ]
      }
   }
}

texture {
   pigment {
      cells
      turbulence 1
      octaves 7
      omega 0.7
      
      color_map {
         [ 0 color rgbt <0.74902, 0.33333, 0.33726, 0.3>     ]
         [ 0.08 color rgbt <0.63529, 0.28235, 0.28628, 0.35> ]
         [ 0.08 color rgbt <1, 1, 1, 1>    ]
         [ 1 color rgbt <1, 1, 1, 1>       ]
      }
   }
}

#declare Piso = superellipsoid {
   <0.3, 0.02>
   scale <1.02, 0.015, 1.52>
   
   texture {
      PisoTex
   }
}

#declare UnionPiso = union {
   object {
      Piso
   }
   
   object {
      Piso
      translate x*2.1
   }
   
   object {
      Piso
      translate x*(-2.1)
   }
   
   object {
      Piso
      translate x*4.2
   }
   
   object {
      Piso
      translate x*(-4.2)
   }
   
   object {
      Piso
      scale 1
      rotate <0, 0, 0>
      translate x*6.3
   }
   
   object {
      Piso
      scale 1
      rotate <0, 0, 0>
      translate x*(-6.3)
   }
}

#declare PisoCompleto = union {
   object {
      UnionPiso
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      UnionPiso
      scale 1
      rotate <0, 0, 0>
      translate z*3.1
   }
   
   object {
      UnionPiso
      scale 1
      rotate <0, 0, 0>
      translate z*(-3.1)
   }
   
   object {
      UnionPiso
      scale 1
      rotate <0, 0, 0>
      translate z*6.2
   }
   
   object {
      UnionPiso
      scale 1
      rotate <0, 0, 0>
      translate z*9.3
   }
}

#declare Canales = difference {
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.5, 20, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <1, 20, 0.8>
      rotate <0, 0, 0>
      translate x*0.35
   }
   
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      scale <0.5, 20, 0.5>
      rotate <0, 0, 0>
      translate <0.124, 0, 0.714>
   }
   
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      scale <0.5, 20, 0.5>
      rotate <0, 0, 0>
      translate <-0.124, 0, 0.714>
   }
   
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      scale <0.5, 20, 0.5>
      rotate <0, 0, 0>
      translate <0.124, 0, -0.714>
   }
   
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      scale <0.5, 20, 0.5>
      rotate <0, 0, 0>
      translate <-0.124, 0, -0.714>
   }
   
   texture {
      CanalesTex
   }
}

#declare Vidrio = box {
   <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
   scale <7, 15, 0.2>
   rotate <0, 0, 0>
   
   pigment {
      color rgbft <0.839216, 0.945098, 1, 0.5, 0.5>
   }
   
   normal {
      granite
      0.3
      scale 1.5
      rotate z*45
   }
   
   finish {
      phong 1
      
      reflection {
         rgb <0.1, 0.1, 0.1>
      }
   }
   
   interior {
      ior 1.3
      caustics 0.5
   }
}

#declare Curva = difference {
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      scale <0.55, 0.5, 0.55>
      rotate <0, 0, 0>
   }
   
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      scale <0.45, 1, 0.45>
      rotate <0, 0, 0>
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate x*0.50001
   }
   translate <-3.15, 0, 0.25>
}

#declare Puerta = union {
   
   object {
      Vidrio
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Canales
      scale <0.8, 0.75, 0.3>
      rotate <0, 0, 0>
      translate x*(-3.38)
   }
   
   object {
      Canales
      scale <0.8, 0.75, 0.3>
      rotate y*180
      translate x*3.38
   }
   
   object {
      Canales
      scale <0.8, 0.31, 0.3>
      rotate z*(-90)
      translate y*7.2
   }
   
   object {
      Canales
      scale <0.8, 0.31, 0.3>
      rotate z*90
      translate y*(-7.2)
   }
   
   union {
      difference {
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <0.5, 6.3, 0.05>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0.5, 0>, <0, -0.5, 0>, 0.5
            scale <0.5, 20, 0.5>
            rotate <0, 0, 0>
            translate <0.124, 0, -0.24>
         }
         
         cylinder {
            <0, 0.5, 0>, <0, -0.5, 0>, 0.5
            scale <0.5, 20, 0.5>
            rotate <0, 0, 0>
            translate <-0.124, 0, -0.24>
         }
         rotate z*90
      }
      
      object {
         Curva
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         Curva
         scale 1
         rotate <180, 180, 0>
         translate <0, 0, 0>
      }
      translate z*(-0.4)
      
      texture {
         CanalesTex
      }
   }
}

#declare NoayPapel = union {
   difference {
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.5
         scale <1, 2, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.5
         scale <0.9, 3, 0.9>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         pigment {
            cells
            turbulence <1, 1, 1>
            octaves 10
            omega 0.8
            lambda 3
            
            color_map {
               [ 0 color rgb <0.686275, 0.643137, 0.580392>
               ]
               [ 0.3 color rgb <0.6, 0.552941, 0.486275>
               ]
               [ 0.35 color rgb <0.760784, 0.709804, 0.647059>
               ]
               [ 0.4 color rgb <0.666667, 0.603922, 0.52549>
               ]
               [ 0.6 color rgb <0.666667, 0.603922, 0.52549>
               ]
               [ 1 color rgb <0.67451, 0.631373, 0.580392>
               ]
            }
         }
      }
      
      texture {
         pigment {
            gradient <1, 1, 0>
            scale 1.5
            rotate y*45
            
            color_map {
               [ 0 color rgb <0.372549, 0.34902, 0.286275>
               ]
               [ 0.01 color rgb <0.372549, 0.333333, 0.313725>
               ]
               [ 0.01 color rgbt <1, 1, 1, 1>
               ]
               [ 1 color rgbt <1, 1, 1, 1>
               ]
            }
         }
      }
      
      texture {
         pigment {
            gradient <0, 0, 1>
            rotate x*9
            
            color_map {
               [ 0 color rgb <1, 1, 1>
               ]
               [ 0.5 color rgb <1, 1, 1>
               ]
               [ 0.5 color rgbt <1, 1, 1, 1>
               ]
               [ 1 color rgbt <1, 1, 1, 1>
               ]
            }
            frequency 0.5
         }
      }
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-3, 0, -3>, <-0.464113, -0.196492, -3>, <3.1882, 0.446572, -3>, <1.39234, 1.8957, -3>,
      <-3, 0, -1>, <-0.553428, -0.142903, -1>, <1.84849, 0.107177, -1>, <2.91069, 0.596112, -1.04397>,
      <-3, 0, 1>, <-0.50877, -0.0714516, 1>, <1.84849, 0.0714516, 1>, <2.91069, 0.67879, 1>,
      <-3, 0, 3>, <-0.240827, -0.214355, 3.54677>, <0.65375, 0.411941, 1.05707>, <1.06012, 0.888851, -0.517612>
      
      pigment {
         image_map {
            png
            "/home/roy/Documents/Imagenes/MapasDeImagenes/PapelH.png"
            once
            map_type 0
         }
         scale 6
         rotate x*90
         translate <-3, 0, -3>
      }
      scale <0.4, 1, 0.33>
      rotate <90, 90, 180>
      translate <0.5, 0, -1.1>
   }
}

#declare ConoLlave = union {
   cone {
      <0, 0.5, 0>, 0.8,
      <0, -0.5, 0>, 1.1
      scale <1, 2, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0, 0>, 0.8
      scale <1, 0.5, 1>
      rotate <0, 0, 0>
      translate y*1
   }
   
   sphere {
      <0, 0, 0>, 1.1
      scale <1, 0.3, 1>
      rotate <0, 0, 0>
      translate y*(-1)
   }
}

#declare LlaveBano = union {
   difference {
      object {
         ConoLlave
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         ConoLlave
         scale <0.5, 0.8, 0.4>
         rotate <-5, 0, 180>
         translate <0, 0.6, -1.1>
      }
      
      object {
         ConoLlave
         scale <0.5, 0.8, 0.4>
         rotate <-5, 0, 180>
         translate <0, 0.6, -1.1>
         rotate y*60
      }
      
      object {
         ConoLlave
         scale <0.5, 0.8, 0.4>
         rotate <-5, 0, 180>
         translate <0, 0.6, -1.1>
         rotate y*120
      }
      
      object {
         ConoLlave
         scale <0.5, 0.8, 0.4>
         rotate <-5, 0, 180>
         translate <0, 0.6, -1.1>
         rotate y*180
      }
      
      object {
         ConoLlave
         scale <0.5, 0.8, 0.4>
         rotate <-5, 0, 180>
         translate <0, 0.6, -1.1>
         rotate y*240
      }
      
      object {
         ConoLlave
         scale <0.5, 0.8, 0.4>
         rotate <-5, 0, 180>
         translate <0, 0.6, -1.1>
         rotate y*300
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.5
         scale <0.8, 1, 0.8>
         rotate <0, 0, 0>
         translate y*1
      }
   }
   
   sphere {
      <0, 0, 0>, 0.5
      
      pigment {
         color rgb <1.5, 1.5, 1.5>
      }
      
      finish {
         phong 1
         
         reflection {
            rgb <0.15, 0.15, 0.15>
         }
      }
      scale <0.7, 0.1, 0.7>
      rotate <0, 0, 0>
      translate y*1.35
   }
   
   sor {
      5,
      <0.25373, 0.3086>, <1.3, 0.3>, <0.46847, 0.70649>, <0.19394, 1.1183>, <1.5824, 2.5515>
      translate y*(-0.5)
      scale 1
      rotate <0, 0, 0>
      translate y*(-1.2)
   }
}

#declare Jabonera = difference {
   union {
      difference {
         superellipsoid {
            <0.7, 0.6>
            scale <1, 1, 0.3>
            rotate <0, 0, 0>
            translate z*0.7
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale 3
            rotate <0, 0, 0>
            translate y*1.5
         }
      }
      
      superellipsoid {
         <0.3, 0.3>
         scale <1, 0.2, 0.3>
         rotate <0, 0, 0>
         translate z*0.7
      }
   }
   
   union {
      difference {
         superellipsoid {
            <0.8, 0.7>
            scale <0.9, 0.9, 0.5>
            rotate <0, 0, 0>
            translate z*0.4
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale 3
            rotate <0, 0, 0>
            translate y*1.5
         }
      }
      
      superellipsoid {
         <0.5, 0.7>
         scale <0.9, 0.2, 0.5>
         rotate <0, 0, 0>
         translate z*0.4
      }
      translate y*(-0.07)
   }
   rotate x*90
}

#declare HoyoToma = union {
   prism {
      linear_spline
      conic_sweep
      0, 1,
      5,
      <0.5, 1>, <0.5, -1>, <-0.5, -1>, <-0.5, 1>, <0.5, 1>
      translate y*(-0.5)
      scale <0.4, 1, 1>
      rotate x*180
      translate <0, 0, 0>
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.3, 1, 1.5>
      rotate <0, 0, 0>
      translate y*0.25
   }
}

#declare HoyossToma = union {
   object {
      HoyoToma
      scale 1
      rotate <0, 0, 0>
      translate x*1.5
   }
   
   object {
      HoyoToma
      scale <1, 1, 1.3>
      rotate <0, 0, 0>
      translate x*(-1.5)
   }
   
   union {
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <1, 2, 0.5>
         rotate <0, 0, 0>
         translate y*0.5
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.5
         scale <1, 2, 1>
         rotate <0, 0, 0>
         translate <0, 0.5, 0.25>
      }
      translate z*2.5
   }
}

#declare Toma = union {
   difference {
      superellipsoid {
         <0.1, 0.05>
         scale <1, 1, 1.7>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      superellipsoid {
         <0.02, 0.02>
         scale <1, 1, 1.7>
         scale <0.75, 0.75, 0.85>
         rotate <0, 0, 0>
         translate x*(-1)
      }
   }
   
   difference {
      superellipsoid {
         <0.02, 0.02>
         scale <1, 1, 1.7>
         scale <0.73, 0.73, 0.83>
         rotate <0, 0, 0>
         translate x*(-0.32)
      }
      
      object {
         HoyossToma
         scale 0.2
         rotate <180, 0, -90>
         rotate z*180
         translate <-0.96, 0, 0.8>
      }
      
      object {
         HoyossToma
         scale 0.2
         rotate <180, 0, -90>
         rotate z*180
         translate <-0.96, 0, -0.6>
      }
   }
}

#declare Bomba = union {
   union {
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.5
         scale <0.4, 6, 0.4>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.5
         scale 0.4
         rotate <0, 0, 0>
         translate y*3
      }
      
      texture {
         BombaTex
         translate y*1
      }
      translate y*2.5
   }
   
   union {
      sor {
         6,
         <0.83913, -0.95984>, <1, -0.7>, <0.93328, -0.19184>, <0.562513, 0.14>, <0.4, 0.44073>, <0.49457, 0.98002>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.5
         scale <2.1, 0.2, 2.1>
         rotate <0, 0, 0>
         translate y*(-0.76)
      }
      
      pigment {
         color rgb <0.0588235, 0.0588235, 0.0588235>
      }
      
      finish {
         specular 0.5
         roughness 0.02
      }
   }
}

union {
   // ObraGris
   
   union {
      // PuertaVidrio
      
      object {
         Puerta
         scale <1, 0.97, 1>
         rotate y*180
         translate <-3, 8.45, 0.2>
      }
      
      object {
         Puerta
         scale <1, 0.97, 1>
         rotate <0, 0, 0>
         translate <-1.5, 8.45, -0.2>
      }
      
      object {
         Canales
         scale <1, 0.8, 1>
         rotate <0, 0, 0>
         translate <-6.95, 8, 0>
      }
      
      object {
         Canales
         scale <1, 0.8, 1>
         rotate y*180
         translate <6.95, 8, 0>
      }
      
      object {
         Canales
         scale <1, 0.8, 1>
         rotate z*90
         translate y*1.25
      }
      
      object {
         Canales
         scale <1, 0.8, 1>
         rotate z*(-90)
         translate y*15.65
      }
   }
   
   difference {
      //*PMName ObraGris
      
      union {
         difference {
            box {
               <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
               scale <18, 21, 33>
               rotate <0, 0, 0>
               translate y*10
            }
            
            box {
               <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
               scale <14.5, 20.5, 29.5>
               rotate <0, 0, 0>
               translate y*10
            }
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <14.5, 20.5, 29.5>
            rotate <0, 0, 0>
            translate <14.499, 10, 0>
            
            texture {
               Enchap
               rotate z*90
            }
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <14.5, 20.5, 20>
            rotate <0, 0, 0>
            translate <-14.499, 10, 10>
            
            texture {
               Enchap
               rotate z*90
            }
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <15, 20.5, 1>
            rotate <0, 0, 0>
            translate <0, 10, 15.24>
            
            texture {
               Enchap
               rotate z*90
               rotate y*90
            }
         }
         
         box {
            //*PMName Piso
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <14.5, 1, 20>
            rotate <0, 0, 0>
            translate <0, -0.498, 10>
            
            texture {
               Enchap
            }
         }
      }
      
      box {
         //*PMName Ventana
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <8, 4, 10>
         rotate <0, 0, 0>
         translate <0, 14, 15>
      }
      
      box {
         //*PMName Puerta
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <8, 15, 30>
         rotate <0, 0, 0>
         translate <-2.999, 7.5001, -5>
      }
   }
   
   object {
      Toma
      scale 0.3
      rotate <0, 0, 0>
      translate <7.5, 2.78573, -7.87277>
      
      texture {
         LosaTex
      }
   }
   
   object {
      //*PMName Piso
      PisoCompleto
      scale <1, 1, 0.6666>
      scale <1.6, 1, 1.6>
      rotate <0, 0, 0>
      translate <0.94, 0, -12>
   }
   
   box {
      //*PMName Piso
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      
      pigment {
         color rgb <0, 0, 0>
      }
      
      finish {
         phong 1
      }
      scale <14.5, 1, 20>
      rotate <0, 0, 0>
      translate <0, -0.498, -10>
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      
      pigment {
         color rgb <0.784314, 0.901961, 1>
      }
      scale <15, 2, 1.5>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      LlaveBano
      
      finish {
         phong 1
         
         reflection {
            rgb <0.75, 0.75, 0.75>
         }
      }
      scale 0.5
      rotate z*90
      translate <6.55, 7, 7.5>
   }
   
   union {
      object {
         Jabonera
         scale <1, 0.7, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
         
         texture {
            LosaTex
         }
      }
      
      superellipsoid {
         <0.5, 0.5>
         scale <1, 0.3, 0.6>
         scale 0.7
         rotate z*(-18)
         translate <-0.3498, -0.27, -0.44>
         
         pigment {
            color rgb <0.756863, 1, 0.952941>
         }
      }
      rotate y*90
      translate <7.05, 8.5, 3.5715>
   }
   
   pigment {
      color rgb <0.784314, 0.901961, 1>
   }
}

#declare Servicio02 = union {
   object {
      NoayPapel
      scale 0.3
      rotate y*(-20)
      translate <0.885541, 3.65773, -0.7>
   }
   
   union {
      //*PMName Base
      
      difference {
         superellipsoid {
            <0.2, 0.2>
            scale <0.7, 2, 0.35>
            rotate z*(-9)
            translate <0.7, -0.21992, 0>
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale 2
            rotate <0, 0, 0>
            translate <0.230891, 2.06139, 0>
         }
      }
      
      difference {
         superellipsoid {
            <0.2, 0.2>
            scale <1, 1, 0.6>
            rotate z*(-10)
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, 0.5>, <0, 0, -0.5>, 0.5
            scale <8, 8, 2>
            rotate <0, 0, 0>
            translate <3.79972, 1.30484, 0>
         }
      }
      
      superellipsoid {
         //*PMName Base
         <0.5, 0.2>
         scale <1.3, 0.6, 0.5>
         rotate x*90
         translate <0.25, -1, 0>
      }
      
      superellipsoid {
         //*PMName Base
         <0.2, 0.3>
         scale <1.3, 0.6, 0.1>
         rotate x*90
         translate <0.3, 1.12, 0>
      }
      translate x*(-0.5)
   }
   
   union {
      union {
         difference {
            sphere {
               <0, 0, 0>, 0.5
               scale <3, 2, 2>
               rotate <0, 0, 0>
            }
            
            box {
               <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
               scale <5, 2, 3>
               rotate <0, 0, 0>
               translate y*1
            }
         }
         
         torus {
            0.45, 0.05
            scale <3, 3, 2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate <-0.5, 1.2725, 0>
      }
      
      difference {
         superellipsoid {
            <1, 0.5>
            scale <3, 2, 2>
            scale <0.5, 0.5, 0.1>
            rotate x*90
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <5, 1, 5>
            rotate <0, 0, 0>
            translate y*(-0.5)
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <5, 1, 5>
            rotate <0, 0, 0>
            translate x*3.4
         }
         translate <-0.5, 1.5, 0>
      }
      scale 1
      translate <-0.5, -0.2, 0>
   }
   
   union {
      //*PMName Tanque
      
      union {
         difference {
            sphere {
               <0, 0, 0>, 0.5
               scale 0.15
               rotate <0, 0, 0>
            }
            
            box {
               <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
               scale 1
               rotate <0, 0, 0>
               translate x*0.5
            }
         }
         
         superellipsoid {
            <1, 0.3>
            scale <0.05, 0.02, 0.15>
            rotate <0, 0, 0>
            translate z*0.1
         }
         
         finish {
            phong 1
            
            reflection {
               rgb <0.478431, 0.478431, 0.478431>
            }
         }
         scale 1.5
         rotate x*(-26.1)
         translate <-0.53, 0.3, 0.65>
      }
      
      superellipsoid {
         <0.2, 0.2>
         scale <0.5, 0.9, 0.6>
         rotate x*8
         translate <0, -0.1, 0.3>
      }
      
      superellipsoid {
         <0.2, 0.2>
         scale <0.5, 0.9, 0.6>
         rotate x*(-8)
         translate <0, -0.1, -0.3>
      }
      
      superellipsoid {
         <0.3, 0.3>
         scale <0.57, 0.2, 1.1>
         rotate <0, 0, 0>
         translate y*0.67
      }
      scale <1.2, 1.1, 1.2>
      translate <0.98963, 2.4, 0>
   }
}

#declare Lavatorio = union {
   difference {
      union {
         difference {
            superellipsoid {
               <1, 0.3>
               scale <1, 1.2, 0.2>
               rotate x*90
               translate <0, 0, 0>
            }
            
            box {
               <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
               scale <2.5, 1, 3>
               rotate <0, 0, 0>
               translate y*(-0.5)
            }
         }
         
         difference {
            union {
               sphere {
                  <0, 0, 0>, 0.5
                  scale <1, 0.8, 1.2>
                  scale 2
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0.5, 0, 0>, <-0.5, 0, 0>, 0.5
                  scale <1, 0.8, 1.2>
                  scale 2
                  rotate <0, 0, 0>
                  translate x*1
               }
               scale 0.9
            }
            
            box {
               <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
               scale <2.5, 1, 3>
               rotate <0, 0, 0>
               translate y*0.5
            }
         }
         
         superellipsoid {
            <0.3, 0.01>
            scale <1.2, 0.2, 1>
            rotate y*90
            translate x*1
         }
      }
      
      sphere {
         <0, 0, 0>, 0.5
         scale <1, 0.8, 1.2>
         scale 1.6
         rotate <0, 0, 0>
         translate y*0.2
      }
   }
   
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 0.5
      
      finish {
         phong 1
         
         reflection {
            rgb <0.75, 0.75, 0.75>
         }
      }
      scale <0.2, 1, 0.2>
      rotate z*67.1
      translate <0.485411, 0.639203, 0>
   }
}

object {
   Bomba
   scale 0.7
   rotate <0, 0, 0>
   translate <6.22902, 0.617, -7.30727>
}

object {
   Lavatorio
   
   texture {
      LosaTex
   }
   scale 2
   rotate <0, 0, 0>
   translate <5.27636, 8.21069, -10.909>
}

object {
   Servicio02
   scale 2
   rotate <0, 0, 0>
   translate <3.6, 1.2, -4.8083>
   
   texture {
      LosaTex
   }
}