// book include file

// read titles
#fopen tit1 "titles1.txt" read
#fopen tit2 "titles2.txt" read
// read first words into array
#read (tit1, n1)
#declare titles1 = array[n1];
#declare i = 0;
#while (defined(tit1))
  #declare titles1[i] = ""
  #read (tit1, titles1[i])
  #declare i = i + 1;
#end
// read second words into array
#read (tit2, n2)
#declare titles2 = array[n2];
#declare i = 0;
#while (defined(tit2))
  #declare titles2[i] = ""
  #read (tit2, titles2[i])
  #declare i = i + 1;
#end
// read authors
#fopen aut1 "authors1.txt" read
#fopen aut2 "authors2.txt" read
// read first words into array
#read (aut1, na1)
#declare authors1 = array[na1];
#declare i = 0;
#while (defined(aut1))
  #declare authors1[i] = ""
  #read (aut1, authors1[i])
  #declare i = i + 1;
#end
// read second words into array
#read (aut2, na2)
#declare authors2 = array[na2];
#declare i = 0;
#while (defined(aut2))
  #declare authors2[i] = ""
  #read (aut2, authors2[i])
  #declare i = i + 1;
#end

// set up fonts
#declare fonts = array[5];
#declare fonts[0] = "Arial.ttf"
#declare fonts[1] = "Arialbd.ttf"
#declare fonts[2] = "Coprgtb.ttf"
#declare fonts[3] = "seagb.ttf"
#declare fonts[4] = "Vwagh.ttf"

#macro PaperBack(rnd, th, ys, SpineCol1, SpineCol2, Mid, TextCol, SpineText)
  // --- make physical books
  #local zs = ys*26/37;
  #local rsp = th/5;
  #local p1 = min_extent(SpineText);
  #local p2 = max_extent(SpineText);
  difference {
    union {
      object { Cube scale <th-rsp, ys, zs> }
      object { Cube scale <th, ys, zs-rsp/2> translate <0, 0, rsp/2> }
      cylinder { <th-rsp, -ys, -zs+rsp>, <th-rsp, ys, -zs+rsp>, rsp }
      cylinder { <-th+rsp, -ys, -zs+rsp>, <-th+rsp, ys, -zs+rsp>, rsp }
      // spine texture
      texture {
        pigment {
          gradient y
          color_map {
            [0 color SpineCol1]
            [Mid color SpineCol1]
            [Mid+0.01 color SpineCol2]
            [1 color SpineCol2] }
          scale 2*ys translate -y*ys }
        finish { ambient 0 } }
      // title texture
      texture {
        pigment {
          object {
            object {
              SpineText
              translate <-(p2.x-p1.x)/2, -p1.y-(p2.y-p1.y)/2, 0>
              scale <ys/(p2.x-p1.x), th/(p2.y-p1.y), 1>
              rotate <0, 0, -90> }
            color Clear color TextCol } }
        finish { ambient 0 } } }
    union {
      plane { <0, 1, 0>, -ys+0.001 }
      plane { <0, -1, 0>, -ys+0.001 }
      plane { <0, 0, -1>, -zs+0.001 }
      pigment {
        gradient x
        color_map {
          [0 color rgb rand(rnd)*0.25+0.75]
          [0.5 color Gray50]
          [1 color rgb rand(rnd)*0.25+0.75] }
        scale <ys*0.02, 1, 1> }
      finish { ambient 0 } } }
#end

#macro HardBack(th, ys, covertype, spinetype)
  #local zs = ys*26/37;
  #local edged = th*0.05;
  // spine texture
  #declare SpineT_1 = texture {
    pigment {
      gradient y
      color_map {
        [0 color Clear] [0.7 color Clear]
        [0.7001 color Gold] [0.71 color Gold]
        [0.7101 color Gray10] [0.8 color Gray10]
        [0.8001 color Gold] [0.81 color Gold]
        [0.8101 color Clear] [1 color Clear] }
      scale <1, 2*ys, 1> translate <0, -ys, 0> }
    finish { ambient 0 phong 0.5 phong_size 10 }
    normal { granite 0.2 scale th*0.2 } }
    #declare SpineT_2 = texture {
      pigment {
        gradient y
        color_map {
          [0 color Clear] [0.2 color Clear]
          [0.2001 color Gold] [0.21 color Gold]
          [0.2101 color Clear] [0.3 color Clear]
          [0.3001 color Gold] [0.31 color Gold]
          [0.3101 color Clear] [0.7 color Clear]
          [0.7001 color Gold] [0.71 color Gold]
          [0.7101 color Clear] [0.8 color Clear]
          [0.8001 color Gold] [0.81 color Gold]
          [0.8101 color Clear] [1 color Clear] }
        scale <1, 2*ys, 1> translate <0, -ys, 0> }
      finish { ambient 0 phong 0.5 phong_size 10 }
      normal { granite 0.2 scale th*0.2 } }
    #declare SpineT_3 = texture {
      pigment {
        gradient y
        color_map {
          [0 color Clear] [0.2 color Clear]
          [0.2001 color Gold] [0.21 color Gold]
          [0.2101 color Clear] [0.5 color Clear]
          [0.5001 color Gold] [0.51 color Gold]
          [0.5101 color Clear] [0.8 color Clear]
          [0.8001 color Gold] [0.81 color Gold]
          [0.8101 color Clear] [1 color Clear] }
        scale <1, 2*ys, 1> translate <0, -ys, 0> }
      finish { ambient 0 phong 0.5 phong_size 10 }
      normal { granite 0.2 scale th*0.2 } }
    #declare Cover_T = texture {
    pigment {
      #if (covertype = 1) color rgb <0.8, 0.2, 0.2> #end
      #if (covertype = 2) color rgb <0.2, 0.8, 0.2> #end
      #if (covertype = 3) color rgb <0.2, 0.2, 0.8> #end }
    finish { ambient 0 phong 0.5 phong_size 10 }
    normal { granite 0.2 scale th*0.2 } }
  union {
    difference {
      union {
        cylinder {
          <0, -ys, 0>, <0, ys, 0>, th scale <1, 1, 0.2> translate <0, 0, -zs>
          texture { Cover_T }
          #if (spinetype = 1) texture { SpineT_1 } #end
          #if (spinetype = 2) texture { SpineT_2 } #end
          #if (spinetype = 3) texture { SpineT_3 } #end }
        object { Cube scale <th, ys, zs> } }
      cylinder { <0, -ys, 0>, <0, ys, 0>, th scale <0.95, 1.1, 0.15> translate <0, 0, -zs> }
      object { Cube scale <0.95*th, 1.1*ys, 1.1*zs> translate <0, 0, 0.1*zs> }
      texture { Cover_T } }
    union {
      object { Cube scale <0.95*th, ys-edged, zs-edged> }
      cylinder { <0, -(ys-edged), 0>, <0, ys-edged, 0>, th scale <0.95, 1, 0.15> translate <0, 0, -zs> }
      texture {
        pigment {
          gradient x
          color_map {
            [0 color White]
            [0.5 color Gray50]
            [1 color White] }
          scale <edged, 1, 1> }
        finish { ambient 0 } } } }
#end

#macro GenerateTitle(srnd, th, h)
  #declare t1 = titles1[rand(srnd)*n1]
  #declare t2 = titles2[rand(srnd)*n2]
  #local addnothing = false;
  #if (rand(srnd) > 0.9)
    #declare t1 = ""
    #local addnothing = true;
  #end
  #if (!addnothing)
    #if (rand(srnd) > 0.8)
      #declare t1 = concat(t1, "'s")
      #local addnothing = true;
    #end
  #end
  #if (!addnothing)
    #if (rand(srnd) > 0.7)
      #declare t1 = concat(t1, " of")
      #local addnothing = true;
    #end
  #end
  #if (!addnothing)
    #if (rand(srnd) > 0.7)
      #declare t1 = concat("The ", t1)
      #local addnothing = true;
    #end
  #end
  //#declare title = concat(t1, " ", t2)
  #declare a1 = authors1[rand(srnd)*na1]
  #declare a2 = authors2[rand(srnd)*na2]
  #if (rand(srnd) > 0.5) #declare t1 = strupr(t1) #declare t2 = strupr(t2) #end
  #if (rand(srnd) > 0.5) #declare a1 = strupr(a1) #declare a2 = strupr(a2) #end
  #local TextDone = false;
  // --- in-line text ---
  #if (th/h < 0.2)
    #local ttex = text { ttf fonts[rand(srnd)*5] concat(t1, " ", t2), 1, 0 translate <0, 0, -0.5> }
    #local atex = text { ttf fonts[rand(srnd)*5] concat(a1, " ", a2), 1, 0 translate <0, 0, -0.5> }
    #local p2 = max_extent(ttex);
    #declare spt = union {
      object { ttex }
      object { atex translate <1.6*p2.x, 0, 0> } }
    #local TextDone = true;
  #end
  // --- two-rows text ---
  #if (!TextDone)
    #local ttex = text { ttf fonts[rand(srnd)*5] concat(t1, " ", t2), 1, 0 translate <0, 0, -0.5> }
    #local atex = text { ttf fonts[rand(srnd)*5] concat(a1, " ", a2), 1, 0 translate <0, 0, -0.5> }
    #local p2 = max_extent(atex);
    #declare spt = union {
      object { atex }
      object { ttex translate <0, 1.2*p2.y, 0> } }
    #local TextDone = true;
  #end
#end

#macro RandomRow(Width, h)
#local thick = rand(prnd)*h/5 + h/8;
#local xp = thick;
#while (xp+thick < Width)
  GenerateTitle(prnd, thick, h)
  // choose cover colours
  #local c1 = rgb <rand(crnd)*0.3, rand(crnd)*0.3, rand(crnd)*0.3>;
  #if (rand(crnd) > 0.5) #local c1 = <1, 1, 1> - c1; #end
  #local c2 = <1, 1, 1> - c1; //rgb <rand(crnd), rand(crnd), rand(crnd)>;
  // choose colour divide
  #local m = rand(crnd)*0.1+0.1;
  #if (rand(crnd) > 0.5) #local m = 1 - m; #end
  #if (rand(crnd) > 0.5) #local c2 = c1; #end
  // choose text colour
  #local brite = (c1.x+c1.y+c1.z+c2.x+c2.y+c2.z)/2;
  #local tcol = rgb <rand(crnd)*0.3, rand(crnd)*0.3, rand(crnd)*0.3>;
  #if (brite < 1.5)
    #local tcol = rgb <tcol.x+0.7, tcol.y+0.7, tcol.z+0.7>;
  #end
  // make book
  #local scal = 1-rand(prnd)*0.2;
  object {
    PaperBack(crnd, thick, h, c1, c2, m, tcol, spt)
    scale <0.99, scal, scal>
    translate <xp, scal*h, 0> }
  #local xp = xp + 2*thick;
  #local thick = rand(prnd)*h/5 + h/8;
#end
#end

#macro PaperRow(wid, numb, hei)
  #local thick = (wid/numb)/2;
  #local xp = thick;
  // choose cover colours
  #local c1 = rgb <rand(crnd)*0.3, rand(crnd)*0.3, rand(crnd)*0.3>;
  #if (rand(crnd) > 0.5) #local c1 = <1, 1, 1> - c1; #end
  #local c2 = <1, 1, 1> - c1; //rgb <rand(crnd), rand(crnd), rand(crnd)>;
  // choose colour divide
  #local m = rand(crnd)*0.1+0.1;
  #if (rand(crnd) > 0.5) #local m = 1 - m; #end
  #if (rand(crnd) > 0.5) #local c2 = c1; #end
  // choose text colour
  #local brite = (c1.x+c1.y+c1.z+c2.x+c2.y+c2.z)/2;
  #local tcol = rgb <rand(crnd)*0.3, rand(crnd)*0.3, rand(crnd)*0.3>;
  #if (brite < 1.5)
    #local tcol = rgb <tcol.x+0.7, tcol.y+0.7, tcol.z+0.7>;
  #end
  #while (xp+thick <= wid)
    GenerateTitle(prnd, thick, hei)
    // make book
    object {
      PaperBack(crnd, thick, hei, c1, c2, m, tcol, spt)
      scale <0.99, 1, 1>
      translate <xp, hei, 0> }
    #local xp = xp + 2*thick;
  #end
#end

#macro HardBackRow(wid, numb, hei, sptype, cotype)
  #local thick = (wid/numb)/2;
  #local xp = thick;
  #while (xp+thick <= wid)
    object { HardBack(thick, hei, cotype, sptype) scale <0.99, 1, 1> translate <xp, hei, 0> }
    #local xp = xp + 2*thick;
  #end
#end
