


/*_______________________________________________________________________________________________________*\

FILE NAME: Make_Clouds.pov
CREATED BY: Isaac Kulka, Copyright 12-28-2006
NOTES: Created for the Internet Raytracing Competition's Nov-Dec 2006 Contest: 'Complexity' (www.irtc.org)

DESCRIPTION: This files is used to generate a background of clouds, to be used as the background of a further scene.
             This image is used as a background for Grassland_Blueground.pov

\*_______________________________________________________________________________________________________*/

 
 
 
 
global_settings
{
  max_trace_level 110
}


camera
{
  location<0,10,0>
  look_at <-1.6,9.1,10>
} 


background{rgb<0.2,0.4,2>}




plane
{
  y
  0
  
  pigment{rgb<1,1,1>}
  finish{ambient 1}
 
}


  
  
  
  
  
  

#local light_c = rgb<0.95,0.95,1.00>; //Light color at the top of the clouds
#local dark_c =  rgb<0.70,0.70,0.825>; //Dark color at the bottom of the clouds



#local LAYERS = 50; //number of cloud layers (higher values means fluffier, smoother clouds, but it will significantly increase render time
#local SEED = 89854; //effects the random appearance of the clouds
                                  
                                  
#local X_ROT = -0.5; //The number of degrees the top layer of clouds is rotated around the x-axis as compared with the bottom layer                                  
#local Z_ROT = 0; //the number of degrees the top layer of clouds is rotated around the z_axis
#local Y_ROT = 0; //The number of degrees the top layer is rotated around the y_axis (good for a motion blur effect)

                                  
#local CLOUD_HEIGHT = 2000;//3000; //Height of the top layer of clouds
#local X_CHANGE = 500; //The distance the top layer is displaced from the bottom layer in the x-direction
#local Z_CHANGE = 2000; //The distance the top layer is displaced from the bottom layer in the z-direction

#local CHANGE = 6000;//4000; //amount the appearance of the clouds shifts between the top and bottom layers

#local RADIUS = 70000; //radius of the cloud_spheres
#local SCALE = 11000; //scale of the pattern in the cloud_spheres

#local CLEAR_POINT = 0.55; //point in the color_map at which the pattern remains clear
#local SOLID_POINT = 1.00; //point in the color_map at which the pattern remains solid






#local cloud_finish = finish{ambient 1}


#local i = 0;
#while(i < LAYERS)
  
  
  
  #local i_ratio = i/LAYERS;
  #local i_ratio_inv = 1 - i_ratio;
  
  
  
  #local cloud_pigment =
  pigment
  {
    wrinkles
      octaves 9
      lambda 5.0
      omega 0.30
      turbulence <0.5,0.5,0.5>
      frequency 1.10



      
    
    #local color_1 = rgbft<dark_c.red*i_ratio_inv + light_c.red*i_ratio,  dark_c.green*i_ratio_inv + light_c.green*i_ratio,  dark_c.blue*i_ratio_inv + light_c.blue*i_ratio, 0, 1.00>; 
    #local color_2 = rgbft<dark_c.red*i_ratio_inv + light_c.red*i_ratio,  dark_c.green*i_ratio_inv + light_c.green*i_ratio,  dark_c.blue*i_ratio_inv + light_c.blue*i_ratio, 0, 0.40>; 
    
    
    
    color_map
    {
      [-0.1         color_1]
      [CLEAR_POINT  color_1]
      [SOLID_POINT  color_2]
      [1.10         color_2]
    
    }
    
    
    scale SCALE
    rotate<X_ROT * i_ratio,  Y_ROT * i_ratio , Z_ROT * i_ratio>
    translate y*SEED
    translate<0,i_ratio*CHANGE,0>
  }
    
 

  
  
  sphere
  {
    <0,0,0>
    RADIUS
    
    pigment{cloud_pigment}
    finish{cloud_finish}
    
    hollow
    
    scale<1,0.20,1>
    translate
    <
      i_ratio*X_CHANGE, 
      i_ratio*CLOUD_HEIGHT,
      i_ratio*Z_CHANGE
    >
  }
  
  #local i = i + 1;
#end
  





fog
{
  fog_type 2 //constant fog
  distance 25000
  color rgb 1
  fog_offset 1
  fog_alt 3000
}