/*  
Important!  
Render this file before rf_mcc.pov
Run this file with the following options:
+UA +H1000 +W1000 +FN +KFI1 +KFF80 +KI1 +KF80
   
This file generates 80 image_maps for needed by rf_mcc.pov   
*/ 

#include "rand.inc" 
#include "shapes.inc"

#declare q=814; // max height 
#declare m=1000; // max height

#declare i_seed = seed(88734); // intercom buttons

global_settings{number_of_waves 1 }

// order is important because of output filenames
#declare draw_canada_flag         = 1;
#declare draw_usa_flag            = 2;
#declare draw_nasa_seal           = 3;
#declare draw_nasa_logo           = 4;
#declare draw_csa_logo            = 5;
#declare draw_mcc_logo            = 6; 
#declare draw_mcc_text            = 7; 
#declare draw_esa_logo            = 8;
#declare draw_roscosmos_logo      = 9;
#declare draw_jaxa_logo           = 10;
#declare draw_moc_logo            = 11;
#declare draw_launch_digitals     = 12;
#declare draw_ascent_ground_track = 13;
#declare draw_altitude_chart      = 14;
#declare draw_specs_and_ofs       = 15;
#declare draw_intercom_buttons    = 16;
#declare draw_earthrise_print     = 17;
#declare draw_chile_flag          = 18;
#declare draw_flight_rules_white  = 19;
#declare draw_flight_rules_blue   = 20;
#declare draw_status_board1       = 21;
#declare draw_status_board2       = 22;
#declare draw_screen1             = 23; // and higher - if this constant change, be sure to update first_computer_screen_index in rf_mcc_textures.inc
camera {
  orthographic
  location <500,500,-1000>    // position & direction of view
  look_at  <500,500,0>
  right 1000*x            // horizontal size of view
  up 1000*y               // vertical size of view 
/*  
  aperture 0.00001           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 2        // number of rays per pixel for sampling
  focal_point <500,814/2,0>    // point that is in focus <X,Y,Z>
  confidence 0.95           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/200            // [0...1] how precise to calculate (smaller is more accurate)
*/
  
}
/*
box {                  // this box fits exactly in view
  0, <1000,1000, 0>
  texture { pigment { rgb <1, 0, 1> } }
}
*/

//background {0}

//light_source {0*x rgb 0.1 translate <500,814/2,-100> parallel point_at <500,814/2,0>}
light_source {0*x rgb 0.7 translate <500,814/2,-100> parallel point_at <500,814/2,0> shadowless}   

#declare c = 500; // center
#declare cp = <500,500,0>; // centerposition



#macro star_group(xlat)
union {
  #local i=0;
  #while (i<10)
    sphere {0, RRand(1,3,ssd) translate <RRand(0, 90, ssd), 0,0> rotate z*rand(ssd)*360 pigment {rgb 1} finish {ambient rgb 0.5}}
    #local i=i+1;
  #end
  translate xlat
}
#end


#declare nasa_vectors =   
union{
  // vector
  // create a curved tube object translating a sphere along a certain path
  sphere_sweep {
    //linear_spline                 // linear curve
    cubic_spline                // alternative spline curves
    //b_spline
    4,                            // number of specified sphere positions
    <150,200, 0>, 3                // position, radius
    <170,400, 0>, 3                 // ...
 //   <400,580, 0>, 1
//    <575,650, 0>, 3 
    <730,750, 0>, 3
    <730,1000, 0>, 1     
    //tolerance 0.001             // optional  
    translate -z*100
    pigment {rgb <1,0,0>}
    finish {ambient rgb <1,0,0>}
  }

// behind planet
  sphere_sweep {
    linear_spline                 // linear curve
    3,                            // number of specified sphere positions
    <170,550, 0>, 3                 // ...
    <580,655, 0>, 8
    <730,750, 0>, 1 
        
    tolerance 0.001             // optional  
    translate -z*1
    pigment {rgb <1,0,0>} 
    finish {ambient rgb <1,0,0> }
    scale <1,1,0.1>   
  }
};

#declare orbit = 
union {
  torus {320, 3 translate  <470,c,-1> translate -z*70 rotate -x*15 pigment {rgb 1} finish {ambient rgb 0.5} } 
  sphere {0 10 translate <705,520,-50> pigment {rgb 1} finish {ambient rgb 0.5}} 
};
// NASA Seal ///////////////////////////////////////////////////////////////////////////////////////////////////////////////
#declare t_nasa_seal_blue = 
texture {
  pigment {
    gradient y
    color_map {
      [0  rgb  <0.0,0.0,0.502>]
      [1  rgb  <0.0,0.302,1>]
    }
  }
};
      
#declare nasa_seal = 
union { 
  #local ssd = seed(98383); // star group
  disc {cp,z, 1000/2,983/2 pigment {rgb <1.0,0.898,0.698> }}  // outer yellow
  disc {cp,z, 983/2,880/2  pigment {rgb 1}} 
  disc {cp,z, 880/2,863/2 pigment {rgb <1.0,0.898,0.698> }}  // outer yellow
  disc {cp,z, 863/2, 30  texture {t_nasa_seal_blue scale 863 translate y*137/2}}

  
  object {
    Circle_Text("TIMES.TTF", "NATIONAL AERONAUTICS AND SPACE ADMINISTRATION" , 50, 0.5, 1, 450, 0, Align_Left, 240)
    translate <c,c,-200> 
    pigment {rgb <0.8,0,0>}
   // finish {ambient rgb <0.8,0,0>}
    }

  object {
    Circle_Text("TIMES.TTF", "U.S.A" , 50, 0.2, 1, 450, 1, Align_Left, 260)
    translate <c,c,-200> 
    pigment {rgb <0.8,0,0>}
   // finish {ambient rgb <0.8,0,0>}
    }

  // planet 
  disc {<400,c,-5>, z, 344/2 0 pigment {rgb <1.0,0.898,0.0>}}
  
  // moon 
  light_group {
    light_source {0*x rgb 1 translate <c,800,-400>}
    sphere {0,40 translate <720,600,-100> pigment {rgb 0.8} finish {ambient rgb <0.651,0.8,0.8>*0.7 diffuse  0.8}  }
    } 
    
  // orbit 
  object {orbit}


  object {nasa_vectors}

  
  star_group(<255,300,-2>)
  star_group(<625,250,-2>)
  star_group(<645,255,-2>)
  star_group(<600,400,-2>)
  star_group(<300,800,-3>)
  star_group(<800,600,-3>)
  
}; 

// NASA Logo (the "meatball" ///////////////////////////////////////////////////////////////////////////////////////////
#declare nasa_logo = 
union {
  disc {cp,z, 976/2 ,0 pigment {rgb <0.125,0.353,0.655>*2} }
  object {nasa_vectors translate -cp scale <1.7,2.5,1> translate cp translate <80,-200,0>}
  torus {320, 3   translate -z*320 rotate x*25 rotate -z*70 translate <400,c 0> pigment {rgb 1} finish {ambient rgb 0.5} } 
  sphere {0 10 translate <515,300,-300> pigment {rgb 1} finish {ambient rgb 0.5}} 

text {
  ttf             // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "NASA",      // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing 
  pigment {rgb 1}
  finish {ambient 1}
  scale 300 
  translate <100,410,-100> 
  }
  star_group(<550,900,-2>) 
  star_group(<450,800,-2>)
  star_group(<300,200,-2>)
  star_group(<700,250,-2>)

};

// Canada Flag /////////////////////////////////////////////////////////////////////////////////////////////////////////
#declare t_canada_flag_bkg = 
texture {
  pigment {
    gradient x
    color_map {
      [0.25 rgb <0.89,0.176,0.125>]
      [0.25 rgb 1]
      [0.75 rgb 1]
      [0.75 rgb <0.89,0.176,0.125>]
    }
    scale 1000
  }
}; 




#declare maple_leaf_half =     
prism {                                
  linear_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
  -5,         // height 1
   50,         // height 2
  15,           // number of points
  // (--- the <u,v> points ---)
  <500,917>
  <512, 917>, <509,717>, <607,744>, <595,670>, <692, 504>, 
  <670,490>, <684,350>, <634,374>, <614,314>, <560,424>
  <575,184>,<540,229>,<500,82>,
  <500,917>
     // , <0.2,   0.2> // match 2nd point, if quadratic_spline add this
  // , <0.2,  -1.0> // match 1st point, if cubic_spline add this as well as the other
  // [open]
  // [sturm]
 rotate -x*90
 translate x*0 
 
  
};

#declare maple_leaf = 
union {
  object {maple_leaf_half rotate x*180 translate y*c*2}
  object {maple_leaf_half rotate x*180 translate y*c*2 rotate y*180 translate x*c*2}
};


#declare canada_flag = 
union {
   box {0, <1000,1000, -1> texture {t_canada_flag_bkg}}
     
    // extrude a closed 2-D shape along an axis  

  object {maple_leaf pigment {rgb <0.89,0.176,0.125>}}    
  };
// USA Flag //////////////////////////////////////////////////////////////////////////////////////////////////////////////
#declare t_usa_flag_bkg =
texture {
  pigment {
    gradient y
    color_map {
      [0.5  rgb <0.765,0.243,0.235> /*<0.588,0.184,0.18>*/]
      [0.5  rgb 1]
    }
    scale 2*1000/13
  }
};

#declare usa_star = 
// extrude a closed 2-D shape along an axis
prism {                                
  linear_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
  -5,         // height 1
   5,         // height 2
  11,           // number of points
  // (--- the <u,v> points ---)
  < 17,0>, <22,17>, <33,20>, <25, 35>, <27, 53>, 
  <17,40>, <6,53>, <9,35>, <0, 20>, <12,17>,<17,0>
  // , <0.2,   0.2> // match 2nd point, if quadratic_spline add this
  // , <0.2,  -1.0> // match 1st point, if cubic_spline add this as well as the other
  // [open]
  // [sturm]
  pigment {rgb 1} 
   
  rotate x*90 
  translate <-17,27,0>
};


  
#declare usa_flag = 
union {
  box {0, <1000,1000, -1> texture {t_usa_flag_bkg}}
  box {<0,1000,0>,<450,461,-2> pigment {rgb <0.0,0.416,0.8> /*<0.0,0.196,0.384>*/}}
  
   
  #local i=0;
  #while (i<5)
    #local j=0;
    #while (j<6)
      object {usa_star translate <43+72*j,939-110*i,-3>}
      #local j=j+1;
    #end
    #local i=i+1;
  #end 
  
  #local i=0;
  #while (i<4)
    #local j=0;
    #while (j<5)
      object {usa_star translate <79+72*j,884-110*i,-3>}
      #local j=j+1;
    #end
    #local i=i+1;
  #end 
  
};

// Canadian Space Agency Logo //////////////////////////////////////////////////////////////////////////////////////////
#declare csa_logo = 
union {
  disc {cp,z, 987/2 ,0 pigment {rgb <0.125,0.353,0.655>*1.8} }
  object {maple_leaf pigment {rgb <1,0,0>} finish {ambient rgb <1,0,0>} scale 0.2*<1.4,1,1> translate <360,300,0>}
  
  union {
    cylinder { <0,0,0>,<0,-2,-20> 200 open scale <2,1.5,1> rotate -x*30  translate cp translate <0,-100,0>}
    
    cone {<500,640,0>,10,<500,950,0>,0  }
    cone {<500,640,0>,10,<800,640,0>,0  }
    cone {<500,640,0>,10,<200,640,0>,0  } 
    cone {<500,640,0>,10,<500+100,640+100,0>,0  } 
    cone {<500,640,0>,10,<500-100,640+100,0>,0  } 
    cone {<500,640,0>,5,<500+30,640+80,0>,0  } 
    cone {<500,640,0>,5,<500-30,640+80,0>,0  } 
  
    torus {90,2 scale <2,1,1> rotate x*40 rotate z*40 translate cp translate y*250 translate -z*20}  
    text {
      ttf             // font type (only TrueType format for now)
      "arialbd.ttf",  // Microsoft Windows-format TrueType font file name
      "CSA   ASC",      // the string to create
      2,              // the extrusion depth
      0               // inter-character spacing 
      scale 130 
      translate <170,200,-100> 
      }
       
    cylinder {0,-z*1,4 scale <5,1,1> translate <641,850,0>  }
    cylinder {0,-z*1,4 scale <5,1,1> rotate z*90 translate <641,850,0>  }
   
    cylinder {0,-z*1,4 scale <5,1,1> translate <375,910,0>  }
    cylinder {0,-z*1,4 scale <5,1,1> rotate z*90 translate <375,910,0>  }
      
    pigment {rgb 1} finish {ambient rgb 1}  
  }  
  
};

#declare mcc_logo = 
union { 
  
  #local pr = 450; // planet radius
  #local pp = <0,414,0>;  // planet position
  #local t_planet_grid_line = texture {pigment {rgb 0.1}};
  #local t_planet_light_blue = texture {pigment {rgb <0.675,0.788,0.843>*2}};
  #local t_planet_dark_blue  = texture {pigment {rgb <0.176,0.459,0.678>*2}};
  #local t_clear = texture {pigment {rgbt 1}};
  #local t_planet_blue = 
  texture {
    gradient x
    texture_map {
      [0  t_planet_light_blue]
      [1  t_planet_dark_blue]
    }
  };

  #local t_mcc_logo_border= 
  texture {
    pigment {
      gradient y
      color_map {
        [0  rgb 2]
        [1  rgb <0.42,0.518,0.624>*2]
      }
    }
  };

  
  #local t_planet_vgrid = 
  texture {
    gradient y
    texture_map {
      [0.1 t_planet_grid_line]
      [0.1 t_clear]
    } 
    scale 1/5
    
  };
  
  #local t_planet = 
    texture {t_planet_blue};
    
    
  #local planet = union {
    sphere {0,1 texture {t_planet} }
    sphere {0,1.0001 texture {t_planet_vgrid}}
    #local i=0;
    #while (i<5) 
      cylinder {<-0.01,0,0>,<0.01,0,0> 1.0002 rotate -y*15*i texture {t_planet_grid_line}}
      #local i=i+1;
    #end
    scale pr
    }
    
  // spaceship 
  #local spaceship = 
  sphere_sweep {
   // linear_spline                 // linear curve
    cubic_spline                // alternative spline curves
    //b_spline
    7,                            // number of specified sphere positions 
    <-50,-100,0>, 0
    <-50,-100,0>, 4
    <-30, -50, 0>, 10                // position, radius
    <0, 0, 0>, 18                 // ...
    < 30, -50, 0>, 10
    < 50, -75, 0>, 4
    < 50, -75, 0>, 0
    
    tolerance 0.001             // optional
    pigment {rgb <1,0,0>} 
    
    finish {phong 2 phong_size 40}
  };


  union {
    plane {z,100 pigment { rgb <0.129,0.0,0.388>}  }
  
    union {
      object {planet }
      disc {0,z, pr+10 ,0 pigment {rgb <0.624,0.639,0.808>*2}} // inner atmostphere
      disc {0,z, pr+80 ,0 pigment {rgb <0.29,0.176,0.58>*2} translate z*1} // outer atmostphere 
      disc {0,z, pr+230 ,0 pigment {rgb <0.161,0.063,0.482>*2} translate z*2} // more atmostphere
      translate pp
      }
    
    // star
    union {
      sphere {0,15 }
      #local i=0;
      #while (i<4)
        cone {0,5,<0,130,0>,0 rotate z*90*i} 
        cone {0,3,<50,50,0>,0 rotate z*90*i}
        #local i=i+1;
      #end 
      disc {0,z 75, 72 }
      pigment {rgb 1} finish {ambient rgb 1}
      translate <c,790,0>
      }
   
   // moon
   light_group  {
    light_source {0*x rgb 1 translate <-50,30,-100>}
    sphere {0,75 pigment {rgb 0.8}  } 
    global_lights
    translate <730,370,0>
    }


  // sinewaves 
  
  #local sinewave = 
  sphere_sweep {
   // linear_spline                 // linear curve
    cubic_spline                // alternative spline curves
    //b_spline
    6, 
    <720,700,0>,4
    <720,700,0>,4   
    <400,340,0>, 4
    <190,500, 0>, 4                 // ...
    <-10,340, 0>, 4
    <-10,340, 0>, 4
    
    tolerance 0.001             // optional
    pigment {rgb <1,1,0>} 
    
    finish {phong 2 phong_size 40}
  };

   object {sinewave translate -z*500 }
   object {sinewave translate -z*500 translate x*30}
   object {sinewave translate -z*500 translate x*60} 

text {
  ttf             // font type (only TrueType format for now)
  "micross.ttf",  // Microsoft Windows-format TrueType font file name
  "MCC",      // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing 
  pigment {rgb <1,0,0>}
  finish {ambient <1,0,0>}
  scale 140*<1,1.3,1> 
  translate <200,520,-500> 
  }

  
 
   bounded_by {box {<-0.5,-0.5,100>,<0.5,0.5,-500> scale <700,700,1> rotate z*45 translate cp}  }
  }
  
 
  difference {
  
    union {   
    #local i=0;
    #while (i<4)  
      cylinder {<0,0,0>,<0,0,1> 1 texture {t_mcc_logo_border} scale 700/2 scale <1,0.2,1>  translate y*700/2  rotate z*45 rotate z*90*i translate cp } 
      #local i=i+1;
    #end 
    }   
    box {<-0.5,-0.5,100>,<0.5,0.5,-500> scale <700,700,1> rotate z*45 translate cp} 
  }
  
  light_group {
    light_source {0*x rgb <1,1,0>*2 translate <-100,50,-100>}
    object {spaceship scale <1,2.5,1>*1.5  rotate y*60 rotate -z*35 }  
    translate <825,800,-600>
    }
}; 





// mcc text
#local mcc_m = 
union {
  cylinder {<0,0.4,0>,<0.4,4,0> 0.2}
  cylinder {<0.7,4,0>,<1.8,0.6,0> 0.2}
  cylinder {<2.9,4,0>,<1.8,0.6,0> 0.2}  
  cylinder {<3.2,4,0>,<3.6,0.4,0> 0.2} 
  
  sphere {0, 0.2 translate <0,0.4,0>}
  sphere {0, 0.2 translate <0.4,4,0>}
  sphere {0, 0.2 scale <1.5,1,1.2> translate (<0.4,4,0>+<0.7,4,0>)/2}
  
  sphere {0, 0.2 translate <0.7,4,0>}
  sphere {0, 0.2 translate <1.8,0.6,0>}
  sphere {0, 0.2 translate <2.9,4,0>}
  sphere {0, 0.2 scale <1.5,1,1.2> translate (<2.9,4,0>+<3.2,4,0>)/2}

  sphere {0, 0.2 translate <3.2,4,0>}
  sphere {0, 0.2 translate <3.6,0.4,0>}
  

};
#local mcc_s = 
union {
  cylinder {<0,3.2,0>,<0.8,3.2,0> 0.15}
  torus {0.3,0.15 rotate x*90 clipped_by {plane{x,0}} translate <0,2.9,0>} 
  
  cylinder {<0,3.2-0.6,0>,<0.5,3.2-1,0> 0.15}
  sphere {0, 0.15 translate <0,3.2-0.6,0>}
  sphere {0, 0.15 translate <0.5,3.2-1,0>}
  
  cylinder {<-0.3,1.4+0.15,0>,<0.5,1.4+0.15,0> 0.15} 
  torus {0.3,0.15 rotate x*90 clipped_by {plane{-x,0}} translate <0.5,1.85,0>}
  };
  
#local mcc_i = cylinder {<0,1.4,0>,<0,3.4,0> 0.15};
#local mcc_o = torus {0.85,0.15 rotate x*90 translate <0,2.4,0>};

#local mcc_n = 
union {
  cylinder {<0,1.4,0>,<0,3.4,0> 0.15}
  cylinder {<0,3.4,0>,<1,1.4,0> 0.15}
  cylinder {<1,1.4,0>,<1,3.4,0> 0.15} 
  sphere {0 0.15 translate <0,3.4,0>}
  sphere {0 0.15 translate <1,1.4,0>}
};

#local mcc_c = torus {1.8, 0.2 rotate x*90 clipped_by {plane {x,0.1}} translate y*2.2}
#local mcc_t = 
union {
  cylinder {<-0.6,3.3,0>,<0.6,3.3.0> 0.15}
  cylinder {<0,1.4,0>,<0,3.3,0> 0.15}
};

#local mcc_r = 
union {
  cylinder {<0,1.4,0>,<0,3,0> 0.15}
  torus {0.4 0.15 rotate x*90 translate <0.4,2.9,0>}
  torus {0.4 0.15 rotate x*90 clipped_by {plane {-x,0}} clipped_by {plane {-y,0}} translate <0.4,2.1,0> }
  cylinder {<0,2.5,0>,<0.5,2.5,0> 0.15}
  cylinder {<0.8,2.1,0>,<0.8,1.4,0> 0.15}
};

#local mcc_l = 
union {
  cylinder {<0.2,1.6,0>,<1,1.6,0> 0.15}
  cylinder {<0,1.8,0>,<0,3.4,0> 0.15}
  torus {0.2 0.15 rotate x*90 clipped_by {plane {y,0}} clipped_by {plane {x,0}}  translate <0.2,1.4+0.4,0>}
  };

#local mcc_e =
union {
  torus {0.85 ,0.15 rotate x*90 clipped_by {plane{x,0}} translate y*2.4}
  cylinder {<-0.85,2.4,0>,<0,2.4,0> 0.15}
};

#declare mcc_text =   
union { 
  object {mcc_m translate x*0.7}
  object {mcc_i translate x*4.8}
  object {mcc_s translate x*5.5}
  object {mcc_s translate x*6.8}
  object {mcc_i translate x*8}
  object {mcc_o translate x*9.2}
  object {mcc_n translate x*10.4}

  object {mcc_c translate x*14.2}
  object {mcc_o translate x*14.8} 
  object {mcc_n translate x*16}
  object {mcc_t translate x*17.8}
  object {mcc_r translate x*18.7}
  object {mcc_o translate x*20.7}
  object {mcc_l translate x*22}
 
  object {mcc_c translate x*25.5}
  object {mcc_e translate x*26.1}
  object {mcc_n translate x*26.5}
  object {mcc_t translate x*28.4}
  object {mcc_e translate x*30} 
  object {mcc_r translate x*30.5} 

  pigment {rgb <1,1,0>}
  finish {ambient rgb <1,1,0>/2} 
  scale 200*<0.15,1,1> 
  translate <0,100,0>
  };


//object {mcc_text }


// European Space Agency Logo ////////////////////////////////////////////////////////////////////////////////////////////
#declare esa_logo = 
union {
  #local t_esa_blue  = texture {pigment {rgb <0,0,0.5>} finish {ambient 0.5}};
  #local t_esa_white = texture {pigment {rgb <1,1,1>}   finish {ambient 0.5}};
  
  #local t_esa_disc =
  texture { 
    ripples
    texture_map {
      [0.5  t_esa_blue]
      [0.5  t_esa_white]
    }
    scale 10
  };
  
  union { // bkg
    cylinder {<200,500,0>,<800,500,0> 495 }
    sphere {0,495 scale <0.4,1,1> translate <800,500,0> }
    sphere {0,495 scale <0.4,1,1> translate <200,500,0> }
    texture {t_esa_blue}  
    scale <1,1,0.001>
  }
  
  disc {0,z,450,0 scale <0.4,1,1>  texture {t_esa_disc translate <200,450,0>} translate <200,500,-5>}
   
  disc {0,z,50,0  scale <0.4,1,1> texture {t_esa_blue} translate <100,500,-6>}
  text {
    ttf             // font type (only TrueType format for now)
    "arialbd",  // Microsoft Windows-format TrueType font file name
    "esa",      // the string to create
    2,              // the extrusion depth
    0               // inter-character spacing 
    texture {t_esa_white}
    scale 1000*<0.35,1,1> 
    translate <400,230,-100> 
    }
    
  text {
    ttf             // font type (only TrueType format for now)
    "arialbd",  // Microsoft Windows-format TrueType font file name
    "e",      // the string to create
    2,              // the extrusion depth
    0               // inter-character spacing 
    texture {t_esa_blue}    
    scale 1000*<0.35,1,1> 
    translate <180,230,-100> 
    }
 

};

#declare roscosmos_logo = 
union { 

  #local t_rk_yel = texture {pigment {rgb <1,1,0>} finish {ambient rgb 0.5}}; 
  #local t_rk_red = texture {pigment {rgb <1,0,0>} finish {ambient rgb 0.5}};
/*
  box {<0,0,2>, <1000,1000, 1>
  texture { pigment { image_map{jpeg "roscomos.jpg"}} scale 1000}
  } 
*/
  torus {290,5  rotate x*90 scale <0.7,1,1> translate cp translate y*80}
  torus {50,2 rotate -x*20 rotate z*30 scale 3.7 translate cp  translate <0,90,-200>}
  
  // extrude a closed 2-D shape along an axis
  prism {                                
    linear_sweep  // or conic_sweep for tapering to a point
    linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
    -5,         // height 1
     5,         // height 2
    5,           // number of points
    // (--- the <u,v> points ---)
    < 360,420>, <600, 740>, <580, 490>, <540, 550>, < 360,420> 
    rotate -x*90 
    translate -z*100 
    texture {t_rk_red}
  }

text {
  ttf             // font type (only TrueType format for now)
  "arial.ttf",  // Microsoft Windows-format TrueType font file name
  "POCKOCMOC",      // pronounced ROSS COSMOS
  2,              // the extrusion depth
  0               // inter-character spacing 

  scale 90*<0.71,1,1> 
  translate <290,180,-100> 
  }



  
  texture {t_rk_yel}  
  scale 1.3  
  translate <-c*0.3,-c*0.3,0>
};


#declare jaxa_logo = 

union {
  //box {<0,0,2>, <1000,1000, 1>
  //texture { pigment { image_map{gif "logo_jaxa.gif"}} scale 1000}  } 

  text {
    ttf             // font type (only TrueType format for now)
    "arialbi.ttf",  // Microsoft Windows-format TrueType font file name
    "JAXA",      // pronounced ROSS COSMOS
    2,              // the extrusion depth
    0               // inter-character spacing 
  
    scale 660*<0.57,1,1> 
    translate <32,400,-100> 
    pigment {rgb <0.1,0.1,0.9>}
    finish {ambient rgb 1}
    }

  text {
    ttf             // font type (only TrueType format for now)
    "arialbd.ttf",  // Microsoft Windows-format TrueType font file name
    "Japan Aerospace Exploration Agency",      // pronounced ROSS COSMOS
    2,              // the extrusion depth
    0               // inter-character spacing 
  
    scale 40*<0.57,1,1> 
    translate <550,300,-100> 
    pigment {rgb <0.7,0.7,0.1>}
    finish {ambient rgb 0.7}
    }


};
#local p = pigment {rgbt <1,1,0,0.5>}; 

#declare moc_logo = 
union {
 // box {<0,0,2>, <1000,1000, 1>   texture { pigment { image_map{jpeg "logo_mod.jpg"}} scale 1000}  } 

  disc {cp,z, 800/2, 0 pigment {rgb 0} translate z*100} // background*
  
  union {
    disc {cp,z, 870/2, 840/2 pigment {rgb <1,0,0>}}
    disc {cp,z, 840/2, 730/2 pigment {rgb <0.8,1,1>} /*finish {ambient rgb 0.4}*/}
    disc {cp,z, 730/2, 720/2 pigment {rgb 0}}
    finish {ambient rgb 0.6}
    translate -z*100
  }
 
  object {
    Circle_Text("arialbd.ttf", "RES GESTA PER  EXCELLENTIAM " , 50, 0, 1, 375, 0, Align_Left, 154)
    translate <c,c,-200> 
    pigment {rgb 0.1}
    } 
    
    
  // moon/mars  
  #local p_planet = 
  pigment {
    gradient x
    color_map { 
      [0.5 rgb <0.875,0.6,0.286>]
      [0.5 rgb 0.8]
    }
    }
   



    intersection {
      union {
        cylinder {<c,0,0>,<c,0,1> 345 pigment {rgb <0.0,0.439,0.657>}} 
        cylinder {<c,0,2>,<c,0,3> 360 pigment {rgb <0.606,0.812,0.835>}}
        } 
        cylinder {<c,c,-300>,<c,c,300> 870/2 }   
        finish {ambient rgb 0.6}
      }  
        
        
      intersection {
        sphere {0,0.5  pigment {p_planet} scale 220 *<1,1,0.1> translate <c,860,0>}  // moon/mars
        cylinder {<c,c,-300>,<c,c,300> 870/2 }  
        finish {ambient rgb 0.6}
      }
      
  // fire 
    intersection {
      cylinder {<0,0,0>,<0,800,0>,30 pigment {rgb <0.882,0.645,0.0>} finish {ambient rgb 0.5} translate x*c}
      cylinder {<c,c,-300>,<c,c,300> 870/2 } 
      finish {ambient rgb 0.6}
      }
    
    #local i=0;
    #while (i<4)
      object {usa_star translate <c,200+50*i,-200> finish {ambient rgb 0.6}}
      #local i=i+1;
    #end
      
  
  // shuttle
  union {
    triangle {<0,0,-50>,<-50,-100,-50>,<50,-100,-50> pigment {rgb 1} } // orbiter 
    cylinder {<0,-20,-50>,<0,-120,-50> 10 pigment {rgb 1}}
    cylinder {<-27,-120,2>,<-27,0,2> 7 pigment {rgb 1}} // srb
    cylinder {< 27,-120,2>,< 27,0,2> 7 pigment {rgb 1}}
    cylinder {<0,-100,2>,<0,25,0>, 20   pigment {rgb <0.8,0.4,0>} }  //et
    cone     {<0,25,0>,20,<0,50,0>,0    pigment {rgb <0.8,0.4,0>} }  //et 
    finish {ambient rgb 0.6}   
    translate <c,840,-200> 
    }
  
  
    difference {  
      box {<0,300,0>,<1000,700,-1> pigment {rgb <0.9,0,0>}} 
      cylinder {<0,0,1> <0,0,-1> 1 scale 500*<1,0.5,1>  pigment {p} translate <c,200,0>}
      cylinder {<0,0,1> <0,0,-1> 1 scale 500*<1,0.5,1>  pigment {p} translate <c,800,0>}
      cylinder {<0,0,2> <0,0,-1> 1 scale 480 translate cp inverse} 
      finish {ambient rgb 0.6}
      
      translate <0,0,-300>
     }
    
    union {
      text {ttf "arialbd.ttf","M",2,0 translate -y*0.5 scale 300*<0.4,1,1>*1.10  translate y*150 translate <50,0,1> } 
      text {ttf "arialbd.ttf","I",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.80  translate y*150 translate <170,0,1> } 
      text {ttf "arialbd.ttf","S",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.70 translate y*150 translate <200,0,1> } 
      text {ttf "arialbd.ttf","S",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.60 translate y*150 translate <260,0,1> } 
      text {ttf "arialbd.ttf","I",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.50 translate y*150 translate <320,0,1> } 
      text {ttf "arialbd.ttf","O",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.45 translate y*150 translate <340,0,1> } 
      text {ttf "arialbd.ttf","N",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.40 translate y*150 translate <390,0,1> } 

      text {ttf "arialbd.ttf","O",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.40  translate y*150 translate <460,0,1> } 
      text {ttf "arialbd.ttf","P",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.40  translate y*150 translate <500,0,1> } 
      text {ttf "arialbd.ttf","E",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.40 translate y*150 translate <530,0,1> } 
      text {ttf "arialbd.ttf","R",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.45 translate y*150 translate <570,0,1> } 
      text {ttf "arialbd.ttf","A",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.50 translate y*150 translate <610,0,1> } 
      text {ttf "arialbd.ttf","T",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.60 translate y*150 translate <650,0,1> } 
      text {ttf "arialbd.ttf","I",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.70 translate y*150 translate <700,0,1> } 
      text {ttf "arialbd.ttf","O",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.80  translate y*150 translate <730,0,1> } 
      text {ttf "arialbd.ttf","N",2,0 translate -y*0.5 scale 300*<0.4,1,1>*0.90  translate y*150 translate <800,0,1> } 
      text {ttf "arialbd.ttf","S",2,0 translate -y*0.5 scale 300*<0.4,1,1>*1.10 translate y*150 translate <860,0,1> } 
            
      translate <0,380,-400>
      pigment {rgb 0.8}
      finish {ambient rgb 0.5}
    }

    
    // sigma
    // extrude a closed 2-D shape along an axis
prism {                                
  linear_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
  -5,         // height 1
   5,         // height 2
  15,           // number of points
 // <225,300>,<408,308>,<442,370>,<425,371>,<393,322>,<273,314>,<421,496>,<279,676>,
 // <417,655>,<435,601>,<454,600>,<433,669>,<230,700>,<355,500>,<225,300>

  <225,700>,<408,692>,<442,630>,<425,629>,<393,678>,<273,686>,<421,504>,<279,324>,
  <417,345>,<435,399>,<454,400>,<433,331>,<230,300>,<355,500>,<225,700>
  
  
  // [open]
  // [sturm]
   rotate -x*90  
   pigment {rgb <0.8,0.7,0>} 
   finish {ambient rgb 0.6}
}

    
};



// textures
#macro flat_color(col)                             //0.6
  texture {pigment {rgb col} finish {ambient rgb col*0.8} }
#end

#declare c_screen_gray_bkg     = <0.514,0.514,0.514>;
#declare c_screen_blue_outline = <0.565,0.651,0.812>;//<0.475,0.616,0.906>; //<0.38,0.584,0.996>;
#declare c_screen_title_bar    = <0.788,0.829,0.882>;
#declare c_text = c_screen_title_bar; // most text 
#declare c_screen_grid         = <0.788,0.929,0.882>; 
#declare c_screen_black        = <0,0,0>; 
#declare c_yel                 = <0.835,0.886,0.706>;
#declare c_teal                = <0.396,0.741,0.741>; //<0.298,0.847,0.835>;
#declare c_white               = <0.95,0.95,0.95>;
#declare c_blue                = <0.467,0.663,0.753>; 
#declare c_navy                = <0.169,0.31,0.51>;
#declare c_green               = <0.192,0.667,0.424>;
#declare c_red                 = <0.663,0.376,0.494>; 
#declare c_win_blue            = <0.149,0.267,0.729>*2; 
#declare c_win_gray            = <0.6,0.6,0.6>; 
#declare c_lt_blue             = <0.447,0.757,1.0>*2;

// intercom buttons
#local t_button_yellow = texture {pigment {rgb <1.0,0.867,0.071>}};


#local t_button_yellow = 
texture {
  pigment {rgbt 1}
  finish {ambient 0 diffuse 0}
  };
#local i_button_yellow = 
  interior {
    media {
      emission 1*<1.0,0.867,0.071> 
      intervals 1
      samples 5
      method 3 
    }
};

#local t_button_black  = texture {pigment {rgb<0.333,0.255,0.039>*3}};

#declare t_yel_dashed = 
  texture {
    pigment {
      gradient y 
      color_map {
        [0.4 rgbt 1]
        [0.4 rgb c_yel]
      }
    }
    finish {ambient rgb c_yel*0.6}
    scale 10
  };
    


#macro screen_text(words, col, sc, xlat)
  text {
    ttf             // font type (only TrueType format for now)
   // "arialbd.ttf",  // Microsoft Windows-format TrueType font file name
    "ariblk.ttf",
    words,      // the string to create
    2,              // the extrusion depth
    0               // inter-character spacing 
    flat_color(col) 
    scale 20 // default
    scale sc
    
    translate xlat
  }
#end 

// courier font
#macro screen_textc(words, col, sc, xlat)
  text {
    ttf             // font type (only TrueType format for now)
   // "arialbd.ttf",  // Microsoft Windows-format TrueType font file name
    "courbd.ttf",
    words,      // the string to create
    2,              // the extrusion depth
    0               // inter-character spacing 
    flat_color(col) 
    scale 20 // default
    scale sc
    
    translate xlat
  }
#end 



#declare mcc_launch_digitals =
union {
//difference {
    box {<   0,   0,   10>,<1000,  814,  9> flat_color(c_screen_blue_outline)  }
 // box {<8,764,10.1>,<1000-8,8,8.9> }    
 // flat_color(c_screen_blue_outline)
  //}
  box {<   8, 789,   8>,<1000-8,764,  5> flat_color(c_screen_title_bar)} // gray
  box {<8,764,4>,<1000-8,8,3>   flat_color(c_screen_gray_bkg) }
  screen_text("Group Launch Digitals (version 1.00)",c_screen_title_bar,0.7,<376,796,0>) 
  screen_text("File",c_screen_black,0.7,<16,814-41,0>) 
  
  // text and grid in the z=0 plane
  
  // top banner
  screen_text("LAUNCH DIGITALS",c_text,1.4,<372,814-96,0>) 
  screen_text("GMT",c_text,1,<61,814-87,0>)  
  screen_text("343:02:04:17",c_yel,1,<151,814-87,0>)
  screen_text("FLT", c_text,1,<61,814-112,0>)
  screen_text("116", c_yel,1, <104,814-112,0>)
  screen_text("VEH", c_text,1,<160,814-112,0>)
  screen_text("103", c_teal,1,<230,814-112,0>) 
  screen_text("MET", c_text,1,<794,814-87,0>)
  screen_text("10:17",c_yel,1,<862,814-87,0>)
  screen_text("MM",  c_text,1,<794,814-112,0>)
  
  
  // left side
  
  // column headings
  #local r = 814-149;
  cylinder {<8,683,0>,<1000-8,683,0> 2 flat_color(c_screen_grid)} 
  screen_text("PASS", c_text, 1, <143,r,0>)  
  screen_text("BFS" , c_text, 1, <283,r,0>)
  screen_text("GND" , c_text, 1, <410,r,0>) 
  
  // grid under pass, bfs, etc
  cylinder {<8,660,0>,<500,660,0> 1 flat_color(c_screen_grid)} 
  cylinder {<8,426,0>,<500,426,0> 1 flat_color(c_screen_grid)} 
  cylinder {<102,660,0>,<102,429,0> 1 flat_color(c_screen_grid)}
  cylinder {<235,660,0>,<235,429,0> 1 flat_color(c_screen_grid)}
  cylinder {<366,660,0>,<366,429,0> 1 flat_color(c_screen_grid)}
  
  #local r = 814-177;
  screen_text("VI", c_text, 1, <71,r,0>)
  screen_text("25698", c_yel,1, <156,r,0>) 
  #local r = 814-211;
  screen_text("ALT", c_text, 1, <55,r,0>) 
  screen_text("56.1", c_yel,1, <175,r,0>) 
  screen_text("56.4", c_yel,1, <300,r,0>) 
  screen_text("62.1", c_yel,1, <430,r,0>) 

  #local r = 814-245;
  screen_text("RANGE", c_text, 1, <20,r,0>)
  screen_text("1178.1", c_yel,1, <147,r,0>) 
  screen_text("1182.2", c_yel,1, <275,r,0>) 
  screen_text("922.3", c_yel,1, <415,r,0>) 

  #local r = 814-279;
  screen_text("ACCEL", c_text, 1, <22,r,0>)
  screen_text("0.02", c_yel,1, <170,r,0>)
  screen_text("0.02", c_yel,1, <300,r,0>)
  screen_text("-", c_yel,1, <450,r,0>)

  #local r = 814-313;
  screen_text("LAT", c_text, 1, <55,r,0>) 
  screen_text("36:22N", c_yel,1, <143,r,0>)
  screen_text("36:22N", c_yel,1, <273,r,0>)
  screen_text("35:02N", c_yel,1, <400,r,0>)  
  
  #local r = 814-347;
  screen_text("LON", c_text, 1, <54,r,0>) 
  screen_text("59:12W", c_yel,1, <143,r,0>)
  screen_text("59:07W", c_yel,1, <273,r,0>)
  screen_text("64:12W", c_yel,1, <400,r,0>)  
  
  
  #local r = 814-381;
  screen_text("DROOP", c_text, 1, <23,r,0>)
  screen_text("145.287", c_yel, 1, <130,r,0>)
  screen_text("-", c_yel, 1, <323,r,0>)
  screen_text("-", c_yel, 1, <450,r,0>)    
  
  // runway selection
  #local r = 814-410;
  screen_text("RWY SELECT", c_text, 1, <75,r,0>)
  screen_text("ABORT SELECT", c_text, 1, <305,r,0>)
  cylinder {<8,814-420,0>,<500,814-420,0> 1 flat_color(c_screen_grid)}
  #local r = 814-442;
  screen_text("PASS", c_text, 1, <35,r,0>) 
  screen_text("KSC33", c_yel, 1, <159,r,0>)
  screen_text("PASS", c_text, 1, <279,r,0>)
  #local r = 814-467;
  screen_text("GND", c_text, 1, <37,r,0>)
  screen_text("KSC33", c_yel, 1, <159,r,0>)
  screen_text("BFS", c_text, 1,  <279,r,0>)
  screen_text("GND", c_text, 1,  <279,814-489,0>)
  cylinder {<255,426,0>,<255,314,0> 1 flat_color(c_screen_grid)}
  cylinder {<8,314,0>,<500,314,0> 1 flat_color(c_screen_grid)}
  screen_text("O/B TAL AREA", c_text, 1, <67,814-528,0>) 
  cylinder {<8,274,0>,<500,274,0> 1 flat_color(c_screen_grid)}
  screen_text("CONTINGENCY REGION", c_text, 1, <149,814-563,0>) 
  cylinder {<8,240,0>,<500,240,0> 1 flat_color(c_screen_grid)}
  screen_text("3EO", c_text, 1, < 36,814-597,0>)
  screen_text("2E0", c_text, 1, <280,814-597,0>)
  cylinder {<8,207,0>,<500,207,0> 1 flat_color(c_screen_grid)}
  cylinder {<255,240,0>,<255,207,0> 1 flat_color(c_screen_grid)}
  screen_text("CONTINGENCY YAW STEER", c_text, 1, <37,814-636,0>)
  cylinder {<8,159,0>,<500,159,0> 2 flat_color(c_screen_grid)}
  
  screen_text("MECO TIME", c_text, 1, <37,814-679,0>) 
  cylinder {<8,124,0>,<500,124,0> 2 flat_color(c_screen_grid)}
  
  screen_text("ARD", c_text, 1, <37,814-712,0>)
  screen_text("GUID CONV", c_text, 1, <300,814-712,0>)
  screen_text("PASS", c_text, 1, <37,814-740,0>)
  screen_text("BS", c_text, 1, <37,814-768,0>)
  cylinder {<255,8,0>,<255,124,0> 1 flat_color(c_screen_grid)}
  
  // centerline
  cylinder {<500,683,0>,<500,8,0> 2 flat_color(c_screen_grid)}
  
  // right side
  cylinder {<500,814-163,0>,<992,814-163,0> 1 flat_color(c_screen_grid)}
  #local r=814-152;
  screen_text("SSME", c_text, 1, <525,r,0>)
  screen_text("CMD", c_text, 1, <625,r,0>)
  screen_text("L", c_text, 1, <739,r,0>)
  screen_text("C", c_text, 1, <834,r,0>)
  screen_text("R", c_text, 1, <932,r,0>)
  
  #local r=814-184;
  screen_text("ARD",c_text,1,<526,r,0>)
  screen_text("-",c_yel,1,<639,r,0>) 
  screen_text("70",c_yel,1,<734,r,0>)
  screen_text("70",c_yel,1,<834,r,0>)
  screen_text("70",c_yel,1,<934,r,0>)

  
  #local r=814-211;
  screen_text("PASS", c_text,1,<526,r,0>)
  screen_text("0.7",c_yel,1,<639,r,0>) 
  screen_text("0",c_yel,1,<744,r,0>)
  screen_text("0",c_yel,1,<844,r,0>)
  screen_text("0",c_yel,1,<944,r,0>)
                                               
  #local r=814-236;
  screen_text("BFS", c_text,1,<526,814-236,0>)
  screen_text("0.7",c_yel,1,<639,r,0>) 
  screen_text("0",c_yel,1,<744,r,0>)
  screen_text("0",c_yel,1,<844,r,0>)
  screen_text("0",c_yel,1,<944,r,0>)

  #local r=814-293;  
  screen_text("UMITS",c_text,1,<526,814-293,0>) 
  screen_text("UNA",c_yel,1,<725,r,0>)
  screen_text("UNA",c_yel,1,<825,r,0>)
  screen_text("UNA",c_yel,1,<925,r,0>)
  
  
  cylinder{<500,814-319,0>,<992,814-319,0>, 1 flat_color(c_screen_grid)}
  cylinder{<600,814-364,0>,<992,814-364,0>, 1 flat_color(c_screen_grid)}
  cylinder{<500,814-423,0>,<992,814-423,0>, 2}  
  
  cylinder{<697,814-130,0>,<694,814-423,0>,1}
  cylinder{<795,814-164,0>,<795,814-319,0>,1}
  cylinder{<891,814-164,0>,<891,814-319,0>,1}
  cylinder{<600,814-319,0>,<600,814-423,0>,1}
  screen_text("VIEO",c_text,1,<529,814-379>)
  #local r=814-354;
  screen_text("LEO",c_text,1,<725,r,0>) 
  screen_text("CEO",c_text,1,<825,r,0>)
  screen_text("REO",c_text,1,<925,r,0>)

  #local r=814-386;
  screen_text("PASS",c_text,1,<622,r,0>)
  screen_text("08:21",c_text,1,<725,r,0>) 
  screen_text("08:21",c_text,1,<825,r,0>)
  screen_text("08:21",c_text,1,<925,r,0>)

  #local r=814-410;  
  screen_text("BFS",c_text,1,<628,r,0>)
  screen_text("08:22",c_text,1,<725,r,0>) 
  screen_text("08:22",c_text,1,<825,r,0>)
  screen_text("08:22",c_text,1,<925,r,0>)


  #local r=814-443;  
  screen_text("OMS PC",c_text,1,<504,r,0>)
  screen_text("L",c_text,1,<678,r,0>)
  screen_text("R",c_text,1,<797,r,0>)
  screen_text("ICNCT",c_text,1,<900,r,0>)
  
  cylinder {<500,814-447,0>,<992,814-447,0>,1} 
  cylinder {<623,814-447,0>,<623,814-613,0>,1}
  cylinder {<745,814-447,0>,<745,814-613,0>,1}
  cylinder {<867,814-447,0>,<867,814-613,0>,1} 
  #local r=814-469;
  screen_text("PASS",c_text,1,<562,r,0>) 
  screen_text("-OS",c_teal,1,<703,r,0>) 
  screen_text("-OS",c_teal,1,<825,r,0>) 
  screen_text("IVH",c_teal,1,<925,r,0>)
  
  #local r=814-494;
  screen_text("BFS",c_text,1,<575,r,0>)
  screen_text("-OS",c_teal,1,<703,r,0>) 
  screen_text("-OS",c_teal,1,<825,r,0>) 
  screen_text("IVH",c_teal,1,<925,r,0>)

  cylinder {<500,814-613,0>,<992,814-613,0>,2} 
  #local r=814-639;
  screen_text("APU",c_text,1,<575,r,0>)
  screen_text("%",c_text,1,<737,r,0>)
  screen_text("PRESS",c_text,1,<827,r,0>)
  #local r=814-663;
  screen_text("1",c_text,1,<670,r,0>)
  screen_text("106",c_teal,1,<755,r,0>) 
  screen_text("1120",c_teal,1,<857,r,0>)
  #local r=814-687;
  screen_text("2",c_text,1,<670,r,0>) 
  screen_text("105",c_teal,1,<755,r,0>) 
  screen_text("1064",c_teal,1,<857,r,0>)
  #local r=814-709;
  screen_text("3",c_text,1,<670,r,0>) 
  screen_text("108",c_teal,1,<755,r,0>) 
  screen_text("1014",c_teal,1,<857,r,0>) 
  cylinder {<573,169,0>,<915,169,0> 1}
  cylinder {<573,98,0>,<915,98,0> 1} 
  
  cylinder {<573,98,0>,<573,169,0> 1}
  cylinder {<689,98,0>,<689,169,0> 1}
  cylinder {<802,98,0>,<802,169,0> 1}
  cylinder {<917,98,0>,<917,169,0> 1}
  
  cylinder {<500,814-731,0>,<992,814-731,0>,2}
  
  screen_text("CABIN PRESS", c_text,1,<630,814-758,0>)
  screen_text("DP/DT"      , c_text,1,<630,814-784,0>)
  screen_text("14.85"      , c_teal,1,<794,814-758,0>)
  screen_text("0.005"      , c_teal,1,<794,814-784,0>)
  
                                          
  
  flat_color(c_screen_grid)
};                            

///////////////////////////////////////////////////////////////////////////////////////////////////
#declare c_bkg = <0.467,0.616,0.808>;
#declare mcc_ascent_ground_track = 
union {
//  difference {
    box {<   0,   0,   10>,<1000,  814,  9> flat_color(c_bkg)  }
//    box {<8,q-21,8.9>,<1000-8,8,10.1>}
//    flat_color(c_bkg)  
//  }
  box {<8,q-21,4>,<1000-8,8,3>   flat_color(c_screen_gray_bkg) } 
  screen_text("ASCENT GROUNDTRACK (version 1.1)"      , c_white,0.8,<375,q-18,0>) 
  
  screen_text("GMT   343:02:04:17", c_white, 0.5, <10,q-38,0>) 
  box {<164,q-41,0>, <833,q-27,0> flat_color(c_teal)}
  cylinder {<8,q-50,0>,<1000-8,q-50,0> 1 flat_color(c_teal)} 
  
  // map box
  cylinder {<80,q-95,0> <930,q-95,0>, 2 flat_color(c_teal)} // top
  cylinder {<80,q-700,0> <930,q-700,0>, 2 flat_color(c_teal)} // bot
  cylinder {<80,q-95,0>  <80,q-700,0>, 2 flat_color(c_teal)} // left  
  cylinder {<930,q-95,0>  <930,q-700,0>, 2 flat_color(c_teal)} // rt  
  
  // latitude lines are 45 px apart  (every 10 degrees)
  #local i=0;
  #while (i<14)
    cylinder {<80,q-700+i*45,0>,<930,q-700+i*45,0> 0.5 flat_color(c_teal)}
    screen_text (str(i*10-80,0,0), c_white, 0.5, <55,q-700+i*45,0>)
    #local i=i+1;
  #end 
  
  // longitude lines are 53 px apart (every 10 degrees) 180-20
  #local i=0; // counter
  #local j=80; // x spacing 
  #local k=180; // decree  
  #while (i<17)
    cylinder {<0,q-700,0>,<0,q-95,0> 0.7 translate <j,0,0> flat_color(c_teal)}
    screen_text(str(k,0,0) c_white, 0.5, <j-10,q-715,0>) 
    #local i=i+1;
    #local j=j+53;
    #local k=k-10;
  #end 
  
  #local a = 5; // thickness of the outline
  
  
union {
  
  sphere_sweep { // the Americas 
    linear_spline                 // linear curve
    135,                            // number of specified sphere positions
    <355, 96, 0>, a                // position, radius
    <359,109, 0>, a                // ...
    <381,115, 0>, a
    <371,123, 0>, a 
    <380,137, 0>, a   
    <375,151, 0>, a 
    <383,162, 0>, a   
    <390,165, 0>, a 
    <399,178, 0>, a   
    <412,186, 0>, a 
    <426,190, 0>, a   
    <420,198, 0>, a 
    <425,206, 0>, a   
    <431,215, 0>, a 
    <438,218, 0>, a   
    <451,231, 0>, a 
    <444,216, 0>, a   
    <431,206, 0>, a 
    <429,197, 0>, a   
    <435,195, 0>, a  //20
    <473,230, 0>, a  
    <476,243, 0>, a 
    <487,253, 0>, a  
    <496,253, 0>, a 
    <505,259, 0>, a  
    <526,263, 0>, a 
    <539,262, 0>, a  
    <553,271, 0>, a 
    <570,274, 0>, a  
    <578,281, 0>, a  //30
    <584,290, 0>, a  
    <606,299, 0>, a 
    <617,293, 0>, a
    <624,298, 0>, a 
    <626,315, 0>, a
    <614,329, 0>, a 
    <611,346, 0>, a
    <603,354, 0>, a 
    <619,374, 0>, a
    <633,401, 0>, a 
    <650,406, 0>, a
    <660,415, 0>, a 
    <662,449, 0>, a
    <655,470, 0>, a      
    <655,485, 0>, a
    <646,502, 0>, a 
    <648,522, 0>, a
    <643,541, 0>, a 
    <636,542, 0>, a
    <649,571, 0>, a  //50
    <658,576, 0>, a
    <665,580, 0>, a 
    <687,580, 0>, a
    <666,571, 0>, a 
    <670,560, 0>, a
    <687,548, 0>, a
    <681,536, 0>, a
    <695,526, 0>, a
    <706,509, 0>, a
    <726,507, 0>, a
    <725,486, 0>, a
    <749,489, 0>, a
    <778,480, 0>, a
    <779,446, 0>, a
    <794,440, 0>, a
    <801,436, 0>, a
    <813,436, 0>, a
    <829,411, 0>, a
    <828,393, 0>, a
    <847,375, 0>, a   //70
    <850,360, 0>, a
    <834,352, 0>, a  
    <822,347, 0>, a
    <800,345, 0>, a  
    <793,339, 0>, a
    <777,337, 0>, a  
    <772,343, 0>, a
    <760,339, 0>, a  
    <769,329, 0>, a
    <763,315, 0>, a  
    <747,307, 0>, a
    <731,306, 0>, a  
    <718,296, 0>, a
    <708,287, 0>, a  
    <688,288, 0>, a
    <663,283, 0>, a  
    <657,291, 0>, a
    <647,283, 0>, a  
    <634,286, 0>, a
    <626,295, 0>, a   //90
    <619,290, 0>, a
    <606,293, 0>, a  
    <592,285, 0>, a
    <593,268, 0>, a  
    <585,262, 0>, a
    <567,262, 0>, a  
    <567,250, 0>, a
    <573,238, 0>, a  
    <559,239, 0>, a
    <551,249, 0>, a  
    <532,250, 0>, a
    <515,232, 0>, a  
    <519,220, 0>, a
    <519,207, 0>, a  
    <534,200, 0>, a
    <549,200, 0>, a  
    <559,204, 0>, a
    <563,197, 0>, a  
    <590,203, 0>, a
    <603,220, 0>, a   //110  // florida
    <610,222, 0>, a
    <613,214, 0>, a  
    <603,194, 0>, a
    <618,182, 0>, a  
    <632,178, 0>, a
    <632,178, 0>, a  
    <639,159, 0>, a
    <638,143, 0>, a  
    <650,140, 0>, a  
    <663,150, 0>, a
    <665,138, 0>, a  
    <674,131, 0>, a
    <693,129, 0>, a  
    <699,134, 0>, a
    <703,136, 0>, a  
    <692,121, 0>, a
    <685,113, 0>, a  
    <662,118, 0>, a
    <708,116, 0>, a  
    <729,117, 0>, a
    <746,114, 0>, a  
    <755,120, 0>, a
    <724,108, 0>, a  
    <737,103, 0>, a
    <738, 96, 0>, a    //135
  } 
  
  
  sphere_sweep {  // Hudson's Bay 
    linear_spline                 // linear curve
    4,                            // number of specified sphere positions
    <600, 96, 0>, a                // position, radius
    <608,106, 0>, a
    <617,105, 0>, a
    <617,96, 0>, a
    }


  sphere_sweep {  // Cuba
    linear_spline                 // linear curve
    9,                            // number of specified sphere positions
    <589,223, 0>, a                // position, radius
    <611,231, 0>, a
    <623,238, 0>, a
    <693,243, 0>, a
    <686,253, 0>, a                
    <643,253, 0>, a
    <620,242, 0>, a
    <593,237, 0>, a
    <589,223, 0>, a
    }
  
  sphere_sweep {  // ET Splashdown?
    linear_spline                 // linear curve
    7,                            // number of specified sphere positions
    <80,392, 0>, a                // position, radius
    <236,308, 0>, a
    <298,325, 0>, a
    <309,383, 0>, a
    <219,462, 0>, a                
    <121,517, 0>, a
    < 80,471, 0>, a 
    flat_color(c_green)
    }
    
  sphere_sweep {  // Shuttle Trajectory
    linear_spline                 // linear curve
    3,                            // number of specified sphere positions
    <605,206,0>, a
    <665,183,0>, a
    <695,175,0>, a
    flat_color(c_red)
    } 
    
  sphere_sweep {  // Future Shuttle Trajectory
    linear_spline                 // linear curve
    3,                            // number of specified sphere positions
    <695,175,0>, a/2
    <737,167,0>, a/2
    <802,160,0>, a/2
    flat_color(c_teal)
    }
    
    
    
    
    translate z*2 
   // translate -y*1000
    rotate x*180 
    translate y*815
   // scale y*-1  
    flat_color(c_blue)  

  } 
  union { 
    screen_text("EDW *" c_white, 0.5, <370,q-179,0>)
    screen_text("NICK *" c_white, 0.5, <372,q-185,0>)
    screen_text("HNL *" c_white, 0.5, <168,q-244,0>)
    screen_text("NOR *" c_white, 0.5, <441,q-190,0>) 
    screen_text("DYS *" c_white, 0.5, <480,q-191,0>)
    screen_text("SUN *" c_white, 0.5, <491,q-163,0>) 
    screen_text("MNT *" c_white, 0.5, <495,q-153,0>)
    screen_text("ORL *" c_white, 0.5, <580,q-209,0>) 
    screen_text("NYC *" c_white, 0.5, <607,q-157,0>)
    screen_text("AWG *" c_white, 0.5, <629,q-571,0>)
    screen_text("MAO *" c_white, 0.5, <250,q-420,0>)
    screen_text("BOA *" c_white, 0.5, <660,q-193,0>)

  //  translate z*6 
  
    }
}; 

#declare mcc_altitude_chart = 
#local s = 0.75; // text size
union { 
 // difference {
    box {<   0,   0,   10>,<1000,  814,  9> flat_color(c_bkg)  } 
//   box {<8,q-28,8.9>,<1000-8,8,10.1>}
//    flat_color(c_bkg)  
//    } 
  box {<8,q-28,4>,<1000-8,8,3>   flat_color(c_screen_gray_bkg) } 
  screen_text("Alt vs. Many Things (version 4.2)"      , c_white,s,<375,q-21,0>) 
  box {<8,q-28,4>,<1000-8,q-50,2>   flat_color(c_teal) }
  screen_text("File    Navigation    Colors", c_screen_black,s, <13,q-43,0>)
  
  // vert axis
  cylinder {<76,q-100,0>,<76,q-750,0> 1  flat_color(c_teal)}
  #local i=0; // counter
  #local j=q-750; // spacing 650/9 = 106px per increment
  #local k=0; // label
  #while (i<7)
    screen_text(str(k,0,0),c_teal, s, <45,j,0>)
    #local i=i+1;
    #local j=j+106;
    #local k=k+20;
  #end

  cylinder {<76,q-750,0>,<930,q-750,0> 1 flat_color(c_teal)} 
  #local i=0; // counter
  #local j=76; // spacing 750/5 = 150px per increment
  #local k=0; // label // increment +=100
  #while (i<6)
    screen_text(str(k,0,0),c_teal, s, <j,q-770,0>)
    #local i=i+1;
    #local j=j+150;
    #local k=k+200;
  #end

  // tracks
  
  sphere_sweep {  // Red track 
    linear_spline                 // linear curve
    4,                            // number of specified sphere positions
    <80, q-528, 0>, a                // position, radius
    <605,q-533, 0>, a
    <683,q-520, 0>, a
    <716,q-510, 0>, a 
    flat_color(c_red)
    translate -z*5
    } 
    
  sphere_sweep {  // Red track 
    linear_spline                 // linear curve
    6,                            // number of specified sphere positions
    <80, q-520, 0>, a                // position, radius
    <140,q-519, 0>, a
    <444,q-531, 0>, a
    <538,q-535, 0>, a 
    <650,q-530, 0>, a    
    <756,q-526, 0>, a
    flat_color(c_blue)
    translate -z*5
    } 
    
  sphere_sweep {  // Yellow track 
    cubic_spline                 // linear curve
    5,                            // number of specified sphere positions
    <80, q-627, 0>, a                // position, radius
    <80, q-627, 0>, a
    <315,q-339, 0>, a
    <472,q-97, 0>, a
    <472,q-97, 0>, a 
    texture {t_yel_dashed}
    translate -z*5
    } 
  
    screen_text("VEH 103",c_blue, s, <380,q-290,0>)

};         


#declare mcc_specs_and_ofs = 
union {
  // specs window
 // box {<   0,   0,      99>,<1000, q    , 98> flat_color(c_screen_gray_bkg)}
  box {<   8,   q-16,   10>,<910,  q-484,  9> flat_color(c_navy)  } // blue bkg  
  screen_text("SSP115                   SPECS                   V1.06"      , c_white,0.8,<375,q-34,0>) 
  box {<17,q-43,8>,     <898,q-137,7> flat_color(c_white)  }
  box {<20,q-46,6>,     <895,q-134,5> flat_color(c_screen_gray_bkg)  } 
  screen_textc("1  GNC 2011:",        c_white,1, <30,q-67,0>)
  screen_textc("2  GNC 2011: RESUME", c_white,1, <30,q-89,0>)
  screen_textc("3         0:",        c_white,1, <30,q-111,0>)
  screen_textc("4   SM 2011:",        c_white,1, <30,q-133,0>)
  screen_textc("S",        c_teal,1, <737,q-67,0>)  
  
  box {<17,q-147,8>,     <898,q-473,7> flat_color(c_white)  }
  box {<20,q-150,6>,     <895,q-470,5> flat_color(c_navy)  }
  
  screen_textc("194/23:04:32    2  GNC  2011 RESUME",           c_white,1, <30,q-175,0>)
  screen_textc("194/23:04:29    2  GNC   210 SPEC 21 PRO",      c_white,1, <30,q-200,0>)
  screen_textc("194/23:04:23    2  GNC   220 ITEM (04) EXEC",   c_white,1, <30,q-225,0>)
  screen_textc("194/23:04:18    2  GNC   220 ITEM (03) EXEC",   c_white,1, <30,q-250,0>)
  screen_textc("194/23:04:10    2  GNC   220 SPEC 22 PRO",      c_white,1, <30,q-275,0>)
  screen_textc("194/23:04:09    2  GNC  2011 RESUME",           c_white,1, <30,q-300,0>)
  screen_textc("194/23:04:01    2  GNC    60 SPEC 6 PRO",       c_white,1, <30,q-325,0>)
  screen_textc("194/23:03:33    2  GNC  8011 OPS 201 PRO",      c_white,1, <30,q-350,0>)
  screen_textc("194/23:03:27    2  GNC     1 RESUME",           c_white,1, <30,q-375,0>)
  screen_textc("194/23:03:13    2  GNC     1 ITEM (01)+2 EXEC", c_white,1, <30,q-400,0>)
  screen_textc("194/23:02:31    2  GNC  2011 OPS 801 PRO",      c_white,1, <30,q-425,0>)
  screen_textc("194/23:01:32    2  GNC  2011 RESUME",           c_white,1, <30,q-450,0>)
  
  // Faults window 
  
  // title bar
  box {<19,q-508,8>,     <810,q-748,7> flat_color(c_blue)  } 
  screen_text("SSP115          Onboard Fault Summary v1.07", c_white, 1 <217,q-527,0>)
  box {<22,q-535,6>,     <807,q-745,5> flat_color(c_navy)  } 
  screen_textc("PASS Faults (GNC Auto)       GPC  Time (GMT)", c_yel, 1, <73,q-557,0>) 
  cylinder {<22,q-565,0>,<807,q-565,0>, 1 flat_color(c_white)} 
  screen_textc("345     I/O ERROR   CRT1  1     343/02:04:12.43", c_white, 1, <85,q-585,0>) 
  screen_textc("344     BCE STRG 1  STKR  1     343/02:03:50.04", c_white, 1, <85,q-607,0>)
  screen_textc("343     BCE STRG 1  STKR  1     343/02:03:44.74", c_white, 1, <85,q-629,0>)
  screen_textc("342 S68 H2 MANF     VLV      4  343/02:03:39.95", c_white, 1, <85,q-651,0>)
  screen_textc("341 INVALID   389   641      4  343/02:02:16.43", c_white, 1, <85,q-695,0>)
  screen_textc("340 S66             FAN      4  343/02:02:10.65", c_white, 1, <85,q-717,0>)
  screen_textc("339 S66             FAN      4  342/02:01:38.02", c_white, 1, <85,q-739,0>)
};                                              

// intercom button box  
#macro ibb_no_detail(x1,y1,x2,y2)
   #local w = 8; // width of box lines 
   
  // draw the outline of a box
  union {
    box {<x1  ,q-y1,  5>,<x2  ,q-y2,  6>  }
    box {<x1+w,q-(y1+w),3>,<x2-w,q-(y2-w),4> texture {t_button_black}  } // block out inside of button
    texture {t_button_yellow} interior {i_button_yellow} 
    hollow
    }
#end
     

#macro ibb (x1,y1,x2,y2)
   #local w = 10; // width of box lines 
   
  // draw the outline of a box
  union {
    box {<x1  ,q-y1,  5>,<x2  ,q-y2,  6>  }
    box {<x1+w,q-(y1+w),3>,<x2-w,q-(y2-w),4> texture {t_button_black}  } // block out inside of button
    
   #local detail = rand(i_seed);
    #if (detail <0.5)       
      box{<x1+30,q-(y1+w),0>,<x2-w,q-(y1+w+20),1> }
    #end 
    #if (detail <0.93)
      box {<x1+40,q-((y1+y2)/2+5), 0>, <x2-20,q-((y1+y2)/2-5), 1> }
    #end 
    texture {t_button_yellow} interior {i_button_yellow} 
    hollow
    }
#end

#declare intercom_buttons = 
union { 
  // button width is 191
  box {<   0,   0,   10>,<1000,  814,  9> texture {t_button_black}  }
  ibb_no_detail(76,22,961,91) // top one
  
  //grid at left
  #local bw = 195; // button width 
  #local bh = 87;  // button hight
  #local bx = 5;   // x spacing btwn buttons (in grid)
  #local sx = 76;  // start here (x)
  #local sy = 97;  // start here (y)
  #local i=0;
  #while (i<3) 
    #local j=0;
    #while (j<8)
      ibb(sx+i*(bw)+bx,sy+j*(bh),(sx+bw)+(i*bw),(sy+bh)+(j*bh))
      #local j=j+1;
    #end
    #local i=i+1;
  #end
  
  // right top
  #local i=0;
  #while (i<6)
    object {ibb(676,97,961,169) translate -y*72*i}
    #local i=i+1;
  #end 
  
  // bot right corner 
  #local i=0;
  #while (i<3)
    ibb(676,539+(i*85),816,623+(i*85))
    ibb(820,539+(i*85),961,623+(i*85))
    #local i=i+1;
  #end  
   
}; 

// computer screen 1 ////////////////////////////////////////////////////////////////////////////////////////
#declare t_xterm1 =
texture {
  pigment {
    bozo 
    color_map {
      [0.6 rgb <0.522,0.78,1.0>]
      [0.6 rgb 0.85]
    }
    scale 10*<500,1,1>
  }
};

// x1,y1 upper left corner; x2,y2 lower right corner, z1 z position; col1 - window frame; col2 inside window 
/*
#macro window (x1,y1,x2,y2,z1,col1,col2)
  box {<x1,1000-y1,z1>,<x2,1000-y2,z1-1> pigment {rgb col1} }
  box {<x1+10,1000-y1-30,z1>,<x2-10,1000-y2+10,z1-2> pigment {rgb col2}}
#end 
*/ 

#macro xterm (x1,y1,x2,y2,z1,col1,col2) // standard white text on blue bkg
  box {<x1,1000-y1,z1>,<x2,1000-y2,z1-1> pigment {rgb col1} }
  //box {<x1+5,1000-y1-30,z1>,<x2-5,1000-y2+5,z1-2> pigment {rgb col2}}
  box {<x1+5,1000-y1-30,z1>,<x2-5,1000-y2+5,z1-2> texture {t_xterm1}}
  box {<x1+5,1000-y1-30,z1-2>,<x2-5,1000-y1-50,z1-3> pigment {rgb c_win_gray}}
  box {<x1+5,1000-y1-5,z1-2>,<x1+20,1000-y1-25,z1-3> pigment {rgb c_win_gray}}
  box {<x2-5,1000-y1-5,z1-2>,<x2-20,1000-y1-25,z1-3> pigment {rgb c_win_gray}}
#end 


// 200x350
#macro rand_num_column (pos)
  union {
    
    box {<0,0,0>,<200,350,-1> pigment {rgb <0.58,0.631,0.765>} }
    box {<5,5,-2>,<195,345,-4> pigment {rgb 0}} 
    box {<0,240,-5>,<200,245,-6> pigment {rgb <0.58,0.631,0.765>} } 
    box {<0,300,-5>,<200,305,-6> pigment {rgb <0.58,0.631,0.765>} }

    #local i=0;
    #while (i<12)
      union {
        text {ttf "courbd.ttf",str(rand(wsd)*9999, 9, 2)  ,1,0 scale 15*<1,1,1> pigment {rgb <0.749,0.925,0.996>} translate <10,10,-5> } 
        text {ttf "courbd.ttf","/"  ,1,0 scale 15*<1,1,1> pigment {rgb <0.949,0.925,0.5>} translate <100,10,-5> } 
        text {ttf "courbd.ttf",str(rand(wsd)*9999, 9, 2)  ,1,0 scale 15*<1,1,1> pigment {rgb <0.749,0.925,0.996>} translate <110,10,-5> } 
        translate y*i*20
      }
      #local i=i+1;
    #end 
    #local i=0;
    #while (i<2)
      union {
        text {ttf "courbd.ttf",str(rand(wsd)*9999, 9, 2)  ,1,0 scale 15*<1,1,1> pigment {rgb <0.949,0.925,0.5>} translate <10,260,-5> } 
        text {ttf "courbd.ttf","/"  ,1,0 scale 15*<1,1,1>                       pigment {rgb <0.949,0.925,0.5>} translate <100,260,-5> }      
        text {ttf "courbd.ttf",str(rand(wsd)*9999, 9, 2)  ,1,0 scale 15*<1,1,1> pigment {rgb <0.949,0.025,0.5>} translate <110,260,-5> } 
        translate y*i*20
      }
      #local i=i+1;
    #end 

    text {ttf "courbd.ttf","/  /  /  /  /  /  /"  ,1,0 scale 15*<1,1,1>  pigment {rgb <0.949,0.925,0.5>} translate <10,320,-5> }      
    
    translate pos
  }  
#end

#declare wsd = seed(clock);
#macro rand_window()

  #declare max_window_style = 10; // bias to xterms
 
  #local style = int(rand(wsd)*max_window_style);
 // override
 // #local style = 7;
union {  
  #switch (style)
    #case (0) // 200x600 graph 
      #local minpos = <0,0,0>;
      #local maxpos = <800,400,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
      #debug concat("Rand z is:",str(pos.z,5,0),"\n")

      union {
        box {<0,590,0>,<200,600,-1> pigment {rgb <0,0.2,0.7>}}
        box {<0,0,0>,<200,590,-1> pigment {rgb 1}}
        box {<5,5,-2>,<195,590,-3> pigment {rgb 0}}
        
        #local i=0;
        #while (i<15)
          box {<20,0,0>,<30+rand(a)*150,10,-1> pigment {rgb <0,0.8,0>} translate <0,10+i*40,-5>}
          #local i=i+1;    
        #end
        translate pos
        }
    #break
    #case (1) 
      #local minpos = <-100,0,0>;
      #local maxpos = <400,200,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
       box {<0,0,0>,<1,1,0> pigment {image_map{png "mcc_img12.png"}}  scale <600,800,1> translate pos}
    #break
    #case (2)
      #local minpos = <-100,0,0>;
      #local maxpos = <400,200,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
       box {<0,0,0>,<1,1,0> pigment {image_map{png "mcc_img13.png"}}  scale <600,800,1> translate pos}
    #break
    #case (3)
      #local minpos = <-100,0,0>;
      #local maxpos = <400,200,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
       box {<0,0,0>,<1,1,0> pigment {image_map{png "mcc_img14.png"}}  scale <600,800,1> translate pos}
    #break
    #case (4)
      #local minpos = <-100,0,0>;
      #local maxpos = <400,200,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
       box {<0,0,0>,<1,1,0> pigment {image_map{png "mcc_img15.png"}}  scale <600,800,1> translate pos} 
      #break
    #case (5)
      #local minpos = <-100,0,0>;
      #local maxpos = <900,700,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
      union {
        box {<0,0,0>,<500,300,-1> pigment {rgb <0.3,0.4,0.9>}}
        box {<10,10,-2>,<490,290,-3> pigment {rgb <0.2,0.2,0.6>}}
        #local i=0;
        #while (i<25)
          union {
            cylinder {<20,20,-3>, <50,20,-3> 3  } 
            cylinder {<60,20,-3>, <80,20,-3> 3  }
            cylinder {<90,20,-3>, <110+rand(wsd)*20,20,-3> 3  } 
            cylinder {<140,20,-3>, <180,20,-3> 3  } 
            cylinder {<190,20,-3>, <250+rand(wsd)*60,20,-3> 3  }
            cylinder {<320,20,-3>, <360,20,-3> 3  } 
            
            translate y*10*i
            pigment {rgb 1} 
            }
          #local i=i+1;
        #end
        translate pos
        }  
    #break
    #case (6) 
      #local minpos = <-100,0,0>;
      #local maxpos = <800,700,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
      union {    
        box {<0,0,0>,<400,300,-1> pigment {rgb <0.69,0.929,1.0>}}
        box {<10,10,-2>,<390,280,-3> pigment {rgb <0.0,0.353,0.863>}}
        #local i=0;
        union {
          #while (i<3) 
            cylinder {< 40,100,0>,< 70,100,0> 8 translate y*40*i pigment {rgb 1} } 
            cylinder {<100,100,0>,<180,100,0> 15 translate y*40*i} 
            cylinder {<200,100,0>,<280,100,0> 15 translate y*40*i} 
            cylinder {<300,100,0>,<380,100,0> 15 translate y*40*i} 
            
            #local i=i+1;
          #end
          cylinder {<300,60,0>,<380,60,0> 15 }  
          scale <1,1,0.5>
          pigment {rgb <0.431,0.667,0.922>}
        
        }
        
        cylinder {<130,210,0>,<150,210,0> 5 pigment {rgb 1} }
        cylinder {<230,210,0>,<250,210,0> 5 pigment {rgb 1} }
        cylinder {<330,210,0>,<350,210,0> 5 pigment {rgb 1} }
         
        translate pos
        }
    #break 
    #case (7)
      #local minpos = <0,0,0>;
      #local maxpos = <800,700,0>;
      #local pos = <RRand(minpos.x,maxpos.x,wsd),RRand(minpos.y,maxpos.y,wsd),0>; 
      
      #local nx = RRand(1,4,wsd);
      #local ny = RRand(1,3,wsd);
      union {
        #local i=0;
        #while (i<nx)
          #local j=0;
          #while (j<ny)        
            rand_num_column(pos+<i*200,j*350,0>)
            #local j=j+1;
          #end
        #local i=i+1;
        #end
      }
            
    #break
    #else 
        #local xt1 = RRand(-100,800,a);
        #local xt2 = RRand(0,1000,a);
        xterm(xt1,xt2,xt1+350,xt2+200, -5-3*i,c_win_blue,c_lt_blue)
    #end

  translate -z*(10*window_number)
  #declare window_number = window_number +1; 
}  
#end


#macro rand_computer_screen_wallpaper() 
  #declare max_computer_wallpapers = 15;
  #local wp = int(rand(wsd)*max_computer_wallpapers);
  
  #switch(wp)
    #case (0)
      #local p = pigment {rgb 0.1}; 
    #break
    #case(1)
      #local p =  pigment {gradient y color_map{[0 rgb 0][0.3 rgb <0,0,0.5>][0.7 rgb <0,0,0.5>][1.0 rgb 0]}scale 1000 rotate z*45};
    #break
    #case(2)
      #local p =  pigment {gradient y color_map{[0 rgb 0][0.3 rgb <0.2,0,0>][0.7 rgb <0.2,0,0>][1.0 rgb 0]}scale 1000 rotate z*45};
    #break
    #case(3)
      #local p =  pigment {image_map {png "mcc_img04.png"} scale <1000,1000,1>};
    #break
    #case(4)
      #local p =  pigment {image_map {png "mcc_img06.png"} scale <1000,1000,1>};
    #break
    #case(5)
      #local p =  pigment {image_map {png "mcc_img11.png"} scale <1000,1000,1>};
    #break
    #case(6)
      #local p =  pigment {image_map {png "mcc_img17.png"} scale <1000,1000,1>};
    #break
      
      
    #else
    
      #local p = pigment {rgb <0.125,0.624,0.733>};      
  #end 
  
  box {<0,0,3>, <1000,1000, 4> pigment {rgb 0} } // give transparent image_maps a bkg 
  box {<0,0,2>, <1000,1000, 1> pigment {p} }

#end

#macro rand_computer_screen()
  union {
    #declare window_number = 0; // reset
    light_source {0*x rgb 1 translate <500,814/2,-100> parallel point_at <500,814/2,0> shadowless}   
    rand_computer_screen_wallpaper() 
    #local i=0; 
    #local num_windows = RRand(3,10,wsd);
    #while (i<num_windows)
      rand_window()
      #local i=i+1;
    #end 
    
  box {<0,0,-98>,<1000,20,-99> pigment {rgb 0.7} }  
  } 
#end
#declare screen2 =
union {
 // box {<0,0,2>, <1000,1000, 1> texture { pigment { image_map{jpeg "flight05"} }finish {ambient rgb 1} scale 1000}  } 
  //  window (0,0,1000,1000,0,c_win_blue,c_screen_black)
   xterm(50,50,400,250,-2,c_win_blue,c_lt_blue)
   xterm(50,250,400,500,-5,c_win_blue,c_lt_blue)
   xterm(50,500,400,750,-5,c_win_blue,c_lt_blue) 
   
  #local i=0; 
  #local xterm_seed = seed(8383);
 
  #while (i<10) 
    #local xt1 = RRand(0,800,xterm_seed);
    #local xt2 = RRand(0,800,xterm_seed);
  
    xterm(xt1,xt2,xt1+350,xt2+200, -5-i,c_win_blue,c_lt_blue)
    #local i=i+1;
  #end
 
 //bottom window
 union {
   //xterm(610,650,1000,1000,5,c_win_blue,c_lt_blue)
    
    #local i=0;
    #while (i<4)
      box {<625,m-705,0>,<675,m-750,1> pigment {rgb 0} translate -y*55*i}
      #local j=0;
        #while (j<3)
        box {<685,m-705,0>,<735,m-725,1> pigment {rgb 0} translate <60*j,-55*i,0>}
        #local j=j+1;
      #end
      #local i=i+1;
    #end 
    #local i=0;
    translate -z*10
  }
 
};

#declare earthrise_print = ///////////////////////////////////////////////////////////////////////////////////////////////////
union { 
 // box {<0,0,2>, <1000,1000, 1> texture { pigment { image_map{jpeg "print_earthrise.jpg"} }finish {ambient rgb 1} scale 1000}  } 
  box {<0,0,2>, <1000,1000, 1> pigment {rgb 0} scale 1000} // space
  #declare t_planet_gnd =
  texture {
    pigment {
      bozo
      color_map {
        [0.75  rgb <0.163,0.327,0.567>]
        [0.75  rgb <0.714,0.604,0.522>]
      }
    }
    scale 50
  };
  #declare t_planet_clouds = 
  texture {
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>*2
                   color rgb <0.75, 0.75, 0.75>*2]
          [0.1 0.7 color rgb <0.75, 0.75, 0.75>*2
                   color rgbt <1, 1, 1, 1>]
          [0.7 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>*100
    } 
    finish {ambient rgb 0 diffuse 0.4}
  }; 
  
  // moon
  #declare t_moon =
  texture {
    pigment {
      bozo
      color_map {
        [0 rgb 0.8*2]
        [1 rgb 0.65*2]
        }
      }
      scale 200
    }; 
    
    
       
  // earth (use light_group excluding global lights to get shaded sphere)
  light_group {     
    light_source {0*x rgb 2 translate <500,3000,-1000>}
    sphere {0 1 scale 100*<2,1,1> translate <500,770,0> texture {t_planet_gnd} texture {t_planet_clouds} }
    }
    
    light_group {
     // light_source {cp rgb 1 translate y*0}
      isosurface {
        //function { y } 
        //function { y + f_noise3d(x,0, z) } 
        function { y +f_noise3d(x * 20, y * 0.05, z * 10) * 0.08}  
        open
        max_gradient 2.0  
        contained_by { box { -1, 1 } }
        
        scale <3.8,0.5,10>*-1000 
        texture {t_moon} 
        finish {ambient rgb 0.2}
        normal {dents scale 20}
        rotate x*15
        translate <0,120,0> 
        
        
        }
        global_lights
      } 
    
};


#declare chile_flag = 
union {
  box{<0,0,0>,<1000,c,1> pigment {rgb <1,0,0>}}
  box{<0,c,0>,<330,1000,1> pigment {rgb <0,0,1>}}
  box{<330,c,0>,<1000,1000,1> pigment {rgb 2}}
  object {usa_star scale 5 translate <165,750,2> pigment {rgb 2}}

};

#declare flight_rules_text = 
union {
 // box {<0,0,3>, <1000,1000, 4> texture { pigment { image_map{gif "paper2.gif"} }finish {ambient rgb 1} scale 1000}  } 

  text {ttf "arial.ttf","NASA - JOHNSON SPACE CENTER",2,0 scale 15*<1.4,1,1>  translate <340,940,0> } 
  text {ttf "arial.ttf","FLIGHT RULES",2,0 scale 20*<1.4,1,1>  translate <405,902,0> }
  cylinder {<115,1000-105,0>,<885,1000-105,0> 1} 
  text {ttf "courbd.ttf","A4-59",2,0 scale 18 translate <115,853,0>}
  text {ttf "courbd.ttf","MANUAL THROTTLE SELECTION   (CONTINUED)",2,0 scale 18 translate <293,853,0>} 
  cylinder {<293,849,0>,<710,849,0> 1} 
  
  text {ttf "courbd.ttf", "E.   THROTTLE COMMAND NOT DECREASED TO MAINTAIN 3-g ACCELERATION",2,0 scale 20 translate <115,820,0>} 
  text {ttf "courbi.ttf","The 3-g acceleration-limiting logic is provided to assure that vehicle loads do not exceed design constraints.",2,0 scale 18*<0.65,1,1> translate <115,788,0>} 
  text {ttf "courbi.ttf","Therefore, manual throttle will be invoked to protect this limit if the flight software fails to do so.  Reference",2,0 scale 18*<0.65,1,1> translate <115,772,0>} 
  text {ttf "courbi.ttf","the rationale for Rule (A4-58C), AUTO GUIDANCE NO-GO, for further background.",2,0 scale 18*<0.65,1,1> translate <115,755,0>} 

  text {ttf "courbd.ttf", "F.   ANY TIME CSS IS SELECTED.",2,0 scale 20 translate <115,727,0>} 
  text {ttf "courbi.ttf","As a conservative guideline, any time the AUTO guidance is unacceptable for vehicle attitude control, it",2,0 scale 18*<0.65,1,1> translate <115,693,0>}
  text {ttf "courbi.ttf","should not be allowed to control the main engines.  If the vehicle attitude is not maintained to satisfy the",2,0 scale 18*<0.65,1,1> translate <115,677,0>} 
  text {ttf "courbi.ttf","guidance solution, the guidance may go unconverged and potentially could issue an undesired MECO",2,0 scale 18*<0.65,1,1> translate <115,660,0>} 
  text {ttf "courbi.ttf","command. Thus, to avoid an inadvertent shutdown, manual throttle should be selected whenever CSS",2,0 scale 18*<0.65,1,1> translate <115,644,0>} 
  text {ttf "courbi.ttf","takeover is initiated.",2,0 scale 18*<0.65,1,1> translate <115,626,0>} 
  text {ttf "courbi.ttf","Rule (A2-64A), MANUAL THROTTLE CRITERIA, references this rule." ,2,0 scale 18*<0.65,1,1> translate <115,594,0>} 
  
  text {ttf "courbd.ttf", "G.  THROTTLES WILL BE MANUALLY COMMANDED TO THE MINIMUM POWER",2,0 scale 20 translate <115,563,0>}
  text {ttf "courbd.ttf", "    LEVEL AT 2 PERCENT PROPELLANT REMAINING IF THE EXPECTED MECO",2,0 scale 20 translate <115,548,0>} 
  text {ttf "courbd.ttf", "    UNDERSPEED EXCEEDS THE VALUE ASSURING EXECUTION OF FLIGHT",2,0 scale 20 translate <115,533,0>} 
  text {ttf "courbd.ttf", "    SOFTWARE MECO PREP THROTTLING:",2,0 scale 20 translate <115,516,0>}  

  text {ttf "courbd.ttf", "1.  TWO OR THREE ENGINES ON:   500 FPS",2,0 scale 20 translate <168,484,0>}  
  text {ttf "courbd.ttf", "2.  ONE ENGINE ON:             250 FPS ",2,0 scale 20 translate <168,454,0>}  

  text {ttf "courbd.ttf", "Flight software MECO preparation throttling is triggered by K-loaded timing values.  When the",        2,0 scale 18*<0.65,1,1> translate <115,421,0>}  
  text {ttf "courbd.ttf", "guidance-computed TGO becomes less than TGO_FCD K-load, the MPS guidance cutoff task begins",          2,0 scale 18*<0.65,1,1> translate <115,404,0>}  
  text {ttf "courbd.ttf", "cyclic execution.  This task determines when to command the SSMEs to the cutoff power level, and",     2,0 scale 18*<0.65,1,1> translate <115,387,0>}  
  text {ttf "courbd.ttf", "assumes that they will remain at that setting for K-load DT_MIN_K seconds. However, the software also",2,0 scale 18*<0.65,1,1> translate <115,371,0>}  
  text {ttf "courbd.ttf", "assumes a guided MECO will result and has no way of compensating for an impending early (low-level)",  2,0 scale 18*<0.65,1,1> translate <115,355,0>}  
  text {ttf "courbd.ttf", "cutoff.  Therefore, for predicted MECO underspeeds greater than a threshold value, a low-level",       2,0 scale 18*<0.65,1,1> translate <115,338,0>}  
  text {ttf "courbd.ttf", "shutdown may be commanded before the engines reach the desired cutoff throttle setting. In such",      2,0 scale 18*<0.65,1,1> translate <115,320,0>}  
  text {ttf "courbd.ttf", "instances, the throttle will be manually retarted to the minimum powerlevel shortly before MECO to",   2,0 scale 18*<0.65,1,1> translate <115,304,0>}  
  text {ttf "courbd.ttf", "provide the required safe shutdown configuration.",2,0 scale 18*<0.65,1,1> translate <115,288,0>}  

  text {ttf "courbd.ttf", "Under most circumstances, the onboard propellant remaining computation is sufficiently accurate to use",2,0 scale 18*<0.65,1,1> translate <115,256,0>}  
  text {ttf "courbd.ttf", "as a throttledown cue.  Ascent/Entry Flight Techniques #63 determined in January 1990 that 2 percent",  2,0 scale 18*<0.65,1,1> translate <115,240,0>}  
  text {ttf "courbd.ttf", "propellant remaining provided a generic value that covered both the pre-MECO dump and no-dump",         2,0 scale 18*<0.65,1,1> translate <115,222,0>}  
  text {ttf "courbd.ttf", "cases. However, the flight software computation is inaccurate when off-nominal mixture ratios are",     2,0 scale 18*<0.65,1,1> translate <115,204,0>}  
  text {ttf "courbd.ttf", "involved, due to the buildup of unusalbe LOX or LH2; the software senses the extra mass but does not",  2,0 scale 18*<0.65,1,1> translate <115,186,0>}  
  text {ttf "courbd.ttf", "recognize it as unusable. Likewise, the onboard mass estimation algorithm in first stage assumes all",  2,0 scale 18*<0.65,1,1> translate <115,168,0>}  
  text {ttf "courbd.ttf", "THIS RULE CONTINUED ON NEXT PAGE",2,0 scale 20 translate <311,139,0>} 
  cylinder {<311,137,0>,<689,137,0> 1}
  pigment {rgb <0,0,0>}
};

#declare flight_rules_white = 
union {
  box {<0,0,2>, <1000,1000, 3> texture { pigment {rgb 1 }finish {ambient rgb 1} scale 1000}  } 
  object {flight_rules_text}
  }; 
  
#declare flight_rules_blue = 
union {
  box {<0,0,2>, <1000,1000, 3> texture { pigment {rgb <0.631,1.0,1.0> }finish {ambient rgb 1} scale 1000}  } 
  object {flight_rules_text}
  };

#declare status_board1 = 
union {
  box {<0,0,2>, <1000,1000, 3> 
  texture { 
    pigment {
      gradient y
      color_map {
        [0.1   rgb 0.1 ]
        [0.1 rgb 0.3]
      }
      scale 150
     }
    finish {ambient rgb 1} 
    }
  }
  union { 
    text {ttf "courbd.ttf", "GMT       343:02:04:17+",2,0 scale 170*<0.4,1,1> translate <50,775,0>} 
    text {ttf "courbd.ttf", "MET       000:00:10:17+",2,0 scale 170*<0.4,1,1> translate <50,625,0>} 
    text {ttf "courbd.ttf", "Oirt          00:55:19-",2,0 scale 170*<0.4,1,1> translate <50,475,0>} 
    text {ttf "courbd.ttf", "Inputs Due    01:02:28-",2,0 scale 170*<0.4,1,1> translate <50,325,0>} 
    text {ttf "courbd.ttf", "Wake-Up       14:12:28-",2,0 scale 170*<0.4,1,1> translate <50,175,0>} 
    texture {pigment {rgb <1.0,0.973,0.435>} finish {ambient rgb 1}}
  }

};

#declare status_board2 = 
union {
  box {<0,0,2>, <1000,1000, 3> 
  texture { 
    pigment {
      gradient y
      color_map {
        [0.1   rgb 0.1 ]
        [0.1 rgb 0.3]
      }
      scale 150
     }
    finish {ambient rgb 1} 
    }
  }
  union { 
    text {ttf "courbd.ttf", "MET       000:00:10:17+",2,0 scale 170*<0.4,1,1> translate <50,625,0>} 
    text {ttf "courbd.ttf", "OIGN         000:03:03-",2,0 scale 170*<0.4,1,1> translate <50,475,0>} 
    text {ttf "courbd.ttf", "Sprcasing ON- 00:07:44-",2,0 scale 170*<0.4,1,1> translate <50,325,0>} 
    text {ttf "courbd.ttf", "STS S047 LOS  00:54:41-",2,0 scale 170*<0.4,1,1> translate <50,175,0>} 
    texture {pigment {rgb <1.0,0.973,0.435>} finish {ambient rgb 1}}
  }

};



#switch (clock)
  #case (draw_nasa_seal)
    object {nasa_seal}    
    #break    
  #case (draw_canada_flag)
    object {canada_flag}  
    #break
  #case (draw_usa_flag)
    object {usa_flag}    
    #break 
  #case (draw_nasa_logo)
    object {nasa_logo}   
    #break 
  #case (draw_csa_logo)
    object {csa_logo} 
    #break 
  #case (draw_mcc_logo)
    object {mcc_logo}
    #break  
  #case (draw_mcc_text)
    object {mcc_text}  
    #break 
  #case (draw_esa_logo)
    object {esa_logo} 
    #break
  #case(draw_roscosmos_logo)
    object {roscosmos_logo} 
    #break
  #case(draw_jaxa_logo)
    object {jaxa_logo} 
    #break
  #case(draw_moc_logo) 
    object {moc_logo} 
    #break
  #case (draw_launch_digitals)
    object {mcc_launch_digitals scale <1,1000/814,1>}    
    #break
  #case (draw_ascent_ground_track)
    object {mcc_ascent_ground_track scale <1,1000/814,1>}  
    #break
  #case (draw_altitude_chart)
    object {mcc_altitude_chart scale <1,1000/814,1>}    
    #break 
  #case (draw_specs_and_ofs)
    object {mcc_specs_and_ofs scale <1,1000/814,1>}   
    #break 
  #case (draw_intercom_buttons)
    object {intercom_buttons scale <1,1000/814,1>} 
    #break 
  #case (draw_earthrise_print)
    object {earthrise_print}
    #break    
  #case (draw_chile_flag)
    object {chile_flag}
    #break
  #case (draw_flight_rules_white)
    object {flight_rules_white} 
    #break
  #case (draw_flight_rules_blue)
    object {flight_rules_blue} 
    #break
  #case (draw_status_board1)
    object {status_board1} 
    #break
  #case (draw_status_board2)  
    object {status_board2}  
    #break
  #else // draw computer screens 
    rand_computer_screen()
     
#end  
     