// Persistence of Vision Ray Tracer Scene Description File
// File: mcc_radiosity.inc
// Vers: 3.6
// Desc: Radiosity Definitions
// Date: Nov 14, 2006 
// Auth: Rob Fitzel
// Unit: N/A


#if (rad>0) 
  #include "rad_def.inc"
  radiosity { 
    #if (rad = 1)  Rad_Settings(Radiosity_Fast, off, off)  
      error_bound 0.15 // helps gets rid of artifacts
      count 80
      always_sample off
      
     #end
    #if (rad =2) 
      Rad_Settings(Radiosity_IndoorLQ, off, off)  
      
      //pretrace_start 0.08
      //pretrace_end   0.004 // attempt to reduce artifacts 
      //count 400 - does not help artifacts 
       error_bound 0.15 // - appears to do the trick, but not entirely  
      
       
    #end 
    #if (rad =3) Rad_Settings(Radiosity_IndoorHQ, off, off) 
      recursion_limit 3  
      count 80 // not 400(!)
    #end 
    
    #if (rad=4)
       // maximum patchiness
       count  20 
       nearest_count 1
       gray_threshold 0  
       
       // improvements
      // count 80 
      // always_sample off 
     // error_bound 0.15 // makes funny artifacts on ceiling, reduces brightness of artifacts, introduces subtler ones 
      pretrace_start 0.08
      pretrace_end   0.004
      
     // count 100
    #end 
    
    #if (rad=5)  
      // copied from Radiosity_IndoorLQ
      pretrace_start 0.08
      pretrace_end   0.01
      count 80
      nearest_count 5
      error_bound 0.7
      recursion_limit 2
      low_error_factor 0.8
      gray_threshold 0
      minimum_reuse 0.015
      brightness 1.0
      adc_bailout 0.01/2    

      // override
      nearest_count 1 // eliminates most of the artifacts
      error_bound 0.15 
    #end
       
    brightness 1.5 // good
    brightness 2.0  
    brightness 2.5

    #if (saverad)
      save_file "mcc.rad"
    #end
    
    #if (loadrad)
      save_file "mcc.rad"
    #end
    
    
  }
#end
    
