// Persistence of Vision Ray Tracer Scene Description File
// File: rf_computer_keyboard.inc
// Vers: 3.6
// Desc: Computer Keyboard
// Date: Sept 12, 2005 - Nov 18, 2006
// Auth: Rob Fitzel
// Units: inches
// Macros: keyboard(scheme)  scheme = 0 black keyboard, scheme = 1 white keyboard

#declare keyboard_light_scheme = 0;
#declare keyboard_dark_scheme  = 1;

#declare t_keyboard_white = texture {pigment {color <0.9,0.9,0.9>} };
#declare t_keyboard_black = texture {pigment {color <0.1,0.1,0.1>} };

#declare t_keyboard_light = 
texture {pigment {rgb <195,255,125>/255}
                  finish {ambient 1 diffuse 0}
                  };


// Computer Keyboard //////////////////////////////////////////////////////////////

#declare key = 
    prism {
    conic_sweep
    cubic_spline
    
    1.0, // sweep the following shape from here ...
    0.7, // ... up through here
    16, // the number of points making up the shape ...
    <-1.0, 1.0>, // point#1 (control point... not on curve)
    < 0.0, 1.0>, // point#2  ... THIS POINT ...
    < 0.7, 1.0>, 
    < 1.0, 0.7>,
    < 1.0, 0.0>,
    < 1.0,-0.7>,
    < 1.0,-0.7>,
    < 0.7,-1.0>,
    < 0.0,-1.0>,
    <-0.7,-1.0>,
    <-1.0,-0.7>,
    <-1.0, 0.0>,
    <-1.0, 0.7>,
    <-0.7, 1.0>,
    < 0.0, 1.0>, // point#5 ... MUST MATCH THIS POINT    
    < 1.0, 1.0>  // point#6 (control point... not on curve)
        
    scale 0.4
    scale <1,-2.5,1>
  };

#declare letter = array[6][21]{ {"Esc","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","Prt Scrn","Scroll","Pause","-","-","-","-","-"},
                                {"~","1","2","3","4","5","6","7","8","9","0","-","=","Backspace", "Insrt", "Home", "Pag Up","NLock","/","*","-"},
                                {"Tab","Q","W","E","R","T","Y","U","I","O","P","[","]","\\","Del","End","Pag Dn","7","8","9","+"},
                                {"Caps","A","S","D","F","G","H","J","K","L",";","\"","Enter","4","5","6","-","-","-","-","-"},
                                {"Shift","Z","X","C","V","B","N","M","<",">","/","Shift","^","1","2","3","*","*","*","*","*"},
                                {"Ctrl","Start","Alt"," ","Alt","Start","D","Ctrl","<-","\\/","->","0",".","-","-","-","-","-","-","-","-"}
                                
                              };
#macro m_key(scheme, key_scale, pos, sym, font_scale, letter_offset)
  #if (scheme = keyboard_dark_scheme)
    object {key scale key_scale pigment { color <0.1,0.1,0.1> } translate pos}
    text {ttf  "arial.ttf" letter[row][i]  0, 0 pigment {rgb 1} scale 0.25*font_scale rotate <90,0,0> translate pos+<letter_offset,-0.695,0> }   
  #else 
    object {key scale key_scale pigment { color <0.7,0.7,0.7> } translate pos}
    text {ttf  "arial.ttf" letter[row][i]  0, 0 pigment {rgb 0} scale 0.25*font_scale rotate <90,0,0> translate pos+<letter_offset,-0.695,0> }   
  #end
#end 








// scheme = 0 for white keyboard ; 1 for dark
#macro keyboard(scheme,xfrm)
  union {
    superellipsoid {<0.1,0.1> scale <9,0.75,3.2> translate <0,0,-1.5>
    #if (scheme = keyboard_light_scheme)
      texture {t_keyboard_white}
    #else
      texture {t_keyboard_black}
    #end
    } 
    
    // um...pre-first row  
  
    #declare row = 0;
    #declare rowz = 0.25;
    #declare i = 0;
    
    m_key(scheme, 1, <-8,1.75, rowz>, letter[row][i],0.5,-0.1)
    #declare i=i+1;
    
    #while(i>=1 & i<=4)
      m_key(scheme, 1,<-7.25+0.75*i,1.75, rowz>, letter[row][i],0.5,-0.1)
      #declare i=i+1;
    #end
    
  //  #declare i=i+1;
    #while(i>=5 & i<=8)
      m_key(scheme, 1,<-7+0.75*i,1.75, rowz>, letter[row][i],0.5,-0.1)
      #declare i=i+1;
    #end
  
  //  #declare i=i+1;
    #while(i>=9 & i<=12)
      m_key(scheme, 1,<-6.75+0.75*i,1.75, rowz>, letter[row][i],0.5,-0.1)
      #declare i=i+1;
    #end
      
  //  #declare i=i+1;
    #while(i>=13 & i<=15)
      m_key(scheme, 1,<-6.25+0.75*i,1.75, rowz>, letter[row][i],0.5,-0.2)
      #declare i=i+1;
    #end    
  
  // lights
     sphere {0,1 scale <0.1,0.05,0.05> translate <3.2,0.78,1> texture {t_keyboard_light} no_shadow}  
     sphere {0,1 scale <0.1,0.05,0.05> translate <3.9,0.78,1> texture {t_keyboard_light} no_shadow}  
     sphere {0,1 scale <0.1,0.05,0.05> translate <4.6,0.78,1> texture {t_keyboard_light} no_shadow}  
  
  // other buttons 
     #declare t_keyb_dark_button = texture {pigment {color <0.3,0.3,0.3>} };
     #declare button = 
       cylinder {<0,-0.05,0>,<0,0.05,0>,0.16  texture {t_keyb_dark_button} };
     
     object {button translate <6.0,0.82,0>}
     object {button translate <6.75,0.82,0>}
     object {button scale 1.25 translate <7.5,0.82,0>}
  
  
     object {button translate <-5.75,0.82,1> }
     object {button translate <-5.00,0.82,1> }
     object {button translate <-4.25,0.82,1> }
     object {button scale 1.25 translate <-3.50,0.82,1> }
     object {button translate <-2.75,0.82,1> }
     object {button translate <-2.00,0.82,1> }
     object {button translate <-1.25,0.82,1> }   
    
    // first row
    #declare row = 1;
    #declare rowz = row *-0.75;             
    #declare i = 0;
    #while (i<13)  
      m_key(scheme, 1, <-8+i*0.75,1.75,rowz>, letter[row][i],1,-0.1)
      #declare i=i+1;
    #end 
    m_key(scheme, <2,1,1>, <2,1.75,rowz>, letter[row][13],0.5,-0.3)   // Backspace
    
    #declare i=i+1;
    #while (i>13 & i<17)  
      m_key(scheme, 1, <-7.0+i*0.75,1.75,rowz>, letter[row][i],0.5,-0.2)
      #declare i=i+1;
    #end  
  
    #while (i>=17 & i<21)  
      m_key(scheme, 1, <-6.75+i*0.75,1.75,rowz>, letter[row][i],0.5,-0.2)
      #declare i=i+1;
    #end 
    
    // second row
    #declare row = 2;
    #declare rowz = row *-0.75;
    #declare i = 0;
    m_key(scheme, <1.75,1,1>, <-7.75,1.72,rowz>, letter[row][i],0.5,-0.2)   // Tab
    #declare i = i+1;
    #while (i<13)
      m_key(scheme, 1,<-7.75+0.15+0.75*i,1.72,rowz>, letter[row][i],1, -0.1)
      #declare i=i+1;
    #end
  
    m_key(scheme, <1.5,1,1>,<-7.75+0.25+0.75*i,1.72,rowz>, letter[row][i],1, -0.1) // "\" 
    
    #declare i=i+1;
    #while (i>13 & i<17)  
      m_key(scheme, 1, <-7.0+i*0.75,1.75,rowz>, letter[row][i],0.5,-0.2)
      #declare i=i+1;
    #end  
    
  
    #while (i>=17 & i<20)  
      m_key(scheme, 1, <-6.75+i*0.75,1.75,rowz>, letter[row][i],1,-0.2)
      #declare i=i+1;
    #end  
  
    // third row
    #declare row = 3;
    #declare rowz = row *-0.75;
    #declare i = 0;
    m_key(scheme, <2,1,1>, <-7.75,1.72,rowz>, letter[row][i],0.5,-0.2)  // Caps
    #declare i = i+1;
    #while (i<12)
      m_key(scheme, 1,<-7.75+0.35+0.75*i,1.72,rowz>, letter[row][i],1, -0.1)
      #declare i=i+1;
    #end 
    m_key(scheme, <2.5,1,1>,<-7.75+0.7+0.75*i,1.72,rowz>, letter[row][i],0.5, -0.2) // Enter
    
    #declare i=i+1;
   // #warning concat("Value of i is:",str(i,5,0),"\n")
  
    #while (i>=12 & i<16)
      m_key(scheme, 1,<-3.75+0.75*i,1.72,rowz>, letter[row][i],1, -0.1)
      #declare i=i+1;
    #end 
  
    // fourth row
    #declare row = 4;
    #declare rowz = row *-0.75;
    #declare i = 0;
    m_key(scheme, <2.5,1,1>, <-7.5,1.72,rowz>, letter[row][i],0.5,-0.2)    //Shift
    
    #declare i = i+1;
    #while (i<11)
      m_key(scheme, 1,<-7.75+0.65+0.75*i,1.72,rowz>, letter[row][i],1, -0.1)
      #declare i=i+1;
    #end 
    
    m_key(scheme, <2.85,1,1>,<-7.75+1.25+0.75*i,1.72,rowz>, letter[row][i],0.5, -0.2) // Shift
  
    
    #declare i=i+1;  
    m_key(scheme, 1,<-7.75+3+0.75*i,1.72,rowz>, letter[row][i],1, -0.1)    // up arrow
    #declare i=i+1; 
      
    #while (i>=11 & i<16)
      m_key(scheme, 1,<-7.75+4+0.75*i,1.72,rowz>, letter[row][i],1, -0.1)
      #declare i=i+1;
    #end 
    
    // fifth row
    #declare row = 5;
    #declare rowz = row *-0.75;
    #declare i = 0;
    
    #while (i<3)
      m_key(scheme, <1.25,1,1>,<-8+0.85*i,1.72,rowz>, letter[row][i],0.75, -0.2)
      #declare i=i+1;
    #end 
  
    // space bar is really one key, but scaling it makes the sides look funny,
    // so, lets just overlap many unscaled keys together
   // #declare i=i+1;
    #declare j=0;
    #while (j<18)
      m_key(scheme, 1,<-5.5+0.25*j,1.72,rowz>, letter[row][i],0.75, -0.2)  // Space
      #declare j=j+1;
    #end
    
    #declare i=i+1;  
    #while (i>=4 & i<8)
      m_key(scheme, <1.25,1,1>,<-3.75+0.85*i,1.72,rowz>, letter[row][i],0.75, -0.2)
      #declare i=i+1;
    #end 
  
  
    #while (i>=8 & i<11)
      m_key(scheme, 1,<-2.5+0.75*i,1.72,rowz>, letter[row][i],0.75, -0.2)
      #declare i=i+1;
    #end 
  
  
    
    m_key(scheme, <2.25,1,1>,<-1.75+0.75*i,1.72,rowz>, letter[row][i],0.75, -0.2)
    #declare i=i+1;
    m_key(scheme, 1,<-1.5+0.75*i,1.72,rowz>, letter[row][i],0.75, -0.2)
  
    // special buttons that span rows
    m_key(scheme, <1,1,2.25>,<8.25,1.72,-1.85>,"+",1,-0.1)
    m_key(scheme, <1,1,2.25>,<8.25,1.72,-3.35>,"Enter",1,-0.2) 
    
    rotate -x*5
    transform {xfrm}
  }
#end


#declare t_keyboard_tray = texture { pigment {color <0.05,0.05,0.05>} finish {reflection 0.1} };
#declare t_keyboard_tray_sppt = texture {pigment {color <0,0,0>} finish {specular 1 roughness 0.0001 reflection 0.13} };
#declare keyboard_tray = 
union {
  superellipsoid {<0.1,0.1> scale <14.5,0.25,5.5> texture {t_keyboard_tray} }
  union {
    box {<0,0,0>,<0.25,1.5,22.5> translate <-14.5,-0.5,-5>  }
    box {<0,0,0>,<0.25,1.5,22.5> translate < 14.5,-0.5,-5>  }
    box {<0,0,0>,<0.25,-4,1.5>   translate <-14.5,4,6>      }
    box {<0,0,0>,<0.25,-4,1.5>   translate < 14.5,4,6>      }
    box {<0,0,0>,<0.25,-4,1.5>   translate <-14.5,4,15.5>   }
    box {<0,0,0>,<0.25,-4,1.5>   translate < 14.5,4,15.5>   }
    
    texture {t_keyboard_tray_sppt}
  }
};


