// Persistence of Vision Ray Tracer Scene Description File
// File: mission control  
// Vers: 3.6
// Desc: The (white) flight control room (WFCR) where shuttle missions are controlled
// Date: May 20, 2006 
// Auth: Rob Fitzel
// Units: feet 
// Notes: Render the mcc_img.pov file first!


// scene constants & default overrides //////////////////////////////////////// 
#declare y_ceil = 18; 
#declare yd = 29/12; // desktop height 
#declare yc = 46.1/12; // top of computer consoles 
#declare yf5 = 53.5/12; // filing cabinet height (5 drawer version)
#declare yf4 = 43.5/12; // filing cabinet height (4 drawer version)
#declare yf3 = 33.5/12; // filing cabinet height (3 drawer version) 
#declare ys = 26/12; // underdesk shelving unit height 
#declare yt = 29/12; // pod end table height
#declare t_monitor = texture { pigment {rgb 0.2} finish {phong 0.4 phong_size 100 }};
#declare pod_lights = 1;  // turn off for front view (casts shadow on faces)
#declare ceiling_vents_spacing = 19;
//#declare ceiling_vents_spacing = 24;
#declare ceiling_speaker_spacing = 27; 
#declare ceiling_sprinkler_spacing = 8; 

// randomizers
#declare bsd = seed(1233); //binder placement 
#declare psd = seed(88373); // paper placement
#declare csd = seed(89484); // seal cloth folds
#declare msd = seed(19987); // misc seed

// Scene Controls /////////////////////////////////////////////////////////////
#declare draw_pods    = 1;
#declare draw_walls   = 1;
#declare draw_ceiling = 1; 
#declare draw_people  = 0; 
#declare draw_slow_to_render_objs = 1;
#declare draw_back_wall_plants = 0;

// these items require external image_maps
#declare draw_insignia = 0;
#declare draw_shuttle_print = 0;
#declare draw_memorial_plaques = 0;
#declare draw_mission_plaque = 0; 

// lights
#declare rad = 2; // 2 with addons is final // 5 is faster, but has some artifacts
#declare cam_light = 1; 
#if (rad >0)
  #declare cam_light = 0.5;
#end
#declare area = 1; // turn area lights on 
#declare top_light = 0.3; // general overhead light
#declare ceiling_lights = 1.5; // along wall
#declare sun_light = 0; 
#declare SunPos    = <100,100,-100>;
#declare back_light = 0.8*0;
#declare left_flag_light = 2;
#declare right_seal_light = 2;
#declare draw_blur = 0; 
#declare saverad = 0;
#declare loadrad = 0;


// includes ///////////////////////////////////////////////////////////////////
#ifndef (Metals_Inc_Temp)
  #include "metals.inc"
#end 

#include "rand.inc"
#include "rf_mcc_arch.inc"
#include "rf_mcc_computer_pod.inc" 
#include "rf_mcc_objs.inc"  // uses some textures in mcc_computer_pod - move to mcc_testures
#ifndef (included_rf_filing_cabinet)
  #include "rf_filing_cabinet.inc" 
#end
#include "rf_flatscreen.inc" 
//#include "rf_computer_monitor.inc"
#include "rf_computer_keyboard.inc" 
//#include "rf_office_supplies.inc" 
#include "rf_office_phone.inc" 
#include "rf_mug.inc"



#ifndef (included_rf_binders) 
  #include "rf_binders.inc"
#end



// Camera /////////////////////////////////////////////////////////////////////

#declare view =21; // 20 final; 21 closer to the action (final) //22 a bit higher up 


#switch (view)
  #case (0)  // top view
    #declare CamPos    = <25, 50, 30> ;
    #declare CamLookAt = <25,0,30>;
    #break
  #case (1) // centered, near back 
    #declare CamPos    = <20, 6, 1>;
    #declare CamLookAt = <20,6,50>;
    #break 
  #case (2) // upper, back corner 
    #declare CamPos    = <40, y_ceil-3, 1>;
    #declare CamLookAt = <20,-5,50>;
    #break      
  #case (-2) // upper, back corner (left side)
    #declare CamPos    = <2, y_ceil-2, 1>;
    #declare CamLookAt = <20,-5,50>;
    #break 
  #case (3) // FDO
    #declare CamPos    = <20, 5, 31>;
    #declare CamLookAt = <10,5,45>;
    #break
  #case (4) // middle view
    #declare CamPos    = <22, 7, 10>;
    #declare CamLookAt = <22,6,30>;
    #break 
  #case (5) // side view of front wall
    #declare CamPos    = <30,6,38>;
    #declare CamLookAt = <45,6,42>;
    #break
  #case (6) // front screen close up
    #declare CamPos    = <30,15,35>;
    #declare CamLookAt = <30,20,50>;
    #break
  #case (7) // sideview
    #declare CamPos    = <40,10,35>;
    #declare CamLookAt = <20,10,35>;
    #break
  #case (8)
    #declare CamPos    = <15,6,15>;
    #declare CamLookAt = <18,0,26>;
    #break 
  #case (9)
    #declare CamPos    = <15,6,10>;
    #declare CamLookAt = <15,20,30>;
    #break 
  #case (11)
    #declare CamPos    = <40, 4, 5>;
    #declare CamLookAt = <40,3,15>;
    #break
  #case (12) // PDRS closeup
    #declare CamPos    = <42, 5,10>;
    #declare CamLookAt = <41,2,15>;
    #break  
  #case (13) // ceiling
    #declare CamPos    = <25, 1,25>;
    #declare CamLookAt = <25,25,25>;
    #break 
  #case (14) // fao
    #declare CamPos    = <18,6,20>;
    #declare CamLookAt = <32.3,3,20>;
    #break   
  #case (15) // fao
    #declare CamPos    = <25,6-3,20>;
    #declare CamLookAt = <32.3,3,25>;
    #break    
  #case (20) // fine tuning camera 
    #declare CamPos    = <44, y_ceil-3, 1>;
    #declare CamPos    = <44, y_ceil-5, 1>; 
    #declare CamLookAt = <17,-5,50>;
    #break 
  #case (21) // fine tuning camera 
    #declare CamPos    = <44, 8, 1>+<0,-0.05,0>; 
    #declare CamLookAt = <17,4,50>+<0.1,-0.2,0>;  // just a bit
    #declare CamPos    = <44, 8, 1>+<0,-0.06,-0.2>; 
    #declare CamLookAt = <17,4,50>+<0.1,-0.3,0>;  // just a bit
    #break  
  #case (22) // more  fine tuning camera 
    #declare CamPos    = <44, 10, 1>; 
    #declare CamLookAt = <17,4,50>;
    #break     
  #case(30) // payloads
    #declare CamPos    = <25,8,20>;
    #declare CamLookAt = <0, 4,30>;
    #break 
  #case(31) // mmacs
    #declare CamPos    = <20,5,30>;
    #declare CamLookAt = <45, 4,30>;
    #break
  #case(32) // front cam looking back
    #declare CamPos    = <44,12.5,48>;
    #declare CamLookAt = <27, 0,27>; 
    #declare cam_light = 1;
    #break
  #case (40) // FDO
    #declare CamPos    = <15, 8, 25>;
    #declare CamLookAt = <5,6,45>;
    #break
  #case (41) // AE
    #declare CamPos    = <20, 8, 25>;
    #declare CamLookAt = <20,6,45>;
    #break
  #case (42) // GC
    #declare CamPos    = <35, 8, 25>;
    #declare CamLookAt = <35,6,45>;
    #break
  #case (43) // PROP
    #declare CamPos    = <10, 8, 15>;
    #declare CamLookAt = <10,6,35>;
    #break 
  #case (44) // MMACS
    #declare CamPos    = <35, 8, 15>;
    #declare CamLookAt = <35,6,35>;
    #break 
  #case (45) // DPS/payloads
    #declare CamPos    = <10, 8, 10>;
    #declare CamLookAt = <10,6,25>;
    #break 
  #case (46) // FAO/EECOM 
    #declare CamPos    = <35, 8, 10>;
    #declare CamLookAt = <35,6,25>;
    #break 
  #case (47) // Surgeon
    #declare CamPos    = <44, 10, 1>; 
    #declare CamLookAt = <40,0,10>;
    #break 
    
  #else  
    #declare CamPos    = <0, 5, -50>; 
    #declare CamLookAt = <0,5,0>; 

#end


camera {
  location  CamPos 
  look_at   CamLookAt  
  
// blur experiments
  #if (draw_blur)  
  //  focal_point <45/2, 8, 50>    
    focal_point <35,5,5>
    aperture 0.055  //0.07 too out of focus 0.04 - cant see blur
    blur_samples 30 //50    // more samples, higher quality image  
    variance 1/10000 
    confidence 0.95
    
  #end  

}

//#default {finish {ambient 0}} 
global_settings {  
  max_trace_level 20 


  #include "mcc_radiosity.inc"

}

// Lights /////////////////////////////////////////////////////////////////////

#if (cam_light>0) 
  light_source {0*x rgb cam_light translate CamPos}
#end 
  
#if (top_light > 0)  // general ceiling light

  light_source {0*x rgb top_light 
  translate <45/2, y_ceil-5+2, 28>
  parallel
  point_at <45/2 0, 28> 
  #if (area)
    area_light
    <0, 0, 0> <8, 0, 8> // lights spread out across this distance (x * z)
    4, 4                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 1          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
   // do not orient light!
 
  #end

  }

//  light_source {0*x rgb top_light translate <45/2,y_ceil-6,25>  fade_distance 7 fade_power 2 shadowless}
/*
light_source {
  0*x                 // light's position (translated below)
  color rgb 3       // light's color
  area_light
  <0, 0, 0> <40, 0, 40> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
//  orient              // orient light
  translate <45/2, 2, 25>   // <x y z> position of light  
  fade_distance 5
  fade_power 2
}
*/

/*
  #local i=2;
  #while (i<45)
    #local j=5;
      #while (j<50)
        light_source {
          0*x                     // light's position (translated below)
          color rgb 0.1      // light's color
          spotlight               // this kind of light source
          translate <i, y_ceil-1, j> // <x y z> position of light
          point_at <i, 0, j>      // direction of spotlight
          radius 0                // hotspot (inner, in degrees)
          tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
          falloff 90               // intensity falloff radius (outer, in degrees)
        }   
      #local j=j+10;
      #end
    #local i=i+8;
  #end
*/  
#end  



#if (sun_light>0)
  light_source {0*x rgb sun_light translate SunPos}
#end 

#if (back_light>0) 

  // artistic source
  light_source {0*x rgb back_light translate CamPos + <0,2,0> shadowless fade_distance 2 fade_power 1} 

/*
light_source {
  0*x  color rgb back_light spotlight translate <12, y_ceil-1, 5> point_at <12, 0, 30>      
  radius 0  tightness 50  falloff 80
  #if (area)
    area_light
    <0, 0, 0> <2, 0, 2> // lights spread out across this distance (x * z)
    4, 4                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 0          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
  #end
  }
light_source {
  0*x  color rgb back_light spotlight translate <24, y_ceil-1, 5> point_at <24, 0, 30>      
  radius 0  tightness 50  falloff 80
  #if (area)
    area_light
    <0, 0, 0> <2, 0, 2> // lights spread out across this distance (x * z)
    4, 4                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 0          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
  #end  
  }
light_source {
  0*x  color rgb back_light spotlight translate <36, y_ceil-1, 5> point_at <36, 0, 30>      
  radius 0  tightness 50  falloff 80
  #if (area)
    area_light
    <0, 0, 0> <2, 0, 2> // lights spread out across this distance (x * z)
    4, 4                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 0          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
  #end
  }
*/
#end 

//cylinder {<5,3,48>, <2,5,50>,0.2 pigment {rgb 1} finish {ambient rgb 1}}
#if (left_flag_light>0)
  light_source {0*x rgb <1,1,0.9>*left_flag_light*1.5      
    spotlight
    translate <6.5,3.5,46>  // tv @ <2,3,46>            
    point_at <2,8,50> 
    radius 5                // hotspot (inner, in degrees)
    tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 30               // intensity falloff radius (outer, in degrees)
    fade_distance 5
    fade_power 2 
    
    #if (area)
      area_light
      <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
      4, 4                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 1          // 0,1,2,3...
      jitter              // adds random softening of light
      circular            // make the shape of the light circular 
      orient
    #end
    
    
   } 
#end
 
#if (right_seal_light>0)
  light_source {0*x rgb <1,1,0.9>*right_seal_light      
    spotlight
    translate <41,3.5,47+0.5>              
    point_at <45, 10,50>
    radius 30                // hotspot (inner, in degrees)
    tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 50               // intensity falloff radius (outer, in degrees)
    fade_distance 3
    fade_power 2 
   } 
  // cylinder {<41,3.5,47> <43, 8,50> 0.5 pigment {rgb 2}}
#end 

background {0}

// Textures ///////////////////////////////////////////////////////////////////
#include "rf_mcc_textures.inc"

// Scene  Objects ///////////////////////////////////////////////////////////// 


plane {y,0 texture {t_carpet} } // floor 





// Scene //////////////////////////////////////////////////////////////////////  

#if (draw_walls)
  object {front_wall}
  object {left_wall}
  object {right_wall}
  object {back_wall}
#end

#if (draw_ceiling)
  object {mcc_ceiling}
#end 

#if (draw_pods)
  #include "rf_pods.inc" 
  

  union // first row "the trench"
    { 
    object {pod_fdo translate <12,0,0>}     // Flight Dynamics Officer
    object {pod_ae  translate <19.7,0,0>}   // Ascent Entry, Guidance
    object {pod_gc  translate <34-3,0,0> }  // Ground Controller
    translate z*44 
    }

    
  union { // second row
    object {pod_prop   translate <4.2,0,0>}   // Propulsion
    object {pod_gnc    translate <11.9,0,0>}  // Guidance, Navigation and Controls Systems
    object {pod_mmacs  translate <32.3,0,0>}  // MMACS: maintenance, mechanical, arm, and crew systems
    object {pod_egil   translate <40,0,0>}    // EGIL: electrical generation and illumination
    translate z*35
    }
 
  union { // third row
    object {pod_dps      translate  <4.2,0,0>}  // DPS: data processing system     
    object {pod_payload  translate <11.9,0,0>}  // Payloads
    object {pod_fao      translate <32.3,0,0>}  // FAO: Flight Activities Officer
    object {pod_eecom    translate <40,0,0>}    // EECOM: Emergency, Environmental and Consumables Operations Manager
    translate z*27
    }

  union { // fourth row
    object {pod_inco     translate <4.2,0,0>} // INstrumentation and Communications Officer 
    object {pod_flight   translate <18.65,0,0>} // Flight Director
    object {pod_capcom   translate <26.35,0,0>} // x= 45/2+7.7/2 // Capsule Communications
    object {pod_pdrs     translate <40,0,0>}    // Payload Deployment and Retrieval
    translate z*19 
  } 


  union { // fifth row
    object {pod_pao     translate <4.2,0,0>}   // Public Affairs Officer 
    object {pod_mod     translate <18.65,0,0>} // Mission Operations Directorate
    object {pod_boost   translate <26.35,0,0>} // Booster Systems
    object {pod_surgeon translate <40,0,0>}    // flight surgeon
    translate z*11 
  } 
    
#end 

// front left corner
object {mcc_tall_lamp translate <1,0,48.5>}   
object {mcc_short_lamp rotate -y*30 translate <4,0,47>}
object {mcc_short_lamp rotate  y*30 translate <41,0,47>}


  

union { 
  tv1(30,20, 2, transform {scale 1.5/12 scale 0.8 rotate y*180 translate <2.5,3,-0.2>})
  box {<-0.5,0,0>,<2.5,3,1> texture {pigment {rgb 0} finish {phong 0.5 phong_size 40}}}
  rotate -y*30 
  translate <2,0,46>
  }

object {office_printer rotate y*180 translate <11,0,48>}
object {office_printer rotate y*90 translate <13,0,48>}

// Notes ///////////////////////////////////////////////////////////////////////
/*
// Assumed dimensions:

         
         front  +z
  +----------------+   z=50
  |                |
  |                |
  |                |
  |                |
  |                |
  |                |
  +----------------+   z=0
  
  x                x
  0                45

ceiling height y_ceil = 18'



STS116 lift off Dec 9 (Day343)  @ 20:47pm EST = 01:47 GMT
mission elapsed time (MET) is 10:17, therefore GMT ~ 343:02:04:17
*/





   