// Persistence of Vision Ray Tracer Scene Description File
// File: rf_mcc_computer_pod.inc
// Vers: 3.6
// Desc: Template scene
// Date: May 20, 2006 
// Auth: Rob Fitzel
// Units: feet 

#declare chair_sd = seed(1443); // chair pos
#declare title_sd = seed(8837); // title signs


#ifndef (pod_lights)
  #declare pod_lights = 0;
#end
// Textures ///////////////////////////////////////////////////////////////////
#include "shapes.inc" 
#include "rf_office_chair.inc"
#include "rand.inc"
#include "metals.inc"
#include "rf_mcc_textures.inc" 
#include "rf_mcc_objs.inc"

#ifndef (included_rf_binders)
  #include "rf_binders.inc"
#end

#ifndef (draw_chairs)
  #declare draw_chairs = 0;
#end

#declare pod_binder_placement_seed = seed(55432);


#declare callsign_fdo     = 0;
#declare callsign_ae      = 1;
#declare callsign_gc      = 2;
#declare callsign_prop    = 3;
#declare callsign_gnc     = 4; 
#declare callsign_mmacs   = 5;
#declare callsign_egil    = 6;
#declare callsign_dps     = 7;
#declare callsign_payl    = 8;
#declare callsign_fao     = 9;
#declare callsign_eecom   =10;
#declare callsign_inco    =11;
#declare callsign_flight  =12;
#declare callsign_capcom  =13;
#declare callsign_pdrs    =14;
#declare callsign_pao     =15;
#declare callsign_mod     =16; 
#declare callsign_boost   =17;
#declare callsign_surgeon =18;




// Scene  Objects ///////////////////////////////////////////////////////////// 

#declare csd = seed(83783); // chairs
#declare nsd = seed(83838); // sticky notes
#declare scrsd = seed(11257); // screens

#declare global_img_idx = first_computer_screen_index; // start with mcc_img23.png 
 
#macro pod_computer_screen(img_idx,xfrm)
  union {
    box {<0,0,0>,<17,1,1>}
    box {<0,12.5,0>,<17,13.5,1>}
    box {<0,1,0>,<1,12.5,1>}
    box {<16,1,0>,<17,12.5,1>}
    
/*    
    #switch (img)
    
      #case (1)   #local t_screen_img = "flight01.jpg";  #break
      #case (2)   #local t_screen_img = "flight02.jpg";  #break
      #case (3)   #local t_screen_img = "flight03.jpg";  #break
      #case (4)   #local t_screen_img = "flight04.jpg";  #break
      #case (5)   #local t_screen_img = "flight05.jpg";  #break
      #case (6)   #local t_screen_img = "flight06.jpg";  #break
      #case (7)   #local t_screen_img = "boost01.jpg";   #break
      #case (8)   #local t_screen_img = "capcom01.jpg";  #break
      #case (9)   #local t_screen_img = "capcom02.jpg";  #break
      #case (10)  #local t_screen_img = "capcom03.jpg";  #break
      #case (11)  #local t_screen_img = "mod01.jpg";     #break
    #else
      #case (12)  #local t_screen_img = "mod02.jpg";     #break    
    #end
*/    
    #local t_screen_img = concat("mcc_img",str(global_img_idx,0,0),".png"); 
    #declare global_img_idx = global_img_idx+1;

    #local t_screen = texture{pigment{image_map{png t_screen_img  }scale <-1,1,1> } };

    // override
 //    #local t_screen_img = "mcc_img18.png"
 //   #local t_screen = texture{pigment{image_map{png t_screen_img  }scale <-1,1,1> } finish {ambient 1}};
  
    box {<0,0,0>,<1,1,0.1> 
      texture {t_screen finish {ambient 0.5 phong 0.5 phong_size 100 reflection 0.2}} 
      /* doesn't work
      interior {
        media {
          emission 10 
          intervals 1
          samples 5
          method 3 
        } 
        
    }
      hollow 
    */  
      scale <15,11.5,1> translate <1,1,0.5>} 


    
    texture {t_computer_screen_frame}
    transform {xfrm}
  }
#end

#declare central_pod_back_and_top = 
union {
  box {<-15,0,3>,<15,3,4>   texture {t_pod_black} } // toe kick
  box {<-15,3,0>,<15,24,4>  texture {t_pod_blue_dark} }  
  box {<-15,24,0>,<15,41,4>  }
  cylinder {<-15,41,2>,<15,41,2> 2  } 
  
  // angled top 
  union {
    box {<-15,0,0>,<15,2,3>  }
    box {<-15,0,3>,<15,2,15> texture {t_pod_blue_grill}} // grill
    box {<-15,0,15>,<15,2,19>  }
    
    rotate -x*10  
    translate <0,41,2> 
    }
  cylinder {<-15,0,0>,<15,0,0> 1 scale <1,1,3> translate <0,45.2,21>   }  
  //sphere {0, 1 pigment {rgb 1} translate <0,44,21>}   
  #if (pod_lights)
    light_source {0*x rgb <0.8,0.8,1>*1  translate <0,44,21> fade_distance 1 fade_power 2}  
  #end
  
  
  texture {t_pod_blue_light}
};



#declare pod_intercom_panel =
union {
  box {<1.5,0.74,0>,<11,12.6,0.1> texture {t_pod_blue_light}} 
  box {<4.25,12.2,0.1>,<8.25,12.55,0.101> pigment {rgb 1}}
  union { // bolts
    cylinder {<0,0,0>,<0,0,0.3> 0.17 translate <2.1,1.9,0>}
    cylinder {<0,0,0>,<0,0,0.3> 0.17 translate <2.1,11,0>}
    cylinder {<0,0,0>,<0,0,0.3> 0.17 translate <10.5,1.9,0>}
    cylinder {<0,0,0>,<0,0,0.3> 0.17 translate <10.5,11,0>}
    texture {T_Chrome_3C} 
    }  
    prism {                                
      conic_sweep //for tapering to a point
      linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
      0.8,         // height 1
       1,         // height 2
      5,           // number of points
      <1,1>,<-1,1>,<-1,-1>,<1,-1>,<1,1>
      translate -y*1 
      scale <1,3,1>
      rotate -x*90 
      scale <3.4,5.2,1>
      translate <6.3,5.2+1.4,0>
      texture {t_pod_intercom_gray}
    }
//box {<0,0,0>,<1,1,0.1> texture {pigment {image_map {jpeg "pod_intercom_buttons.jpg"}}} scale <5.1,7.4,1> translate <3.7,2.7,0.501>}
  box {<0,0,0>,<1,1,0.1> texture {t_intercom_buttons} scale <5.1,7.4,1> translate <3.7,2.7,0.501>}

  
};


#declare central_desktop = 
  union {
    box {<-15,0,0>,<15,16,-6> } // backing
    box {<-15,1,-10>,<15,2,2> texture {t_pod_blue_dark}}  // front lip
  //pod_computer_screen(1,transform {translate <-8.5,3,0>}) 
   // keyboard(keyboard_light_scheme, transform {rotate y*180 rotate x*5 translate <0,1,10>})
    //object {keyboard  rotate y*180 rotate x*5 translate <0,1,10>}
    }; 

#declare right_side_desktop =
  union {
    box {<-18,1,-10>,<18,2,2> texture {t_pod_blue_dark}}  // front lip
    box {< 11,2,0>,< -18,16,-6> } // backing 
    object {pod_intercom_panel translate <-0.2,2,0>} 
    box {< 17,0,-6>,<11,15,-7>}  // back of bookshelf 
    #local i=0;
    #local sz = 1;
    #while (i<6)    
      object {binder_spine scale <sz,1,-1> translate <11+sz,1,RRand(0,1,pod_binder_placement_seed)> texture {t_binder_cover} }
      #local sz = RRand(1,2,pod_binder_placement_seed);      
      #local i=i+sz;
    #end
    texture {t_pod_blue_light}
  };
  
#declare left_side_desktop =
  union {
    box {<-18,1,-10>,<18,2,2> texture {t_pod_blue_dark}}  // front lip
    box {<-11,2,0>,<  18,16,-6>} // backing 
    object {pod_intercom_panel translate <-13,2,0>} 
    box {<-17,0,-6>,<-11,15,-7>}  // back of bookshelf 
    #local i=0;
    #local sz = 1;
    #while (i<6)    
      object {binder_spine scale <sz,1,-1> translate <-17-1+sz,1,RRand(0,1,pod_binder_placement_seed)> texture {t_binder_cover} }
      #local sz = RRand(1,2,pod_binder_placement_seed);      
      #local i=i+sz;
    #end
    
    texture {t_pod_blue_light}
  };
    

#declare pod_side_wall =
union {
  box {<0,0,0>,<1,28,20>  texture {t_pod_blue_dark} }
  box {<0,28,0>,<1,29,20> texture {t_pod_black} } 
 
  prism {                                
    linear_sweep  // or conic_sweep for tapering to a point
    -0.5,         // height 1
     0.5,         // height 2
    5,           // number of points
    // (--- the <u,v> points ---)
    < 7, 0.5>, <20,0>, <20,25>, <3,20>, <7,0.5>
    rotate -z*90
    translate <0.89999,49,0>
  }
  
  texture {t_pod_blue_light}
  translate <-0.9,0,0>
  //translate <-0.001,0,0>
};

 
#declare central_pod = 
union { 
  object {central_pod_back_and_top }
  object {central_desktop translate <0,28,20>} 
  //pod_computer_screen(1,transform {translate <-8.5,3+28,0+20>})
  // desktop
  texture {t_pod_blue_light}
}

#declare common_desk_top =  // desk is not angled
union {
  box {<-46,0,0>,<46,1,24>      }  // desktop
  box {<-46,0,24>,<-46+12,1,36> }  // small extended desk 
  box {< 46,0,24>,< 46-12,1,36> }
  texture {t_pod_desktop}
  translate <0,28,0>
  };
   

#declare right_pod =
//intersection {
  union {
    object {central_pod_back_and_top scale <36/30,1,1>} 
    object {right_side_desktop    translate <0,28,20>} 
  //pod_computer_screen(1,transform {translate <-14,3+28,0+20>}) 
  
   object {pod_side_wall translate < 18,0,0> texture {t_pod_blue_light}} 
}; 



#declare left_pod = 
  union {
    object {central_pod_back_and_top scale <36/30,1,1>} 
    object {left_side_desktop    translate <0,28,20>}  
  //pod_computer_screen(1,transform {translate <-10+6,3+28,0+20>})
    object {pod_side_wall translate <-18,0,0> texture {t_pod_blue_light}} 
}; 


#macro draw_computer_pod(img1,img2,img3,xfrm)
  union {
    object {central_pod translate <0,0,0>}     
    pod_computer_screen(img1,transform {translate <-8.5,3+28,20>}) 
    
    // stickies and posted papers
    #if (rand(nsd) < 0.5) 
      #local i=0;
      #while (i<2)
        object {sticky_note scale 12 rotate x*90 rotate z*RRand(-10,10,nsd) translate <RRand(8,11,nsd),RRand(32,40,nsd),20>}
        #local i=i+1;
      #end         
    #else
      box {<0,0,0>,<3,8,0.001> texture {t_white_paper} translate <9,33,20>}
    #end 
    
    #if (rand(nsd) < 0.3) 
      #local i=0;
      #while (i<2)
        object {sticky_note scale 12 rotate x*90 rotate z*RRand(-10,10,nsd) translate <RRand(-11,-14,nsd),RRand(32,40,nsd),20>}
        #local i=i+1;
      #end         
    #else 
      #if (rand(nsd) <0.8)
        box {<0,0,0>,<-3,8,0.001> texture {t_white_paper} translate <-9,33,20>}
      #end
    #end
    
    
    
    // position label
/*    
    #local position_title = text {ttf "arial.ttf" name1 0.2, 0  scale 2};
    #local pos_position_title_text = (min_extent(position_title) + max_extent(position_title) )/2; 
    
    union {
      box {<-10,0,0>,<10,3,3> pigment {rgb 1} } 
      text {ttf "arial.ttf" name1 1, 0  scale 2 translate <pos_position_title_text.x,0,0> + <-10,1,-0.01> } 
      rotate x*45
      clipped_by {plane {-y,0}}  
      
      rotate y*180 
     // rotate y*RRand(160,200,title_sd) //- causes ttf to disappear
      rotate -x*10
      translate <0,46.1,20>
      
      }
*/ 
/*
#declare callsign_sign =
union {
    box {<-10,0,0>,<10,3.5,3.5>      pigment {rgb 1} }
    box {<-10,0,0>,<-10.001,3.5,3.5> pigment {rgb 0}}
    box {<10,0,0>,<10.001,3.5,3.5>   pigment {rgb 0}}
    text {ttf "arial.ttf" "hello" 1, 0  scale 2 translate <-10,1,-0.01>  pigment {rgb 0}} 
    text {ttf "arial.ttf" "hello" 1, 0  scale 2 rotate y*180 rotate x*90 translate <10,1,-0.01>  pigment {rgb 0}} 
    
    rotate x*45
    clipped_by {plane {-y,0}}  
      
};
*/
//    object {callsign_sign  /*rotate y*30*/ rotate -x*10 translate  <0,45.5,16>  }
//    object {callsign_sign  rotate y*180 rotate -x*10 translate  <5,55.5,16>  }
     
    /*
       #declare store_name = object {
     #declare s = rand(a_rand)*3;
     text {ttf  f_storefront_name[rand(a_rand)*num_f_name] l_storefront_name[rand(a_rand)*num_l_name] 0.2 0 scale <1.5+s,1.5+s,1>  texture {pigment {color p_storefront_name[rand(a_rand)*num_p_name]} finish {ambient 1}} no_shadow }
     };
      
   #declare store_name_pos = (min_extent(store_name) + max_extent(store_name) )/2;
   
  // union {
  //   box {<-9.5,-2,0>,<9.5,2,0.05> pigment {White} }
     object {store_name translate -store_name_pos + <0,0,0> translate <9.5,14,0>}
   */
    
    // callsign
    
  //  callsign_sign1("FLIGHT DIRECTOR", 0, 1,transform {rotate -x*10 translate <0,45,16>})
  /*  
    #switch(callsign)
      #case(callsign_fdo)
          callsign_sign1("TRAJECTORY", 0, 1,transform {rotate -x*10 translate <0,45,16>})  
          #break
      #else
           
    #end
  */  
    
    union {
      object {left_pod  }            
      pod_computer_screen(img2,transform {translate <-10+6+2,3+28,0+20>})
      translate <-18,0,0> rotate  y*10 translate <-15,0,0>
      }
    union {
      object {right_pod }                       //-14
      pod_computer_screen(img3,transform {translate <-16,3+28,0+20>})
      translate < 18,0,0> rotate -y*10 translate < 15,0,0>
      }
    object {common_desk_top translate <0,0,20>} 
    #if (draw_chairs)
      object {office_chair rotate -y*(90+RRand(-60,60,chair_sd)) translate < 20,0,48>}
      object {office_chair rotate -y*(90+RRand(-60,60,chair_sd)) translate <-20,0,48>}
    #end
    texture {t_pod_blue_light} 
    
    
    scale 1/12 // feet 
    rotate y*180 
    transform {xfrm}  
    
    }
#end

/*
#declare pod_end_table = 
union {
  box {<0,0,0> }

};
*/ 

#macro callsign_sign1(txt, xl, sc,xfrm)  
  union {
    box {<-10,0,0>,<10,3.5,3.5>  pigment {rgb 1}} 
    box {<-10,0,0>,<-10.001,3.5,3.5> pigment {rgb 0}}
    box {< 10,0,0>,< 10.001,3.5,3.5> pigment {rgb 0}}
    text {ttf "arial.ttf" txt 0.01, 0  scale 2.5*sc translate <0,0.75,-0.01>  translate x*(-10+xl)} 
    text {ttf "arial.ttf" txt 0.01, 0  scale 2.5*sc rotate x*90 translate <0,3.501,0>  rotate y*180 translate z*2.5 translate x*(10-xl)} 
    bounded_by {box {<-11,0,-5>,<11,5,5>  rotate -x*45}}
    rotate x*45    
    pigment {rgb 0}
    transform {xfrm}
  }                 
#end 

#macro callsign_sign2(txt1, txt2, xl, xl2, sc, xfrm)  
  union {
    box {<-10,0,0>,<10,3.5,3.5>  pigment {rgb 1}}
    box {<-10,0,0>,<-10.001,3.5,3.5> pigment {rgb 0}}
    box {< 10,0,0>,< 10.001,3.5,3.5> pigment {rgb 0}}
    text {ttf "arial.ttf" txt1 0.01, 0  scale 1.5*sc translate <0,2,-0.01>  translate x*(-10+xl)}
    text {ttf "arial.ttf" txt2 0.01, 0  scale 1.5*sc translate <0,0.5,-0.01>  translate x*(-10+xl2)} 
    text {ttf "arial.ttf" txt1 0.01, 0  scale 1.5*sc rotate x*90 translate <0,3.501,0>  rotate y*180 translate z*1.5 translate x*(10-xl)}
    text {ttf "arial.ttf" txt2 0.01, 0  scale 1.5*sc rotate x*90 translate <0,3.501,0>  rotate y*180 translate z*3   translate x*(10-xl2)}
    bounded_by {box {<-11,0,-5>,<11,5,5>  rotate -x*45}}
    rotate x*45    
    pigment {rgb 0}
    transform {xfrm}
  }                 
#end 


// Notes ///////////////////////////////////////////////////////////////////////
/*




*/





   