// Persistence of Vision Ray Tracer Scene Description File
// File: rf_office_chair.pov
// Vers: 3.6
// Desc: Office Chair from Rob's den
// Date: Sept 12, 2005
// Auth: Rob Fitzel
// Units: inches
// Objects:  office_chair

#declare incl_rf_office_chair =1;
#declare height_office_chair1 = 22;
#include "shapes.inc"


#declare t_chair = texture {pigment {color <0.05,0.05,0.05>} normal {bumps 0.01} finish {phong 0.2 phong_size 180} };
#declare t_backrest =  texture {pigment {rgbt <0.2,0.2,0.2,0.5>} normal {bumps 0.01} finish {phong 0.4 phong_size 180}  };


#declare chair_bottom_part = 
union {
  difference { 
    torus {40.1,1  rotate <90,0,0> translate <0,-35,0>} // clipped_by {plane {x,0}} clipped_by {plane {-y,37.25}} }
    box {<0,2.25,-3>,<13,7,3>  inverse }
    sphere {0,40.1 translate <0,-35,0>   }   
  }
  difference {
    sphere {0,1 translate <13,3,0>  }     
    sphere {0,40.1 translate <0,-35,0>  }
  }
  
  difference {
    union {
      cylinder {<0,0,0>,<0,1.25,0> 0.625 translate <13,2,0> } 
      sphere   {0,0.625 translate <13,2,0> }    
      }
    cylinder {<14,2,-2>,<13,2,2>,1.125 } 
  }     
 
  cylinder {<13,2,-0.75>,<13,2,0.75>,1.125}
  cylinder {<13,2,-1.125>,<13,2,1.125>,1}     
             
  pigment {rgb 0} 
  translate <0,-1,0>    
};       

#declare office_chair = 
union {
  #declare i = 0;
  #while (i<6)
    union {chair_bottom_part rotate <0,72*i,0> }
    #declare i = i+1;
  #end

  cylinder {<0,1.5,0>,<0,6.75,0> 1}  
  cylinder {<0,5,0>,<0,9.5,0>, 1.5}
  cylinder {<0,9.5,0>,<0,14,0>,1.125}
  
  box {<-2,14.1,-2.5>,<8,16.5,2.5> }
  cylinder {<0,0,0>,<0,0,1>,0.5 translate <1,15.5,2.5>  } 
  sphere_sweep {linear_spline  4,
    <1,15.5,2.5>, 0.1
    <1,15.5,4.0>, 0.1
    <1,15.0,4.3>, 0.1
    <1,15.0,7.5>, 0.1
    } 

  // adjusting arm
  difference {     
    cylinder {<0,0,0>,<0,0,1.5>, 5  translate <1,15.0+5,7.5> }
    cylinder {<0,0,-1>,<0,0,2>, 4.8 translate <1,15.0+5,7.5> }  
    box {<-1.5,-1.5,-1.5>,<1.5,1.5,1.5>  translate <1,15.0,8> inverse}
    } 
  // fwd adjuster
  cylinder {<2,15,0>,<-3,12,0> 1}

  // seat
  difference {
    superellipsoid {<0.5,0.5> scale <9.5,2,10.5> translate <1,18.5,0>  }
    sphere {0,1 scale <30,19,30> translate <1,38,0>  }
  }
  
  //armrest 
  #declare armrest =   
  union {
    box {<0,0,0>,<2.25,0.25,5.5>  translate <1,16.5,5> }
    box {<0,0,0>,<2.25,5,0.25>  translate <1,16.5,10.5> } // should have a curved connection
    box {<0,0,-0.5>,<3,7,0.5>  translate <1,20,10.5> }
    superellipsoid {<0.3,0.3> scale <5,0.5,1.5>  translate <3,27,10.5>  }
  };
  
  union {armrest} 
  union {armrest scale <1,1,-1>  }  // note how scaling makes a mirror image and translates to opposite side
  
  // backrest 
  
  
  union { 
    difference { // need a nontransparent rim around
      cylinder {<0,0,-9.5>,<0,0,9.5> 24 translate <32,28.5,0>  } 
      cylinder {<0,0,-9.6>,<0,0,9.6> 23 translate <32,28.5,0>  }   // basic shape
      box      {<5,18,-10>,<15,40,30> inverse }
      cylinder {<0,10,0>,<40,12,0> 50 scale <1,0.65,1> inverse }  // round off the top 
      
//      superellipsoid {<0.3,0.3> scale <3,11,8> translate <10,27.5,0>  } // make hole for mesh    
      superellipsoid {<0.3,0.3> scale <3,11.5,9> translate <10,28,0> inverse }  //  round off top corners 
     // Round_Box_Union (<5,18,-8>,<15,38,8>, 3)
    
    } 
 
  }
      
 //superellipsoid {<0.3,0.3> scale <3,11,8> translate <10,27.5,0>   pigment {rgbt <1,0,0,0.5>} } 
 //object {Round_Box_Union (<5,18,-10>,<15,40,10>, 3)  pigment {rgbt <1,0,0,0.5>} }
 //object {Round_Box_Union (<5,18,-8>,<15,38,8>, 3)  pigment {rgbt <1,0,0,0.5>} }  
      

 //   superellipsoid {<0.3,0.3> scale <10,10.5,9> translate <10,28,0> pigment {rgbt <1,1,0,0.5>}  } 
//  superellipsoid {<0.3,0.3> scale  <10,8,6> translate <10,28,0>  pigment {rgbt <1,1,0,0.5>} } 
  
  // todo: change scale of last superellipsoids to make rim wider  

  // fill in mesh?
/*  
  union { 
    difference { // need a nontransparent rim around
      cylinder {<0,0,-9.5>,<0,0,9.5> 24 translate <32,28.5,0> texture {t_backrest} } 
      cylinder {<0,0,-9.6>,<0,0,9.6> 23 translate <32,28.5,0> texture {t_backrest} }   // basic shape 
      superellipsoid {<0.3,0.3> scale <3,15,8> translate <10,23.5,0>  inverse} // fill hole with mesh
      superellipsoid {<0.3,0.3> scale <3,11.5,9> translate <10,28,0> inverse texture {t_backrest} }  // round off top corners
      
    }
  } 
*/  

  
  texture {t_chair}
}