// Persistence of Vision Ray Tracer Scene Description File
// File: rf_popcan.inc
// Vers: 3.6
// Desc: Popcan
// Date: July 15, 2006
// Auth: Rob Fitzel
// Unit: mm
#declare included_rf_popcan = 1;

#declare cm_to_feet = 0.0328;

#ifndef (draw_coke_label)
  #declare draw_coke_label = 0;
#end

#if (draw_coke_label)
  #declare t_popcan_label=
  texture{
    pigment{
      image_map{jpeg "Coca-Cola_logo2.jpg"  once map_type 2}
      scale <1,11.3,1>
      translate 0.5*y
    } 
    finish {phong 0.8 phong_size 60}
  }; 
#else
  #declare t_popcan_label=
  texture{
    pigment{rgb <1.0,0.184,0.169>}
    finish {phong 0.8 phong_size 60}
  }; 
#end

#include "metals.inc" 
#include "shapes.inc"

#declare x_popcan_side = transform {rotate x*90 translate y*3.25};


#declare t_popcan_metal = texture {T_Chrome_1C};
#declare t_popcan_tab   = texture {T_Chrome_3E};


#declare can_closed = 0;
#declare can_open =1;  


// popcan - units = cm
#macro popcan(label,opened xfrm)
union {
  torus {2.45,0.2 translate <0,0.2,0>}
  difference {
    union {
      cone {<0,0.2,0>,2.45,<0,0.5,0>,3.25} 
      union {
        cylinder {<0,0.5,0>,<0,10.5,0>,3.25 }  // put imagemap here
        cone {<0,10.5,0>,3.25,<0,11.8,0>,2.6 open}  // tapered top 
        texture {t_popcan_label}
      }  
    }
    sphere {0,1  scale <2.45,1,2.45> } 
  }
  difference {                           // metal ring around top
    cylinder {<0,11.1,0>,<0,12,0>,2.7}
    cylinder {<0,11.0,0>,<0,12.1,0>,2.6}
  } 
  cylinder {<0,11.1,>,<0,11.6>,2.6 }  // top of can 
  #if (can_open)
    cylinder {<0,0,0>,<0,-1,0>,1 scale <1.2,1,0.9> translate <0,11.6001,-1.2> pigment {rgb 0.2}}
  #end
  
  //tab
  difference {
    Round_Box_Merge(<-0.6,0,0>,<0.6,10,2>,0.5)
    cylinder {<0,-1,0.6>,<0,11,0.6>,0.5 scale <1,1,0.8>}
    cylinder {<0,-1,0>,<0,11,0>,0.5 scale <1,1,0.4> translate <0,0,1.5>}  
    texture {t_popcan_tab}
    scale <1,0.01,1>
    translate <0,11.7,0>
    }
  
  texture {t_popcan_metal}
  transform {xfrm}
}
#end