// Persistence of Vision Ray Tracer Scene Description File
// File: rf_tiled_ceiling.inc
// Vers: 3.6
// Desc: Standard office acoustic
// Date: Nov 11, 2005 (based on observations from the physio clinic after busting up my ankle playing volleyball!)
// Auth: Rob Fitzel
// Units: feet
// Objects: square_flourescent_light,rect_flourescent_light,
// Macros:  

/*      draw_tiled_ceiling (x_len, z_len, style, flx, flz, xfrm)
              x_len, z_len =dimensions, style = [square_ceiling_tiles|rect_ceiling_tiles],
              fl_x = draw a flourescent light every flx rows and every flz cols,
              xfrm = object transformation
*/

#declare square_ceiling_tiles = 0;
#declare rect_ceiling_tiles   = 1;


// acoustic ceiling tile
#declare t_ceiling_tile = 
texture {
  pigment {
    dents
    pigment_map {
      [0.0  rgb 0]
      [0.05  rgb 1]
    } 
    scale 0.01
  }
  finish {ambient 0.3}
};

#declare t_ceiling_tile_grid = 
texture {pigment {rgb <0.7,0.72,0.7>} finish {phong 1 phong_size 60}}; 


#declare square_tile_frame = 
union {
  box {<0,0,0>,<2,-0.02,0.05> }
  box {<0,0,2>,<2,-0.02,1.95> } 
  box {<0,0,0>,<0.05,-0.02,2> }
  box {<2,0,0>,<1.95,-0.02,2> }   
  texture {t_ceiling_tile_grid}
  }; 
  
#declare rect_tile_frame = 
union {
  box {<0,0,0>,<4,-0.02,0.05> }
  box {<0,0,2>,<4,-0.02,1.95> } 
  box {<0,0,0>,<0.05,-0.02,2> }
  box {<4,0,0>,<3.95,-0.02,2> }   
  texture {t_ceiling_tile_grid} 
  };
  
#declare square_acoustic_tile = 
union {
  box {<0.05,0,0.05>,<1.95,0.1,1.95> texture {t_ceiling_tile} } 
  object {square_tile_frame}
  };

  
#declare rect_acoustic_tile   = 
union {
  box {<0.05,0,0.05>,<3.95,0.1,1.95> texture {t_ceiling_tile} }
  object {rect_tile_frame}
  };

//#declare t_ceiling_tile_grid = 
//texture {pigment {rgb <1,0,0>}};

#declare t_fl_light_tube = texture {pigment {rgb 1.5} finish {ambient rgb 1*2}};
#declare t_no_light_tube = texture {pigment {rgb 1.0} finish {ambient rgb 0.9*2}}; 

/*
#declare t_flourescent_lights =
texture {
  gradient z
  texture_map {
  [0.00  t_no_light_tube]
  [0.15  t_no_light_tube]
  [0.30  t_fl_light_tube]
  [0.45  t_no_light_tube]
//  [0.56  t_no_light_tube]
  [0.60  t_fl_light_tube]
  [0.85  t_no_light_tube]
  [1.00  t_no_light_tube]
  
  }    
}
*/
#declare light_tube =
cylinder
  {<0,0,0>,<0,3.8,0> 1
  pigment {rgbt 1}
  finish {ambient 0 diffuse 0}
  interior {
    media {
      emission 1.05*<0.9,0.9,1>
      intervals 1
      samples 5
      method 3 
      density {  
      
        cylindrical
        color_map {
          [0  rgb 1]
          [1  rgb 5]
         }
      
        
        
      }
    }
  }
  hollow
  
  rotate x*90 
  scale <0.1,0.1,1>
  rotate y*90 
  
};


/*
#declare t_light_cover = texture {pigment {rgbf 0.9} normal { checker 1} scale 0.1};
  
#declare flourescent_lights = 
union {             
  box {<0,0,0>,<72,-0.001,36> texture {t_flourescent_lights}  }
  box {<0,-0.001,0>,<72,-0.002,36> texture {t_light_cover} }  

};
*/

#declare t_light_cover = texture {
  gradient z
  texture_map {
  [0.00  t_no_light_tube]
  [0.15  t_no_light_tube]
  [0.30  t_fl_light_tube]
  [0.45  t_no_light_tube]
//  [0.56  t_no_light_tube]
  [0.60  t_fl_light_tube]
  [0.85  t_no_light_tube]
  [1.00  t_no_light_tube]
  
  }    

 };
 
 
#declare rect_flourescent_light =
union { 

  light_group {
    light_source {0*x rgb 1*<0.9,0.9,1> translate <2,-3,1>}
  
  
  
    box {<0.05,-0.2,0.05>,<3.95,-0.1,1.95> texture {pigment {rgbt <1,1,1,0.7>} finish {ambient 0.8} }  }
    object {rect_tile_frame translate <0,-0.15,0>}
    object {light_tube translate <0,0,0.4>}
    object {light_tube translate <0,0,0.6>}
    object {light_tube translate <0,0,1.4>}
    object {light_tube translate <0,0,1.6>}
    translate <0,0.15,0> 
    global_lights 
    }
  
  };  
  
#declare rect_flourescent_light =
union { 
    box {<0.05,0.05,0.05>,<3.95,0.1,1.95> pigment {rgb 1}}
    box {<0.05,0.3,0.05>,<3.95,0,1.95> 
      pigment {rgbt 1}
      finish {ambient 0 diffuse 0}
      interior {
        media {
          emission <0.9,0.9,1>*3
          intervals 1
          samples 5
          method 3 
          density {
            gradient z
            color_map { 
              [0    rgb 0] 
              [0.25 rgb 1]
              [0.35 rgb 1]
              [0.5  rgb 0.4]
              [0.65 rgb 1] 
              [0.75 rgb 1] 
              [1.0 rgb 0]
            }
            scale 2
          }

        }
      }
      hollow            
    }

    object {rect_tile_frame /*translate <0,-0.15,0>*/} 
    /*
    object {light_tube translate <0,0,0.4>}
    object {light_tube translate <0,0,0.6>}
    object {light_tube translate <0,0,1.4>}
    object {light_tube translate <0,0,1.6>}
    */
  //  translate <0,0.15,0> 
  };  
 

#declare square_flourescent_light = 
union { 
  object {square_tile_frame translate <0,-0.15,0>}
  box {<0.05,-0.2,0.05>,<1.95,-0.1,1.95> texture {pigment {rgbt <1,1,1,0.9>} finish {ambient 0.8} } } // cover
  object {light_tube translate <0,0,0.4>}
  object {light_tube translate <0,0,0.6>}
  object {light_tube translate <0,0,1.4>}
  object {light_tube translate <0,0,1.6>}
  translate <0,0.15,0> 
  };

#declare t_ceiling_light_glow_reflection = 
texture {
  pigment {
    gradient z
    color_map {
      [0    rgb <0.9,0.9,1>]
      [0.25 rgb <0.9,0.9,1>]
      [0.50 rgb <0.9,0.9,1>]
      [0.75 rgb <0.9,0.9,1>]
      [1.00 rgb <0.9,0.9,1>]
    }
  }
  scale 2
};




#declare t_ceiling_vent_metal = texture {pigment {rgb 0.5} finish {ambient rgb 0.4 phong 0.7 phong_size 50}};
#declare t_ceiling_vent_black = texture {pigment {rgb 0.1}}; 
#declare t_ceiling_vent_ridge =  

#declare t1 = texture {pigment {rgb 1} finish {ambient rgb 1}};
#declare t2 = texture {pigment {rgb <1,0,0>} finish {ambient rgb <1,0,0>}};
texture {
  gradient z
  texture_map {
   [0.3  t_ceiling_vent_black]
   [0.6  t_ceiling_vent_metal]
    }
  scale 0.2
}; 

/*
#declare n_ceiling_vent_ridge = 
normal {
  gradient z
  slope_map {
    [0.4  0]
    [0.7  1]
  } 
  scale 0.3
};
*/
#declare ceiling_vent_quarter = 
triangle {<-1,0,-1>,<0,0,0>,<1,0,-1> /*pigment {rgb 0.6} normal {n_ceiling_vent_ridge}*/ 
          texture {t_ceiling_vent_ridge} scale 0.9}; 

#declare ceiling_vent = 
union {
  object {ceiling_vent_quarter rotate y*0}
  object {ceiling_vent_quarter rotate y*90}
  object {ceiling_vent_quarter rotate y*180}
  object {ceiling_vent_quarter rotate y*270} 
  
//  box {<-1,0.00001,-1>,<1,0.1,1> pigment {rgb 1} /*texture {t_ceiling_vent_metal}*/} 
  translate <1,-0.01,1>
}

#declare ceiling_diffuser_ridge =  
intersection  {
  difference {
    cylinder {<-0.5,0,0>,<0.5,0,0> 0.1 } 
    cylinder {<-0.6,0,0>,<0.6,0,0>, 0.0999} 
    }
  
  plane {z,0}
  plane {y,0}
 
  
 //texture {pigment {rgb 0.7} finish {phong 1 phong_size 50}}
 texture {T_Chrome_5A}
  scale <1,1,1.5> 
} 

#declare ceiling_diffuser_quarter =  
  intersection {
    union {
      #local i=0;
      #while (i<6)
        object {ceiling_diffuser_ridge translate <0,0.01*i,0.1*i>}
        #local i=i+1;
      #end
      } 
      plane {x,0 rotate  y*45 pigment {rgbt <1,0,0,0.5>}}   
      plane {x,0 rotate -y*45 pigment {rgbt <0,1,0,0.5>} inverse} 
      bounded_by{box {<-0.5,0.1,0>,<0.5,-0.1,0.5>}}
    }; 
    
#declare ceiling_diffuser = // approx 1 foot x 1 foot
union {  
  object {ceiling_diffuser_quarter rotate y*0}
  object {ceiling_diffuser_quarter rotate y*90}
  object {ceiling_diffuser_quarter rotate y*180}
  object {ceiling_diffuser_quarter rotate y*270} 
  box {<-0.5,0,-0.5>,<0.5,-0.0001,0.5> pigment {rgb 0.2}} 
  translate <0.5,0,.5>
}  


#declare ceiling_speaker = 
union
  {
  cylinder {<0,0,0>,<0,-0.0001,0> 0.5 texture {pigment {rgb <0.988,0.949,0.831>}}}
  cylinder {<0,0,0>,<0,-0.0002,0> 0.45 texture {pigment {leopard scale 0.005 color_map {[0 rgb <0.988,0.949,0.831>][1 rgb 0]} }}}
  };
  
#declare ceiling_sprinkler =
union {
  cylinder {<0,0,0>,<0,-0.05,0> 0.5 pigment {rgb 0.3}} // base
  cylinder {<0,0,0>,<0,-1.5,0> 0.05} // column 
  cylinder {<0,0,0>,< 0.5,-0.7,0> 0.02}
  cylinder {<0,0,0>,<-0.5,-0.7,0> 0.02}
  cylinder {<0,-1.5,0>,<0.5,-0.7,0> 0.02}
  cylinder {<0,-1.5,0>,<-0.5,-0.7,0> 0.02}
  cylinder {<0,-1.5,0>,<0,-1.6,0> 0.5}  // head
  texture {T_Chrome_3C} 
  scale 1/12 
  scale <2,1,2>
};   

// switch to units of feet
#macro draw_tiled_ceiling (x_len, z_len, style, flx, flz, xfrm)
  
  #ifndef (ceil_sd)
    #local ceil_sd = seed(8383);
  #end
  #local vent_count = 0;
  #local speaker_count =0;
  #local sprinkler_count = 0;
  
  #ifndef (ceiling_vents_spacing)
    #declare ceiling_vents_spacing = -1;
  #end
  
  #ifndef (ceiling_speaker_spacing)
    #declare ceiling_speaker_spacing = -1;
  #end 

  #ifndef (ceiling_sprinkler_spacing)
    #declare ceiling_sprinkler_spacing = -1;
  #end  
  
  
  #local rsd = seed(98833);
  
  #if (style = rect_ceiling_tiles)
    #local xt = 2;
    #local zt = 4;
    #local tile = object {rect_acoustic_tile}; 
    #local flourescent_light = object {rect_flourescent_light};
  #else
    #local xt = 2;
    #local zt = 2;
    #local tile = object {square_acoustic_tile};
    #local flourescent_light = object {square_flourescent_light};    
  #end
//  #include "rfdebug.inc"

  

  
  union {
    

    box {<0,0.5,0>, <x_len,1,z_len> texture {t_ceiling_light_glow_reflection}} // cover any holes and give flourescent tubes more glow
    
    #local j=0;
      #while (j<z_len)
        #local i=0;
        #while (i<x_len)
          
          
          #if (mod(i/xt,flx)=0) 
            #if (mod (j/zt,flz)=0)
              object {flourescent_light translate <j,0,i>} 
            #else
              object {tile translate <j,0,i>} 
            #end 
          #else                            
            #if (ceiling_vents_spacing>0)
              #local vent_count = vent_count +1;
              #if (mod(vent_count,ceiling_vents_spacing) = 0)
                object {ceiling_diffuser scale 2  translate <j,0,i> }
              #end
            #end
            #if (ceiling_speaker_spacing>0)
              #local speaker_count = speaker_count +1;
              #if (mod(speaker_count,ceiling_speaker_spacing) = 0)
                object {ceiling_speaker translate <j+3,-0.05,i+1>}  
              #end 
            #end
            #if (ceiling_sprinkler_spacing>0)
              #local sprinkler_count = sprinkler_count +1;
              #if (mod(sprinkler_count,ceiling_sprinkler_spacing) = 0)
                object {ceiling_sprinkler translate <j+3,-0.05,i+1>}  
              #end 
            #end

            
            object {tile translate <j,0,i>} 
          #end 
          
          // add some randomness to the vents and speakers         
          #if (rand(ceil_sd)<0.2)
             #local vent_count = vent_count + 2;
          #end
          #if (rand(ceil_sd)<0.2)
             #local speaker_count = speaker_count + 2;
          #end
        //  #debug concat("tile coords ", str(j,3,1), ",", str(i,3,1),"\n")
          
          #local i=i+xt;
        #end 
        
        #local j=j+zt;
      #end
    
    

    transform {xfrm}  
  }

#end
