//Persistence of Vision Ray Tracer Scene Description File
//File: dragon.pov
//Date: Nov 15, 2006 - December 2, 2006
//Author: MJP
// Entry to the IRTC, Nov/Dec 2006
// Topic: Complexity
// Complexity is a dragon; here is its face!
// Interestingly, this is one of the simplest scenes I have ever made.

#include "colors.inc"
//#include "functions.inc"

#declare phd = 1.0;	//used in photons
global_settings {
	assumed_gamma 1.8
	adc_bailout 1/255
	max_trace_level 25
	photons {
		count 15000
		jitter 0.4
		max_trace_level 3
	}
}

#version unofficial MegaPov 1.2;

/* 
	Lights, Camera, Stage
*/
#declare Light_Colour = <1,.8,.2>*1.8 ;
#declare SceneCam  = camera {
	perspective 
	location < 1/4, -.4, -3.3>*.81
//	right x * image_width up y * image_height
	right x*2.8 up y *2
	angle 48
	look_at <1/9,1.25,-1/3>
}
#declare OverviewCam  = camera {
	perspective 
	location < 1/4, -.4, -3.3>
	right x * image_width
	up y * image_height
	angle 40.5
	look_at <1/9,1.25,-1/3>
}
camera {SceneCam}
//camera {OverviewCam}
light_source { <1.5,5,6>/4 rgb Light_Colour/6
	photons { refraction on reflection on }
}
light_source { <2,1,6>/4 rgb Light_Colour/3
	photons { refraction on reflection on }
}
light_source { <0,0,3>*2 rgb Light_Colour*20
	photons { refraction on  reflection on  }
}
//object { #include "OriginMarker.inc"
//box { 0,1  pigment { rgbf .7 }
//	scale <1,1,-1>
//	translate <0,2/2,-1>
//}

sphere { 0, 1/8
	pigment { red .8 filter 1 }
	finish { reflection .1 ambient .5 }
	interior { ior 1.8 }
	translate <0,1.9,-.8>
}

background { White }
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 rgb 0]
			[0.15 rgb .1 red .55 ]
			[0.25 rgb <.87,.40,0>*1.3 ]
			[0.4 rgb <.5,.3,.2> ]
			[0.5 rgb <0.55,		0,	.15>*2	]
			[0.6 rgb <.5,.4,.2> ]
			[0.75 rgb <.87,.40,0>*1.3 ]
			[0.85 rgb .1 red .55 ]
			[1 rgb <1/2,1/4,2/3>*.4]
		}
		translate -y/2 scale 2 // map to whole sky sphere
	}
}

/* 
	Isosurface elements
*/

#declare Dragonball = function(x,y,z) { 
	0
	+x*x+y*y+z*z -4 // sphere, 2 unit
	+sin(3*pi*(x*x+y*y))/3 // woodgrain about z-axis
	+sin(3*pi*((z*z)*1.01+y*y))/5 // woodgrain about x-axis
	+sin(2*pi*(x*x+y*y+z*z))/10 // cloudshell
}
#if (1)
isosurface {
	function { Dragonball(1.2*x, y, z) }
	contained_by { sphere { 0 2.3 } }
	threshold 0.0
	accuracy 0.001
	max_gradient 18
	all_intersections
//	pigment { rgb <1.07,.8,.83>*.8 filter .75 }
	pigment { radial
		scale 2.3
		color_map {
			[ .1 rgb <1.33,.8,.83>*.9 filter .75 ]
			[ .6 rgb <1,1.2,.8>*.3 filter 1 ]
		}
	}
	hollow
	finish { phong .6 phong_size 30 }
	interior {
		ior 0.9  // this value is critical: too high, the dragon vanishes; too low, reflection hides it
		media {
			emission rgb <.25, .6, 0.1>*.6
			density {
				spherical
				color_map {
					[ 0 rgb .0 ]
					[ .4 rgb .05 ]
					[.6 rgb .4 ]
				}
				scale <3/2,1/3,3/2>*2.3
				turbulence <.3, .1, .3> octaves 2
			}
		}
	}
	photons { target 1 refraction on  reflection on }
}
#end
/*
	Smoke
*/
sphere { 0, 8
	pigment { rgbf 1 }
	hollow
	interior { media {
		absorption rgb <.8,.8,1.2>*.33
		density {
			agate
			color_map {
//				[ 0 rgb 0 ]
				[ .5 rgb 0 ]
				[ .6 rgb 1/6 ]
				[ 1 rgb 1/2 ]
			}
			turbulence <.3, .1, .3>*5 octaves 4
			scale <1, 1/20, 1>*3
		}
	}}
}
