/*
 * Operation Parameters Test
 *
 * This specification is intended for testing purposes. It demonstrates a wide range of combinations of the `style` and `explode` attributes for parameters in various locations: query, path, header, and cookie. The goal is to verify correct path and parameter generation for each case.
 *
 * API version: 1.0.0
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package openapi

import (
	"net/http"

	"github.com/gin-gonic/gin"
)

// Route is the information for every URI.
type Route struct {
	// Name is the name of this Route.
	Name string
	// Method is the string for the HTTP method. ex) GET, POST etc..
	Method string
	// Pattern is the pattern of the URI.
	Pattern string
	// HandlerFunc is the handler function of this route.
	HandlerFunc gin.HandlerFunc
}

// NewRouter returns a new router.
func NewRouter(handleFunctions ApiHandleFunctions) *gin.Engine {
	return NewRouterWithGinEngine(gin.Default(), handleFunctions)
}

// NewRouter add routes to existing gin engine.
func NewRouterWithGinEngine(router *gin.Engine, handleFunctions ApiHandleFunctions) *gin.Engine {
	for _, route := range getRoutes(handleFunctions) {
		if route.HandlerFunc == nil {
			route.HandlerFunc = DefaultHandleFunc
		}
		switch route.Method {
		case http.MethodGet:
			router.GET(route.Pattern, route.HandlerFunc)
		case http.MethodPost:
			router.POST(route.Pattern, route.HandlerFunc)
		case http.MethodPut:
			router.PUT(route.Pattern, route.HandlerFunc)
		case http.MethodPatch:
			router.PATCH(route.Pattern, route.HandlerFunc)
		case http.MethodDelete:
			router.DELETE(route.Pattern, route.HandlerFunc)
		}
	}

	return router
}

// Default handler for not yet implemented routes
func DefaultHandleFunc(c *gin.Context) {
	c.String(http.StatusNotImplemented, "501 not implemented")
}

type ApiHandleFunctions struct {

	// Routes for the TestAPI part of the API
	TestAPI TestAPI
}

func getRoutes(handleFunctions ApiHandleFunctions) []Route {
	return []Route{
		{
			"DeepObjectExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/deepObject-explode/deepObjectExplodeAnytype",
			handleFunctions.TestAPI.DeepObjectExplodeAnytype,
		},
		{
			"SeveralExplodeCookies",
			http.MethodPost,
			"/v2/cookie/several-cookies/form-explode/severalExplodeCookies",
			handleFunctions.TestAPI.SeveralExplodeCookies,
		},
		{
			"SeveralNotExplodeCookies",
			http.MethodPost,
			"/v2/cookie/several-cookies/form-not-explode/severalNotExplodeCookies",
			handleFunctions.TestAPI.SeveralNotExplodeCookies,
		},
		{
			"SeveralHeaderParametersOp",
			http.MethodPost,
			"/v2/header/several-headers/simple/severalHeaderParameters",
			handleFunctions.TestAPI.SeveralHeaderParametersOp,
		},
		{
			"CookieExplodeAnytype",
			http.MethodPost,
			"/v2/cookie/anytype/form-explode/cookieExplodeAnytype",
			handleFunctions.TestAPI.CookieExplodeAnytype,
		},
		{
			"CookieExplodeArray",
			http.MethodPost,
			"/v2/cookie/array/form-explode/cookieExplodeArray",
			handleFunctions.TestAPI.CookieExplodeArray,
		},
		{
			"CookieExplodeInt",
			http.MethodPost,
			"/v2/cookie/int/form-explode/cookieExplodeInt",
			handleFunctions.TestAPI.CookieExplodeInt,
		},
		{
			"CookieExplodeObject",
			http.MethodPost,
			"/v2/cookie/object/form-explode/cookieExplodeObject",
			handleFunctions.TestAPI.CookieExplodeObject,
		},
		{
			"CookieExplodeString",
			http.MethodPost,
			"/v2/cookie/string/form-explode/cookieExplodeString/:pathParam",
			handleFunctions.TestAPI.CookieExplodeString,
		},
		{
			"CookieExplodeStringMap",
			http.MethodPost,
			"/v2/cookie/map/string-mapping/form-explode/cookieExplodeMap",
			handleFunctions.TestAPI.CookieExplodeStringMap,
		},
		{
			"CookieNotExplodeAnytype",
			http.MethodPost,
			"/v2/cookie/anytype/form-not-explode/cookieNotExplodeAnytype",
			handleFunctions.TestAPI.CookieNotExplodeAnytype,
		},
		{
			"CookieNotExplodeArray",
			http.MethodPost,
			"/v2/cookie/array/form-not-explode/cookieNotExplodeArray",
			handleFunctions.TestAPI.CookieNotExplodeArray,
		},
		{
			"CookieNotExplodeInt",
			http.MethodPost,
			"/v2/cookie/int/form-not-explode/cookieNotExplodeInt",
			handleFunctions.TestAPI.CookieNotExplodeInt,
		},
		{
			"CookieNotExplodeObject",
			http.MethodPost,
			"/v2/cookie/object/form-not-explode/cookieNotExplodeObject",
			handleFunctions.TestAPI.CookieNotExplodeObject,
		},
		{
			"CookieNotExplodeString",
			http.MethodPost,
			"/v2/cookie/string/form-not-explode/cookieNotExplodeString/:pathParam",
			handleFunctions.TestAPI.CookieNotExplodeString,
		},
		{
			"CookieNotExplodeStringInvalidStyle",
			http.MethodPost,
			"/v2/cookie/string/invalid-simple-not-explode/cookieNotExplodeStringInvalidStyle",
			handleFunctions.TestAPI.CookieNotExplodeStringInvalidStyle,
		},
		{
			"CookieNotExplodeStringMap",
			http.MethodPost,
			"/v2/cookie/map/string-mapping/form-not-explode/cookieNotExplodeMap",
			handleFunctions.TestAPI.CookieNotExplodeStringMap,
		},
		{
			"DeepObjectExplodeModelMap",
			http.MethodPost,
			"/v2/query/map/model-mapping/deepObject-explode/deepObjectExplodeMap",
			handleFunctions.TestAPI.DeepObjectExplodeModelMap,
		},
		{
			"DeepObjectExplodeObject",
			http.MethodPost,
			"/v2/query/object/deepObject-explode/deepObjectExplodeObject",
			handleFunctions.TestAPI.DeepObjectExplodeObject,
		},
		{
			"DeepObjectExplodeStringMap",
			http.MethodPost,
			"/v2/query/map/string-mapping/deepObject-explode/deepObjectExplodeMap",
			handleFunctions.TestAPI.DeepObjectExplodeStringMap,
		},
		{
			"DeepObjectNotExplodeObject",
			http.MethodPost,
			"/v2/query/object/deepObject-not-explode/deepObjectNotExplodeObject",
			handleFunctions.TestAPI.DeepObjectNotExplodeObject,
		},
		{
			"FormExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/form-explode/formExplodeAnytype",
			handleFunctions.TestAPI.FormExplodeAnytype,
		},
		{
			"FormExplodeArray",
			http.MethodPost,
			"/v2/query/array/form-explode/formExplodeArray",
			handleFunctions.TestAPI.FormExplodeArray,
		},
		{
			"FormExplodeDifferentOptions",
			http.MethodPost,
			"/v2/query/strings/form-explode/formExplodeDifferentOptions",
			handleFunctions.TestAPI.FormExplodeDifferentOptions,
		},
		{
			"FormExplodeDouble",
			http.MethodPost,
			"/v2/query/double/form-explode/formExplodeDouble",
			handleFunctions.TestAPI.FormExplodeDouble,
		},
		{
			"FormExplodeFloat",
			http.MethodPost,
			"/v2/query/float/form-explode/formExplodeFloat",
			handleFunctions.TestAPI.FormExplodeFloat,
		},
		{
			"FormExplodeInt",
			http.MethodPost,
			"/v2/query/int/form-explode/formExplodeInt",
			handleFunctions.TestAPI.FormExplodeInt,
		},
		{
			"FormExplodeModelMap",
			http.MethodPost,
			"/v2/query/map/model-mapping/form-explode/formExplodeMap",
			handleFunctions.TestAPI.FormExplodeModelMap,
		},
		{
			"FormExplodeObject",
			http.MethodPost,
			"/v2/query/object/form-explode/formExplodeObject",
			handleFunctions.TestAPI.FormExplodeObject,
		},
		{
			"FormExplodeString",
			http.MethodPost,
			"/v2/query/string/form-explode/formExplodeString",
			handleFunctions.TestAPI.FormExplodeString,
		},
		{
			"FormExplodeStringMap",
			http.MethodPost,
			"/v2/query/map/string-mapping/form-explode/formExplodeMap",
			handleFunctions.TestAPI.FormExplodeStringMap,
		},
		{
			"FormExplodeStringOptions",
			http.MethodPost,
			"/v2/query/strings/form-explode/formExplodeStringOptions",
			handleFunctions.TestAPI.FormExplodeStringOptions,
		},
		{
			"FormNotExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/form-not-explode/formNotExplodeAnytype",
			handleFunctions.TestAPI.FormNotExplodeAnytype,
		},
		{
			"FormNotExplodeArray",
			http.MethodPost,
			"/v2/query/array/form-not-explode/formNotExplodeArray",
			handleFunctions.TestAPI.FormNotExplodeArray,
		},
		{
			"FormNotExplodeDouble",
			http.MethodPost,
			"/v2/query/double/form-not-explode/formNotExplodeDouble",
			handleFunctions.TestAPI.FormNotExplodeDouble,
		},
		{
			"FormNotExplodeFloat",
			http.MethodPost,
			"/v2/query/float/form-not-explode/formNotExplodeFloat",
			handleFunctions.TestAPI.FormNotExplodeFloat,
		},
		{
			"FormNotExplodeInt",
			http.MethodPost,
			"/v2/query/int/form-not-explode/formNotExplodeInt",
			handleFunctions.TestAPI.FormNotExplodeInt,
		},
		{
			"FormNotExplodeModelMap",
			http.MethodPost,
			"/v2/query/map/model-mapping/form-not-explode/formNotExplodeMap",
			handleFunctions.TestAPI.FormNotExplodeModelMap,
		},
		{
			"FormNotExplodeObject",
			http.MethodPost,
			"/v2/query/object/form-not-explode/formNotExplodeObject",
			handleFunctions.TestAPI.FormNotExplodeObject,
		},
		{
			"FormNotExplodeString",
			http.MethodPost,
			"/v2/query/string/form-not-explode/formNotExplodeString",
			handleFunctions.TestAPI.FormNotExplodeString,
		},
		{
			"FormNotExplodeStringMap",
			http.MethodPost,
			"/v2/query/map/string-mapping/form-not-explode/formNotExplodeMap",
			handleFunctions.TestAPI.FormNotExplodeStringMap,
		},
		{
			"InvalidDeepObjectNotExplodeArray",
			http.MethodPost,
			"/v2/query/array/invalid-deepObject-not-explode/deepObjectNotExplodeArray",
			handleFunctions.TestAPI.InvalidDeepObjectNotExplodeArray,
		},
		{
			"InvalidDeepObjectNotExplodeString",
			http.MethodPost,
			"/v2/query/string/invalid-deepObject-not-explode/deepObjectNotExplodeString",
			handleFunctions.TestAPI.InvalidDeepObjectNotExplodeString,
		},
		{
			"InvalidFormExplodeString",
			http.MethodPost,
			"/v2/path/string/invalid-form-explode/formExplodeString/:stringParameter",
			handleFunctions.TestAPI.InvalidFormExplodeString,
		},
		{
			"InvalidMatrixExplodeString",
			http.MethodPost,
			"/v2/query/string/invalid-matrix-explode/matrixExplodeString",
			handleFunctions.TestAPI.InvalidMatrixExplodeString,
		},
		{
			"LabelExplodeAnytype",
			http.MethodGet,
			"/v2/path/anytype/label-explode/:anytypeParameter",
			handleFunctions.TestAPI.LabelExplodeAnytype,
		},
		{
			"LabelExplodeArray",
			http.MethodGet,
			"/v2/path/array/label-explode/:arrayParameter",
			handleFunctions.TestAPI.LabelExplodeArray,
		},
		{
			"LabelExplodeDouble",
			http.MethodGet,
			"/v2/path/double/label-explode/:doubleParameter",
			handleFunctions.TestAPI.LabelExplodeDouble,
		},
		{
			"LabelExplodeFloat",
			http.MethodGet,
			"/v2/path/float/label-explode/:floatParameter",
			handleFunctions.TestAPI.LabelExplodeFloat,
		},
		{
			"LabelExplodeInt",
			http.MethodGet,
			"/v2/path/int/label-explode/:intParameter",
			handleFunctions.TestAPI.LabelExplodeInt,
		},
		{
			"LabelExplodeModelMap",
			http.MethodPost,
			"/v2/path/map/model-mapping/label-explode/:mapParameter",
			handleFunctions.TestAPI.LabelExplodeModelMap,
		},
		{
			"LabelExplodeObject",
			http.MethodGet,
			"/v2/path/object/label-explode/:objectParameter",
			handleFunctions.TestAPI.LabelExplodeObject,
		},
		{
			"LabelExplodeString",
			http.MethodGet,
			"/v2/path/string/label-explode/:stringParameter",
			handleFunctions.TestAPI.LabelExplodeString,
		},
		{
			"LabelExplodeStringMap",
			http.MethodPost,
			"/v2/path/map/string-mapping/label-explode/:mapParameter",
			handleFunctions.TestAPI.LabelExplodeStringMap,
		},
		{
			"LabelNotExplodeAnytype",
			http.MethodGet,
			"/v2/path/anytype/label-not-explode/:anytypeParameter",
			handleFunctions.TestAPI.LabelNotExplodeAnytype,
		},
		{
			"LabelNotExplodeArray",
			http.MethodGet,
			"/v2/path/array/label-not-explode/:arrayParameter",
			handleFunctions.TestAPI.LabelNotExplodeArray,
		},
		{
			"LabelNotExplodeDouble",
			http.MethodGet,
			"/v2/path/double/label-not-explode/:doubleParameter",
			handleFunctions.TestAPI.LabelNotExplodeDouble,
		},
		{
			"LabelNotExplodeFloat",
			http.MethodGet,
			"/v2/path/float/label-not-explode/:floatParameter",
			handleFunctions.TestAPI.LabelNotExplodeFloat,
		},
		{
			"LabelNotExplodeInt",
			http.MethodGet,
			"/v2/path/int/label-not-explode/:intParameter",
			handleFunctions.TestAPI.LabelNotExplodeInt,
		},
		{
			"LabelNotExplodeModelMap",
			http.MethodPost,
			"/v2/path/map/model-mapping/label-not-explode/:mapParameter",
			handleFunctions.TestAPI.LabelNotExplodeModelMap,
		},
		{
			"LabelNotExplodeObject",
			http.MethodPost,
			"/v2/path/object/label-not-explode/:objectParameter",
			handleFunctions.TestAPI.LabelNotExplodeObject,
		},
		{
			"LabelNotExplodeString",
			http.MethodGet,
			"/v2/path/string/label-not-explode/:stringParameter",
			handleFunctions.TestAPI.LabelNotExplodeString,
		},
		{
			"LabelNotExplodeStringMap",
			http.MethodPost,
			"/v2/path/map/string-mapping/label-not-explode/:mapParameter",
			handleFunctions.TestAPI.LabelNotExplodeStringMap,
		},
		{
			"LabelStringMatrixArrayNotExplode",
			http.MethodGet,
			"/v2/path/string/label-not-explode/array/matrix-not-explode/:stringParameter/:arrayParameter",
			handleFunctions.TestAPI.LabelStringMatrixArrayNotExplode,
		},
		{
			"MatrixExplodeAnytype",
			http.MethodGet,
			"/v2/path/anytype/matrix-explode/:anytypeParameter",
			handleFunctions.TestAPI.MatrixExplodeAnytype,
		},
		{
			"MatrixExplodeArray",
			http.MethodGet,
			"/v2/path/array/matrix-explode/:arrayParameter",
			handleFunctions.TestAPI.MatrixExplodeArray,
		},
		{
			"MatrixExplodeDouble",
			http.MethodGet,
			"/v2/path/double/matrix-explode/:doubleParameter",
			handleFunctions.TestAPI.MatrixExplodeDouble,
		},
		{
			"MatrixExplodeFloat",
			http.MethodGet,
			"/v2/path/float/matrix-explode/:floatParameter",
			handleFunctions.TestAPI.MatrixExplodeFloat,
		},
		{
			"MatrixExplodeInt",
			http.MethodGet,
			"/v2/path/int/matrix-explode/:intParameter",
			handleFunctions.TestAPI.MatrixExplodeInt,
		},
		{
			"MatrixExplodeModelMap",
			http.MethodPost,
			"/v2/path/map/model-mapping/matrix-explode/:mapParameter",
			handleFunctions.TestAPI.MatrixExplodeModelMap,
		},
		{
			"MatrixExplodeObject",
			http.MethodGet,
			"/v2/path/object/matrix-explode/:objectParameter",
			handleFunctions.TestAPI.MatrixExplodeObject,
		},
		{
			"MatrixExplodeString",
			http.MethodGet,
			"/v2/path/string/matrix-explode/:stringParameter",
			handleFunctions.TestAPI.MatrixExplodeString,
		},
		{
			"MatrixExplodeStringMap",
			http.MethodPost,
			"/v2/path/map/string-mapping/matrix-explode/:mapParameter",
			handleFunctions.TestAPI.MatrixExplodeStringMap,
		},
		{
			"MatrixNotExplodeAnytype",
			http.MethodGet,
			"/v2/path/anytype/matrix-not-explode/:anytypeParameter",
			handleFunctions.TestAPI.MatrixNotExplodeAnytype,
		},
		{
			"MatrixNotExplodeArray",
			http.MethodGet,
			"/v2/path/array/matrix-not-explode/:arrayParameter",
			handleFunctions.TestAPI.MatrixNotExplodeArray,
		},
		{
			"MatrixNotExplodeDouble",
			http.MethodGet,
			"/v2/path/double/matrix-not-explode/:doubleParameter",
			handleFunctions.TestAPI.MatrixNotExplodeDouble,
		},
		{
			"MatrixNotExplodeFloat",
			http.MethodGet,
			"/v2/path/float/matrix-not-explode/:floatParameter",
			handleFunctions.TestAPI.MatrixNotExplodeFloat,
		},
		{
			"MatrixNotExplodeInt",
			http.MethodGet,
			"/v2/path/int/matrix-not-explode/:intParameter",
			handleFunctions.TestAPI.MatrixNotExplodeInt,
		},
		{
			"MatrixNotExplodeModelMap",
			http.MethodPost,
			"/v2/path/map/model-mapping/matrix-not-explode/:mapParameter",
			handleFunctions.TestAPI.MatrixNotExplodeModelMap,
		},
		{
			"MatrixNotExplodeObject",
			http.MethodGet,
			"/v2/path/object/matrix-not-explode/:objectParameter",
			handleFunctions.TestAPI.MatrixNotExplodeObject,
		},
		{
			"MatrixNotExplodeString",
			http.MethodGet,
			"/v2/path/string/matrix-not-explode/:stringParameter",
			handleFunctions.TestAPI.MatrixNotExplodeString,
		},
		{
			"MatrixNotExplodeStringMap",
			http.MethodPost,
			"/v2/path/map/string-mapping/matrix-not-explode/:mapParameter",
			handleFunctions.TestAPI.MatrixNotExplodeStringMap,
		},
		{
			"PipeDelimitedExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/pipeDelimited-explode/pipeDelimitedExplodeAnytype",
			handleFunctions.TestAPI.PipeDelimitedExplodeAnytype,
		},
		{
			"PipeDelimitedExplodeArray",
			http.MethodPost,
			"/v2/query/array/pipeDelimited-explode/pipeDelimitedExplodeArray",
			handleFunctions.TestAPI.PipeDelimitedExplodeArray,
		},
		{
			"PipeDelimitedExplodeObject",
			http.MethodPost,
			"/v2/query/object/pipeDelimited-explode/pipeDelimitedExplodeObject",
			handleFunctions.TestAPI.PipeDelimitedExplodeObject,
		},
		{
			"PipeDelimitedNotExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/pipeDelimited-not-explode/pipeDelimitedNotExplodeAnytype",
			handleFunctions.TestAPI.PipeDelimitedNotExplodeAnytype,
		},
		{
			"PipeDelimitedNotExplodeArray",
			http.MethodPost,
			"/v2/query/array/pipeDelimited-not-explode/pipeDelimitedNotExplodeArray",
			handleFunctions.TestAPI.PipeDelimitedNotExplodeArray,
		},
		{
			"PipeDelimitedNotExplodeModelMap",
			http.MethodPost,
			"/v2/query/map/model-mapping/pipeDelimited-not-explode/pipeDelimitedNotExplodeMap",
			handleFunctions.TestAPI.PipeDelimitedNotExplodeModelMap,
		},
		{
			"PipeDelimitedNotExplodeObject",
			http.MethodPost,
			"/v2/query/object/pipeDelimited-not-explode/pipeDelimitedNotExplodeObject",
			handleFunctions.TestAPI.PipeDelimitedNotExplodeObject,
		},
		{
			"PipeDelimitedNotExplodeStringMap",
			http.MethodPost,
			"/v2/query/map/string-mapping/pipeDelimited-not-explode/pipeDelimitedNotExplodeMap",
			handleFunctions.TestAPI.PipeDelimitedNotExplodeStringMap,
		},
		{
			"SimpleExplodeAnytype",
			http.MethodGet,
			"/v2/path/anytype/simple-explode/:anytypeParameter",
			handleFunctions.TestAPI.SimpleExplodeAnytype,
		},
		{
			"SimpleExplodeArray",
			http.MethodGet,
			"/v2/path/array/simple-explode/:arrayParameter",
			handleFunctions.TestAPI.SimpleExplodeArray,
		},
		{
			"SimpleExplodeDouble",
			http.MethodGet,
			"/v2/path/double/simple-explode/:doubleParameter",
			handleFunctions.TestAPI.SimpleExplodeDouble,
		},
		{
			"SimpleExplodeFloat",
			http.MethodGet,
			"/v2/path/float/simple-explode/:floatParameter",
			handleFunctions.TestAPI.SimpleExplodeFloat,
		},
		{
			"SimpleExplodeInt",
			http.MethodGet,
			"/v2/path/int/simple-explode/:intParameter",
			handleFunctions.TestAPI.SimpleExplodeInt,
		},
		{
			"SimpleExplodeModelMap",
			http.MethodPost,
			"/v2/path/map/model-mapping/simple-explode/:mapParameter",
			handleFunctions.TestAPI.SimpleExplodeModelMap,
		},
		{
			"SimpleExplodeObject",
			http.MethodGet,
			"/v2/path/object/simple-explode/:objectParameter",
			handleFunctions.TestAPI.SimpleExplodeObject,
		},
		{
			"SimpleExplodeString",
			http.MethodGet,
			"/v2/path/string/simple-explode/:stringParameter",
			handleFunctions.TestAPI.SimpleExplodeString,
		},
		{
			"SimpleExplodeStringMap",
			http.MethodPost,
			"/v2/path/map/string-mapping/simple-explode/:mapParameter",
			handleFunctions.TestAPI.SimpleExplodeStringMap,
		},
		{
			"SimpleExplodeStrings",
			http.MethodGet,
			"/v2/path/strings/simple-explode/:stringParameter1/:stringParameter2",
			handleFunctions.TestAPI.SimpleExplodeStrings,
		},
		{
			"SimpleNotExplodeAnytype",
			http.MethodGet,
			"/v2/path/anytype/simple-not-explode/:anytypeParameter",
			handleFunctions.TestAPI.SimpleNotExplodeAnytype,
		},
		{
			"SimpleNotExplodeArray",
			http.MethodGet,
			"/v2/path/array/simple-not-explode/:arrayParameter",
			handleFunctions.TestAPI.SimpleNotExplodeArray,
		},
		{
			"SimpleNotExplodeDouble",
			http.MethodGet,
			"/v2/path/double/simple-not-explode/:doubleParameter",
			handleFunctions.TestAPI.SimpleNotExplodeDouble,
		},
		{
			"SimpleNotExplodeFloat",
			http.MethodGet,
			"/v2/path/float/simple-not-explode/:floatParameter",
			handleFunctions.TestAPI.SimpleNotExplodeFloat,
		},
		{
			"SimpleNotExplodeInt",
			http.MethodGet,
			"/v2/path/int/simple-not-explode/:intParameter",
			handleFunctions.TestAPI.SimpleNotExplodeInt,
		},
		{
			"SimpleNotExplodeModelMap",
			http.MethodPost,
			"/v2/path/map/model-mapping/simple-not-explode/:mapParameter",
			handleFunctions.TestAPI.SimpleNotExplodeModelMap,
		},
		{
			"SimpleNotExplodeObject",
			http.MethodGet,
			"/v2/path/object/simple-not-explode/:objectParameter",
			handleFunctions.TestAPI.SimpleNotExplodeObject,
		},
		{
			"SimpleNotExplodeString",
			http.MethodGet,
			"/v2/path/string/simple-not-explode/:stringParameter",
			handleFunctions.TestAPI.SimpleNotExplodeString,
		},
		{
			"SimpleNotExplodeStringMap",
			http.MethodPost,
			"/v2/path/map/string-mapping/simple-not-explode/:mapParameter",
			handleFunctions.TestAPI.SimpleNotExplodeStringMap,
		},
		{
			"SpaceDelimitedExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/spaceDelimited-explode/spaceDelimitedExplodeAnytype",
			handleFunctions.TestAPI.SpaceDelimitedExplodeAnytype,
		},
		{
			"SpaceDelimitedExplodeArray",
			http.MethodPost,
			"/v2/query/array/spaceDelimited-explode/spaceDelimitedExplodeArray",
			handleFunctions.TestAPI.SpaceDelimitedExplodeArray,
		},
		{
			"SpaceDelimitedExplodeObject",
			http.MethodPost,
			"/v2/query/object/spaceDelimited-explode/spaceDelimitedExplodeObject",
			handleFunctions.TestAPI.SpaceDelimitedExplodeObject,
		},
		{
			"SpaceDelimitedNotExplodeAnytype",
			http.MethodPost,
			"/v2/query/anytype/spaceDelimited-not-explode/spaceDelimitedNotExplodeAnytype",
			handleFunctions.TestAPI.SpaceDelimitedNotExplodeAnytype,
		},
		{
			"SpaceDelimitedNotExplodeArray",
			http.MethodPost,
			"/v2/query/array/spaceDelimited-not-explode/spaceDelimitedNotExplodeArray",
			handleFunctions.TestAPI.SpaceDelimitedNotExplodeArray,
		},
		{
			"SpaceDelimitedNotExplodeModelMap",
			http.MethodPost,
			"/v2/query/map/model-mapping/spaceDelimited-not-explode/spaceDelimitedNotExplodeMap",
			handleFunctions.TestAPI.SpaceDelimitedNotExplodeModelMap,
		},
		{
			"SpaceDelimitedNotExplodeObject",
			http.MethodPost,
			"/v2/query/object/spaceDelimited-not-explode/spaceDelimitedNotExplodeObject",
			handleFunctions.TestAPI.SpaceDelimitedNotExplodeObject,
		},
		{
			"SpaceDelimitedNotExplodeStringMap",
			http.MethodPost,
			"/v2/query/map/string-mapping/spaceDelimited-not-explode/spaceDelimitedNotExplodeMap",
			handleFunctions.TestAPI.SpaceDelimitedNotExplodeStringMap,
		},
		{
			"SpaceDelimitedNotExplodeString",
			http.MethodPost,
			"/v2/query/string/spaceDelimited-not-explode/spaceDelimitedNotExplodeString",
			handleFunctions.TestAPI.SpaceDelimitedNotExplodeString,
		},
		{
			"HeaderSimpleExplodeAnytype",
			http.MethodPost,
			"/v2/header/anytype/simple-explode/anytypeParameter",
			handleFunctions.TestAPI.HeaderSimpleExplodeAnytype,
		},
		{
			"HeaderSimpleExplodeArray",
			http.MethodGet,
			"/v2/header/array/simple-explode/arrayParameter",
			handleFunctions.TestAPI.HeaderSimpleExplodeArray,
		},
		{
			"HeaderSimpleExplodeMap",
			http.MethodPost,
			"/v2/header/map/simple-explode/mapParameter",
			handleFunctions.TestAPI.HeaderSimpleExplodeMap,
		},
		{
			"HeaderSimpleExplodeObject",
			http.MethodGet,
			"/v2/header/object/simple-explode/objectParameter",
			handleFunctions.TestAPI.HeaderSimpleExplodeObject,
		},
		{
			"HeaderSimpleExplodeString",
			http.MethodGet,
			"/v2/header/string/simple-explode/stringParameter",
			handleFunctions.TestAPI.HeaderSimpleExplodeString,
		},
		{
			"HeaderSimpleNotExplodeAnytype",
			http.MethodGet,
			"/v2/header/anytype/simple-not-explode/anytypeParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeAnytype,
		},
		{
			"HeaderSimpleNotExplodeArray",
			http.MethodPost,
			"/v2/header/array/simple-not-explode/arrayParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeArray,
		},
		{
			"HeaderSimpleNotExplodeMap",
			http.MethodGet,
			"/v2/header/map/simple-not-explode/mapParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeMap,
		},
		{
			"HeaderSimpleNotExplodeObject",
			http.MethodPost,
			"/v2/header/object/simple-not-explode/objectParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeObject,
		},
		{
			"HeaderSimpleNotExplodeString",
			http.MethodGet,
			"/v2/header/string/simple-not-explode/stringParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeString,
		},
		{
			"HeaderInvalidLabelNotExplodeString",
			http.MethodGet,
			"/v2/header/string/invalid-label-not-explode/stringParameter",
			handleFunctions.TestAPI.HeaderInvalidLabelNotExplodeString,
		},
		{
			"HeaderSimpleNotExplodeContentType",
			http.MethodGet,
			"/v2/header/bad-header-name/simple-not-explode/operatoinParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeContentType,
		},
		{
			"HeaderSimpleNotExplodeCustomDevidedString",
			http.MethodGet,
			"/v2/header/string-custom-devided/simple-not-explode/stringParameter",
			handleFunctions.TestAPI.HeaderSimpleNotExplodeCustomDevidedString,
		},
		{
			"QueryAndPathParams",
			http.MethodPost,
			"/v2/path/string/matrix-explode/:stringParameter/query/array/spaceDelimited-not-explode",
			handleFunctions.TestAPI.QueryAndPathParams,
		},
		{
			"InvalidStylesQueryPathParams",
			http.MethodPost,
			"/v2/path/string/invalid-form-explode/:stringParameter/query/array/invalid-label-explode",
			handleFunctions.TestAPI.InvalidStylesQueryPathParams,
		},
	}
}
