/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.qtproject.qt5.android.QtNative;

public class QtSurface
extends SurfaceView
implements SurfaceHolder.Callback {
    private GestureDetector m_gestureDetector;
    private Object m_accessibilityDelegate = null;

    public QtSurface(Context context, int n, boolean bl, int n2) {
        super(context);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.setZOrderMediaOverlay(bl);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        if (n2 == 16) {
            this.getHolder().setFormat(4);
        } else {
            this.getHolder().setFormat(1);
        }
        if (Build.VERSION.SDK_INT < 11) {
            this.getHolder().setType(2);
        }
        this.setId(n);
        this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                QtNative.longPress(QtSurface.this.getId(), (int)motionEvent.getX(), (int)motionEvent.getY());
            }
        });
        this.m_gestureDetector.setIsLongpressEnabled(true);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        QtNative.setSurface(this.getId(), surfaceHolder.getSurface(), this.getWidth(), this.getHeight());
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Class<?> clazz = Class.forName("org.qtproject.qt5.android.accessibility.QtAccessibilityDelegate");
                Constructor<?> constructor = clazz.getConstructor(Class.forName("android.view.View"));
                this.m_accessibilityDelegate = constructor.newInstance(new Object[]{this});
                Class<?> clazz2 = Class.forName("android.view.View$AccessibilityDelegate");
                Method method = ((Object)((Object)this)).getClass().getMethod("setAccessibilityDelegate", clazz2);
                method.invoke((Object)this, this.m_accessibilityDelegate);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                Log.w((String)"Qt A11y", (String)("Unknown exception: " + exception.toString()));
            }
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            return;
        }
        QtNative.setSurface(this.getId(), surfaceHolder.getSurface(), n2, n3);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        QtNative.setSurface(this.getId(), null, 0, 0);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        QtNative.sendTouchEvent(motionEvent, this.getId());
        this.m_gestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        QtNative.sendTrackballEvent(motionEvent, this.getId());
        return true;
    }
}

