/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.util.Log;

public class QtNfc {
    private static final String TAG = "QtNfc";
    public static NfcAdapter m_adapter = null;
    public static PendingIntent m_pendingIntent = null;
    public static IntentFilter[] m_filters;
    public static Activity m_activity;

    public static void setContext(Context context) {
        if (!(context instanceof Activity)) {
            Log.w((String)TAG, (String)"NFC only works with Android activities and not in Android services. NFC has been disabled.");
            return;
        }
        m_activity = (Activity)context;
        m_adapter = NfcAdapter.getDefaultAdapter((Context)m_activity);
        if (m_adapter == null) {
            return;
        }
        m_pendingIntent = PendingIntent.getActivity((Context)m_activity, (int)0, (Intent)new Intent((Context)m_activity, m_activity.getClass()).addFlags(0x20000000), (int)0);
        IntentFilter intentFilter = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
        m_filters = new IntentFilter[]{intentFilter};
        try {
            intentFilter.addDataType("*/*");
        }
        catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
            throw new RuntimeException("Fail", malformedMimeTypeException);
        }
    }

    public static boolean start() {
        if (m_adapter == null) {
            return false;
        }
        m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IntentFilter[] intentFilterArray = new IntentFilter[2];
                intentFilterArray[0] = new IntentFilter();
                intentFilterArray[0].addAction("android.nfc.action.NDEF_DISCOVERED");
                intentFilterArray[0].addCategory("android.intent.category.DEFAULT");
                try {
                    intentFilterArray[0].addDataType("*/*");
                }
                catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                    throw new RuntimeException("Check your mime type.");
                }
                intentFilterArray[1] = new IntentFilter();
                intentFilterArray[1].addAction("android.nfc.action.TECH_DISCOVERED");
                String[][] stringArray = new String[][]{{"android.nfc.tech.Ndef"}, {"android.nfc.tech.NdefFormatable"}};
                try {
                    m_adapter.enableForegroundDispatch(m_activity, m_pendingIntent, intentFilterArray, stringArray);
                }
                catch (IllegalStateException illegalStateException) {
                    Log.d((String)QtNfc.TAG, (String)("enableForegroundDispatch failed: " + illegalStateException.toString()));
                }
            }
        });
        return true;
    }

    public static boolean stop() {
        if (m_adapter == null) {
            return false;
        }
        m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    m_adapter.disableForegroundDispatch(m_activity);
                }
                catch (IllegalStateException illegalStateException) {
                    Log.d((String)QtNfc.TAG, (String)("disableForegroundDispatch failed: " + illegalStateException.toString()));
                }
            }
        });
        return true;
    }

    public static boolean isAvailable() {
        m_adapter = NfcAdapter.getDefaultAdapter((Context)m_activity);
        if (m_adapter == null) {
            return false;
        }
        return m_adapter.isEnabled();
    }

    public static Intent getStartIntent() {
        Log.d((String)TAG, (String)"getStartIntent");
        if (m_activity == null) {
            return null;
        }
        Intent intent = m_activity.getIntent();
        if ("android.nfc.action.NDEF_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TECH_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TAG_DISCOVERED".equals(intent.getAction())) {
            return intent;
        }
        return null;
    }
}

