/*
 * Copyright (C) 2007, 2013 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef ChangeVersionWrapper_h
#define ChangeVersionWrapper_h

#include <memory>
#include "modules/webdatabase/SQLTransactionBackend.h"
#include "platform/heap/Handle.h"
#include "platform/wtf/Forward.h"

namespace blink {

class SQLErrorData;

class ChangeVersionWrapper final : public SQLTransactionWrapper {
 public:
  static ChangeVersionWrapper* Create(const String& old_version,
                                      const String& new_version) {
    return new ChangeVersionWrapper(old_version, new_version);
  }

  bool PerformPreflight(SQLTransactionBackend*) override;
  bool PerformPostflight(SQLTransactionBackend*) override;
  SQLErrorData* SqlError() const override { return sql_error_.get(); }
  void HandleCommitFailedAfterPostflight(SQLTransactionBackend*) override;

 private:
  ChangeVersionWrapper(const String& old_version, const String& new_version);

  String old_version_;
  String new_version_;
  std::unique_ptr<SQLErrorData> sql_error_;
};

}  // namespace blink

#endif  // ChangeVersionWrapper_h
