/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ConfigurationLoader {
    private static final Log LOG = LogFactory.getLog(ConfigurationLoader.class);
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Check Configuration 1.0//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/configuration_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Check Configuration 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/configuration_1_1.dtd";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Check Configuration 1.2//EN";
    private static final String DTD_RESOURCE_NAME_1_2 = "com/puppycrawl/tools/checkstyle/configuration_1_2.dtd";
    private static final String DTD_PUBLIC_ID_1_3 = "-//Puppy Crawl//DTD Check Configuration 1.3//EN";
    private static final String DTD_RESOURCE_NAME_1_3 = "com/puppycrawl/tools/checkstyle/configuration_1_3.dtd";
    private final InternalLoader saxHandler;
    private final PropertyResolver overridePropsResolver;
    private final Deque<DefaultConfiguration> configStack = new ArrayDeque<DefaultConfiguration>();
    private Configuration configuration;
    private final boolean omitIgnoredModules;

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap<String, String> map = Maps.newHashMap();
        map.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        map.put(DTD_PUBLIC_ID_1_2, DTD_RESOURCE_NAME_1_2);
        map.put(DTD_PUBLIC_ID_1_3, DTD_RESOURCE_NAME_1_3);
        return map;
    }

    private ConfigurationLoader(PropertyResolver overrideProps, boolean omitIgnoredModules) throws ParserConfigurationException, SAXException {
        this.saxHandler = new InternalLoader();
        this.overridePropsResolver = overrideProps;
        this.omitIgnoredModules = omitIgnoredModules;
    }

    private void parseInputSource(InputSource source) throws IOException, SAXException {
        this.saxHandler.parseInputSource(source);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(config, overridePropsResolver, false);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver, boolean omitIgnoredModules) throws CheckstyleException {
        try {
            URI uri;
            try {
                URL url = new URL(config);
                uri = url.toURI();
            }
            catch (MalformedURLException ex) {
                uri = null;
            }
            catch (URISyntaxException ex) {
                uri = null;
            }
            if (uri == null) {
                File file = new File(config);
                if (file.exists()) {
                    uri = file.toURI();
                } else {
                    try {
                        URL configUrl = ConfigurationLoader.class.getResource(config);
                        if (configUrl == null) {
                            throw new FileNotFoundException(config);
                        }
                        uri = configUrl.toURI();
                    }
                    catch (URISyntaxException e) {
                        throw new FileNotFoundException(config);
                    }
                }
            }
            InputSource source = new InputSource(uri.toString());
            return ConfigurationLoader.loadConfiguration(source, overridePropsResolver, omitIgnoredModules);
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + config, e);
        }
        catch (CheckstyleException e) {
            throw new CheckstyleException("unable to read " + config + " - " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static Configuration loadConfiguration(InputStream configStream, PropertyResolver overridePropsResolver, boolean omitIgnoredModules) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(new InputSource(configStream), overridePropsResolver, omitIgnoredModules);
    }

    public static Configuration loadConfiguration(InputSource configSource, PropertyResolver overridePropsResolver, boolean omitIgnoredModules) throws CheckstyleException {
        try {
            ConfigurationLoader loader = new ConfigurationLoader(overridePropsResolver, omitIgnoredModules);
            loader.parseInputSource(configSource);
            return loader.getConfiguration();
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse configuration stream", e);
        }
        catch (SAXParseException e) {
            throw new CheckstyleException("unable to parse configuration stream - " + e.getMessage() + ":" + e.getLineNumber() + ":" + e.getColumnNumber(), e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse configuration stream - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read from stream", e);
        }
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    static String replaceProperties(String value, PropertyResolver props, String defaultValue) throws CheckstyleException {
        if (value == null) {
            return null;
        }
        ArrayList<String> fragments = Lists.newArrayList();
        ArrayList<String> propertyRefs = Lists.newArrayList();
        ConfigurationLoader.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder sb = new StringBuilder();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String propertyName;
            String fragment = (String)i.next();
            if (fragment == null && (fragment = props.resolve(propertyName = (String)j.next())) == null) {
                if (defaultValue != null) {
                    return defaultValue;
                }
                throw new CheckstyleException("Property ${" + propertyName + "} has not been set");
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String value, List<String> fragments, List<String> propertyRefs) throws CheckstyleException {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '$') {
                    fragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new CheckstyleException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }

    private final class InternalLoader
    extends AbstractLoader {
        private static final String MODULE = "module";
        private static final String NAME = "name";
        private static final String PROPERTY = "property";
        private static final String VALUE = "value";
        private static final String DEFAULT = "default";
        private static final String SEVERITY = "severity";
        private static final String MESSAGE = "message";
        private static final String KEY = "key";

        private InternalLoader() throws SAXException, ParserConfigurationException {
            super(ConfigurationLoader.createIdToResourceNameMap());
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals(MODULE)) {
                String name = atts.getValue(NAME);
                DefaultConfiguration conf = new DefaultConfiguration(name);
                if (ConfigurationLoader.this.configuration == null) {
                    ConfigurationLoader.this.configuration = conf;
                }
                if (!ConfigurationLoader.this.configStack.isEmpty()) {
                    DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                    top.addChild(conf);
                }
                ConfigurationLoader.this.configStack.push(conf);
            } else if (qName.equals(PROPERTY)) {
                String value;
                String name = atts.getValue(NAME);
                try {
                    value = ConfigurationLoader.replaceProperties(atts.getValue(VALUE), ConfigurationLoader.this.overridePropsResolver, atts.getValue(DEFAULT));
                }
                catch (CheckstyleException ex) {
                    throw new SAXException(ex.getMessage());
                }
                DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                top.addAttribute(name, value);
            } else if (qName.equals(MESSAGE)) {
                String key = atts.getValue(KEY);
                String value = atts.getValue(VALUE);
                DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                top.addMessage(key, value);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals(MODULE)) {
                boolean omitModule;
                Configuration recentModule = (Configuration)ConfigurationLoader.this.configStack.pop();
                SeverityLevel level = null;
                try {
                    String severity = recentModule.getAttribute(SEVERITY);
                    level = SeverityLevel.getInstance(severity);
                }
                catch (CheckstyleException e) {
                    LOG.debug("Severity not set, ignoring exception", e);
                }
                boolean bl = omitModule = ConfigurationLoader.this.omitIgnoredModules && SeverityLevel.IGNORE == level;
                if (omitModule && !ConfigurationLoader.this.configStack.isEmpty()) {
                    DefaultConfiguration parentModule = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                    parentModule.removeChild(recentModule);
                }
            }
        }
    }
}

