/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;
import java.util.TreeMap;

public class OneTopLevelClassCheck
extends Check {
    public static final String MSG_KEY = "one.top.level.class";
    private boolean publicTypeFound;
    private TreeMap<Integer, String> lineNumberTypeMap = new TreeMap();

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        for (DetailAST currentNode = rootAST; currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getType() != 14 && currentNode.getType() != 154 && currentNode.getType() != 15) continue;
            if (this.isPublic(currentNode)) {
                this.publicTypeFound = true;
                continue;
            }
            String typeName = currentNode.findFirstToken(58).getText();
            this.lineNumberTypeMap.put(currentNode.getLineNo(), typeName);
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (!this.publicTypeFound && !this.lineNumberTypeMap.isEmpty()) {
            this.lineNumberTypeMap.remove(this.lineNumberTypeMap.firstKey());
        }
        for (Map.Entry<Integer, String> entry : this.lineNumberTypeMap.entrySet()) {
            this.log((int)entry.getKey(), MSG_KEY, entry.getValue());
        }
        this.lineNumberTypeMap.clear();
        this.publicTypeFound = false;
    }

    private boolean isPublic(DetailAST typeDef) {
        DetailAST modifiers = typeDef.findFirstToken(5);
        return modifiers.findFirstToken(62) != null;
    }
}

