/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportOrderOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportOrderCheck
extends AbstractOptionCheck<ImportOrderOption> {
    public static final String MSG_SEPARATION = "import.separation";
    public static final String MSG_ORDERING = "import.ordering";
    private static final String WILDCARD_GROUP_NAME = "*";
    private Pattern[] groups = new Pattern[0];
    private boolean separated;
    private boolean ordered = true;
    private boolean caseSensitive = true;
    private int lastGroup;
    private int lastImportLine;
    private String lastImport;
    private boolean lastImportStatic;
    private boolean beforeFirstImport;
    private boolean sortStaticImportsAlphabetically;

    public ImportOrderCheck() {
        super(ImportOrderOption.UNDER, ImportOrderOption.class);
    }

    public void setGroups(String[] packageGroups) {
        this.groups = new Pattern[packageGroups.length];
        for (int i = 0; i < packageGroups.length; ++i) {
            Pattern grp;
            String pkg = packageGroups[i];
            if (WILDCARD_GROUP_NAME.equals(pkg)) {
                grp = Pattern.compile("");
            } else if (pkg.startsWith("/")) {
                if (!pkg.endsWith("/")) {
                    throw new IllegalArgumentException("Invalid group");
                }
                pkg = pkg.substring(1, pkg.length() - 1);
                grp = Pattern.compile(pkg);
            } else {
                if (!pkg.endsWith(".")) {
                    pkg = pkg + ".";
                }
                grp = Pattern.compile("^" + Pattern.quote(pkg));
            }
            this.groups[i] = grp;
        }
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setSeparated(boolean separated) {
        this.separated = separated;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setSortStaticImportsAlphabetically(boolean sortAlphabetically) {
        this.sortStaticImportsAlphabetically = sortAlphabetically;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.lastGroup = Integer.MIN_VALUE;
        this.lastImportLine = Integer.MIN_VALUE;
        this.lastImport = "";
        this.lastImportStatic = false;
        this.beforeFirstImport = true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isStatic;
        FullIdent ident;
        if (ast.getType() == 30) {
            ident = FullIdent.createFullIdentBelow(ast);
            isStatic = false;
        } else {
            ident = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
            isStatic = true;
        }
        switch ((ImportOrderOption)((Object)this.getAbstractOption())) {
            case TOP: {
                if (!isStatic && this.lastImportStatic) {
                    this.lastGroup = Integer.MIN_VALUE;
                    this.lastImport = "";
                }
            }
            case ABOVE: {
                this.doVisitToken(ident, isStatic, !this.lastImportStatic && isStatic);
                break;
            }
            case INFLOW: {
                this.doVisitToken(ident, isStatic, true);
                break;
            }
            case BOTTOM: {
                if (isStatic && !this.lastImportStatic) {
                    this.lastGroup = Integer.MIN_VALUE;
                    this.lastImport = "";
                }
            }
            case UNDER: {
                this.doVisitToken(ident, isStatic, this.lastImportStatic && !isStatic);
                break;
            }
        }
        this.lastImportLine = ast.findFirstToken(45).getLineNo();
        this.lastImportStatic = isStatic;
        this.beforeFirstImport = false;
    }

    private void doVisitToken(FullIdent ident, boolean isStatic, boolean previous) {
        if (ident != null) {
            String name = ident.getText();
            int groupIdx = this.getGroupNumber(name);
            int line = ident.getLineNo();
            if (groupIdx > this.lastGroup) {
                if (!this.beforeFirstImport && this.separated && line - this.lastImportLine < 2) {
                    this.log(line, MSG_SEPARATION, name);
                }
            } else if (groupIdx == this.lastGroup || this.sortStaticImportsAlphabetically && this.isAlphabeticallySortableStaticImport(isStatic)) {
                this.doVisitTokenInSameGroup(isStatic, previous, name, line);
            } else {
                this.log(line, MSG_ORDERING, name);
            }
            this.lastGroup = groupIdx;
            this.lastImport = name;
        }
    }

    private boolean isAlphabeticallySortableStaticImport(boolean isStatic) {
        boolean result = false;
        if (isStatic && (this.getAbstractOption() == ImportOrderOption.TOP || this.getAbstractOption() == ImportOrderOption.BOTTOM)) {
            result = true;
        }
        return result;
    }

    private void doVisitTokenInSameGroup(boolean isStatic, boolean previous, String name, int line) {
        if (!this.ordered) {
            return;
        }
        if (this.getAbstractOption() == ImportOrderOption.INFLOW) {
            if (ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0) {
                this.log(line, MSG_ORDERING, name);
            }
        } else {
            boolean shouldFireError;
            boolean bl = shouldFireError = !(this.lastImportStatic ^ isStatic) && ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0 || previous;
            if (shouldFireError) {
                this.log(line, MSG_ORDERING, name);
            }
        }
    }

    private int getGroupNumber(String name) {
        int bestIndex = this.groups.length;
        int bestLength = -1;
        int bestPos = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            Matcher matcher = this.groups[i].matcher(name);
            while (matcher.find()) {
                int length = matcher.end() - matcher.start();
                if (length <= bestLength && (length != bestLength || matcher.start() >= bestPos)) continue;
                bestIndex = i;
                bestLength = length;
                bestPos = matcher.start();
            }
        }
        return bestIndex;
    }

    private static int compare(String string1, String string2, boolean caseSensitive) {
        int result = caseSensitive ? string1.compareTo(string2) : string1.compareToIgnoreCase(string2);
        return result;
    }
}

