/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;

public class JavaNCSSCheck
extends Check {
    public static final String MSG_METHOD = "ncss.method";
    public static final String MSG_CLASS = "ncss.class";
    public static final String MSG_FILE = "ncss.file";
    private static final int FILE_MAX_NCSS = 2000;
    private static final int CLASS_MAX_NCSS = 1500;
    private static final int METHOD_MAX_NCSS = 50;
    private int fileMax = 2000;
    private int classMax = 1500;
    private int methodMax = 50;
    private Deque<Counter> counters;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.counters = new ArrayDeque<Counter>();
        this.counters.push(new Counter());
    }

    @Override
    public void visitToken(DetailAST ast) {
        int tokenType = ast.getType();
        if (14 == tokenType || 9 == tokenType || 8 == tokenType || 12 == tokenType || 11 == tokenType) {
            this.counters.push(new Counter());
        }
        if (this.isCountable(ast)) {
            for (Counter c : this.counters) {
                c.increment();
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        Counter counter;
        int count;
        int tokenType = ast.getType();
        if (9 == tokenType || 8 == tokenType || 12 == tokenType || 11 == tokenType) {
            Counter counter2 = this.counters.pop();
            int count2 = counter2.getCount();
            if (count2 > this.methodMax) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_METHOD, count2, this.methodMax);
            }
        } else if (14 == tokenType && (count = (counter = this.counters.pop()).getCount()) > this.classMax) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_CLASS, count, this.classMax);
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        Counter counter = this.counters.pop();
        int count = counter.getCount();
        if (count > this.fileMax) {
            this.log(rootAST.getLineNo(), rootAST.getColumnNo(), MSG_FILE, count, this.fileMax);
        }
    }

    public void setFileMaximum(int fileMax) {
        this.fileMax = fileMax;
    }

    public void setClassMaximum(int classMax) {
        this.classMax = classMax;
    }

    public void setMethodMaximum(int methodMax) {
        this.methodMax = methodMax;
    }

    private boolean isCountable(DetailAST ast) {
        boolean countable = true;
        int tokenType = ast.getType();
        if (28 == tokenType) {
            countable = this.isExpressionCountable(ast);
        } else if (10 == tokenType) {
            countable = this.isVariableDefCountable(ast);
        }
        return countable;
    }

    private boolean isVariableDefCountable(DetailAST ast) {
        boolean countable = false;
        int parentType = ast.getParent().getType();
        if (7 == parentType || 6 == parentType) {
            DetailAST prevSibling = ast.getPreviousSibling();
            countable = prevSibling == null || 74 != prevSibling.getType();
        }
        return countable;
    }

    private boolean isExpressionCountable(DetailAST ast) {
        boolean countable = true;
        int parentType = ast.getParent().getType();
        switch (parentType) {
            case 7: 
            case 22: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 92: {
                DetailAST prevSibling = ast.getPreviousSibling();
                countable = prevSibling == null || 76 != prevSibling.getType();
                break;
            }
            default: {
                countable = false;
            }
        }
        return countable;
    }

    private static class Counter {
        private int ivCount;

        private Counter() {
        }

        public void increment() {
            ++this.ivCount;
        }

        public int getCount() {
            return this.ivCount;
        }
    }
}

