// This file is generated. Edit android/platform/scripts/generate-style-code.js, then run `make android-style-code`.

#include "background_layer.hpp"

#include <string>

#include "../conversion/property_value.hpp"

namespace mbgl {
namespace android {

    BackgroundLayer::BackgroundLayer(jni::JNIEnv& env, jni::String layerId)
        : Layer(env, std::make_unique<mbgl::style::BackgroundLayer>(jni::Make<std::string>(env, layerId))) {
    }

    BackgroundLayer::BackgroundLayer(mbgl::Map& map, mbgl::style::BackgroundLayer& coreLayer)
        : Layer(map, coreLayer) {
    }

    BackgroundLayer::~BackgroundLayer() = default;

    // Property getters

    jni::Object<jni::ObjectTag> BackgroundLayer::getBackgroundColor(jni::JNIEnv& env) {
        using namespace mbgl::android::conversion;
        Result<jni::jobject*> converted = convert<jni::jobject*>(env, layer.as<mbgl::style::BackgroundLayer>()->BackgroundLayer::getBackgroundColor());
        return jni::Object<jni::ObjectTag>(*converted);
    }

    jni::Object<jni::ObjectTag> BackgroundLayer::getBackgroundPattern(jni::JNIEnv& env) {
        using namespace mbgl::android::conversion;
        Result<jni::jobject*> converted = convert<jni::jobject*>(env, layer.as<mbgl::style::BackgroundLayer>()->BackgroundLayer::getBackgroundPattern());
        return jni::Object<jni::ObjectTag>(*converted);
    }

    jni::Object<jni::ObjectTag> BackgroundLayer::getBackgroundOpacity(jni::JNIEnv& env) {
        using namespace mbgl::android::conversion;
        Result<jni::jobject*> converted = convert<jni::jobject*>(env, layer.as<mbgl::style::BackgroundLayer>()->BackgroundLayer::getBackgroundOpacity());
        return jni::Object<jni::ObjectTag>(*converted);
    }

    jni::Class<BackgroundLayer> BackgroundLayer::javaClass;

    jni::jobject* BackgroundLayer::createJavaPeer(jni::JNIEnv& env) {
        static auto constructor = BackgroundLayer::javaClass.template GetConstructor<jni::jlong>(env);
        return BackgroundLayer::javaClass.New(env, constructor, reinterpret_cast<jni::jlong>(this));
    }

    void BackgroundLayer::registerNative(jni::JNIEnv& env) {
        //Lookup the class
        BackgroundLayer::javaClass = *jni::Class<BackgroundLayer>::Find(env).NewGlobalRef(env).release();

        #define METHOD(MethodPtr, name) jni::MakeNativePeerMethod<decltype(MethodPtr), (MethodPtr)>(name)

        //Register the peer
        jni::RegisterNativePeer<BackgroundLayer>(
            env, BackgroundLayer::javaClass, "nativePtr",
            std::make_unique<BackgroundLayer, JNIEnv&, jni::String>,
            "initialize",
            "finalize",
            METHOD(&BackgroundLayer::getBackgroundColor, "nativeGetBackgroundColor"),
            METHOD(&BackgroundLayer::getBackgroundPattern, "nativeGetBackgroundPattern"),
            METHOD(&BackgroundLayer::getBackgroundOpacity, "nativeGetBackgroundOpacity"));
    }

} // namespace android
} // namespace mbgl
