/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configurable;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.Contextualizable;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;

public class AutomaticBean
implements Configurable,
Contextualizable {
    private Configuration configuration;

    private static BeanUtilsBean createBeanUtilsBean() {
        ConvertUtilsBean cub = new ConvertUtilsBean();
        cub.register(new BooleanConverter(), Boolean.TYPE);
        cub.register(new BooleanConverter(), Boolean.class);
        cub.register(new ArrayConverter(boolean[].class, new BooleanConverter()), boolean[].class);
        cub.register(new ByteConverter(), Byte.TYPE);
        cub.register(new ByteConverter(), Byte.class);
        cub.register(new ArrayConverter(byte[].class, new ByteConverter()), byte[].class);
        cub.register(new CharacterConverter(), Character.TYPE);
        cub.register(new CharacterConverter(), Character.class);
        cub.register(new ArrayConverter(char[].class, new CharacterConverter()), char[].class);
        cub.register(new DoubleConverter(), Double.TYPE);
        cub.register(new DoubleConverter(), Double.class);
        cub.register(new ArrayConverter(double[].class, new DoubleConverter()), double[].class);
        cub.register(new FloatConverter(), Float.TYPE);
        cub.register(new FloatConverter(), Float.class);
        cub.register(new ArrayConverter(float[].class, new FloatConverter()), float[].class);
        cub.register(new IntegerConverter(), Integer.TYPE);
        cub.register(new IntegerConverter(), Integer.class);
        cub.register(new ArrayConverter(int[].class, new IntegerConverter()), int[].class);
        cub.register(new LongConverter(), Long.TYPE);
        cub.register(new LongConverter(), Long.class);
        cub.register(new ArrayConverter(long[].class, new LongConverter()), long[].class);
        cub.register(new ShortConverter(), Short.TYPE);
        cub.register(new ShortConverter(), Short.class);
        cub.register(new ArrayConverter(short[].class, new ShortConverter()), short[].class);
        cub.register(new RelaxedStringArrayConverter(), String[].class);
        return new BeanUtilsBean(cub, new PropertyUtilsBean());
    }

    @Override
    public final void configure(Configuration configuration) throws CheckstyleException {
        Configuration[] childConfigs;
        String[] attributes;
        this.configuration = configuration;
        BeanUtilsBean beanUtils = AutomaticBean.createBeanUtilsBean();
        for (String key : attributes = configuration.getAttributeNames()) {
            String value = configuration.getAttribute(key);
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(this, key);
                if (pd == null || pd.getWriteMethod() == null) {
                    throw new CheckstyleException("Property '" + key + "' in module " + configuration.getName() + " does not exist, please check the documentation");
                }
                beanUtils.copyProperty(this, key, value);
            }
            catch (InvocationTargetException e) {
                throw new CheckstyleException("Cannot set property '" + key + "' in module " + configuration.getName() + " to '" + value + "': " + e.getTargetException().getMessage(), e);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new CheckstyleException("cannot access " + key + " in " + this.getClass().getName(), e);
            }
            catch (IllegalArgumentException | ConversionException e) {
                throw new CheckstyleException("illegal value '" + value + "' for property '" + key + "' of module " + configuration.getName(), e);
            }
        }
        this.finishLocalSetup();
        for (Configuration childConfig : childConfigs = configuration.getChildren()) {
            this.setupChild(childConfig);
        }
    }

    @Override
    public final void contextualize(Context context) throws CheckstyleException {
        BeanUtilsBean beanUtils = AutomaticBean.createBeanUtilsBean();
        ImmutableCollection<String> attributes = context.getAttributeNames();
        for (String key : attributes) {
            Object value = context.get(key);
            try {
                beanUtils.copyProperty(this, key, value);
            }
            catch (InvocationTargetException e) {
                throw new CheckstyleException("cannot set property " + key + " to value " + value + " in bean " + this.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new CheckstyleException("cannot access " + key + " in " + this.getClass().getName(), e);
            }
            catch (IllegalArgumentException | ConversionException e) {
                throw new CheckstyleException("illegal value '" + value + "' for property '" + key + "' of bean " + this.getClass().getName(), e);
            }
        }
    }

    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    protected void finishLocalSetup() throws CheckstyleException {
    }

    protected void setupChild(Configuration childConf) throws CheckstyleException {
    }

    private static class RelaxedStringArrayConverter
    implements Converter {
        private RelaxedStringArrayConverter() {
        }

        @Override
        public Object convert(Class type, Object value) {
            if (null == type) {
                throw new ConversionException("Cannot convert from null.");
            }
            StringTokenizer st = new StringTokenizer(value.toString().trim(), ",");
            ArrayList<String> result = Lists.newArrayList();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                result.add(token.trim());
            }
            return result.toArray(new String[result.size()]);
        }
    }
}

