/*!****************************************************************************

 @file         OGLES3/OGLES3Tools.h
 @ingroup      API_OGLES3
 @copyright    Copyright (c) Imagination Technologies Limited.
 @brief        Header file of OGLES3Tools.lib.

******************************************************************************/

#ifndef _OGLES3TOOLS_H_
#define _OGLES3TOOLS_H_

/*!
 @addtogroup API_OGLES3
 @brief      Tools for the OpenGL ES 3.0 API.
*/

#ifndef BUILD_OGLES3
	#define BUILD_OGLES3
#endif

#include "../OGLES2/PVRTContext.h"
#include "../PVRTGlobal.h"
#include "../PVRTArray.h"
#include "../PVRTHash.h"
#include "../PVRTVector.h"
#include "../PVRTString.h"
#include "../PVRTStringHash.h"
#include "../PVRTFixedPoint.h"
#include "../PVRTMatrix.h"
#include "../PVRTQuaternion.h"
#include "../PVRTTrans.h"
#include "../PVRTVertex.h"
#include "../PVRTMap.h"
#include "../PVRTMisc.h"
#include "../PVRTBackground.h"
#include "PVRTgles3Ext.h"
#include "../PVRTPrint3D.h"
#include "../PVRTBoneBatch.h"
#include "../PVRTModelPOD.h"
#include "../PVRTTexture.h"
#include "PVRTTextureAPI.h"
#include "../PVRTTriStrip.h"
#include "../OGLES2/PVRTShader.h"
#include "../PVRTPFXParser.h"
#include "../OGLES2/PVRTPFXParserAPI.h"
#include "../OGLES2/PVRTPFXSemantics.h"
#include "../PVRTShadowVol.h"
#include "../PVRTResourceFile.h"
#include "../PVRTError.h"

#endif /* _OGLES3TOOLS_H_ */

/*****************************************************************************
 End of file (OGLES3Tools.h)
*****************************************************************************/

