/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.purchasing;

import org.qtproject.qt5.android.purchasing.Base64DecoderException;

public class Base64 {
    public static final boolean ENCODE = true;
    public static final boolean DECODE = false;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] WEBSAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};
    private static final byte[] WEBSAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private Base64() {
    }

    private static byte[] encode3to4(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte[] byArray3) {
        int n4 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3] = byArray3[n4 >>> 18];
                byArray2[n3 + 1] = byArray3[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n4 >>> 6 & 0x3F];
                byArray2[n3 + 3] = byArray3[n4 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n3] = byArray3[n4 >>> 18];
                byArray2[n3 + 1] = byArray3[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n4 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n3] = byArray3[n4 >>> 18];
                byArray2[n3 + 1] = byArray3[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 0, byArray.length, ALPHABET, true);
    }

    public static String encodeWebSafe(byte[] byArray, boolean bl) {
        return Base64.encode(byArray, 0, byArray.length, WEBSAFE_ALPHABET, bl);
    }

    public static String encode(byte[] byArray, int n, int n2, byte[] byArray2, boolean bl) {
        int n3;
        byte[] byArray3 = Base64.encode(byArray, n, n2, byArray2, Integer.MAX_VALUE);
        for (n3 = byArray3.length; !bl && n3 > 0 && byArray3[n3 - 1] == 61; --n3) {
        }
        return new String(byArray3, 0, n3);
    }

    public static byte[] encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = (n2 + 2) / 3;
        int n5 = n4 * 4;
        byte[] byArray3 = new byte[n5 + n5 / n3];
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 - 2;
        int n9 = 0;
        while (n6 < n8) {
            int n10 = byArray[n6 + n] << 24 >>> 8 | byArray[n6 + 1 + n] << 24 >>> 16 | byArray[n6 + 2 + n] << 24 >>> 24;
            byArray3[n7] = byArray2[n10 >>> 18];
            byArray3[n7 + 1] = byArray2[n10 >>> 12 & 0x3F];
            byArray3[n7 + 2] = byArray2[n10 >>> 6 & 0x3F];
            byArray3[n7 + 3] = byArray2[n10 & 0x3F];
            if ((n9 += 4) == n3) {
                byArray3[n7 + 4] = 10;
                ++n7;
                n9 = 0;
            }
            n6 += 3;
            n7 += 4;
        }
        if (n6 < n2) {
            Base64.encode3to4(byArray, n6 + n, n2 - n6, byArray3, n7, byArray2);
            if ((n9 += 4) == n3) {
                byArray3[n7 + 4] = 10;
                ++n7;
            }
            n7 += 4;
        }
        assert (n7 == byArray3.length);
        return byArray3;
    }

    private static int decode4to3(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3) {
        if (byArray[n + 2] == 61) {
            int n3 = byArray3[byArray[n]] << 24 >>> 6 | byArray3[byArray[n + 1]] << 24 >>> 12;
            byArray2[n2] = (byte)(n3 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n4 = byArray3[byArray[n]] << 24 >>> 6 | byArray3[byArray[n + 1]] << 24 >>> 12 | byArray3[byArray[n + 2]] << 24 >>> 18;
            byArray2[n2] = (byte)(n4 >>> 16);
            byArray2[n2 + 1] = (byte)(n4 >>> 8);
            return 2;
        }
        int n5 = byArray3[byArray[n]] << 24 >>> 6 | byArray3[byArray[n + 1]] << 24 >>> 12 | byArray3[byArray[n + 2]] << 24 >>> 18 | byArray3[byArray[n + 3]] << 24 >>> 24;
        byArray2[n2] = (byte)(n5 >> 16);
        byArray2[n2 + 1] = (byte)(n5 >> 8);
        byArray2[n2 + 2] = (byte)n5;
        return 3;
    }

    public static byte[] decode(String string) throws Base64DecoderException {
        byte[] byArray = string.getBytes();
        return Base64.decode(byArray, 0, byArray.length);
    }

    public static byte[] decodeWebSafe(String string) throws Base64DecoderException {
        byte[] byArray = string.getBytes();
        return Base64.decodeWebSafe(byArray, 0, byArray.length);
    }

    public static byte[] decode(byte[] byArray) throws Base64DecoderException {
        return Base64.decode(byArray, 0, byArray.length);
    }

    public static byte[] decodeWebSafe(byte[] byArray) throws Base64DecoderException {
        return Base64.decodeWebSafe(byArray, 0, byArray.length);
    }

    public static byte[] decode(byte[] byArray, int n, int n2) throws Base64DecoderException {
        return Base64.decode(byArray, n, n2, DECODABET);
    }

    public static byte[] decodeWebSafe(byte[] byArray, int n, int n2) throws Base64DecoderException {
        return Base64.decode(byArray, n, n2, WEBSAFE_DECODABET);
    }

    public static byte[] decode(byte[] byArray, int n, int n2, byte[] byArray2) throws Base64DecoderException {
        int n3 = n2 * 3 / 4;
        byte[] byArray3 = new byte[2 + n3];
        int n4 = 0;
        byte[] byArray4 = new byte[4];
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        for (n6 = 0; n6 < n2; ++n6) {
            by = (byte)(byArray[n6 + n] & 0x7F);
            by2 = byArray2[by];
            if (by2 >= -5) {
                if (by2 < -1) continue;
                if (by == 61) {
                    int n7 = n2 - n6;
                    byte by3 = (byte)(byArray[n2 - 1 + n] & 0x7F);
                    if (n5 == 0 || n5 == 1) {
                        throw new Base64DecoderException("invalid padding byte '=' at byte offset " + n6);
                    }
                    if (n5 == 3 && n7 > 2 || n5 == 4 && n7 > 1) {
                        throw new Base64DecoderException("padding byte '=' falsely signals end of encoded value at offset " + n6);
                    }
                    if (by3 == 61 || by3 == 10) break;
                    throw new Base64DecoderException("encoded value has invalid trailing byte");
                }
                byArray4[n5++] = by;
                if (n5 != 4) continue;
                n4 += Base64.decode4to3(byArray4, 0, byArray3, n4, byArray2);
                n5 = 0;
                continue;
            }
            throw new Base64DecoderException("Bad Base64 input character at " + n6 + ": " + byArray[n6 + n] + "(decimal)");
        }
        if (n5 != 0) {
            if (n5 == 1) {
                throw new Base64DecoderException("single trailing character at offset " + (n2 - 1));
            }
            byArray4[n5++] = 61;
            n4 += Base64.decode4to3(byArray4, 0, byArray3, n4, byArray2);
        }
        byte[] byArray5 = new byte[n4];
        System.arraycopy(byArray3, 0, byArray5, 0, n4);
        return byArray5;
    }
}

