/*
 * Copyright (C) 2010 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ScopedEventQueue_h
#define ScopedEventQueue_h

#include "base/macros.h"
#include "base/memory/scoped_refptr.h"
#include "core/CoreExport.h"
#include "core/dom/events/Event.h"
#include "platform/heap/Handle.h"
#include "platform/wtf/Vector.h"

namespace blink {

class CORE_EXPORT ScopedEventQueue {
  USING_FAST_MALLOC(ScopedEventQueue);

 public:
  ~ScopedEventQueue();

  void EnqueueEvent(Event*);
  static ScopedEventQueue* Instance();

  void IncrementScopingLevel();
  void DecrementScopingLevel();
  bool ShouldQueueEvents() const { return scoping_level_ > 0; }

 private:
  ScopedEventQueue();
  static void Initialize();
  void DispatchAllEvents();
  void DispatchEvent(Event*) const;

  PersistentHeapVector<Member<Event>> queued_events_;
  unsigned scoping_level_;

  static ScopedEventQueue* instance_;
  DISALLOW_COPY_AND_ASSIGN(ScopedEventQueue);
};

class EventQueueScope {
  STACK_ALLOCATED();

 public:
  EventQueueScope() { ScopedEventQueue::Instance()->IncrementScopingLevel(); }
  ~EventQueueScope() { ScopedEventQueue::Instance()->DecrementScopingLevel(); }
  DISALLOW_COPY_AND_ASSIGN(EventQueueScope);
};

}  // namespace blink

#endif  // ScopedEventQueue_h
