/*
 * Copyright 2015 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// Auto-generated by create_test_font.cpp

static SkTestFontData gTestFonts[] = {
    {    LiberationMonoNormalPoints, LiberationMonoNormalVerbs, LiberationMonoNormalCharCodes,
         LiberationMonoNormalCharCodesCount, LiberationMonoNormalWidths,
         LiberationMonoNormalMetrics, "Toy Liberation Mono", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), nullptr
    },
    {    LiberationMonoBoldPoints, LiberationMonoBoldVerbs, LiberationMonoBoldCharCodes,
         LiberationMonoBoldCharCodesCount, LiberationMonoBoldWidths,
         LiberationMonoBoldMetrics, "Toy Liberation Mono", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), nullptr
    },
    {    LiberationMonoItalicPoints, LiberationMonoItalicVerbs, LiberationMonoItalicCharCodes,
         LiberationMonoItalicCharCodesCount, LiberationMonoItalicWidths,
         LiberationMonoItalicMetrics, "Toy Liberation Mono", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), nullptr
    },
    {    LiberationMonoBoldItalicPoints, LiberationMonoBoldItalicVerbs, LiberationMonoBoldItalicCharCodes,
         LiberationMonoBoldItalicCharCodesCount, LiberationMonoBoldItalicWidths,
         LiberationMonoBoldItalicMetrics, "Toy Liberation Mono", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), nullptr
    },
    {    LiberationSansNormalPoints, LiberationSansNormalVerbs, LiberationSansNormalCharCodes,
         LiberationSansNormalCharCodesCount, LiberationSansNormalWidths,
         LiberationSansNormalMetrics, "Toy Liberation Sans", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), nullptr
    },
    {    LiberationSansBoldPoints, LiberationSansBoldVerbs, LiberationSansBoldCharCodes,
         LiberationSansBoldCharCodesCount, LiberationSansBoldWidths,
         LiberationSansBoldMetrics, "Toy Liberation Sans", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), nullptr
    },
    {    LiberationSansItalicPoints, LiberationSansItalicVerbs, LiberationSansItalicCharCodes,
         LiberationSansItalicCharCodesCount, LiberationSansItalicWidths,
         LiberationSansItalicMetrics, "Toy Liberation Sans", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), nullptr
    },
    {    LiberationSansBoldItalicPoints, LiberationSansBoldItalicVerbs, LiberationSansBoldItalicCharCodes,
         LiberationSansBoldItalicCharCodesCount, LiberationSansBoldItalicWidths,
         LiberationSansBoldItalicMetrics, "Toy Liberation Sans", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), nullptr
    },
    {    LiberationSerifNormalPoints, LiberationSerifNormalVerbs, LiberationSerifNormalCharCodes,
         LiberationSerifNormalCharCodesCount, LiberationSerifNormalWidths,
         LiberationSerifNormalMetrics, "Toy Liberation Serif", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), nullptr
    },
    {    LiberationSerifBoldPoints, LiberationSerifBoldVerbs, LiberationSerifBoldCharCodes,
         LiberationSerifBoldCharCodesCount, LiberationSerifBoldWidths,
         LiberationSerifBoldMetrics, "Toy Liberation Serif", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), nullptr
    },
    {    LiberationSerifItalicPoints, LiberationSerifItalicVerbs, LiberationSerifItalicCharCodes,
         LiberationSerifItalicCharCodesCount, LiberationSerifItalicWidths,
         LiberationSerifItalicMetrics, "Toy Liberation Serif", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), nullptr
    },
    {    LiberationSerifBoldItalicPoints, LiberationSerifBoldItalicVerbs, LiberationSerifBoldItalicCharCodes,
         LiberationSerifBoldItalicCharCodesCount, LiberationSerifBoldItalicWidths,
         LiberationSerifBoldItalicMetrics, "Toy Liberation Serif", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), nullptr
    },
};

const int gTestFontsCount = (int) SK_ARRAY_COUNT(gTestFonts);

struct SubFont {
    const char* fName;
    SkFontStyle fStyle;
    SkTestFontData& fFont;
    const char* fFile;
};

const SubFont gSubFonts[] = {
    { "monospace", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), gTestFonts[0], "LiberationMono-Regular.ttf" },
    { "monospace", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), gTestFonts[1], "LiberationMono-Bold.ttf" },
    { "monospace", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), gTestFonts[2], "LiberationMono-Italic.ttf" },
    { "monospace", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), gTestFonts[3], "LiberationMono-BoldItalic.ttf" },
    { "sans-serif", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), gTestFonts[4], "LiberationSans-Regular.ttf" },
    { "sans-serif", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), gTestFonts[5], "LiberationSans-Bold.ttf" },
    { "sans-serif", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), gTestFonts[6], "LiberationSans-Italic.ttf" },
    { "sans-serif", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), gTestFonts[7], "LiberationSans-BoldItalic.ttf" },
    { "serif", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), gTestFonts[8], "LiberationSerif-Regular.ttf" },
    { "serif", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), gTestFonts[9], "LiberationSerif-Bold.ttf" },
    { "serif", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), gTestFonts[10], "LiberationSerif-Italic.ttf" },
    { "serif", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), gTestFonts[11], "LiberationSerif-BoldItalic.ttf" },
    { "Toy Liberation Mono", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), gTestFonts[0], "LiberationMono-Regular.ttf" },
    { "Toy Liberation Mono", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), gTestFonts[1], "LiberationMono-Bold.ttf" },
    { "Toy Liberation Mono", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), gTestFonts[2], "LiberationMono-Italic.ttf" },
    { "Toy Liberation Mono", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), gTestFonts[3], "LiberationMono-BoldItalic.ttf" },
    { "Toy Liberation Sans", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), gTestFonts[4], "LiberationSans-Regular.ttf" },
    { "Toy Liberation Sans", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), gTestFonts[5], "LiberationSans-Bold.ttf" },
    { "Toy Liberation Sans", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), gTestFonts[6], "LiberationSans-Italic.ttf" },
    { "Toy Liberation Sans", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), gTestFonts[7], "LiberationSans-BoldItalic.ttf" },
    { "Toy Liberation Serif", SkFontStyle(400,5,SkFontStyle::kUpright_Slant), gTestFonts[8], "LiberationSerif-Regular.ttf" },
    { "Toy Liberation Serif", SkFontStyle(700,5,SkFontStyle::kUpright_Slant), gTestFonts[9], "LiberationSerif-Bold.ttf" },
    { "Toy Liberation Serif", SkFontStyle(400,5,SkFontStyle::kItalic_Slant), gTestFonts[10], "LiberationSerif-Italic.ttf" },
    { "Toy Liberation Serif", SkFontStyle(700,5,SkFontStyle::kItalic_Slant), gTestFonts[11], "LiberationSerif-BoldItalic.ttf" },
};

const int gSubFontsCount = (int) SK_ARRAY_COUNT(gSubFonts);

const int gDefaultFontIndex = 4;
