/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import java.util.Objects;

class TargetLibraryInfo {
    private static final String TARGET_VERSION_METADATA_KEY = "ClientApiVersion";
    private final String remotePackageName;
    private final String libraryName;

    public TargetLibraryInfo(String remotePackageName, String libraryName) {
        this.remotePackageName = remotePackageName;
        this.libraryName = libraryName;
    }

    public String getRemotePackageName() {
        return this.remotePackageName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    String getRemoteClientVersionKey() {
        String string = this.remotePackageName;
        String string2 = this.libraryName;
        return new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).append(".").append(TARGET_VERSION_METADATA_KEY).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TargetLibraryInfo) {
            TargetLibraryInfo other = (TargetLibraryInfo)obj;
            return Objects.equals(this.remotePackageName, other.remotePackageName) && Objects.equals(this.libraryName, other.libraryName);
        }
        return false;
    }

    public int hashCode() {
        int hash = Objects.hashCode(this.remotePackageName);
        hash = 37 * hash + Objects.hashCode(this.libraryName);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[packageName=");
        sb.append(this.getRemotePackageName());
        sb.append(",libraryName=");
        sb.append(this.getLibraryName());
        sb.append("]");
        return sb.toString();
    }
}

