/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.chromium.devtools.jsdoc.FileCheckerCallable;
import org.chromium.devtools.jsdoc.ValidatorContext;

public class JsDocValidator {
    private static final String FILES_LIST_NAME = "--files-list-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("At least 1 argument is expected");
            System.exit(1);
        }
        String[] stringArray2 = FILES_LIST_NAME.equals(stringArray[0]) ? this.readFileNames(stringArray) : stringArray;
        int n = Math.min(stringArray2.length, Runtime.getRuntime().availableProcessors());
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        try {
            this.runWithExecutor(stringArray2, executorService);
        }
        finally {
            executorService.shutdown();
        }
    }

    private String[] readFileNames(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("A single file name is expected to follow --files-list-name");
            System.exit(1);
        }
        try {
            List<String> list = Files.readAllLines(FileSystems.getDefault().getPath(stringArray[1], new String[0]), Charset.forName("UTF-8"));
            return list.toArray(new String[list.size()]);
        }
        catch (IOException iOException) {
            System.err.println("Unable to read list file " + stringArray[1]);
            iOException.printStackTrace();
            System.exit(1);
            return new String[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runWithExecutor(String[] stringArray, ExecutorService executorService) {
        Object object2;
        void future;
        ArrayList<Future<ValidatorContext>> arrayList = new ArrayList<Future<ValidatorContext>>(stringArray.length);
        HashMap<Future<ValidatorContext>, String> hashMap = new HashMap<Future<ValidatorContext>, String>();
        Object arrayList2 = stringArray;
        int n = ((String[])arrayList2).length;
        boolean bl = false;
        while (future < n) {
            String string = arrayList2[future];
            object2 = executorService.submit(new FileCheckerCallable(string));
            hashMap.put((Future<ValidatorContext>)object2, string);
            arrayList.add((Future<ValidatorContext>)object2);
            ++future;
        }
        arrayList2 = new ArrayList(stringArray.length);
        for (Future object3 : arrayList) {
            try {
                ValidatorContext validatorContext = (ValidatorContext)object3.get();
                if (validatorContext == null) continue;
                arrayList2.add(validatorContext);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (exception.getMessage().indexOf("DESTRUCTURING_LHS") != -1) continue;
                System.err.println((String)hashMap.get(object3) + ": ERROR - " + exception.getMessage());
            }
        }
        int n2 = 0;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ValidatorContext validatorContext = (ValidatorContext)iterator.next();
            n2 += validatorContext.getValidationResult().size();
        }
        ArrayList<LogEntry> arrayList3 = new ArrayList<LogEntry>(n2);
        Iterator iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            object2 = (ValidatorContext)iterator2.next();
            SortedSet<ValidatorContext.MessageRecord> sortedSet = ((ValidatorContext)object2).getValidationResult();
            for (ValidatorContext.MessageRecord messageRecord : sortedSet) {
                arrayList3.add(new LogEntry(((ValidatorContext)object2).scriptFileName, messageRecord));
            }
        }
        Collections.sort(arrayList3);
        for (Object object2 : arrayList3) {
            System.err.println(((LogEntry)object2).record.text);
        }
        if (!arrayList3.isEmpty()) {
            System.err.println("Total errors: " + arrayList3.size());
        }
    }

    public static void main(String[] stringArray) {
        new JsDocValidator().run(stringArray);
    }

    private static class LogEntry
    implements Comparable<LogEntry> {
        private final String fileName;
        private final ValidatorContext.MessageRecord record;

        LogEntry(String string, ValidatorContext.MessageRecord messageRecord) {
            this.fileName = string;
            this.record = messageRecord;
        }

        @Override
        public int compareTo(LogEntry logEntry) {
            int n = this.fileName.compareTo(logEntry.fileName);
            if (n != 0) {
                return n;
            }
            return Integer.compare(this.record.position, logEntry.record.position);
        }

        public int hashCode() {
            return 17 + this.fileName.hashCode() * 3 + this.record.hashCode() * 5;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LogEntry logEntry = (LogEntry)object;
            if (this.fileName != logEntry.fileName && this.fileName != null && !this.fileName.equals(logEntry.fileName)) {
                return false;
            }
            if (this.record == logEntry.record) {
                return true;
            }
            if (this.record != null) {
                if (logEntry.record == null) {
                    return false;
                }
                return this.record.position == logEntry.record.position;
            }
            return false;
        }
    }
}

