//
// Copyright (c) 2017 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

// ErrorStrings.h: Contains mapping of commonly used error messages

#ifndef LIBANGLE_ERRORSTRINGS_H_
#define LIBANGLE_ERRORSTRINGS_H_

namespace gl
{
namespace err
{
#define MSG constexpr const char *

// clang-format off
MSG k3DDepthStencil = "Format cannot be GL_DEPTH_COMPONENT or GL_DEPTH_STENCIL if target is GL_TEXTURE_3D";
MSG kANGLECopyTexture3DUnavailable = "GL_ANGLE_copy_texture_3d extension not available.";
MSG kAtomicCounterResourceName = "Active atomic counter resources are not assigned name strings.";
MSG kAttributeZeroRequiresDivisorLimitation = "The current context doesn't support setting a non-zero divisor on the attribute with index zero. Please reorder the attributes in your vertex shader so that attribute zero can have a zero divisor.";
MSG kBaseLevelNegative = "Base level must be at least 0.";
MSG kBaseLevelNonZero = "Base level must be 0.";
MSG kBaseLevelOutOfRange = "Texture base level out of range";
MSG kBlitDepthOrStencilFormatMismatch = "Depth/stencil buffer format combination not allowed for blit.";
MSG kBlitDimensionsOutOfRange = "BlitFramebuffer dimensions out of 32-bit integer range.";
MSG kBlitExtensionDepthStencilWholeBufferBlit = "Only whole-buffer depth and stencil blits are supported by this extension.";
MSG kBlitExtensionFormatMismatch = "Attempting to blit and the read and draw buffer formats don't match.";
MSG kBlitExtensionFromInvalidAttachmentType = "Blits are only supported from 2D texture = renderbuffer or default framebuffer attachments in this extension.";
MSG kBlitExtensionLinear = "Linear blit not supported in this extension.";
MSG kBlitExtensionMultisampledDepthOrStencil = "Multisampled depth/stencil blit is not supported by this extension.";
MSG kBlitExtensionMultisampledWholeBufferBlit = "Only whole-buffer blit is supported from a multisampled read buffer in this extension.";
MSG kBlitExtensionNotAvailable = "Blit extension not available.";
MSG kBlitExtensionScaleOrFlip = "Scaling and flipping in BlitFramebufferANGLE not supported by this implementation.";
MSG kBlitExtensionToInvalidAttachmentType = "Blits are only supported to 2D texture = renderbuffer or default framebuffer attachments in this extension.";
MSG kBlitFeedbackLoop = "Blit feedback loop: the read and draw framebuffers are the same.";
MSG kBlitFramebufferMissing = "Read and draw framebuffers must both exist for a blit to succeed.";
MSG kBlitFromMultiview = "Attempt to read from a multi-view framebuffer.";
MSG kBlitIntegerWithLinearFilter = "Cannot use GL_LINEAR filter when blitting a integer framebuffer.";
MSG kBlitInvalidFilter = "Invalid blit filter.";
MSG kBlitInvalidMask = "Invalid blit mask.";
MSG kBlitMissingColor = "Attempt to read from a missing color attachment of a complete framebuffer.";
MSG kBlitMissingDepthOrStencil = "Attempt to read from a missing depth/stencil attachment of a complete framebuffer.";
MSG kBlitMultisampledBoundsMismatch = "Attempt to blit from a multisampled framebuffer and the bounds don't match with the draw framebuffer.";
MSG kBlitMultisampledFormatOrBoundsMismatch = "Attempt to blit from a multisampled framebuffer and the bounds or format of the color buffer don't match with the draw framebuffer.";
MSG kBlitOnlyNearestForNonColor = "Only nearest filtering can be used when blitting buffers other than the color buffer.";
MSG kBlitSameImageColor = "Read and write color attachments cannot be the same image.";
MSG kBlitSameImageDepthOrStencil = "Read and write depth stencil attachments cannot be the same image.";
MSG kBlitToMultiview = "Attempt to write to a multi-view framebuffer.";
MSG kBlitTypeMismatchFixedOrFloat = "If the read buffer contains fixed-point or floating-point values = the draw buffer must as well.";
MSG kBlitTypeMismatchFixedPoint = "If the read buffer contains fixed-point values = the draw buffer must as well.";
MSG kBlitTypeMismatchSignedInteger = "If the read buffer contains signed integer values the draw buffer must as well.";
MSG kBlitTypeMismatchUnsignedInteger = "If the read buffer contains unsigned integer values the draw buffer must as well.";
MSG kBufferAlreadyMapped = "Buffer is already mapped.";
MSG kBufferBoundForTransformFeedback = "Buffer is bound for transform feedback.";
MSG kBufferMapped = "An active buffer is mapped";
MSG kBufferNotBound = "A buffer must be bound.";
MSG kBufferNotMappable = "Attempted to map buffer object zero.";
MSG kBufferNotMapped = "Buffer is not mapped.";
MSG kBufferOffsetOverflow = "Buffer offset overflow.";
MSG kBufferPointerNotAvailable = "Can not get pointer for reserved buffer name zero.";
MSG kCannotPopDefaultDebugGroup = "Cannot pop the default debug group.";
MSG kClientDataInVertexArray = "Client data cannot be used with a non-default vertex array object.";
MSG kColorNumberGreaterThanMaxDrawBuffers = "Color number for primary color greater than or equal to MAX_DRAW_BUFFERS";
MSG kColorNumberGreaterThanMaxDualSourceDrawBuffers = "Color number for secondary color greater than or equal to MAX_DUAL_SOURCE_DRAW_BUFFERS";
MSG kCompressedDataSizeTooSmall = "dataSize is too small";
MSG kCompressedMismatch = "Compressed data is valid if-and-only-if the texture is compressed.";
MSG kCompressedTextureDimensionsMustMatchData = "Compressed texture dimensions must exactly match the dimensions of the data passed in.";
MSG kCompressedTexturesNotAttachable = "Compressed textures cannot be attached to a framebuffer.";
MSG kConstantColorAlphaLimitation = "Simultaneous use of GL_CONSTANT_ALPHA/GL_ONE_MINUS_CONSTANT_ALPHA and GL_CONSTANT_COLOR/GL_ONE_MINUS_CONSTANT_COLOR not supported by this implementation.";
MSG kContextLost = "Context has been lost.";
MSG kCopyAlias = "The read and write copy regions alias memory.";
MSG kCubemapFacesEqualDimensions = "Each cubemap face must have equal width and height.";
MSG kCubemapIncomplete = "Texture is not cubemap complete. All cubemaps faces must be defined and be the same size.";
MSG kDataTypeNotAligned = "Data is not evenly divisible into the number of bytes needed to store in memory a datum indicated by type.";
MSG kDefaultFramebuffer = "Default framebuffer is bound.";
MSG kDefaultFramebufferInvalidAttachment = "Invalid attachment when the default framebuffer is bound.";
MSG kDefaultFramebufferInvalidDrawBuffer = "Only NONE or BACK are valid draw buffers for the default framebuffer";
MSG kDefaultFramebufferTarget = "It is invalid to change default FBO's attachments";
MSG kDefaultVertexArray = "Default vertex array object is bound.";
MSG kDestinationImmutable = "Destination texture cannot be immutable.";
MSG kDestinationLevelNotDefined = "The destination level of the destination texture must be defined.";
MSG kDestinationTextureTooSmall = "Destination texture too small.";
MSG kDimensionsMustBePow2 = "Texture dimensions must be power-of-two.";
MSG kDispatchIndirectBufferNotBound = "Dispatch indirect buffer must be bound.";
MSG kDrawBufferMaskMismatch = "Active draw buffers with missing fragment shader outputs.";
MSG kDrawBufferTypeMismatch = "Fragment shader output type does not match the bound framebuffer attachment type.";
MSG kDrawFramebufferIncomplete = "Draw framebuffer is incomplete";
MSG kDrawIndirectBufferNotBound = "Draw indirect buffer must be bound.";
MSG kEGLImageCannotCreate2DMultisampled = "Cannot create a 2D texture from a multisampled EGL image.";
MSG kEGLImageRenderbufferFormatNotSupported = "EGL image internal format is not supported as a renderbuffer.";
MSG kEGLImageTextureFormatNotSupported = "EGL image internal format is not supported as a texture.";
MSG kElementArrayBufferBoundForTransformFeedback = "It is undefined behavior to use an element array buffer that is bound for transform feedback.";
MSG kElementArrayNoBufferOrPointer = "No element array buffer and no pointer.";
MSG kEnumNotSupported = "Enum is not currently supported.";
MSG kEnumRequiresGLES30 = "Enum requires GLES 3.0";
MSG kEnumRequiresGLES31 = "Enum requires GLES 3.1";
MSG kES31Required = "OpenGL ES 3.1 Required";
MSG kES3Required = "OpenGL ES 3.0 Required.";
MSG kExceedsComputeWorkGroupCountX = "num_groups_x cannot be greater than MAX_COMPUTE_WORK_GROUP_COUNT[0]";
MSG kExceedsComputeWorkGroupCountY = "num_groups_y cannot be greater than MAX_COMPUTE_WORK_GROUP_COUNT[1]";
MSG kExceedsComputeWorkGroupCountZ = "num_groups_z cannot be greater than MAX_COMPUTE_WORK_GROUP_COUNT[2]";
MSG kExceedsElementRange = "Element value exceeds element range.";
MSG kExceedsFramebufferHeight = "Params less than 0 or greater than GL_MAX_FRAMEBUFFER_HEIGHT.";
MSG kExceedsFramebufferSamples = "Params less than 0 or greater than GL_MAX_FRAMEBUFFER_SAMPLES.";
MSG kExceedsFramebufferWidth = "Params less than 0 or greater than GL_MAX_FRAMEBUFFER_WIDTH.";
MSG kExceedsMaxColorAttachments = "Index is greater than the maximum supported color attachments";
MSG kExceedsMaxDebugGroupStackDepth = "Cannot push more than GL_MAX_DEBUG_GROUP_STACK_DEPTH debug groups.";
MSG kExceedsMaxDebugMessageLength = "Message length is larger than GL_MAX_DEBUG_MESSAGE_LENGTH.";
MSG kExceedsMaxDrawBuffers = "Draw buffer greater than MAX_DRAW_BUFFERS.";
MSG kExceedsMaxElement = "Element value exceeds maximum element index.";
MSG kExceedsMaxImageUnits = "Index must be within [0, MAX_IMAGE_UNITS).";
MSG kExceedsMaxLabelLength = "Label length is larger than GL_MAX_LABEL_LENGTH.";
MSG kExceedsMaxShaderStorageBufferBindings = "Index must be within [0, MAX_SHADER_STORAGE_BUFFER_BINDINGS).";
MSG kExceedsMaxVertexAttribBindings = "Index must be within [0, MAX_VERTEX_ATTRIB_BINDINGS).";
MSG kExceedsMaxVertexAttribStride = "Stride must be within [0, MAX_VERTEX_ATTRIB_STRIDE).";
MSG kExceedsNumExtensions = "Index must be within [0, NUM_EXTENSIONS).";
MSG kExceedsNumRequestableExtensions = "Index must be within [0, NUM_REQUESTABLE_EXTENSIONS_ANGLE).";
MSG kExpectedProgramName = "Expected a program name = but found a shader name.";
MSG kExpectedShaderName = "Expected a shader name = but found a program name.";
MSG kExtensionNotEnabled = "Extension is not enabled.";
MSG kExtensionNotRequestable = "Extension is not requestable.";
MSG kExternalTextureNotSupported = "External texture extension not enabled";
MSG kFeedbackLoop = "Feedback loop formed between Framebuffer and active Texture.";
MSG kFixedNotInWebGL = "GL_FIXED is not supported in WebGL.";
MSG kFormatNotRenderable = "Internal format is not renderable.";
MSG kFragDataBindingIndexOutOfRange = "Fragment output color index must be zero or one.";
MSG kFragmentInputTypeNotFloatingPoint = "Fragment input type is not a floating point scalar or vector.";
MSG kFramebufferIncomplete = "Framebuffer is incomplete.";
MSG kFramebufferIncompleteAttachment = "Attachment type must be compatible with attachment object.";
MSG kFramebufferTextureInvalidLayer = "Layer invalid for framebuffer texture attachment.";
MSG kFramebufferTextureInvalidMipLevel = "Mip level invalid for framebuffer texture attachment.";
MSG kFramebufferTextureLayerIncorrectTextureType = "Texture is not a three-dimensional or two-dimensionsal array texture.";
MSG kGenerateMipmapNotAllowed = "Texture format does not support mipmap generation.";
MSG kGenerateMipmapZeroSize = "Cannot generate mipmaps for a zero-size texture in a WebGL context.";
MSG kGeometryShaderExtensionNotEnabled = "GL_EXT_geometry_shader extension not enabled.";
MSG kGLES1Only = "GLES1-only function.";
MSG kImageSizeMustBeZero = "imageSize must be 0 if no texture data is provided.";
MSG kImageSizeTooSmall = "imageSize is too small.";
MSG kImmutableTextureBound = "The value of TEXTURE_IMMUTABLE_FORMAT for the texture currently bound to target on the active texture unit is true.";
MSG kIncompatibleDrawModeAgainstGeometryShader = "Primitive mode is incompatible with the input primitive type of the geometry shader.";
MSG kIndexExceedsActiveUniformBlockCount = "Index exceeds active uniform block count.";
MSG kIndexExceedsMaxActiveUniform = "Index must be less than program active uniform count.";
MSG kIndexExceedsMaxActiveUniformBlock = "Index must be less than program active uniform block count.";
MSG kIndexExceedsMaxAtomicCounterBufferBindings = "Index must be less than MAX_ATOMIC_COUNTER_BUFFER_BINDINGS.";
MSG kIndexExceedsMaxDrawBuffer = "Index must be less than MAX_DRAW_BUFFERS.";
MSG kIndexExceedsMaxTransformFeedbackAttribs = "Index must be less than MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS.";
MSG kIndexExceedsMaxUniformBufferBindings = "Index must be less than MAX_UNIFORM_BUFFER_BINDINGS.";
MSG kIndexExceedsMaxVertexAttribute = "Index must be less than MAX_VERTEX_ATTRIBS.";
MSG kIndexExceedsMaxWorkgroupDimensions = "Index must be less than the number of workgroup dimensions (3).";
MSG kIndexExceedsSamples = "Index must be less than the value of SAMPLES.";
MSG kIndexExceedsTransformFeedbackBufferBindings = "Index is greater than or equal to the number of TRANSFORM_FEEDBACK_BUFFER indexed binding points.";
MSG kInsufficientBufferSize = "Insufficient buffer size.";
MSG kInsufficientParams = "More parameters are required than were provided.";
MSG kInsufficientVertexBufferSize = "Vertex buffer is not big enough for the draw call";
MSG kIntegerOverflow = "Integer overflow.";
MSG kInternalFormatRequiresTexture2DArray = "internalformat is an ETC2/EAC format and target is not GL_TEXTURE_2D_ARRAY.";
MSG kInvalidAccessBits = "Invalid access bits.";
MSG kInvalidAccessBitsFlush = "The explicit flushing bit may only be set if the buffer is mapped for writing.";
MSG kInvalidAccessBitsRead = "Invalid access bits when mapping buffer for reading";
MSG kInvalidAccessBitsReadWrite = "Need to map buffer for either reading or writing.";
MSG kInvalidAttachment = "Invalid Attachment Type.";
MSG kInvalidBindBufferSize = "Invalid buffer binding size.";
MSG kInvalidBindUniformLocation = "Location must be less than (MAX_VERTEX_UNIFORM_VECTORS + MAX_FRAGMENT_UNIFORM_VECTORS) * 4";
MSG kInvalidBlendEquation = "Invalid blend equation.";
MSG kInvalidBlendFunction = "Invalid blend function.";
MSG kInvalidBooleanValue = "Invalid boolean value. Must be GL_FALSE or GL_TRUE.";
MSG kInvalidBorder = "Border must be 0.";
MSG kInvalidBufferName = "name is not a valid buffer.";
MSG kInvalidBufferTypes = "Invalid buffer target.";
MSG kInvalidBufferUsage = "Invalid buffer usage enum.";
MSG kInvalidClearMask = "Invalid mask bits.";
MSG kInvalidClientState = "Invalid client vertex array type.";
MSG kInvalidClipPlane = "Invalid clip plane.";
MSG kInvalidCombinedImageUnit = "Specified unit must be in [GL_TEXTURE0 = GL_TEXTURE0 + GL_MAX_COMBINED_IMAGE_UNITS)";
MSG kInvalidComponents = "Invalid components.";
MSG kInvalidCompressedFormat = "Not a valid compressed texture format.";
MSG kInvalidCompressedImageSize = "Invalid compressed image size.";
MSG kInvalidConstantColor = "CONSTANT_COLOR (or ONE_MINUS_CONSTANT_COLOR) and CONSTANT_ALPHA (or ONE_MINUS_CONSTANT_ALPHA) cannot be used together as source and destination factors in the blend function.";
MSG kInvalidCopyCombination = "Invalid copy texture format combination.";
MSG kInvalidCoverageComponents = "components is not one of GL_RGB, GL_RGBA, GL_ALPHA or GL_NONE.";
MSG kInvalidCoverMode = "Invalid cover mode.";
MSG kInvalidCullMode = "Cull mode not recognized.";
MSG kInvalidDebugSeverity = "Invalid debug severity.";
MSG kInvalidDebugSource = "Invalid debug source.";
MSG kInvalidDebugSourceType = "If count is greater than zero, source and type cannot be GL_DONT_CARE.";
MSG kInvalidDebugType = "Invalid debug type.";
MSG kInvalidDefaultReadBuffer = "Read buffer must be GL_NONE or GL_BACK when reading from the default framebuffer.";
MSG kInvalidDepthRange = "Near value cannot be greater than far.";
MSG kInvalidDepthStencilDrawBuffer = "Draw buffer must be zero when using depth or stencil.";
MSG kInvalidDestinationTexture = "Destination texture is not a valid texture object.";
MSG kInvalidDestinationTextureType = "Invalid destination texture type.";
MSG kInvalidDrawBuffer = "Invalid draw buffer.";
MSG kInvalidDrawBufferCountForDefault = "The default framebuffer must have exactly one draw buffer.";
MSG kInvalidDrawBufferValue = "Ith value does not match COLOR_ATTACHMENTi or NONE.";
MSG kInvalidDrawMode = "Invalid draw mode.";
MSG kInvalidDrawModeTransformFeedback = "Draw mode must match current transform feedback object's draw mode.";
MSG kInvalidEGLImage = "EGL image is not valid.";
MSG kInvalidElementRange = "Invalid element range.";
MSG kInvalidFence = "Invalid fence object.";
MSG kInvalidFenceCondition = "Invalid value for condition.";
MSG kInvalidFenceState = "Fence must be set.";
MSG kInvalidFillMode = "Invalid fill mode.";
MSG kInvalidFilterTexture = "Texture only supports NEAREST and LINEAR filtering.";
MSG kInvalidFlags = "Invalid value for flags.";
MSG kInvalidFlushOutOfRange = "Flushed range does not fit into buffer mapping dimensions.";
MSG kInvalidFlushTarget = "Attempted to flush a buffer not mapped for explicit flushing.";
MSG kInvalidFlushZero = "Attempted to flush buffer object zero.";
MSG kInvalidFogDensity = "Invalid fog density (must be nonnegative).";
MSG kInvalidFogMode = "Invalid fog mode.";
MSG kInvalidFogParameter = "Invalid fog parameter.";
MSG kInvalidFormat = "Invalid format.";
MSG kInvalidFormatCombination = "Invalid combination of format = type and internalFormat.";
MSG kInvalidFragmentInputBinding = "No such binding.";
MSG kInvalidFramebufferAttachmentParameter = "Invalid parameter name for framebuffer attachment.";
MSG kInvalidFramebufferLayer = "Framebuffer layer cannot be less than 0 or greater than GL_MAX_FRAMEBUFFER_LAYERS_EXT.";
MSG kInvalidFramebufferName = "name is not a valid framebuffer.";
MSG kInvalidFramebufferTarget = "Invalid framebuffer target.";
MSG kInvalidFramebufferTextureLevel = "Mipmap level must be 0 when attaching a texture.";
MSG kInvalidHandleType = "Invalid handle type.";
MSG kInvalidImageAccess = "access is not one of the supported tokens.";
MSG kInvalidImageLayout = "Invalid image layout.";
MSG kInvalidImageFormat = "format is not one of supported image unit formats.";
MSG kInvalidIndentifier = "Invalid identifier.";
MSG kInvalidIndirectOffset = "indirect must be a multiple of the size of uint in basic machine units.";
MSG kInvalidInternalFormat = "Invalid internal format.";
MSG kInvalidLight = "Invalid light.";
MSG kInvalidLightModelParameter = "Invalid light model parameter.";
MSG kInvalidLightParameter = "Invalid light parameter.";
MSG kInvalidLogicOp = "Invalid logical operation.";
MSG kInvalidMapPointerQuery = "GL_BUFFER_MAP_POINTER can only be queried with GetBufferPointerv.";
MSG kInvalidMaterialFace = "Invalid material face.";
MSG kInvalidMaterialParameter = "Invalid material parameter.";
MSG kInvalidMatrixMode = "Invalid matrix mode.";
MSG kInvalidMemoryBarrierBit = "Invalid memory barrier bit.";
MSG kInvalidMipLevel = "Level of detail outside of range.";
MSG kInvalidMipLevels = "Invalid level count.";
MSG kInvalidMultisampledFramebufferOperation = "Invalid operation on multisampled framebuffer";
MSG kInvalidMultitextureUnit = "Specified unit must be in [GL_TEXTURE0 = GL_TEXTURE0 + GL_MAX_TEXTURE_UNITS)";
MSG kInvalidName = "Invalid name.";
MSG kInvalidNameCharacters = "Name contains invalid characters.";
MSG kInvalidPathCoefficientsArray = "No coefficients array given.";
MSG kInvalidPathCommand = "Invalid command.";
MSG kInvalidPathCommandsArray = "No commands array given.";
MSG kInvalidPathComponents = "Unexpected number of components";
MSG kInvalidPathCoordinateType = "Invalid coordinate type.";
MSG kInvalidPathEndCaps = "Invalid end caps.";
MSG kInvalidPathGenMode = "Invalid gen mode.";
MSG kInvalidPathJoinStyle = "Invalid join style.";
MSG kInvalidPathMatrix = "Invalid matrix.";
MSG kInvalidPathMiterLimit = "Invalid miter limit.";
MSG kInvalidPathNameArray = "No path name array.";
MSG kInvalidPathNameType = "Invalid path name type.";
MSG kInvalidPathNumCommands = "Invalid number of commands.";
MSG kInvalidPathNumCoords = "Invalid number of coordinates.";
MSG kInvalidPathNumCoordsArray = "No coordinate array given.";
MSG kInvalidPathNumPaths = "Invalid (negative) numPaths.";
MSG kInvalidPathParameter = "Invalid path parameter.";
MSG kInvalidPathStrokeWidth = "Invalid stroke width.";
MSG kInvalidPathValueArray = "No value array.";
MSG kInvalidPname = "Invalid pname.";
MSG kInvalidPointerQuery = "Invalid pointer query.";
MSG kInvalidPointParameter = "Invalid point parameter.";
MSG kInvalidPointParameterValue = "Invalid point parameter value (must be non-negative).";
MSG kInvalidPointSizeValue = "Invalid point size (must be positive).";
MSG kInvalidPrecision = "Invalid or unsupported precision type.";
MSG kInvalidPrimitiveMode = "Invalid primitive mode.";
MSG kInvalidProgramBinaryFormat = "Program binary format is not valid.";
MSG kInvalidProgramInterface = "Invalid program interface.";
MSG kInvalidProgramName = "Program object expected.";
MSG kInvalidProgramResourceIndex = "Invalid program resource index.";
MSG kInvalidProgramResourceProperty = "Invalid program resource property.";
MSG kInvalidProjectionMatrix = "Invalid projection matrix. Left/right = top/bottom = near/far intervals cannot be zero = and near/far cannot be less than zero.";
MSG kInvalidPropCount = "Invalid propCount.";
MSG kInvalidPropertyForProgramInterface = "Not an allowed program resource property for this program interface";
MSG kInvalidProvokingVertex = "Invalid provoking vertex.";
MSG kInvalidQueryId = "Invalid query Id.";
MSG kInvalidQueryName = "name is not a valid query.";
MSG kInvalidQueryTarget = "Invalid query target.";
MSG kInvalidQueryType = "Invalid query type.";
MSG kInvalidRange = "Invalid range.";
MSG kInvalidReadBuffer = "Invalid read buffer";
MSG kInvalidRenderbufferInternalFormat = "Invalid renderbuffer internalformat.";
MSG kInvalidRenderbufferName = "name is not a valid renderbuffer.";
MSG kInvalidRenderbufferTarget = "Invalid renderbuffer target.";
MSG kInvalidRenderbufferTextureParameter = "Invalid parameter name for renderbuffer attachment.";
MSG kInvalidRenderbufferWidthHeight = "Renderbuffer width and height cannot be negative and cannot exceed maximum texture size.";
MSG kInvalidResetStatus = "Reset status is not valid";
MSG kInvalidSampleMaskNumber = "MaskNumber cannot be greater than or equal to the value of MAX_SAMPLE_MASK_WORDS.";
MSG kInvalidSampler = "Sampler is not valid";
MSG kInvalidSamplerName = "name is not a valid sampler.";
MSG kInvalidShaderBinaryFormat = "Invalid shader binary format.";
MSG kInvalidShaderName = "Shader object expected.";
MSG kInvalidShaderType = "Invalid shader type.";
MSG kInvalidShadingModel = "Invalid shading model.";
MSG kInvalidSourceTexture = "Source texture is not a valid texture object.";
MSG kInvalidSourceTextureInternalFormat = "Source texture internal format is invalid.";
MSG kInvalidSourceTextureLevel = "Invalid source texture level.";
MSG kInvalidSourceTextureSize = "Invalid source texture height or width.";
MSG kInvalidSourceTextureType = "Source texture must be a valid texture type.";
MSG kInvalidStencil = "Invalid stencil.";
MSG kInvalidStencilBitMask = "Invalid stencil bit mask.";
MSG kInvalidSyncPointer = "Not a valid sync pointer.";
MSG kInvalidTarget = "Invalid target.";
MSG kInvalidTextureCombine = "Invalid texture combine mode.";
MSG kInvalidTextureCombineOp = "Invalid texture combine operand.";
MSG kInvalidTextureCombineSrc = "Invalid texture combine source.";
MSG kInvalidTextureEnvMode = "Invalid texture environment mode.";
MSG kInvalidTextureEnvParameter = "Invalid texture environment parameter.";
MSG kInvalidTextureEnvScale = "Invalid texture environment scale.";
MSG kInvalidTextureEnvTarget = "Invalid texture environment target.";
MSG kInvalidTextureFilterParam = "Texture filter not recognized.";
MSG kInvalidTextureLevel = "Texture level does not exist.";
MSG kInvalidTextureName = "Not a valid texture object name.";
MSG kInvalidTextureRange = "Cannot be less than 0 or greater than maximum number of textures.";
MSG kInvalidTextureTarget = "Invalid or unsupported texture target.";
MSG kInvalidTextureType = "Texture has incompatible target.";
MSG kInvalidTextureWrap = "Texture wrap mode not recognized.";
MSG kInvalidTimeout = "Invalid value for timeout.";
MSG kInvalidTransformation = "Invalid transformation.";
MSG kInvalidTransformFeedbackAttribsCount = "Count exceeds MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS.";
MSG kInvalidTransformFeedbackName = "name is not a valid transform feedback.";
MSG kInvalidType = "Invalid type.";
MSG kInvalidUniformCount = "Only array uniforms may have count > 1.";
MSG kInvalidUniformLocation = "Invalid uniform location";
MSG kInvalidUnpackAlignment = "Unpack alignment must be 1 = 2 = 4 = or 8.";
MSG kInvalidVaryingLocation = "Location exceeds max varying.";
MSG kInvalidVertexArray = "Vertex array does not exist.";
MSG kInvalidVertexArrayName = "name is not a valid vertex array.";
MSG kInvalidVertexAttribSize2101010 = "Type is INT_2_10_10_10_REV or UNSIGNED_INT_2_10_10_10_REV and size is not 4.";
MSG kInvalidVertexAttrSize = "Vertex attribute size must be 1 = 2 = 3 = or 4.";
MSG kInvalidVertexPointerSize = "Size for built-in vertex attribute is outside allowed range.";
MSG kInvalidVertexPointerStride = "Invalid stride for built-in vertex attribute.";
MSG kInvalidVertexPointerType = "Invalid type for built-in vertex attribute.";
MSG kInvalidWidth = "Invalid width.";
MSG kInvalidWrapModeTexture = "Invalid wrap mode for texture type.";
MSG kLengthZero = "Length must not be zero.";
MSG kLevelNotZero = "Texture level must be zero.";
MSG kLightParameterOutOfRange = "Light parameter out of range.";
MSG kMapOutOfRange = "Mapped range does not fit into buffer dimensions.";
MSG kMaterialParameterOutOfRange = "Material parameter out of range.";
MSG kMatrixStackOverflow = "Current matrix stack is full.";
MSG kMatrixStackUnderflow = "Current matrix stack has only a single matrix.";
MSG kMaxActiveVariablesInterface = "MAX_NUM_ACTIVE_VARIABLES requires a buffer or block interface.";
MSG kMismatchedFormat = "Format must match internal format.";
MSG kMismatchedTargetAndFormat = "Invalid texture target and format combination.";
MSG kMismatchedTypeAndFormat = "Invalid format and type combination.";
MSG kMismatchedVariableProgram = "Variable is not part of the current program.";
MSG kMissingName = "No name given.";
MSG kMissingReadAttachment = "Missing read attachment.";
MSG kMissingTexture = "No Texture is bound to the specified target.";
MSG kMissingTextureName = "texture is not the name of an existing texture object.";
MSG kMultisampleArrayExtensionRequired = "GL_ANGLE_texture_multisample_array not enabled.";
MSG kMultisampleTextureExtensionOrES31Required = "GL_ANGLE_texture_multisample or GLES 3.1 required.";
MSG kMultiviewActive = "The number of views in the active draw framebuffer is greater than 1.";
MSG kMultiviewMismatch = "The number of views in the active program and draw framebuffer does not match.";
MSG kMultiviewNotAvailable = "ANGLE_multiview is not available.";
MSG kMultiviewReadFramebuffer = "The active read framebuffer object has multiview attachments.";
MSG kMultiviewTimerQuery = "There is an active query for target GL_TIME_ELAPSED_EXT when the number of views in the active draw framebuffer is greater than 1.";
MSG kMultiviewTransformFeedback = "There is an active transform feedback object when the number of views in the active draw framebuffer is greater than 1.";
MSG kMultiviewViewsTooLarge = "numViews cannot be greater than GL_MAX_VIEWS_ANGLE.";
MSG kMultiviewViewsTooSmall = "numViews cannot be less than 1.";
MSG kMustHaveElementArrayBinding = "Must have element array buffer bound.";
MSG kNameBeginsWithGL = "Attributes that begin with 'gl_' are not allowed.";
MSG kNegativeAttachments = "Negative number of attachments.";
MSG kNegativeBaseViewIndex = "Negative baseViewIndex.";
MSG kNegativeBufferSize = "Negative buffer size.";
MSG kNegativeBufSize = "Invalid bufSize.";
MSG kNegativeCount = "Negative count.";
MSG kNegativeHeightWidthDepth = "Cannot have negative height = width = or depth.";
MSG kNegativeLayer = "Negative layer.";
MSG kNegativeLength = "Negative length.";
MSG kNegativeLevel = "Level is negative.";
MSG kNegativeLocation = "Location cannot be less than 0.";
MSG kNegativeMaxCount = "Negative maxcount.";
MSG kNegativeOffset = "Negative offset.";
MSG kNegativeParam = "param is negative.";
MSG kNegativePrimcount = "Primcount must be greater than or equal to zero.";
MSG kNegativeSize = "Negative size.";
MSG kNegativeStart = "Cannot have negative start.";
MSG kNegativeStride = "Cannot have negative stride.";
MSG kNegativeXYZ = "x = y = or z cannot be negative.";
MSG kNoActiveComputeShaderStage = "No active compute shader stage in this program.";
MSG kNoActiveGeometryShaderStage = "No active geometry shader stage in this program.";
MSG kNoActiveGraphicsShaderStage = "It is a undefined behaviour to render without vertex shader stage or fragment shader stage.";
MSG kNoActiveProgramWithComputeShader = "No active program for the compute shader stage.";
MSG kNoDefinedClearConversion = "No defined conversion between clear value and attachment format.";
MSG kNonPositiveDrawTextureDimension = "Both width and height argument of drawn texture must be positive.";
MSG kNoPathOrNoPathData = "No such path or path has no data.";
MSG kNoProgramBinaryFormats = "No program binary formats supported.";
MSG kNoReadFramebuffer = "No active read framebuffer.";
MSG kNoSampleAlphaToCoveragesLimitation = "Current renderer doesn't support alpha-to-coverage.";
MSG kNoSuchPath = "No such path object.";
MSG kNoTransformArray = "No transform array given.";
MSG kNoTransformFeedbackOutputVariables = "The active program has specified no output variables to record.";
MSG kNoZeroDivisor = "At least one enabled attribute must have a divisor of zero.";
MSG kNVFenceNotSupported = "GL_NV_fence is not supported";
MSG kObjectNotGenerated = "Object cannot be used because it has not been generated.";
MSG kOffsetAlignment = "offset must be a multiple of 4.";
MSG kOffsetAndSizeAlignment = "Offset and size must be multiple of 4.";
MSG kOffsetMustBeMultipleOfType = "Offset must be a multiple of the passed in datatype.";
MSG kOffsetMustBeMultipleOfUint = "Offset must be a multiple of the size = in basic machine units = of uint";
MSG kOffsetOverflow = "Offset overflows texture dimensions.";
MSG kOtherQueryActive = "Other query is active.";
MSG kOutsideOfBounds = "Parameter outside of bounds.";
MSG kParamOverflow = "The provided parameters overflow with the provided buffer.";
MSG kPixelDataNotNull = "Pixel data must be null.";
MSG kPixelDataNull = "Pixel data cannot be null.";
MSG kPixelPackBufferBoundForTransformFeedback = "It is undefined behavior to use a pixel pack buffer that is bound for transform feedback.";
MSG kPixelUnpackBufferBoundForTransformFeedback = "It is undefined behavior to use a pixel unpack buffer that is bound for transform feedback.";
MSG kPointSizeArrayExtensionNotEnabled = "GL_OES_point_size_array not enabled.";
MSG kProgramDoesNotExist = "Program doesn't exist.";
MSG kProgramInterfaceMustBeProgramOutput = "programInterface must be set to GL_PROGRAM_OUTPUT.";
MSG kProgramNotBound = "A program must be bound.";
MSG kProgramNotLinked = "Program not linked.";
MSG kQueryActive = "Query is active.";
MSG kQueryExtensionNotEnabled = "Query extension not enabled.";
MSG kQueryInactive = "Query is not active.";
MSG kQueryTargetMismatch = "Query type does not match target.";
MSG kReadBufferNone = "Read buffer is GL_NONE.";
MSG kReadBufferNotAttached = "Read buffer has no attachment.";
MSG kRectangleTextureCompressed = "Rectangle texture cannot have a compressed format.";
MSG kRelativeOffsetTooLarge = "relativeOffset cannot be greater than MAX_VERTEX_ATTRIB_RELATIVE_OFFSET.";
MSG kRenderableInternalFormat = "SizedInternalformat must be color-renderable = depth-renderable = or stencil-renderable.";
MSG kRenderbufferNotBound = "A renderbuffer must be bound.";
MSG kResourceMaxRenderbufferSize = "Desired resource size is greater than max renderbuffer size.";
MSG kResourceMaxTextureSize = "Desired resource size is greater than max texture size.";
MSG kSamplerFormatMismatch = "Mismatch between texture format and sampler type (signed/unsigned/float/shadow).";
MSG kSamplerUniformValueOutOfRange = "Sampler uniform value out of range.";
MSG kSamplesOutOfRange = "Samples must not be greater than maximum supported value for the format.";
MSG kSamplesZero = "Samples may not be zero.";
MSG kShaderAttachmentHasShader = "Shader attachment already has a shader.";
MSG kShaderSourceInvalidCharacters = "Shader source contains invalid characters.";
MSG kShaderStorageBufferOffsetAlignment = "Offset must be multiple of value of SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT.";
MSG kShaderToDetachMustBeAttached = "Shader to be detached must be currently attached to the program.";
MSG kSourceLevelNotDefined = "The source level of the source texture must be defined.";
MSG kSourceTextureLevelZeroDefined = "Source texture must level 0 defined.";
MSG kSourceTextureMustBeCompressed = "Source texture must have a compressed internal format.";
MSG kSourceTextureTooSmall = "The specified dimensions are outside of the bounds of the texture.";
MSG kStencilReferenceMaskOrMismatch = "Stencil reference and mask values must be the same for front facing and back facing triangles.";
MSG kStrideExceedsWebGLLimit = "Stride is over the maximum stride allowed by WebGL.";
MSG kStrideMustBeMultipleOfType = "Stride must be a multiple of the passed in datatype.";
MSG kSyncMissing = "Sync object does not exist.";
MSG kTargetMustBeTexture2DMultisampleArrayOES = "Target must be TEXTURE_2D_MULTISAMPLE_ARRAY_OES.";
MSG kTextureFormatMismatch = "Passed in texture target and format must match the one originally used to define the texture.";
MSG kTextureIsImmutable = "Texture is immutable.";
MSG kTextureIsNotImmutable = "Texture is not immutable.";
MSG kTextureNotBound = "A texture must be bound.";
MSG kTextureNotPow2 = "The texture is a non-power-of-two texture.";
MSG kTextureRectangleNotSupported = "Context does not support GL_ANGLE_texture_rectangle";
MSG kTextureSizeTooSmall = "Texture dimensions must all be greater than zero.";
MSG kTextureTargetMismatch = "Textarget must match the texture target type.";
MSG kTextureTargetRequiresES31 = "Texture target requires at least OpenGL ES 3.1.";
MSG kTextureTypeConflict = "Two textures of different types use the same sampler location.";
MSG kTextureTypeMismatch = "Passed in texture type must match the one originally used to define the texture.";
MSG kTextureWidthOrHeightOutOfRange = "Width and height must be less than or equal to GL_MAX_TEXTURE_SIZE.";
MSG kTransfomFeedbackAlreadyActive = "Transform feedback is already active.";
MSG kTransformFeedbackActiveDelete = "Attempt to delete an active transform feedback.";
MSG kTransformFeedbackActiveDuringLink = "Cannot link program while program is associated with an active transform feedback object.";
MSG kTransformFeedbackBufferDoubleBound = "A transform feedback buffer that would be written to is also bound to a non-transform-feedback target = which would cause undefined behavior.";
MSG kTransformFeedbackBufferMultipleOutputs = "Transform feedback has a buffer bound to multiple outputs.";
MSG kTransformFeedbackBufferTooSmall = "Not enough space in bound transform feedback buffers.";
MSG kTransformFeedbackDoesNotExist = "Transform feedback object that does not exist.";
MSG kTransformFeedbackNotActive = "No Transform Feedback object is active.";
MSG kTransformFeedbackNotPaused = "The active Transform Feedback object is not paused.";
MSG kTransformFeedbackPaused = "The active Transform Feedback object is paused.";
MSG kTransformFeedbackProgramBinary = "Cannot change program binary while program is associated with an active transform feedback object.";
MSG kTransformFeedbackTargetActive = "Target is TRANSFORM_FEEDBACK_BUFFER and transform feedback is currently active.";
MSG kTransformFeedbackUseProgram = "Cannot change active program while transform feedback is unpaused.";
MSG kTransformFeedbackVaryingIndexOutOfRange = "Index must be less than the transform feedback varying count in the program.";
MSG kTypeNotUnsignedShortByte = "Only UNSIGNED_SHORT and UNSIGNED_BYTE types are supported.";
MSG kUniformBufferBoundForTransformFeedback = "It is undefined behavior to use an uniform buffer that is bound for transform feedback.";
MSG kUniformBufferOffsetAlignment = "Offset must be multiple of value of UNIFORM_BUFFER_OFFSET_ALIGNMENT.";
MSG kUniformBufferTooSmall = "It is undefined behaviour to use a uniform buffer that is too small.";
MSG kUniformBufferUnbound = "It is undefined behaviour to have a used but unbound uniform buffer.";
MSG kUniformSizeMismatch = "Uniform size does not match uniform method.";
MSG kUniformTypeMismatch = "Uniform type does not match uniform method.";
MSG kUnimplementedComputeShaderPrecision = "Compute shader precision not yet implemented.";
MSG kUnknownParameter = "Unknown parameter value.";
MSG kUnsizedInternalFormatUnsupported = "Internalformat is one of the unsupported unsized base internalformats.";
MSG kUnsupportedDrawModeForTransformFeedback = "The draw command is unsupported when transform feedback is active and not paused.";
MSG kUnsupportedFloatBlending = "GL_BLEND with floating-point color attachments requires the EXT_float_blend extension.";
MSG kVertexArrayNoBuffer = "An enabled vertex array has no buffer.";
MSG kVertexArrayNoBufferPointer = "An enabled vertex array has no buffer and no pointer.";
MSG kVertexBufferBoundForTransformFeedback = "It is undefined behavior to use a vertex buffer that is bound for transform feedback.";
MSG kVertexShaderTypeMismatch = "Vertex shader input type does not match the type of the bound vertex attribute.";
MSG kViewportNegativeSize = "Viewport size cannot be negative.";
MSG kViewsExceedMaxArrayLayers = "baseViewIndex+numViews cannot be greater than GL_MAX_ARRAY_TEXTURE_LAYERS.";
MSG kWebgl2NameLengthLimitExceeded = "Location lengths must not be greater than 1024 characters.";
MSG kWebglBindAttribLocationReservedPrefix = "Attributes that begin with 'webgl_' = or '_webgl_' are not allowed.";
MSG kWebglNameLengthLimitExceeded = "Location name lengths must not be greater than 256 characters.";
MSG kZeroBoundToTarget = "Zero is bound to target.";
// clang-format on

#undef MSG
}  // namespace err
}  // namespace gl
#endif  // LIBANGLE_ERRORSTRINGS_H_
