Skia Graphics Library
=====================

Skia is an open source 2D graphics library which provides common APIs that work
across a variety of hardware and software platforms.  It serves as the graphics
engine for Google Chrome and Chrome OS, Android, Mozilla Firefox and Firefox
OS, and many other products.

Skia is sponsored and managed by Google, but is available for use by anyone
under the BSD Free Software License.  While engineering of the core components
is done by the Skia development team, we consider contributions from any
source.

  * Canonical source tree:
    [skia.googlesource.com/skia](https://skia.googlesource.com/skia).
  * Issue tracker:
    [bug.skia.org](https://bug.skia.org/).
  * Discussion forum:
    [skia-discuss@googlegroups.com](https://groups.google.com/forum/#!forum/skia-discuss).
  * API Reference and Overview: [skia.org/user/api](https://skia.org/user/api/).
  * Skia Fiddle: [fiddle.skia.org](https://fiddle.skia.org/c/@skcanvas_paint).

Showcase
--------

Click on any image below to see the source code that generated the image.
<table>
  <tr><th>Shapes</th><th>Bézier Curves</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@shapes'><img src='https://fiddle.skia.org/i/@shapes_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@bezier_curves'><img src='https://fiddle.skia.org/i/@bezier_curves_raster.png'></a>
    </td>
  </tr>

  <tr><th>Translations and Rotations</th><th>Text Rendering</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@rotations'><img src='https://fiddle.skia.org/i/@rotations_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@text_rendering'><img src='https://fiddle.skia.org/i/@text_rendering_raster.png'></a>
    </td>
  </tr>

  <tr><th>Discrete Path Effects</th><th>Composed Path Effects</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@discrete_path'><img src='https://fiddle.skia.org/i/@discrete_path_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@compose_path'><img src='https://fiddle.skia.org/i/@compose_path_raster.png'></a>
    </td>
  </tr>
  <tr><th>Sum Path Effects</th><th>Shaders</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@sum_path_effect'><img src='https://fiddle.skia.org/i/@sum_path_effect_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@shader'><img src='https://fiddle.skia.org/i/@shader_raster.png'></a>
    </td>
  </tr>
</table>

Roadmap
-------
For a look at high level themes we have on tap the next 6-12 months, view our
roadmap [here](https://docs.google.com/document/d/1LSdO3I-IdZVZCtEnW9pu3k_32gfPIcB_YeSn-OJBGZI/edit?usp=sharing).
Note it is a living document that changes based on the requirements of our users.

Platforms
---------
  * Windows 7, 8, 8.1, 10
  * macOS 10.10.5 or later
  * iOS 8 or later
  * Android 4.1 (JellyBean) or later
  * Ubuntu 14.04+, Debian 8+, openSUSE 13.3+, or Fedora Linux 24+
