/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;

public final class DisallowedGlobalPropertiesChecker
extends ContextTrackingChecker {
    private static final Set<String> GLOBAL_OBJECT_NAMES = new HashSet<String>();
    private static final Set<String> DISALLOWED_PROPERTIES = new HashSet<String>();
    private static final FunctionRecord TOP_LEVEL_FUNCTION;
    private final Map<FunctionRecord, Set<String>> declaredLocalVariables = new HashMap<FunctionRecord, Set<String>>();
    private final Map<FunctionRecord, List<Node>> globalPropertyAccessNodes = new HashMap<FunctionRecord, List<Node>>();

    @Override
    protected void enterNode(Node node) {
        switch (node.getToken()) {
            case VAR: {
                this.handleVar(node);
                break;
            }
            case CONST: {
                this.handleVar(node);
                break;
            }
            case LET: {
                this.handleVar(node);
                break;
            }
            case NAME: {
                this.handleName(node);
                break;
            }
            case STRING: {
                this.handleString(node);
                break;
            }
            case FUNCTION: 
            case SCRIPT: {
                this.enterFunctionOrScript();
                break;
            }
        }
    }

    @Override
    protected void leaveNode(Node node) {
        switch (node.getToken()) {
            case FUNCTION: 
            case SCRIPT: {
                this.leaveFunctionOrScript();
                break;
            }
        }
    }

    private void enterFunctionOrScript() {
        FunctionRecord functionRecord = this.getCurrentFunction();
        this.declaredLocalVariables.put(functionRecord, new HashSet());
        this.globalPropertyAccessNodes.put(functionRecord, new ArrayList());
    }

    private void leaveFunctionOrScript() {
        FunctionRecord functionRecord = this.getCurrentFunction();
        if (!functionRecord.suppressesGlobalPropertiesCheck()) {
            this.checkAccessNodes(this.globalPropertyAccessNodes.get(functionRecord));
        }
        this.declaredLocalVariables.remove(functionRecord);
        this.globalPropertyAccessNodes.remove(functionRecord);
    }

    private void checkAccessNodes(List<Node> list) {
        FunctionRecord functionRecord = this.getCurrentFunction();
        for (Node node : list) {
            String string = this.getContext().getNodeText(node);
            if (this.functionHasVisibleIdentifier(functionRecord, string)) continue;
            this.reportErrorAtNodeStart(node, String.format("Access to \"%s\" property of global object is disallowed", string));
        }
    }

    private void handleVar(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return;
        }
        String string = node2.getString();
        if (string != null) {
            this.declaredLocalVariables.get(this.getCurrentFunction()).add(string);
        }
    }

    private void handleName(Node node) {
        Node node2 = node.getParent();
        if (node2 != null && node2.getToken() == Token.FUNCTION) {
            return;
        }
        String string = this.getContext().getNodeText(node);
        if (!DISALLOWED_PROPERTIES.contains(string)) {
            return;
        }
        if (node2 != null && node2.getToken() == Token.GETPROP) {
            boolean bl;
            boolean bl2 = bl = node2.getFirstChild() == node;
            if (!bl) {
                return;
            }
        }
        this.globalPropertyAccessNodes.get(this.getCurrentFunction()).add(node);
    }

    private void handleString(Node node) {
        boolean bl;
        String string = this.getContext().getNodeText(node);
        if (!DISALLOWED_PROPERTIES.contains(string)) {
            return;
        }
        Node node2 = node.getParent();
        if (node2 == null || node2.getToken() != Token.GETPROP) {
            return;
        }
        Node node3 = node2.getFirstChild();
        boolean bl2 = bl = node3 != null && this.isGlobalObject(node3) && node3.getNext() == node;
        if (bl) {
            this.globalPropertyAccessNodes.get(this.getCurrentFunction()).add(node);
        }
    }

    private FunctionRecord getCurrentFunction() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        return functionRecord == null ? TOP_LEVEL_FUNCTION : functionRecord;
    }

    private boolean isGlobalObject(Node node) {
        String string = this.getContext().getNodeText(node);
        if (!GLOBAL_OBJECT_NAMES.contains(string)) {
            return false;
        }
        return node.getToken() == Token.NAME && !this.functionHasVisibleIdentifier(this.getCurrentFunction(), string);
    }

    private boolean functionHasVisibleIdentifier(FunctionRecord functionRecord, String string) {
        if (this.functionHasLocalIdentifier(functionRecord, string)) {
            return true;
        }
        if (functionRecord == TOP_LEVEL_FUNCTION) {
            return false;
        }
        FunctionRecord functionRecord2 = functionRecord.enclosingFunctionRecord;
        return this.functionHasVisibleIdentifier(functionRecord2 == null ? TOP_LEVEL_FUNCTION : functionRecord2, string);
    }

    private boolean functionHasLocalIdentifier(FunctionRecord functionRecord, String string) {
        return functionRecord.parameterNames.contains(string) || this.declaredLocalVariables.get(functionRecord).contains(string);
    }

    static {
        GLOBAL_OBJECT_NAMES.add("window");
        GLOBAL_OBJECT_NAMES.add("self");
        DISALLOWED_PROPERTIES.add("document");
        DISALLOWED_PROPERTIES.add("addEventListener");
        DISALLOWED_PROPERTIES.add("removeEventListener");
        DISALLOWED_PROPERTIES.add("requestAnimationFrame");
        DISALLOWED_PROPERTIES.add("cancelAnimationFrame");
        DISALLOWED_PROPERTIES.add("getSelection");
        TOP_LEVEL_FUNCTION = new FunctionRecord();
    }
}

