/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.util.ListUtil;

public class ClassPathElement
extends Path {
    private String filter;
    private String apkFilter;
    private String jarFilter;
    private String aarFilter;
    private String warFilter;
    private String earFilter;
    private String zipFilter;

    public ClassPathElement(Project project) {
        super(project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendClassPathEntriesTo(ClassPath classPath, boolean bl) {
        Object object;
        String[] stringArray;
        File file = this.getProject().getBaseDir();
        if (this.isReference()) {
            Object object2 = this.getCheckedRef(DataType.class, DataType.class.getName());
            if (object2 instanceof Path) {
                Path path = (Path)object2;
                stringArray = path.list();
            } else {
                if (!(object2 instanceof AbstractFileSet)) throw new BuildException("The refid attribute doesn't point to a <path> element or a <fileset> element");
                AbstractFileSet abstractFileSet = (AbstractFileSet)object2;
                object = abstractFileSet.getDirectoryScanner(this.getProject());
                file = object.getBasedir();
                stringArray = object.getIncludedFiles();
            }
        } else {
            stringArray = this.list();
        }
        if (bl && stringArray.length != 1) {
            throw new BuildException("The <outjar> element must specify exactly one file or directory [" + stringArray.length + "]");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            object = new File(string);
            ClassPathEntry classPathEntry = new ClassPathEntry((File)(((File)object).isAbsolute() ? object : new File(file, string)), bl);
            classPathEntry.setFilter(ListUtil.commaSeparatedList(this.filter));
            classPathEntry.setApkFilter(ListUtil.commaSeparatedList(this.apkFilter));
            classPathEntry.setJarFilter(ListUtil.commaSeparatedList(this.jarFilter));
            classPathEntry.setAarFilter(ListUtil.commaSeparatedList(this.aarFilter));
            classPathEntry.setWarFilter(ListUtil.commaSeparatedList(this.warFilter));
            classPathEntry.setEarFilter(ListUtil.commaSeparatedList(this.earFilter));
            classPathEntry.setZipFilter(ListUtil.commaSeparatedList(this.zipFilter));
            classPath.add(classPathEntry);
        }
    }

    public void setFile(File file) {
        this.setLocation(file);
    }

    public void setDir(File file) {
        this.setLocation(file);
    }

    public void setName(File file) {
        this.setLocation(file);
    }

    public void setFilter(String string) {
        this.filter = string;
    }

    public void setApkfilter(String string) {
        this.apkFilter = string;
    }

    public void setJarfilter(String string) {
        this.jarFilter = string;
    }

    public void setAarfilter(String string) {
        this.aarFilter = string;
    }

    public void setWarfilter(String string) {
        this.warFilter = string;
    }

    public void setEarfilter(String string) {
        this.earFilter = string;
    }

    public void setZipfilter(String string) {
        this.zipFilter = string;
    }
}

