/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.CharsetProviderICU;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetHZ
extends CharsetICU {
    private static final int UCNV_TILDE = 126;
    private static final int UCNV_OPEN_BRACE = 123;
    private static final int UCNV_CLOSE_BRACE = 125;
    private static final byte[] SB_ESCAPE = new byte[]{126, 125};
    private static final byte[] DB_ESCAPE = new byte[]{126, 123};
    private static final byte[] TILDE_ESCAPE = new byte[]{126, 126};
    private static final byte[] fromUSubstitution = new byte[]{26};
    private CharsetMBCS gbCharset = (CharsetMBCS)new CharsetProviderICU().charsetForName("GBK");
    private boolean isEmptySegment;

    public CharsetHZ(String icuCanonicalName, String canonicalName, String[] aliases) {
        super(icuCanonicalName, canonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.isEmptySegment = false;
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderHZ(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderHZ(this);
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        setFillIn.add(0, 127);
        this.gbCharset.MBCSGetFilteredUnicodeSetForUnicode(this.gbCharset.sharedData, setFillIn, which, 6);
    }

    class CharsetEncoderHZ
    extends CharsetEncoderICU {
        CharsetMBCS.CharsetEncoderMBCS gbEncoder;
        boolean isEscapeAppended;
        boolean isTargetUCharDBCS;

        public CharsetEncoderHZ(CharsetICU cs) {
            super(cs, fromUSubstitution);
            this.isEscapeAppended = false;
            this.isTargetUCharDBCS = false;
            this.gbEncoder = (CharsetMBCS.CharsetEncoderMBCS)CharsetHZ.this.gbCharset.newEncoder();
        }

        protected void implReset() {
            super.implReset();
            this.gbEncoder.implReset();
            this.isEscapeAppended = false;
            this.isTargetUCharDBCS = false;
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            int length = 0;
            int[] targetUniChar = new int[]{0};
            char mySourceChar = '\u0000';
            boolean oldIsTargetUCharDBCS = this.isTargetUCharDBCS;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (this.fromUChar32 != 0 && target.hasRemaining()) {
                CoderResult cr = this.handleSurrogates(source, (char)this.fromUChar32);
                return cr != null ? cr : CoderResult.unmappableForLength(2);
            }
            while (source.hasRemaining()) {
                targetUniChar[0] = 65535;
                if (target.hasRemaining()) {
                    mySourceChar = source.get();
                    oldIsTargetUCharDBCS = this.isTargetUCharDBCS;
                    if (mySourceChar == '~') {
                        this.concatEscape(source, target, offsets, TILDE_ESCAPE);
                        continue;
                    }
                    if (mySourceChar <= '\u007f') {
                        length = 1;
                        targetUniChar[0] = mySourceChar;
                    } else {
                        length = this.gbEncoder.fromUChar32(mySourceChar, targetUniChar, super.isFallbackUsed());
                        targetUniChar[0] = length == 2 && 41377 <= targetUniChar[0] && targetUniChar[0] <= 65022 && 161 <= (targetUniChar[0] & 0xFF) && (targetUniChar[0] & 0xFF) <= 254 ? targetUniChar[0] - 32896 : 65535;
                    }
                    if (targetUniChar[0] != 65535) {
                        boolean bl = this.isTargetUCharDBCS = targetUniChar[0] > 255;
                        if (oldIsTargetUCharDBCS != this.isTargetUCharDBCS || !this.isEscapeAppended) {
                            if (!this.isTargetUCharDBCS) {
                                this.concatEscape(source, target, offsets, SB_ESCAPE);
                                this.isEscapeAppended = true;
                            } else {
                                this.concatEscape(source, target, offsets, DB_ESCAPE);
                                this.isEscapeAppended = true;
                            }
                        }
                        if (this.isTargetUCharDBCS) {
                            if (target.hasRemaining()) {
                                target.put((byte)(targetUniChar[0] >> 8));
                                if (offsets != null) {
                                    offsets.put(source.position() - 1);
                                }
                                if (target.hasRemaining()) {
                                    target.put((byte)targetUniChar[0]);
                                    if (offsets == null) continue;
                                    offsets.put(source.position() - 1);
                                    continue;
                                }
                                this.errorBuffer[this.errorBufferLength++] = (byte)targetUniChar[0];
                                continue;
                            }
                            this.errorBuffer[this.errorBufferLength++] = (byte)(targetUniChar[0] >> 8);
                            this.errorBuffer[this.errorBufferLength++] = (byte)targetUniChar[0];
                            continue;
                        }
                        if (target.hasRemaining()) {
                            target.put((byte)targetUniChar[0]);
                            if (offsets == null) continue;
                            offsets.put(source.position() - 1);
                            continue;
                        }
                        this.errorBuffer[this.errorBufferLength++] = (byte)targetUniChar[0];
                        continue;
                    }
                    if (UTF16.isSurrogate((char)mySourceChar)) {
                        CoderResult cr = this.handleSurrogates(source, mySourceChar);
                        return cr != null ? cr : CoderResult.unmappableForLength(2);
                    }
                    this.fromUChar32 = mySourceChar;
                    return CoderResult.unmappableForLength(1);
                }
                return CoderResult.OVERFLOW;
            }
            return CoderResult.UNDERFLOW;
        }

        private CoderResult concatEscape(CharBuffer source, ByteBuffer target, IntBuffer offsets, byte[] strToAppend) {
            CoderResult cr = null;
            for (int i = 0; i < strToAppend.length; ++i) {
                byte b = strToAppend[i];
                if (target.hasRemaining()) {
                    target.put(b);
                    if (offsets == null) continue;
                    offsets.put(source.position() - 1);
                    continue;
                }
                this.errorBuffer[this.errorBufferLength++] = b;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    class CharsetDecoderHZ
    extends CharsetDecoderICU {
        CharsetMBCS.CharsetDecoderMBCS gbDecoder;
        boolean isStateDBCS;

        public CharsetDecoderHZ(CharsetICU cs) {
            super(cs);
            this.isStateDBCS = false;
            this.gbDecoder = (CharsetMBCS.CharsetDecoderMBCS)CharsetHZ.this.gbCharset.newDecoder();
        }

        protected void implReset() {
            super.implReset();
            this.gbDecoder.implReset();
            this.isStateDBCS = false;
            CharsetHZ.this.isEmptySegment = false;
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] tempBuf = new byte[2];
            int targetUniChar = 0;
            int mySourceChar = 0;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            block5: while (source.hasRemaining()) {
                if (target.hasRemaining()) {
                    mySourceChar = source.get() & 0xFF;
                    if (this.mode == 126) {
                        this.mode = 0;
                        switch (mySourceChar) {
                            case 10: {
                                continue block5;
                            }
                            case 126: {
                                if (offsets != null) {
                                    offsets.put(source.position() - 2);
                                }
                                target.put((char)mySourceChar);
                                continue block5;
                            }
                            case 123: 
                            case 125: {
                                boolean bl = this.isStateDBCS = mySourceChar == 123;
                                if (CharsetHZ.this.isEmptySegment) {
                                    CharsetHZ.this.isEmptySegment = false;
                                    this.toUBytesArray[0] = 126;
                                    this.toUBytesArray[1] = (byte)mySourceChar;
                                    this.toULength = 2;
                                    return CoderResult.malformedForLength(1);
                                }
                                CharsetHZ.this.isEmptySegment = true;
                                continue block5;
                            }
                        }
                        CharsetHZ.this.isEmptySegment = false;
                        err = CoderResult.malformedForLength(1);
                        this.toUBytesArray[0] = 126;
                        if (this.isStateDBCS ? 33 <= mySourceChar && mySourceChar <= 126 : mySourceChar <= 127) {
                            this.toULength = 1;
                            source.position(source.position() - 1);
                        } else {
                            this.toUBytesArray[1] = (byte)mySourceChar;
                            this.toULength = 2;
                        }
                        return err;
                    }
                    if (this.isStateDBCS) {
                        boolean trailIsOk;
                        if (this.toUnicodeStatus == 0) {
                            if (mySourceChar == 126) {
                                this.mode = 126;
                                continue;
                            }
                            this.toUnicodeStatus = mySourceChar | 0x100;
                            CharsetHZ.this.isEmptySegment = false;
                            continue;
                        }
                        int leadByte = this.toUnicodeStatus & 0xFF;
                        targetUniChar = 65535;
                        boolean leadIsOk = (short)(0xFF & leadByte - 33) <= 92;
                        boolean bl = trailIsOk = (short)(0xFF & mySourceChar - 33) <= 93;
                        if (leadIsOk && trailIsOk) {
                            tempBuf[0] = (byte)(leadByte + 128);
                            tempBuf[1] = (byte)(mySourceChar + 128);
                            targetUniChar = this.gbDecoder.simpleGetNextUChar(ByteBuffer.wrap(tempBuf), super.isFallbackUsed());
                            mySourceChar = leadByte << 8 | mySourceChar;
                        } else if (trailIsOk) {
                            source.position(source.position() - 1);
                            mySourceChar = leadByte;
                        } else {
                            mySourceChar = 0x10000 | leadByte << 8 | mySourceChar;
                        }
                        this.toUnicodeStatus = 0;
                    } else {
                        if (mySourceChar == 126) {
                            this.mode = 126;
                            continue;
                        }
                        if (mySourceChar <= 127) {
                            targetUniChar = mySourceChar;
                            CharsetHZ.this.isEmptySegment = false;
                        } else {
                            targetUniChar = 65535;
                            CharsetHZ.this.isEmptySegment = false;
                        }
                    }
                    if (targetUniChar < 65534) {
                        if (offsets != null) {
                            offsets.put(source.position() - 1 - (this.isStateDBCS ? 1 : 0));
                        }
                        target.put((char)targetUniChar);
                        continue;
                    }
                    if (mySourceChar > 255) {
                        this.toUBytesArray[this.toUBytesBegin + 0] = (byte)(mySourceChar >> 8);
                        this.toUBytesArray[this.toUBytesBegin + 1] = (byte)mySourceChar;
                        this.toULength = 2;
                    } else {
                        this.toUBytesArray[this.toUBytesBegin + 0] = (byte)mySourceChar;
                        this.toULength = 1;
                    }
                    if (targetUniChar == 65534) {
                        return CoderResult.unmappableForLength(this.toULength);
                    }
                    return CoderResult.malformedForLength(this.toULength);
                }
                return CoderResult.OVERFLOW;
            }
            return err;
        }
    }
}

