C++11 in Skia
=============

Skia uses C++11.  But as a library, we are technically limited by what our
clients support and what our build bots support.

Skia may also be limited by restrictions we choose put on ourselves.  This
document is not concerned with C++11 policy in Skia, only its technical
feasibility.  This is about what we can use, a superset of what we may use.

The gist:

-   C++11 the language as supported by GCC 4.7 or later is pretty usable.
-   The C++11 standard library can generally be used, with some teething.
-   If you break a bot, that feature is not usable.
-   Local statics are not thread safe.


Clients
-------

The clients we pay most attention to are Chrome, Android, Mozilla, and a few
internal Google projects.

Chrome builds with a recent Clang on Mac and Linux and with a recent MSVC on
Windows.  These toolchains are new enough to not be the weak link to use any
C++11 language feature.  Chromium, however, builds against libstdc++4.6.4
(STL and runtime) on Linux.  This precludes direct use of a number of type
traits.

Chrome intentionally disables thread-safe initialization of static variables,
so we cannot rely on that.  Our bots disable this too, so keep an eye on TSAN.

Android builds with either a somewhat aged GCC or a recent Clang.  They're
generally not a weak link for C++11 language features.  Android's C++ standard
library had historically been a pain, but seems to work fine these days.

Mozilla's current weak link is a minimum requirement of GCC 4.7.  Most features
marked in red on Mozilla's C++11 [feature
matrix](https://developer.mozilla.org/en-US/docs/Using_CXX_in_Mozilla_code) are
marked that way because they arrived in GCC 4.8.  Their minimum-supported Clang
and MSVC toolchains are pretty good, but MSVC 2013 will become the weak link soon.

Internal Google projects tend to support C++11 completely, including the
full C++11 standard library.


Bots
----

Most of our bots are pretty up-to-date: the Windows bots use MSVC 2013, the Mac
bots a recent Clang, and the Linux bots GCC 4.8 or a recent Clang.  Our Android
bots use a recent toolchain from Android (see above), and our Chrome bots use
Chrome's toolchains (see above).  I'm not exactly sure what our Chrome OS bots
are using.  They're probably our weak link right now, though problems are rare.

I believe our bots' ability to use C++11 matches Mozilla's list nearly identically.
