#

#=============================================================================
# Copyright 2002-2009 Kitware, Inc.
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distribute this file outside of CMake, substitute the full
#  License text for the above reference.)

# This is an implementation detail for using VTK 4.0 with the
# FindVTK.cmake module.  Do not include directly.

# Hard-code the version number since it isn't provided by VTK 4.0.
SET(VTK_MAJOR_VERSION 4)
SET(VTK_MINOR_VERSION 0)
SET(VTK_BUILD_VERSION 2)

# Provide a new UseVTK file that doesn't do a full LOAD_CACHE.
SET(VTK_USE_FILE ${CMAKE_ROOT}/Modules/UseVTK40.cmake)

# Provide a build settings file.
SET(VTK_BUILD_SETTINGS_FILE ${CMAKE_ROOT}/Modules/UseVTKBuildSettings40.cmake)

# There are no CMake extensions for VTK 4.0.
SET(VTK_CMAKE_EXTENSIONS_DIR "")

# grep "VTK40_" UseVTKConfig40.cmake |sed 's/.*VTK40_\([A-Za-z0-9_]*\).*/  \1/'
LOAD_CACHE(${VTK_DIR} READ_WITH_PREFIX VTK40_
  BUILD_SHARED_LIBS
  CMAKE_BUILD_TOOL
  CMAKE_BUILD_TYPE
  CMAKE_CACHE_MAJOR_VERSION
  CMAKE_CACHE_MINOR_VERSION
  CMAKE_CXX_COMPILER
  CMAKE_CXX_FLAGS
  CMAKE_CXX_FLAGS_DEBUG
  CMAKE_CXX_FLAGS_MINSIZEREL
  CMAKE_CXX_FLAGS_RELEASE
  CMAKE_CXX_FLAGS_RELWITHDEBINFO
  CMAKE_C_COMPILER
  CMAKE_C_FLAGS
  CMAKE_C_FLAGS_DEBUG
  CMAKE_C_FLAGS_MINSIZEREL
  CMAKE_C_FLAGS_RELEASE
  CMAKE_C_FLAGS_RELWITHDEBINFO
  CMAKE_INSTALL_PREFIX
  CMAKE_Xutil_INCLUDE_PATH
  EXECUTABLE_OUTPUT_PATH
  JAVA_INCLUDE_PATH2
  LIBRARY_OUTPUT_PATH
  MPIRUN
  MPI_INCLUDE_PATH
  MPI_POSTFLAGS
  MPI_PREFLAGS
  OPENGL_INCLUDE_DIR
  OSMESA_INCLUDE_PATH
  PYTHON_INCLUDE_PATH
  TCL_INCLUDE_PATH
  VLI_INCLUDE_PATH_FOR_VG500
  VLI_INCLUDE_PATH_FOR_VP1000
  VTK_BINARY_DIR
  VTK_DEBUG_LEAKS
  VTK_HAVE_VG500
  VTK_HAVE_VP1000
  VTK_MANGLE_MESA
  VTK_OPENGL_HAS_OSMESA
  VTK_PARSE_JAVA_EXE
  VTK_SOURCE_DIR
  VTK_USE_64BIT_IDS
  VTK_USE_ANSI_STDLIB
  VTK_USE_HYBRID
  VTK_USE_MATROX_IMAGING
  VTK_USE_MPI
  VTK_USE_PARALLEL
  VTK_USE_PATENTED
  VTK_USE_RENDERING
  VTK_USE_VIDEO_FOR_WINDOWS
  VTK_USE_VOLUMEPRO
  VTK_USE_X
  VTK_WRAP_JAVA
  VTK_WRAP_JAVA_EXE
  VTK_WRAP_PYTHON
  VTK_WRAP_PYTHON_EXE
  VTK_WRAP_TCL
  VTK_WRAP_TCL_EXE
  vtkCommonJava_LIB_DEPENDS
  vtkCommonPython_LIB_DEPENDS
  vtkCommonTCL_LIB_DEPENDS
  vtkCommon_LIB_DEPENDS
  vtkFilteringJava_LIB_DEPENDS
  vtkFilteringPython_LIB_DEPENDS
  vtkFilteringTCL_LIB_DEPENDS
  vtkFiltering_LIB_DEPENDS
  vtkGraphicsJava_LIB_DEPENDS
  vtkGraphicsPython_LIB_DEPENDS
  vtkGraphicsTCL_LIB_DEPENDS
  vtkGraphics_LIB_DEPENDS
  vtkHybridJava_LIB_DEPENDS
  vtkHybridPython_LIB_DEPENDS
  vtkHybridTCL_LIB_DEPENDS
  vtkHybrid_LIB_DEPENDS
  vtkIOJava_LIB_DEPENDS
  vtkIOPython_LIB_DEPENDS
  vtkIOTCL_LIB_DEPENDS
  vtkIO_LIB_DEPENDS
  vtkImagingJava_LIB_DEPENDS
  vtkImagingPython_LIB_DEPENDS
  vtkImagingTCL_LIB_DEPENDS
  vtkImaging_LIB_DEPENDS
  vtkParallelJava_LIB_DEPENDS
  vtkParallelPython_LIB_DEPENDS
  vtkParallelTCL_LIB_DEPENDS
  vtkParallel_LIB_DEPENDS
  vtkPatentedJava_LIB_DEPENDS
  vtkPatentedPython_LIB_DEPENDS
  vtkPatentedTCL_LIB_DEPENDS
  vtkPatented_LIB_DEPENDS
  vtkRenderingJava_LIB_DEPENDS
  vtkRenderingPythonTkWidgets_LIB_DEPENDS
  vtkRenderingPython_LIB_DEPENDS
  vtkRenderingTCL_LIB_DEPENDS
  vtkRendering_LIB_DEPENDS
  vtkjpeg_LIB_DEPENDS
  vtkpng_LIB_DEPENDS
  vtkzlib_LIB_DEPENDS
)

# Copy needed settings from the VTK 4.0 cache.
SET(VTK_BUILD_SHARED ${VTK40_BUILD_SHARED_LIBS})
SET(VTK_DEBUG_LEAKS ${VTK40_VTK_DEBUG_LEAKS})
SET(VTK_HAVE_VG500 ${VTK40_VTK_HAVE_VG500})
SET(VTK_HAVE_VP1000 ${VTK40_VTK_HAVE_VP1000})
SET(VTK_USE_MANGLED_MESA ${VTK40_VTK_MANGLE_MESA})
SET(VTK_MPIRUN_EXE ${VTK40_MPIRUN})
SET(VTK_MPI_POSTFLAGS ${VTK40_MPI_POSTFLAGS})
SET(VTK_MPI_PREFLAGS ${VTK40_MPI_PREFLAGS})
SET(VTK_OPENGL_HAS_OSMESA ${VTK40_VTK_OPENGL_HAS_OSMESA})
SET(VTK_USE_64BIT_IDS ${VTK40_VTK_USE_64BIT_IDS})
SET(VTK_USE_ANSI_STDLIB ${VTK40_VTK_USE_ANSI_STDLIB})
SET(VTK_USE_HYBRID ${VTK40_VTK_USE_HYBRID})
SET(VTK_USE_MATROX_IMAGING ${VTK40_VTK_USE_MATROX_IMAGING})
SET(VTK_USE_MPI ${VTK40_VTK_USE_MPI})
SET(VTK_USE_PARALLEL ${VTK40_VTK_USE_PARALLEL})
SET(VTK_USE_PATENTED ${VTK40_VTK_USE_PATENTED})
SET(VTK_USE_RENDERING ${VTK40_VTK_USE_RENDERING})
SET(VTK_USE_VIDEO_FOR_WINDOWS ${VTK40_VTK_USE_VIDEO_FOR_WINDOWS})
SET(VTK_USE_VOLUMEPRO ${VTK40_VTK_USE_VOLUMEPRO})
SET(VTK_USE_X ${VTK40_VTK_USE_X})
SET(VTK_WRAP_JAVA ${VTK40_VTK_WRAP_JAVA})
SET(VTK_WRAP_PYTHON ${VTK40_VTK_WRAP_PYTHON})
SET(VTK_WRAP_TCL ${VTK40_VTK_WRAP_TCL})

# Create the list of available kits.
SET(VTK_KITS COMMON FILTERING GRAPHICS IMAGING IO)
IF(VTK_USE_RENDERING)
  SET(VTK_KITS ${VTK_KITS} RENDERING)
ENDIF(VTK_USE_RENDERING)
IF(VTK_USE_HYBRID)
  SET(VTK_KITS ${VTK_KITS} HYBRID)
ENDIF(VTK_USE_HYBRID)
IF(VTK_USE_PARALLEL)
  SET(VTK_KITS ${VTK_KITS} PARALLEL)
ENDIF(VTK_USE_PARALLEL)
IF(VTK_USE_PATENTED)
  SET(VTK_KITS ${VTK_KITS} PATENTED)
ENDIF(VTK_USE_PATENTED)

# Create the list of available languages.
SET(VTK_LANGUAGES "")
IF(VTK_WRAP_TCL)
  SET(VTK_LANGUAGES ${VTK_LANGUAGES} TCL)
ENDIF(VTK_WRAP_TCL)
IF(VTK_WRAP_PYTHON)
  SET(VTK_LANGUAGES ${VTK_LANGUAGES} PYTHON)
ENDIF(VTK_WRAP_PYTHON)
IF(VTK_WRAP_JAVA)
  SET(VTK_LANGUAGES ${VTK_LANGUAGES} JAVA)
ENDIF(VTK_WRAP_JAVA)

# Include directories for other projects installed on the system and
# used by VTK.
SET(VTK_INCLUDE_DIRS_SYS "")
IF(VTK_USE_RENDERING)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS}
      ${VTK40_OPENGL_INCLUDE_PATH} ${VTK40_OPENGL_INCLUDE_DIR})
  IF(VTK_USE_X)
    SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS}
        ${VTK40_CMAKE_Xlib_INCLUDE_PATH} ${VTK40_CMAKE_Xutil_INCLUDE_PATH})
  ENDIF(VTK_USE_X)
ENDIF(VTK_USE_RENDERING)

IF(VTK_OPENGL_HAS_OSMESA)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS}
      ${VTK40_OSMESA_INCLUDE_PATH})
ENDIF(VTK_OPENGL_HAS_OSMESA)

IF(VTK_USE_MPI)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS} ${VTK40_MPI_INCLUDE_PATH})
ENDIF(VTK_USE_MPI)

IF(VTK_WRAP_TCL)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS} ${VTK40_TCL_INCLUDE_PATH})
ENDIF(VTK_WRAP_TCL)

IF(VTK_WRAP_PYTHON)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS} ${VTK40_PYTHON_INCLUDE_PATH})
ENDIF(VTK_WRAP_PYTHON)

IF(VTK_WRAP_JAVA)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS}
      ${VTK40_JAVA_INCLUDE_PATH} ${VTK40_JAVA_INCLUDE_PATH2})
ENDIF(VTK_WRAP_JAVA)

IF(VTK_HAVE_VG500)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS}
      ${VTK40_VLI_INCLUDE_PATH_FOR_VG500})
ENDIF(VTK_HAVE_VG500)

IF(VTK_HAVE_VP1000)
  SET(VTK_INCLUDE_DIRS_SYS ${VTK_INCLUDE_DIRS_SYS}
      ${VTK40_VLI_INCLUDE_PATH_FOR_VP1000})
ENDIF(VTK_HAVE_VP1000)

# See if this is a build tree or install tree.
IF(EXISTS ${VTK_DIR}/Common)
  # This is a VTK 4.0 build tree.

  SET(VTK_LIBRARY_DIRS ${VTK40_LIBRARY_OUTPUT_PATH})

  # Determine the include directories needed.
  SET(VTK_INCLUDE_DIRS ${VTK40_VTK_BINARY_DIR})
  IF(VTK_USE_PARALLEL)
    SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} ${VTK40_VTK_SOURCE_DIR}/Parallel)
  ENDIF(VTK_USE_PARALLEL)
  IF(VTK_USE_HYBRID)
    SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} ${VTK40_VTK_SOURCE_DIR}/Hybrid)
  ENDIF(VTK_USE_HYBRID)
  IF(VTK_USE_PATENTED)
    SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} ${VTK40_VTK_SOURCE_DIR}/Patented)
  ENDIF(VTK_USE_PATENTED)
  IF(VTK_USE_RENDERING)
    SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} ${VTK40_VTK_SOURCE_DIR}/Rendering)
  ENDIF(VTK_USE_RENDERING)

  # These directories are always needed.
  SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS}
    ${VTK40_VTK_SOURCE_DIR}/IO
    ${VTK40_VTK_SOURCE_DIR}/Imaging
    ${VTK40_VTK_SOURCE_DIR}/Graphics
    ${VTK40_VTK_SOURCE_DIR}/Filtering
    ${VTK40_VTK_SOURCE_DIR}/Common)

  # Give access to a few utilities.
  SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS}
    ${VTK40_VTK_BINARY_DIR}/Utilities/png
    ${VTK40_VTK_SOURCE_DIR}/Utilities/png
    ${VTK40_VTK_BINARY_DIR}/Utilities/zlib
    ${VTK40_VTK_SOURCE_DIR}/Utilities/zlib)

  # Executable locations.
  IF(VTK_WRAP_TCL)
    SET(VTK_TCL_EXE ${VTK40_EXECUTABLE_OUTPUT_PATH}/vtk)
    SET(VTK_WRAP_TCL_EXE ${VTK40_VTK_WRAP_TCL_EXE})
    SET(VTK_TCL_HOME ${VTK40_VTK_SOURCE_DIR}/Wrapping/Tcl)
  ENDIF(VTK_WRAP_TCL)
  IF(VTK_WRAP_PYTHON)
    SET(VTK_WRAP_PYTHON_EXE ${VTK40_VTK_WRAP_PYTHON_EXE})
  ENDIF(VTK_WRAP_PYTHON)
  IF(VTK_WRAP_JAVA)
    SET(VTK_PARSE_JAVA_EXE ${VTK40_VTK_PARSE_JAVA_EXE})
    SET(VTK_WRAP_JAVA_EXE ${VTK40_VTK_WRAP_JAVA_EXE})
  ENDIF(VTK_WRAP_JAVA)

ELSE(EXISTS ${VTK_DIR}/Common)
  # This is a VTK 4.0 install tree.

  SET(VTK_INCLUDE_DIRS ${VTK_DIR})
  SET(VTK_LIBRARY_DIRS ${VTK40_CMAKE_INSTALL_PREFIX}/lib/vtk)

  # Executable locations.
  IF(VTK_WRAP_TCL)
    SET(VTK_TCL_EXE ${VTK40_CMAKE_INSTALL_PREFIX}/bin/vtk)
    SET(VTK_WRAP_TCL_EXE ${VTK40_CMAKE_INSTALL_PREFIX}/bin/vtkWrapTcl)
    SET(VTK_TCL_HOME ${VTK40_CMAKE_INSTALL_PREFIX}/lib/vtk/tcl)
  ENDIF(VTK_WRAP_TCL)
  IF(VTK_WRAP_PYTHON)
    SET(VTK_WRAP_PYTHON_EXE ${VTK40_CMAKE_INSTALL_PREFIX}/bin/vtkWrapPython)
  ENDIF(VTK_WRAP_PYTHON)
  IF(VTK_WRAP_JAVA)
    SET(VTK_PARSE_JAVA_EXE ${VTK40_CMAKE_INSTALL_PREFIX}/bin/vtkParseJava)
    SET(VTK_WRAP_JAVA_EXE ${VTK40_CMAKE_INSTALL_PREFIX}/bin/vtkWrapJava)
  ENDIF(VTK_WRAP_JAVA)
ENDIF(EXISTS ${VTK_DIR}/Common)

# Add the system include directories last.
SET(VTK_INCLUDE_DIRS ${VTK_INCLUDE_DIRS} ${VTK_INCLUDE_DIRS_SYS})

# Find the required C and C++ compiler flags.
IF(CMAKE_COMPILER_IS_GNUCXX)
  IF(WIN32)
    # The platform is gcc on cygwin.
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -mwin32")
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -mwin32")
  ENDIF(WIN32)
ELSE(CMAKE_COMPILER_IS_GNUCXX)
  IF(CMAKE_ANSI_CFLAGS)
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} ${CMAKE_ANSI_CFLAGS}")
  ENDIF(CMAKE_ANSI_CFLAGS)
  IF(CMAKE_SYSTEM MATCHES "OSF1-V.*")
     SET(VTK_REQUIRED_CXX_FLAGS
         "${VTK_REQUIRED_CXX_FLAGS} -timplicit_local -no_implicit_include")
  ENDIF(CMAKE_SYSTEM MATCHES "OSF1-V.*")
ENDIF(CMAKE_COMPILER_IS_GNUCXX)

IF(VTK_USE_X)
  IF(CMAKE_X_CFLAGS)
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} ${CMAKE_X_CFLAGS}")
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} ${CMAKE_X_CFLAGS}")
  ENDIF(CMAKE_X_CFLAGS)
ENDIF(VTK_USE_X)

# Copy library dependencies.
SET(vtkCommonJava_LIB_DEPENDS "${VTK40_vtkCommonJava_LIB_DEPENDS}")
SET(vtkCommonPython_LIB_DEPENDS "${VTK40_vtkCommonPython_LIB_DEPENDS}")
SET(vtkCommonTCL_LIB_DEPENDS "${VTK40_vtkCommonTCL_LIB_DEPENDS}")
SET(vtkCommon_LIB_DEPENDS "${VTK40_vtkCommon_LIB_DEPENDS}")
SET(vtkFilteringJava_LIB_DEPENDS "${VTK40_vtkFilteringJava_LIB_DEPENDS}")
SET(vtkFilteringPython_LIB_DEPENDS "${VTK40_vtkFilteringPython_LIB_DEPENDS}")
SET(vtkFilteringTCL_LIB_DEPENDS "${VTK40_vtkFilteringTCL_LIB_DEPENDS}")
SET(vtkFiltering_LIB_DEPENDS "${VTK40_vtkFiltering_LIB_DEPENDS}")
SET(vtkGraphicsJava_LIB_DEPENDS "${VTK40_vtkGraphicsJava_LIB_DEPENDS}")
SET(vtkGraphicsPython_LIB_DEPENDS "${VTK40_vtkGraphicsPython_LIB_DEPENDS}")
SET(vtkGraphicsTCL_LIB_DEPENDS "${VTK40_vtkGraphicsTCL_LIB_DEPENDS}")
SET(vtkGraphics_LIB_DEPENDS "${VTK40_vtkGraphics_LIB_DEPENDS}")
SET(vtkHybridJava_LIB_DEPENDS "${VTK40_vtkHybridJava_LIB_DEPENDS}")
SET(vtkHybridPython_LIB_DEPENDS "${VTK40_vtkHybridPython_LIB_DEPENDS}")
SET(vtkHybridTCL_LIB_DEPENDS "${VTK40_vtkHybridTCL_LIB_DEPENDS}")
SET(vtkHybrid_LIB_DEPENDS "${VTK40_vtkHybrid_LIB_DEPENDS}")
SET(vtkIOJava_LIB_DEPENDS "${VTK40_vtkIOJava_LIB_DEPENDS}")
SET(vtkIOPython_LIB_DEPENDS "${VTK40_vtkIOPython_LIB_DEPENDS}")
SET(vtkIOTCL_LIB_DEPENDS "${VTK40_vtkIOTCL_LIB_DEPENDS}")
SET(vtkIO_LIB_DEPENDS "${VTK40_vtkIO_LIB_DEPENDS}")
SET(vtkImagingJava_LIB_DEPENDS "${VTK40_vtkImagingJava_LIB_DEPENDS}")
SET(vtkImagingPython_LIB_DEPENDS "${VTK40_vtkImagingPython_LIB_DEPENDS}")
SET(vtkImagingTCL_LIB_DEPENDS "${VTK40_vtkImagingTCL_LIB_DEPENDS}")
SET(vtkImaging_LIB_DEPENDS "${VTK40_vtkImaging_LIB_DEPENDS}")
SET(vtkParallelJava_LIB_DEPENDS "${VTK40_vtkParallelJava_LIB_DEPENDS}")
SET(vtkParallelPython_LIB_DEPENDS "${VTK40_vtkParallelPython_LIB_DEPENDS}")
SET(vtkParallelTCL_LIB_DEPENDS "${VTK40_vtkParallelTCL_LIB_DEPENDS}")
SET(vtkParallel_LIB_DEPENDS "${VTK40_vtkParallel_LIB_DEPENDS}")
SET(vtkPatentedJava_LIB_DEPENDS "${VTK40_vtkPatentedJava_LIB_DEPENDS}")
SET(vtkPatentedPython_LIB_DEPENDS "${VTK40_vtkPatentedPython_LIB_DEPENDS}")
SET(vtkPatentedTCL_LIB_DEPENDS "${VTK40_vtkPatentedTCL_LIB_DEPENDS}")
SET(vtkPatented_LIB_DEPENDS "${VTK40_vtkPatented_LIB_DEPENDS}")
SET(vtkRenderingJava_LIB_DEPENDS "${VTK40_vtkRenderingJava_LIB_DEPENDS}")
SET(vtkRenderingPythonTkWidgets_LIB_DEPENDS "${VTK40_vtkRenderingPythonTkWidgets_LIB_DEPENDS}")
SET(vtkRenderingPython_LIB_DEPENDS "${VTK40_vtkRenderingPython_LIB_DEPENDS}")
SET(vtkRenderingTCL_LIB_DEPENDS "${VTK40_vtkRenderingTCL_LIB_DEPENDS}")
SET(vtkRendering_LIB_DEPENDS "${VTK40_vtkRendering_LIB_DEPENDS}")
SET(vtkjpeg_LIB_DEPENDS "${VTK40_vtkjpeg_LIB_DEPENDS}")
SET(vtkpng_LIB_DEPENDS "${VTK40_vtkpng_LIB_DEPENDS}")
SET(vtkzlib_LIB_DEPENDS "${VTK40_vtkzlib_LIB_DEPENDS}")

# List of VTK configuration variables set above.
# grep "^[ ]*SET(VTK" UseVTKConfig40.cmake |sed 's/[ ]*SET(\([^ ]*\) .*/  \1/'
SET(VTK_SETTINGS
  VTK_BUILD_SHARED
  VTK_BUILD_VERSION
  VTK_DEBUG_LEAKS
  VTK_HAVE_VG500
  VTK_HAVE_VP1000
  VTK_INCLUDE_DIRS
  VTK_KITS
  VTK_LANGUAGES
  VTK_LIBRARY_DIRS
  VTK_MAJOR_VERSION
  VTK_MANGLE_MESA
  VTK_MINOR_VERSION
  VTK_MPIRUN_EXE
  VTK_MPI_POSTFLAGS
  VTK_MPI_PREFLAGS
  VTK_OPENGL_HAS_OSMESA
  VTK_PARSE_JAVA_EXE
  VTK_TCL_EXE
  VTK_TCL_HOME
  VTK_USE_64BIT_IDS
  VTK_USE_ANSI_STDLIB
  VTK_USE_HYBRID
  VTK_USE_MATROX_IMAGING
  VTK_USE_MPI
  VTK_USE_PARALLEL
  VTK_USE_PATENTED
  VTK_USE_RENDERING
  VTK_USE_VIDEO_FOR_WINDOWS
  VTK_USE_VOLUMEPRO
  VTK_USE_X
  VTK_WRAP_JAVA
  VTK_WRAP_JAVA_EXE
  VTK_WRAP_PYTHON
  VTK_WRAP_PYTHON_EXE
  VTK_WRAP_TCL
  VTK_WRAP_TCL_EXE
)
