/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.MultiComparator;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.LocaleData;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlphabeticIndex<V>
implements Iterable<Bucket<V>> {
    static final boolean HACK_CODED_FIRSTS = true;
    private static UnicodeSet UNIHAN = new UnicodeSet("[:script=Hani:]").freeze();
    static final String BASE = "\ufdd0";
    static final UnicodeSet PINYIN_LABELS = new UnicodeSet("[A-Z{\ufdd0A}{\ufdd0B}{\ufdd0C}{\ufdd0D}{\ufdd0E}{\ufdd0F}{\ufdd0G}{\ufdd0H}{\ufdd0I}{\ufdd0J}{\ufdd0K}{\ufdd0L}{\ufdd0M}{\ufdd0N}{\ufdd0O}{\ufdd0P}{\ufdd0Q}{\ufdd0R}{\ufdd0S}{\ufdd0T}{\ufdd0U}{\ufdd0V}{\ufdd0W}{\ufdd0X}{\ufdd0Y}{\ufdd0Z}]").freeze();
    static final UnicodeSet STROKE_LABELS = new UnicodeSet("[{\ufdd0\u2801}{\ufdd0\u2802}{\ufdd0\u2803}{\ufdd0\u2804}{\ufdd0\u2805}{\ufdd0\u2806}{\ufdd0\u2807}{\ufdd0\u2808}{\ufdd0\u2809}{\ufdd0\u280a}{\ufdd0\u280b}{\ufdd0\u280c}{\ufdd0\u280d}{\ufdd0\u280e}{\ufdd0\u280f}{\ufdd0\u2810}{\ufdd0\u2811}{\ufdd0\u2812}{\ufdd0\u2813}{\ufdd0\u2814}{\ufdd0\u2815}{\ufdd0\u2816}{\ufdd0\u2817}{\ufdd0\u2818}{\ufdd0\u2819}{\ufdd0\u281a}{\ufdd0\u281b}{\ufdd0\u281c}{\ufdd0\u281d}{\ufdd0\u281e}{\ufdd0\u281f}{\ufdd0\u2820}{\ufdd0\u2821}{\ufdd0\u2822}{\ufdd0\u2823}{\ufdd0\u2824}{\ufdd0\u2825}{\ufdd0\u2826}{\ufdd0\u2827}{\ufdd0\u2828}{\ufdd0\u2829}{\ufdd0\u282a}{\ufdd0\u282b}{\ufdd0\u282c}{\ufdd0\u282e}{\ufdd0\u2830}{\ufdd0\u2834}{\ufdd0\u2840}]").freeze();
    static final UnicodeSet RADICAL_LABELS = new UnicodeSet("[{\ufdd0\u2e80}{\ufdd0\u2e81}{\ufdd0\u2e84}{\ufdd0\u2e85}{\ufdd0\u2e86}{\ufdd0\u2e87}{\ufdd0\u2e88}{\ufdd0\u2e8a}{\ufdd0\u2e8b}{\ufdd0\u2e8c}{\ufdd0\u2e91}{\ufdd0\u2e92}{\ufdd0\u2e93}{\ufdd0\u2e95}{\ufdd0\u2e97}{\ufdd0\u2e98}{\ufdd0\u2e99}{\ufdd0\u2e9b}{\ufdd0\u2e9d}{\ufdd0\u2e9e}{\ufdd0\u2e9f}{\ufdd0\u2ea0}{\ufdd0\u2ea2}{\ufdd0\u2ea3}{\ufdd0\u2ea4}{\ufdd0\u2ea7}{\ufdd0\u2ea8}{\ufdd0\u2ea9}{\ufdd0\u2eaa}{\ufdd0\u2eab}{\ufdd0\u2eac}{\ufdd0\u2eae}{\ufdd0\u2eaf}{\ufdd0\u2eb0}{\ufdd0\u2eb4}{\ufdd0\u2eb8}{\ufdd0\u2eb9}{\ufdd0\u2ebb}{\ufdd0\u2ebc}{\ufdd0\u2ebd}{\ufdd0\u2ec0}{\ufdd0\u2ec1}{\ufdd0\u2ec2}{\ufdd0\u2ec3}{\ufdd0\u2ec5}{\ufdd0\u2ec6}{\ufdd0\u2ec8}{\ufdd0\u2ec9}{\ufdd0\u2eca}{\ufdd0\u2ecb}{\ufdd0\u2ecf}{\ufdd0\u2ed0}{\ufdd0\u2ed1}{\ufdd0\u2ed3}{\ufdd0\u2ed4}{\ufdd0\u2ed6}{\ufdd0\u2ed7}{\ufdd0\u2ed8}{\ufdd0\u2ed9}{\ufdd0\u2eda}{\ufdd0\u2edb}{\ufdd0\u2edc}{\ufdd0\u2edd}{\ufdd0\u2ee0}{\ufdd0\u2ee1}{\ufdd0\u2ee2}{\ufdd0\u2ee3}{\ufdd0\u2ee4}{\ufdd0\u2ee5}{\ufdd0\u2ee6}{\ufdd0\u2ee7}{\ufdd0\u2ee8}{\ufdd0\u2eea}{\ufdd0\u2eeb}{\ufdd0\u2eed}{\ufdd0\u2eee}{\ufdd0\u2eef}{\ufdd0\u2ef0}{\ufdd0\u2ef2}{\ufdd0\u2ef3}{\ufdd0\u2f00}{\ufdd0\u2f01}{\ufdd0\u2f02}{\ufdd0\u2f03}{\ufdd0\u2f05}{\ufdd0\u2f06}{\ufdd0\u2f07}{\ufdd0\u2f09}{\ufdd0\u2f0a}{\ufdd0\u2f0b}{\ufdd0\u2f0d}{\ufdd0\u2f0e}{\ufdd0\u2f10}{\ufdd0\u2f12}{\ufdd0\u2f13}{\ufdd0\u2f14}{\ufdd0\u2f15}{\ufdd0\u2f16}{\ufdd0\u2f17}{\ufdd0\u2f1b}{\ufdd0\u2f1d}{\ufdd0\u2f1e}{\ufdd0\u2f1f}{\ufdd0\u2f20}{\ufdd0\u2f21}{\ufdd0\u2f22}{\ufdd0\u2f23}{\ufdd0\u2f24}{\ufdd0\u2f25}{\ufdd0\u2f26}{\ufdd0\u2f27}{\ufdd0\u2f28}{\ufdd0\u2f2b}{\ufdd0\u2f2c}{\ufdd0\u2f2d}{\ufdd0\u2f2e}{\ufdd0\u2f2f}{\ufdd0\u2f31}{\ufdd0\u2f32}{\ufdd0\u2f34}{\ufdd0\u2f35}{\ufdd0\u2f36}{\ufdd0\u2f37}{\ufdd0\u2f38}{\ufdd0\u2f3a}{\ufdd0\u2f3b}{\ufdd0\u2f3d}{\ufdd0\u2f3e}{\ufdd0\u2f40}{\ufdd0\u2f42}{\ufdd0\u2f43}{\ufdd0\u2f44}{\ufdd0\u2f45}{\ufdd0\u2f46}{\ufdd0\u2f48}{\ufdd0\u2f4a}{\ufdd0\u2f4b}{\ufdd0\u2f4c}{\ufdd0\u2f4e}{\ufdd0\u2f50}{\ufdd0\u2f51}{\ufdd0\u2f53}{\ufdd0\u2f57}{\ufdd0\u2f58}{\ufdd0\u2f59}{\ufdd0\u2f5a}{\ufdd0\u2f5b}{\ufdd0\u2f5e}{\ufdd0\u2f60}{\ufdd0\u2f61}{\ufdd0\u2f62}{\ufdd0\u2f63}{\ufdd0\u2f64}{\ufdd0\u2f65}{\ufdd0\u2f67}{\ufdd0\u2f68}{\ufdd0\u2f69}{\ufdd0\u2f6a}{\ufdd0\u2f6b}{\ufdd0\u2f6d}{\ufdd0\u2f6e}{\ufdd0\u2f6f}{\ufdd0\u2f71}{\ufdd0\u2f72}{\ufdd0\u2f73}{\ufdd0\u2f74}{\ufdd0\u2f76}{\ufdd0\u2f78}{\ufdd0\u2f7b}{\ufdd0\u2f7d}{\ufdd0\u2f7e}{\ufdd0\u2f7f}{\ufdd0\u2f82}{\ufdd0\u2f83}{\ufdd0\u2f84}{\ufdd0\u2f86}{\ufdd0\u2f87}{\ufdd0\u2f88}{\ufdd0\u2f89}{\ufdd0\u2f8a}{\ufdd0\u2f8d}{\ufdd0\u2f8e}{\ufdd0\u2f8f}{\ufdd0\u2f92}{\ufdd0\u2f94}{\ufdd0\u2f95}{\ufdd0\u2f96}{\ufdd0\u2f97}{\ufdd0\u2f98}{\ufdd0\u2f99}{\ufdd0\u2f9a}{\ufdd0\u2f9b}{\ufdd0\u2f9d}{\ufdd0\u2f9e}{\ufdd0\u2f9f}{\ufdd0\u2fa0}{\ufdd0\u2fa1}{\ufdd0\u2fa3}{\ufdd0\u2fa4}{\ufdd0\u2fa5}{\ufdd0\u2fa6}{\ufdd0\u2fa8}{\ufdd0\u2faa}{\ufdd0\u2fab}{\ufdd0\u2fae}{\ufdd0\u2faf}{\ufdd0\u2fb0}{\ufdd0\u2fb1}{\ufdd0\u2fb2}{\ufdd0\u2fb3}{\ufdd0\u2fb4}{\ufdd0\u2fb5}{\ufdd0\u2fb6}{\ufdd0\u2fb9}{\ufdd0\u2fba}{\ufdd0\u2fbc}{\ufdd0\u2fbd}{\ufdd0\u2fbe}{\ufdd0\u2fbf}{\ufdd0\u2fc0}{\ufdd0\u2fc2}{\ufdd0\u2fc3}{\ufdd0\u2fc4}{\ufdd0\u2fc5}{\ufdd0\u2fc6}{\ufdd0\u2fc7}{\ufdd0\u2fc8}{\ufdd0\u2fc9}{\ufdd0\u2fca}{\ufdd0\u2fcb}{\ufdd0\u2fcc}{\ufdd0\u2fcd}{\ufdd0\u2fce}{\ufdd0\u2fcf}{\ufdd0\u2fd0}{\ufdd0\u2fd1}{\ufdd0\u2fd5}]").freeze();
    static final List<String> PROBES = Arrays.asList("\u4e00", "\ufdd0A", "\ufdd0\u2801", "\ufdd0\u2e80");
    static final int PINYIN_PROBE_INDEX = 1;
    static final UnicodeSet[] MATCHING = new UnicodeSet[]{null, PINYIN_LABELS, STROKE_LABELS, RADICAL_LABELS};
    private static final char CGJ = '\u034f';
    private static final UnicodeSet ALPHABETIC = new UnicodeSet("[[:alphabetic:]-[:mark:]]").add("\ufdd0").freeze();
    private static final UnicodeSet HANGUL = new UnicodeSet("[\uac00 \ub098 \ub2e4 \ub77c \ub9c8 \ubc14  \uc0ac  \uc544 \uc790  \ucc28 \uce74 \ud0c0 \ud30c \ud558]").freeze();
    private static final UnicodeSet ETHIOPIC = new UnicodeSet("[[:Block=Ethiopic:]&[:Script=Ethiopic:]]").freeze();
    private static final UnicodeSet CORE_LATIN = new UnicodeSet("[a-z]").freeze();
    private final RuleBasedCollator collatorOriginal;
    private final RuleBasedCollator collatorPrimaryOnly;
    private RuleBasedCollator collatorExternal;
    private final LinkedHashMap<String, Set<String>> alreadyIn = new LinkedHashMap();
    private final List<String> noDistinctSorting = new ArrayList<String>();
    private final List<String> notAlphabetic = new ArrayList<String>();
    private final UnicodeSet initialLabels = new UnicodeSet();
    private final Collection<Record<V>> inputList = new ArrayList<Record<V>>();
    private BucketList buckets;
    private String overflowLabel = "\u2026";
    private String underflowLabel = "\u2026";
    private String inflowLabel = "\u2026";
    private boolean hasPinyin = false;
    private static final UnicodeSet IGNORE_SCRIPTS = new UnicodeSet("[[:sc=Common:][:sc=inherited:][:script=Unknown:][:script=braille:]]").freeze();
    private static final PreferenceComparator PREFERENCE_COMPARATOR = new PreferenceComparator();
    private int maxLabelCount = 99;
    private static final List<String> HACK_FIRST_CHARS_IN_SCRIPTS = Arrays.asList("a", "\u03b1", "\u2c81", "\u0430", "\u2c30", "\u10d0", "\u0561", "\u05d0", "\ud802\udd00", "\u0800", "\u0621", "\u0710", "\u0840", "\u0780", "\u07ca", "\u2d30", "\u1200", "\u0950", "\u0985", "\u0a74", "\u0ad0", "\u0b05", "\u0bd0", "\u0c05", "\u0c85", "\u0d05", "\u0d85", "\uabc0", "\ua800", "\ua882", "\ud804\udc83", "\u1b83", "\ud804\udc05", "\ud802\ude00", "\u0e01", "\u0e81", "\uaa80", "\u0f40", "\u1c00", "\ua840", "\u1900", "\u1700", "\u1720", "\u1740", "\u1760", "\u1a00", "\u1bc0", "\ua930", "\ua90a", "\u1000", "\u1780", "\u1950", "\u1980", "\u1a20", "\uaa00", "\u1b05", "\ua984", "\u1880", "\u1c5a", "\u13a0", "\u1401", "\u1681", "\u16a0", "\ud803\udc00", "\ua500", "\ua6a0", "\u1100", "\u3041", "\u30a1", "\u3105", "\ua000", "\ua4f8", "\ud800\ude80", "\ud800\udea0", "\ud802\udd20", "\ud800\udf00", "\ud800\udf30", "\ud801\udc28", "\ud801\udc50", "\ud801\udc80", "\ud800\udc00", "\ud802\udc00", "\ud802\ude60", "\ud802\udf00", "\ud802\udc40", "\ud802\udf40", "\ud802\udf60", "\ud800\udf80", "\ud800\udfa0", "\ud808\udc00", "\ud80c\udc00", "\u4e00");

    public AlphabeticIndex(ULocale locale) {
        this(locale, null, null);
    }

    public AlphabeticIndex(Locale locale) {
        this(ULocale.forLocale(locale));
    }

    public AlphabeticIndex(ULocale locale, RuleBasedCollator collator, UnicodeSet exemplarChars) {
        this.collatorOriginal = collator != null ? collator : (RuleBasedCollator)Collator.getInstance(locale);
        try {
            this.collatorPrimaryOnly = (RuleBasedCollator)this.collatorOriginal.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException("Collator cannot be cloned", e);
        }
        this.collatorPrimaryOnly.setStrength(0);
        if (exemplarChars == null) {
            exemplarChars = this.getIndexExemplars(locale);
        }
        this.addLabels(exemplarChars);
    }

    public AlphabeticIndex<V> addLabels(UnicodeSet additions) {
        this.initialLabels.addAll(additions);
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> addLabels(ULocale ... additions) {
        for (ULocale addition : additions) {
            this.initialLabels.addAll(this.getIndexExemplars(addition));
        }
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> addLabels(Locale ... additions) {
        for (Locale addition : additions) {
            this.initialLabels.addAll(this.getIndexExemplars(ULocale.forLocale(addition)));
        }
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> setOverflowLabel(String overflowLabel) {
        this.overflowLabel = overflowLabel;
        return this;
    }

    public String getUnderflowLabel() {
        return this.underflowLabel;
    }

    public AlphabeticIndex<V> setUnderflowLabel(String underflowLabel) {
        this.underflowLabel = underflowLabel;
        return this;
    }

    public String getOverflowLabel() {
        return this.overflowLabel;
    }

    public AlphabeticIndex<V> setInflowLabel(String inflowLabel) {
        this.inflowLabel = inflowLabel;
        return this;
    }

    public String getInflowLabel() {
        return this.inflowLabel;
    }

    public int getMaxLabelCount() {
        return this.maxLabelCount;
    }

    public AlphabeticIndex<V> setMaxLabelCount(int maxLabelCount) {
        this.maxLabelCount = maxLabelCount;
        return this;
    }

    private ArrayList<String> initLabels() {
        UnicodeSet exemplars = new UnicodeSet(this.initialLabels);
        TreeSet preferenceSorting = new TreeSet(new MultiComparator(this.collatorPrimaryOnly, PREFERENCE_COMPARATOR));
        exemplars.addAllTo(preferenceSorting);
        TreeSet<Object> indexCharacterSet = new TreeSet<Object>(this.collatorPrimaryOnly);
        block0: for (String item : preferenceSorting) {
            if (indexCharacterSet.contains(item)) {
                for (String string : indexCharacterSet) {
                    if (this.collatorPrimaryOnly.compare(item, string) != 0) continue;
                    Set<String> targets = this.alreadyIn.get(string);
                    if (targets == null) {
                        targets = new LinkedHashSet<String>();
                        this.alreadyIn.put(string, targets);
                    }
                    targets.add(item);
                    continue block0;
                }
                continue;
            }
            if (UTF16.countCodePoint(item) > 1 && this.collatorPrimaryOnly.compare(item, this.separated(item)) == 0) {
                this.noDistinctSorting.add(item);
                continue;
            }
            if (!ALPHABETIC.containsSome(item)) {
                this.notAlphabetic.add(item);
                continue;
            }
            indexCharacterSet.add(item);
        }
        int size = indexCharacterSet.size() - 1;
        if (size > this.maxLabelCount) {
            int count = 0;
            int old = -1;
            Iterator<Object> iterator = indexCharacterSet.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int bump = ++count * this.maxLabelCount / size;
                if (bump == old) {
                    iterator.remove();
                    continue;
                }
                old = bump;
            }
        }
        return new ArrayList<Object>(indexCharacterSet);
    }

    private UnicodeSet getIndexExemplars(ULocale locale) {
        UnicodeSet exemplars = LocaleData.getExemplarSet(locale, 0, 2);
        if (exemplars != null) {
            String language = locale.getLanguage();
            if (language.equals("zh") || language.equals("ja") || language.equals("ko")) {
                TreeSet<Object> probeSet = new TreeSet<Object>(this.collatorOriginal);
                probeSet.addAll(PROBES);
                String first = (String)probeSet.iterator().next();
                int location = PROBES.indexOf(first);
                if (location > 0) {
                    if (location == 1) {
                        this.hasPinyin = true;
                    }
                    exemplars.clear().addAll(MATCHING[location]);
                }
            }
            return exemplars;
        }
        exemplars = LocaleData.getExemplarSet(locale, 0, 0);
        if ((exemplars = exemplars.cloneAsThawed()).containsSome(CORE_LATIN) || exemplars.size() == 0) {
            exemplars.addAll(CORE_LATIN);
        }
        if (exemplars.containsSome(HANGUL)) {
            exemplars.removeAll(new UnicodeSet("[:block=hangul_syllables:]")).addAll(HANGUL);
        }
        if (exemplars.containsSome(ETHIOPIC)) {
            UnicodeSetIterator it = new UnicodeSetIterator(ETHIOPIC);
            while (it.next()) {
                if ((it.codepoint & 7) == 0) continue;
                exemplars.remove(it.codepoint);
            }
        }
        UnicodeSet uppercased = new UnicodeSet();
        for (String item : exemplars) {
            uppercased.add(UCharacter.toUpperCase(locale, item));
        }
        return uppercased;
    }

    private String separated(String item) {
        StringBuilder result = new StringBuilder();
        char last = item.charAt(0);
        result.append(last);
        for (int i = 1; i < item.length(); ++i) {
            char ch = item.charAt(i);
            if (!UCharacter.isHighSurrogate(last) || !UCharacter.isLowSurrogate(ch)) {
                result.append('\u034f');
            }
            result.append(ch);
            last = ch;
        }
        return result.toString();
    }

    public List<String> getBucketLabels() {
        if (this.buckets == null) {
            this.initBuckets();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Bucket bucket : this.buckets) {
            result.add(bucket.getLabel());
        }
        return result;
    }

    public RuleBasedCollator getCollator() {
        if (this.collatorExternal == null) {
            try {
                this.collatorExternal = (RuleBasedCollator)this.collatorOriginal.clone();
            }
            catch (Exception e) {
                throw new IllegalStateException("Collator cannot be cloned", e);
            }
        }
        return this.collatorExternal;
    }

    public AlphabeticIndex<V> addRecord(CharSequence name, V data) {
        this.buckets = null;
        this.inputList.add(new Record(name, data, this.inputList.size()));
        return this;
    }

    public int getBucketIndex(CharSequence name) {
        if (this.buckets == null) {
            this.initBuckets();
        }
        return this.rawGetBucketIndex(name);
    }

    private int rawGetBucketIndex(CharSequence name) {
        int result = 0;
        Bucket lastBucket = null;
        Bucket bucket = null;
        Iterator it = this.buckets.fullIterator();
        while (it.hasNext()) {
            bucket = (Bucket)it.next();
            if (bucket.lowerBoundary == null) {
                bucket = lastBucket;
                --result;
                break;
            }
            int bucketLower2name = this.collatorPrimaryOnly.compare((Object)bucket.lowerBoundary, name);
            if (bucketLower2name > 0) {
                bucket = lastBucket;
                --result;
                break;
            }
            if (bucketLower2name == 0) break;
            ++result;
            lastBucket = bucket;
        }
        if (this.buckets.rebucket != null) {
            Bucket temp = (Bucket)this.buckets.rebucket.get(bucket);
            if (temp != null) {
                bucket = temp;
            }
            result = 0;
            for (Bucket bucket2 : this.buckets) {
                if (bucket2 == bucket) break;
                ++result;
            }
        }
        return result;
    }

    public AlphabeticIndex<V> clearRecords() {
        this.buckets = null;
        this.inputList.clear();
        return this;
    }

    public int getBucketCount() {
        if (this.buckets == null) {
            this.initBuckets();
        }
        return this.buckets.bucketList.size();
    }

    public int getRecordCount() {
        return this.inputList.size();
    }

    @Override
    public Iterator<Bucket<V>> iterator() {
        if (this.buckets == null) {
            this.initBuckets();
        }
        return this.buckets.iterator();
    }

    private void initBuckets() {
        this.buckets = new BucketList();
        Comparator fullComparator = new Comparator<Record<V>>(){

            @Override
            public int compare(Record<V> o1, Record<V> o2) {
                int result = AlphabeticIndex.this.collatorOriginal.compare(o1.name, o2.name);
                if (result != 0) {
                    return result;
                }
                return o1.counter - o2.counter;
            }
        };
        TreeSet<Record<V>> sortedInput = new TreeSet<Record<V>>(fullComparator);
        sortedInput.addAll(this.inputList);
        Iterator bucketIterator = this.buckets.fullIterator();
        Bucket currentBucket = (Bucket)bucketIterator.next();
        Bucket nextBucket = (Bucket)bucketIterator.next();
        String upperBoundary = nextBucket.lowerBoundary;
        boolean atEnd = false;
        for (Record record : sortedInput) {
            while (!atEnd && this.collatorPrimaryOnly.compare(record.name, (Object)upperBoundary) >= 0) {
                currentBucket = nextBucket;
                if (bucketIterator.hasNext()) {
                    nextBucket = (Bucket)bucketIterator.next();
                    upperBoundary = nextBucket.lowerBoundary;
                    if (upperBoundary != null) continue;
                    atEnd = true;
                    continue;
                }
                atEnd = true;
            }
            this.buckets.addTo(record, currentBucket);
        }
    }

    public String getOverflowComparisonString(String lowerLimit) {
        for (String s : HACK_FIRST_CHARS_IN_SCRIPTS) {
            if (this.collatorPrimaryOnly.compare(s, lowerLimit) <= 0) continue;
            return s;
        }
        return null;
    }

    public List<String> getFirstScriptCharacters() {
        return HACK_FIRST_CHARS_IN_SCRIPTS;
    }

    public Map<String, Set<String>> getAlreadyIn() {
        return this.alreadyIn;
    }

    public List<String> getNoDistinctSorting() {
        return this.noDistinctSorting;
    }

    public List<String> getNotAlphabetic() {
        return this.notAlphabetic;
    }

    private static UnicodeSet getScriptSet(String codePoint) {
        if (codePoint.startsWith(BASE)) {
            return new UnicodeSet(UNIHAN);
        }
        return new UnicodeSet().applyIntPropertyValue(4106, UScript.getScript(codePoint.codePointAt(0)));
    }

    public static List<String> getFirstCharactersInScripts() {
        return HACK_FIRST_CHARS_IN_SCRIPTS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BucketList
    implements Iterable<Bucket<V>> {
        private final ArrayList<Bucket<V>> bucketList = new ArrayList();
        private final HashMap<Bucket<V>, Bucket<V>> rebucket;
        private final List<Bucket<V>> immutableVisibleList;

        private BucketList() {
            ArrayList<Bucket<Object>> publicBucketList;
            ArrayList indexCharacters = AlphabeticIndex.this.initLabels();
            this.bucketList.add(new Bucket(AlphabeticIndex.this.getUnderflowLabel(), "", Bucket.LabelType.UNDERFLOW));
            String last = (String)indexCharacters.get(0);
            this.bucketList.add(new Bucket(this.fixLabel(last), last, Bucket.LabelType.NORMAL));
            UnicodeSet lastSet = AlphabeticIndex.getScriptSet(last).removeAll(IGNORE_SCRIPTS);
            for (int i = 1; i < indexCharacters.size(); ++i) {
                String current = (String)indexCharacters.get(i);
                UnicodeSet set = AlphabeticIndex.getScriptSet(current).removeAll(IGNORE_SCRIPTS);
                if (lastSet.containsNone(set)) {
                    String overflowComparisonString = AlphabeticIndex.this.getOverflowComparisonString(last);
                    if (AlphabeticIndex.this.collatorPrimaryOnly.compare(overflowComparisonString, current) < 0) {
                        this.bucketList.add(new Bucket(AlphabeticIndex.this.getInflowLabel(), overflowComparisonString, Bucket.LabelType.INFLOW));
                        lastSet = set;
                    }
                }
                this.bucketList.add(new Bucket(this.fixLabel(current), current, Bucket.LabelType.NORMAL));
                last = current;
                lastSet = set;
            }
            String limitString = AlphabeticIndex.this.getOverflowComparisonString(last);
            this.bucketList.add(new Bucket(AlphabeticIndex.this.getOverflowLabel(), limitString, Bucket.LabelType.OVERFLOW));
            if (AlphabeticIndex.this.hasPinyin) {
                this.rebucket = new HashMap();
                publicBucketList = new ArrayList();
                HashMap rebucketLabel = new HashMap();
                Bucket flowBefore = null;
                boolean flowRedirect = false;
                boolean havePinyin = false;
                for (Bucket bucket : this.bucketList) {
                    String label = bucket.getLabel();
                    String lowerBound = bucket.getLowerBoundary();
                    if (lowerBound != null && lowerBound.startsWith(AlphabeticIndex.BASE)) {
                        this.rebucket.put(bucket, rebucketLabel.get(label));
                        havePinyin = true;
                        continue;
                    }
                    if (bucket.labelType != Bucket.LabelType.NORMAL) {
                        if (!flowRedirect) {
                            if (havePinyin) {
                                this.rebucket.put(flowBefore, bucket);
                                publicBucketList.remove(flowBefore);
                                flowRedirect = true;
                            } else {
                                flowBefore = bucket;
                            }
                        }
                    } else {
                        rebucketLabel.put(label, bucket);
                    }
                    publicBucketList.add(bucket);
                }
            } else {
                this.rebucket = null;
                publicBucketList = this.bucketList;
            }
            this.immutableVisibleList = Collections.unmodifiableList(publicBucketList);
        }

        private void addTo(Record<V> s, Bucket<V> currentBucket) {
            Bucket newBucket;
            if (this.rebucket != null && (newBucket = this.rebucket.get(currentBucket)) != null) {
                currentBucket = newBucket;
            }
            currentBucket.records.add(s);
        }

        private String fixLabel(String current) {
            if (!current.startsWith(AlphabeticIndex.BASE)) {
                return current;
            }
            char rest = current.charAt(1);
            if ('\u2800' < rest && rest <= '\u28ff') {
                return rest - 10240 + "\u5283";
            }
            return current.substring(1);
        }

        private Iterator<Bucket<V>> fullIterator() {
            return this.bucketList.iterator();
        }

        @Override
        public Iterator<Bucket<V>> iterator() {
            return this.immutableVisibleList.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bucket<V>
    implements Iterable<Record<V>> {
        private final String label;
        private final String lowerBoundary;
        private final LabelType labelType;
        private final List<Record<V>> records = new ArrayList<Record<V>>();

        private Bucket(String label, String lowerBoundary, LabelType labelType) {
            this.label = label;
            this.lowerBoundary = lowerBoundary;
            this.labelType = labelType;
        }

        String getLowerBoundary() {
            return this.lowerBoundary;
        }

        public String getLabel() {
            return this.label;
        }

        public LabelType getLabelType() {
            return this.labelType;
        }

        public int size() {
            return this.records.size();
        }

        @Override
        public Iterator<Record<V>> iterator() {
            return this.records.iterator();
        }

        public String toString() {
            return "{labelType=" + (Object)((Object)this.labelType) + ", " + "lowerBoundary=" + this.lowerBoundary + ", " + "label=" + this.label + "}";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum LabelType {
            NORMAL,
            UNDERFLOW,
            INFLOW,
            OVERFLOW;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record<V> {
        private CharSequence name;
        private V data;
        private int counter;

        private Record(CharSequence name, V data, int counter) {
            this.name = name;
            this.data = data;
            this.counter = counter;
        }

        public CharSequence getName() {
            return this.name;
        }

        public V getData() {
            return this.data;
        }

        public String toString() {
            return this.name + "=" + this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreferenceComparator
    implements Comparator<Object> {
        static final Comparator<String> binary = new UTF16.StringComparator(true, false, 0);

        private PreferenceComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.compare((String)o1, (String)o2);
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            String n1 = Normalizer.decompose(s1, true);
            String n2 = Normalizer.decompose(s2, true);
            int result = n1.length() - n2.length();
            if (result != 0) {
                return result;
            }
            result = binary.compare(n1, n2);
            if (result != 0) {
                return result;
            }
            return binary.compare(s1, s2);
        }
    }
}

