/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassSubHierarchyInitializer
implements ClassVisitor {
    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.addSubclass(programClass, programClass.getSuperClass());
        for (int i = 0; i < programClass.u2interfacesCount; ++i) {
            this.addSubclass(programClass, programClass.getInterface(i));
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.addSubclass(libraryClass, libraryClass.superClass);
        Clazz[] clazzArray = libraryClass.interfaceClasses;
        if (clazzArray != null) {
            for (int i = 0; i < clazzArray.length; ++i) {
                this.addSubclass(libraryClass, clazzArray[i]);
            }
        }
    }

    private void addSubclass(Clazz clazz, Clazz clazz2) {
        if (clazz2 != null) {
            clazz2.addSubClass(clazz);
        }
    }
}

