/* This module is generated by the maint/MultiStage2.py script.
Do not modify it by hand. Instead modify the script and run it
to regenerate this code.

As well as being part of the PCRE2 library, this module is #included
by the pcre2test program, which redefines the PRIV macro to change
table names from _pcre2_xxx to xxxx, thereby avoiding name clashes
with the library. At present, just one of these tables is actually
needed. */

#ifndef PCRE2_PCRE2TEST

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "pcre2_internal.h"

#endif /* PCRE2_PCRE2TEST */

/* Unicode character database. */
/* This file was autogenerated by the MultiStage2.py script. */
/* Total size: 97152 bytes, block size: 128. */

/* The tables herein are needed only when UCP support is built,
and in PCRE2 that happens automatically with UTF support.
This module should not be referenced otherwise, so
it should not matter whether it is compiled or not. However
a comment was received about space saving - maybe the guy linked
all the modules rather than using a library - so we include a
condition to cut out the tables when not needed. But don't leave
a totally empty module because some compilers barf at that.
Instead, just supply some small dummy tables. */

#ifndef SUPPORT_UNICODE
const ucd_record PRIV(ucd_records)[] = {{0,0,0,0,0,0,0 }};
const uint16_t PRIV(ucd_stage1)[] = {0};
const uint16_t PRIV(ucd_stage2)[] = {0};
const uint32_t PRIV(ucd_caseless_sets)[] = {0};
#else

const char *PRIV(unicode_version) = "11.0.0";

/* If the 32-bit library is run in non-32-bit mode, character values
greater than 0x10ffff may be encountered. For these we set up a
special record. */

#if PCRE2_CODE_UNIT_WIDTH == 32
const ucd_record PRIV(dummy_ucd_record)[] = {{
  ucp_Unknown,    /* script */
  ucp_Cn,         /* type unassigned */
  ucp_gbOther,    /* grapheme break property */
  0,              /* case set */
  0,              /* other case */
  ucp_Unknown,    /* script extension */
  0,              /* dummy filler */
  }};
#endif

/* When recompiling tables with a new Unicode version, please check the
types in this structure definition from pcre2_internal.h (the actual
field names will be different):

typedef struct {
uint8_t property_0;
uint8_t property_1;
uint8_t property_2;
uint8_t property_3;
pcre_int32 property_4;
pcre_int16 property_5;
uint16_t property_6;
} ucd_record;
*/

/* This table contains lists of characters that are caseless sets of
more than one character. Each list is terminated by NOTACHAR. */

const uint32_t PRIV(ucd_caseless_sets)[] = {
  NOTACHAR,
  0x0053,   0x0073,   0x017f,   NOTACHAR,
  0x01c4,   0x01c5,   0x01c6,   NOTACHAR,
  0x01c7,   0x01c8,   0x01c9,   NOTACHAR,
  0x01ca,   0x01cb,   0x01cc,   NOTACHAR,
  0x01f1,   0x01f2,   0x01f3,   NOTACHAR,
  0x0345,   0x0399,   0x03b9,   0x1fbe,   NOTACHAR,
  0x00b5,   0x039c,   0x03bc,   NOTACHAR,
  0x03a3,   0x03c2,   0x03c3,   NOTACHAR,
  0x0392,   0x03b2,   0x03d0,   NOTACHAR,
  0x0398,   0x03b8,   0x03d1,   0x03f4,   NOTACHAR,
  0x03a6,   0x03c6,   0x03d5,   NOTACHAR,
  0x03a0,   0x03c0,   0x03d6,   NOTACHAR,
  0x039a,   0x03ba,   0x03f0,   NOTACHAR,
  0x03a1,   0x03c1,   0x03f1,   NOTACHAR,
  0x0395,   0x03b5,   0x03f5,   NOTACHAR,
  0x0412,   0x0432,   0x1c80,   NOTACHAR,
  0x0414,   0x0434,   0x1c81,   NOTACHAR,
  0x041e,   0x043e,   0x1c82,   NOTACHAR,
  0x0421,   0x0441,   0x1c83,   NOTACHAR,
  0x0422,   0x0442,   0x1c84,   0x1c85,   NOTACHAR,
  0x042a,   0x044a,   0x1c86,   NOTACHAR,
  0x0462,   0x0463,   0x1c87,   NOTACHAR,
  0x1e60,   0x1e61,   0x1e9b,   NOTACHAR,
  0x03a9,   0x03c9,   0x2126,   NOTACHAR,
  0x004b,   0x006b,   0x212a,   NOTACHAR,
  0x00c5,   0x00e5,   0x212b,   NOTACHAR,
  0x1c88,   0xa64a,   0xa64b,   NOTACHAR,
};

/* When #included in pcre2test, we don't need the table of digit
sets, nor the the large main UCD tables. */

#ifndef PCRE2_PCRE2TEST

/* This table lists the code points for the '9' characters in each
set of decimal digits. It is used to ensure that all the digits in
a script run come from the same set. */

const uint32_t PRIV(ucd_digit_sets)[] = {
  61,  /* Number of subsequent values */
  0x00039, 0x00669, 0x006f9, 0x007c9, 0x0096f, 0x009ef, 0x00a6f, 0x00aef,
  0x00b6f, 0x00bef, 0x00c6f, 0x00cef, 0x00d6f, 0x00def, 0x00e59, 0x00ed9,
  0x00f29, 0x01049, 0x01099, 0x017e9, 0x01819, 0x0194f, 0x019d9, 0x01a89,
  0x01a99, 0x01b59, 0x01bb9, 0x01c49, 0x01c59, 0x0a629, 0x0a8d9, 0x0a909,
  0x0a9d9, 0x0a9f9, 0x0aa59, 0x0abf9, 0x0ff19, 0x104a9, 0x10d39, 0x1106f,
  0x110f9, 0x1113f, 0x111d9, 0x112f9, 0x11459, 0x114d9, 0x11659, 0x116c9,
  0x11739, 0x118e9, 0x11c59, 0x11d59, 0x11da9, 0x16a69, 0x16b59, 0x1d7d7,
  0x1d7e1, 0x1d7eb, 0x1d7f5, 0x1d7ff, 0x1e959,
};

/* This vector is a list of lists of scripts for the Script Extension
property. Each sublist is zero-terminated. */

const uint8_t PRIV(ucd_script_sets)[] = {
  /*   0 */   0,
  /*   1 */   1,  11,   0,
  /*   4 */   1, 144,   0,
  /*   7 */   1,  50,   0,
  /*  10 */   1,  56,   0,
  /*  13 */   2,  17,   0,
  /*  16 */   3,  15,   0,
  /*  19 */   4,  23,   0,
  /*  22 */   6,  84,   0,
  /*  25 */  12,  36,   0,
  /*  28 */  13,  18,   0,
  /*  31 */  13,  34,   0,
  /*  34 */  13, 118,   0,
  /*  37 */  15, 107,   0,
  /*  40 */  15, 100,   0,
  /*  43 */  15,  54,   0,
  /*  46 */  17,  34,   0,
  /*  49 */ 107,  54,   0,
  /*  52 */  21, 108,   0,
  /*  55 */  22, 129,   0,
  /*  58 */  27,  30,   0,
  /*  61 */  38,  65,   0,
  /*  64 */   1,  50,  56,   0,
  /*  68 */   3,  96,  49,   0,
  /*  72 */  96,  39,  53,   0,
  /*  76 */  12, 110,  36,   0,
  /*  80 */  15, 107,  29,   0,
  /*  84 */  15, 107,  34,   0,
  /*  88 */  23,  27,  30,   0,
  /*  92 */  69,  34,  39,   0,
  /*  96 */   1, 144,  50,  56,   0,
  /* 101 */   3,  15, 107,  29,   0,
  /* 106 */   7,  25,  52,  51,   0,
  /* 111 */  15, 142,  85, 111,   0,
  /* 116 */   4,  24,  23,  27,  30,   0,
  /* 122 */   4,  24,  23,  27,  30,  61,   0,
  /* 129 */  15,  29,  37,  44,  54,  55,   0,
  /* 136 */ 132,   1,  95, 112, 121, 144, 148,  50,   0,
  /* 145 */  15, 142,  21,  22, 108,  85, 111, 114, 109, 102, 124,   0,
  /* 157 */   3,  15, 107,  21,  22,  29,  34,  37,  44,  54,  55, 124,   0,
  /* 170 */  15, 142,  21,  22, 108,  29,  85, 111, 114, 109, 102, 124,   0,
  /* 183 */   3,  15, 107,  21,  22,  29,  34,  37,  44, 100,  54,  55, 124,   0,
  /* 197 */  15, 142,  21,  22, 108,  29,  85, 111,  37, 114, 109, 102, 124,   0,
  /* 211 */   3,  15, 142, 143, 107,  21,  22,  29, 111,  37,  44, 109,  48,  49, 102,  54,  55, 124,   0,
  /* 230 */   3,  15, 142, 143, 107,  21,  22,  29,  35, 111,  37,  44, 109,  48,  49, 102,  54,  55, 124,   0,
  /* 250 */
};

/* These are the main two-stage UCD tables. The fields in each record are:
script (8 bits), character type (8 bits), grapheme break property (8 bits),
offset to multichar other cases or zero (8 bits), offset to other case
or zero (32 bits, signed), script extension (16 bits, signed), and a dummy
16-bit field to make the whole thing a multiple of 4 bytes. */

const ucd_record PRIV(ucd_records)[] = { /* 11136 bytes, record size 12 */
  {    10,      0,      2,      0,      0,     10,    256, }, /*   0 */
  {    10,      0,      2,      0,      0,     10,      0, }, /*   1 */
  {    10,      0,      1,      0,      0,     10,      0, }, /*   2 */
  {    10,      0,      0,      0,      0,     10,      0, }, /*   3 */
  {    10,     29,     12,      0,      0,     10,      0, }, /*   4 */
  {    10,     21,     12,      0,      0,     10,      0, }, /*   5 */
  {    10,     23,     12,      0,      0,     10,      0, }, /*   6 */
  {    10,     22,     12,      0,      0,     10,      0, }, /*   7 */
  {    10,     18,     12,      0,      0,     10,      0, }, /*   8 */
  {    10,     25,     12,      0,      0,     10,      0, }, /*   9 */
  {    10,     17,     12,      0,      0,     10,      0, }, /*  10 */
  {    10,     13,     12,      0,      0,     10,      0, }, /*  11 */
  {    34,      9,     12,      0,     32,     34,      0, }, /*  12 */
  {    34,      9,     12,    100,     32,     34,      0, }, /*  13 */
  {    34,      9,     12,      1,     32,     34,      0, }, /*  14 */
  {    10,     24,     12,      0,      0,     10,      0, }, /*  15 */
  {    10,     16,     12,      0,      0,     10,      0, }, /*  16 */
  {    34,      5,     12,      0,    -32,     34,      0, }, /*  17 */
  {    34,      5,     12,    100,    -32,     34,      0, }, /*  18 */
  {    34,      5,     12,      1,    -32,     34,      0, }, /*  19 */
  {    10,     26,     12,      0,      0,     10,      0, }, /*  20 */
  {    10,     26,     14,      0,      0,     10,      0, }, /*  21 */
  {    34,      7,     12,      0,      0,     34,      0, }, /*  22 */
  {    10,     20,     12,      0,      0,     10,      0, }, /*  23 */
  {    10,      1,      2,      0,      0,     10,      0, }, /*  24 */
  {    10,     15,     12,      0,      0,     10,      0, }, /*  25 */
  {    10,      5,     12,     26,    775,     10,      0, }, /*  26 */
  {    10,     19,     12,      0,      0,     10,      0, }, /*  27 */
  {    34,      9,     12,    104,     32,     34,      0, }, /*  28 */
  {    34,      5,     12,      0,   7615,     34,      0, }, /*  29 */
  {    34,      5,     12,    104,    -32,     34,      0, }, /*  30 */
  {    34,      5,     12,      0,    121,     34,      0, }, /*  31 */
  {    34,      9,     12,      0,      1,     34,      0, }, /*  32 */
  {    34,      5,     12,      0,     -1,     34,      0, }, /*  33 */
  {    34,      9,     12,      0,      0,     34,      0, }, /*  34 */
  {    34,      5,     12,      0,      0,     34,      0, }, /*  35 */
  {    34,      9,     12,      0,   -121,     34,      0, }, /*  36 */
  {    34,      5,     12,      1,   -268,     34,      0, }, /*  37 */
  {    34,      5,     12,      0,    195,     34,      0, }, /*  38 */
  {    34,      9,     12,      0,    210,     34,      0, }, /*  39 */
  {    34,      9,     12,      0,    206,     34,      0, }, /*  40 */
  {    34,      9,     12,      0,    205,     34,      0, }, /*  41 */
  {    34,      9,     12,      0,     79,     34,      0, }, /*  42 */
  {    34,      9,     12,      0,    202,     34,      0, }, /*  43 */
  {    34,      9,     12,      0,    203,     34,      0, }, /*  44 */
  {    34,      9,     12,      0,    207,     34,      0, }, /*  45 */
  {    34,      5,     12,      0,     97,     34,      0, }, /*  46 */
  {    34,      9,     12,      0,    211,     34,      0, }, /*  47 */
  {    34,      9,     12,      0,    209,     34,      0, }, /*  48 */
  {    34,      5,     12,      0,    163,     34,      0, }, /*  49 */
  {    34,      9,     12,      0,    213,     34,      0, }, /*  50 */
  {    34,      5,     12,      0,    130,     34,      0, }, /*  51 */
  {    34,      9,     12,      0,    214,     34,      0, }, /*  52 */
  {    34,      9,     12,      0,    218,     34,      0, }, /*  53 */
  {    34,      9,     12,      0,    217,     34,      0, }, /*  54 */
  {    34,      9,     12,      0,    219,     34,      0, }, /*  55 */
  {    34,      5,     12,      0,     56,     34,      0, }, /*  56 */
  {    34,      9,     12,      5,      2,     34,      0, }, /*  57 */
  {    34,      8,     12,      5,      1,     34,      0, }, /*  58 */
  {    34,      5,     12,      5,     -2,     34,      0, }, /*  59 */
  {    34,      9,     12,      9,      2,     34,      0, }, /*  60 */
  {    34,      8,     12,      9,      1,     34,      0, }, /*  61 */
  {    34,      5,     12,      9,     -2,     34,      0, }, /*  62 */
  {    34,      9,     12,     13,      2,     34,      0, }, /*  63 */
  {    34,      8,     12,     13,      1,     34,      0, }, /*  64 */
  {    34,      5,     12,     13,     -2,     34,      0, }, /*  65 */
  {    34,      5,     12,      0,    -79,     34,      0, }, /*  66 */
  {    34,      9,     12,     17,      2,     34,      0, }, /*  67 */
  {    34,      8,     12,     17,      1,     34,      0, }, /*  68 */
  {    34,      5,     12,     17,     -2,     34,      0, }, /*  69 */
  {    34,      9,     12,      0,    -97,     34,      0, }, /*  70 */
  {    34,      9,     12,      0,    -56,     34,      0, }, /*  71 */
  {    34,      9,     12,      0,   -130,     34,      0, }, /*  72 */
  {    34,      9,     12,      0,  10795,     34,      0, }, /*  73 */
  {    34,      9,     12,      0,   -163,     34,      0, }, /*  74 */
  {    34,      9,     12,      0,  10792,     34,      0, }, /*  75 */
  {    34,      5,     12,      0,  10815,     34,      0, }, /*  76 */
  {    34,      9,     12,      0,   -195,     34,      0, }, /*  77 */
  {    34,      9,     12,      0,     69,     34,      0, }, /*  78 */
  {    34,      9,     12,      0,     71,     34,      0, }, /*  79 */
  {    34,      5,     12,      0,  10783,     34,      0, }, /*  80 */
  {    34,      5,     12,      0,  10780,     34,      0, }, /*  81 */
  {    34,      5,     12,      0,  10782,     34,      0, }, /*  82 */
  {    34,      5,     12,      0,   -210,     34,      0, }, /*  83 */
  {    34,      5,     12,      0,   -206,     34,      0, }, /*  84 */
  {    34,      5,     12,      0,   -205,     34,      0, }, /*  85 */
  {    34,      5,     12,      0,   -202,     34,      0, }, /*  86 */
  {    34,      5,     12,      0,   -203,     34,      0, }, /*  87 */
  {    34,      5,     12,      0,  42319,     34,      0, }, /*  88 */
  {    34,      5,     12,      0,  42315,     34,      0, }, /*  89 */
  {    34,      5,     12,      0,   -207,     34,      0, }, /*  90 */
  {    34,      5,     12,      0,  42280,     34,      0, }, /*  91 */
  {    34,      5,     12,      0,  42308,     34,      0, }, /*  92 */
  {    34,      5,     12,      0,   -209,     34,      0, }, /*  93 */
  {    34,      5,     12,      0,   -211,     34,      0, }, /*  94 */
  {    34,      5,     12,      0,  10743,     34,      0, }, /*  95 */
  {    34,      5,     12,      0,  42305,     34,      0, }, /*  96 */
  {    34,      5,     12,      0,  10749,     34,      0, }, /*  97 */
  {    34,      5,     12,      0,   -213,     34,      0, }, /*  98 */
  {    34,      5,     12,      0,   -214,     34,      0, }, /*  99 */
  {    34,      5,     12,      0,  10727,     34,      0, }, /* 100 */
  {    34,      5,     12,      0,   -218,     34,      0, }, /* 101 */
  {    34,      5,     12,      0,  42282,     34,      0, }, /* 102 */
  {    34,      5,     12,      0,    -69,     34,      0, }, /* 103 */
  {    34,      5,     12,      0,   -217,     34,      0, }, /* 104 */
  {    34,      5,     12,      0,    -71,     34,      0, }, /* 105 */
  {    34,      5,     12,      0,   -219,     34,      0, }, /* 106 */
  {    34,      5,     12,      0,  42261,     34,      0, }, /* 107 */
  {    34,      5,     12,      0,  42258,     34,      0, }, /* 108 */
  {    34,      6,     12,      0,      0,     34,      0, }, /* 109 */
  {    10,      6,     12,      0,      0,     10,      0, }, /* 110 */
  {     4,     24,     12,      0,      0,      4,      0, }, /* 111 */
  {    28,     12,      3,      0,      0,     28,      0, }, /* 112 */
  {    28,     12,      3,      0,      0,     20,      0, }, /* 113 */
  {    28,     12,      3,     21,    116,     20,      0, }, /* 114 */
  {    28,     12,      3,      0,      0,     34,      0, }, /* 115 */
  {    20,      9,     12,      0,      1,     20,      0, }, /* 116 */
  {    20,      5,     12,      0,     -1,     20,      0, }, /* 117 */
  {    20,     24,     12,      0,      0,     20,      0, }, /* 118 */
  {     0,      2,     12,      0,      0,      0,      0, }, /* 119 */
  {    20,      6,     12,      0,      0,     20,      0, }, /* 120 */
  {    20,      5,     12,      0,    130,     20,      0, }, /* 121 */
  {    20,      9,     12,      0,    116,     20,      0, }, /* 122 */
  {    20,      9,     12,      0,     38,     20,      0, }, /* 123 */
  {    20,      9,     12,      0,     37,     20,      0, }, /* 124 */
  {    20,      9,     12,      0,     64,     20,      0, }, /* 125 */
  {    20,      9,     12,      0,     63,     20,      0, }, /* 126 */
  {    20,      5,     12,      0,      0,     20,      0, }, /* 127 */
  {    20,      9,     12,      0,     32,     20,      0, }, /* 128 */
  {    20,      9,     12,     34,     32,     20,      0, }, /* 129 */
  {    20,      9,     12,     59,     32,     20,      0, }, /* 130 */
  {    20,      9,     12,     38,     32,     20,      0, }, /* 131 */
  {    20,      9,     12,     21,     32,     20,      0, }, /* 132 */
  {    20,      9,     12,     51,     32,     20,      0, }, /* 133 */
  {    20,      9,     12,     26,     32,     20,      0, }, /* 134 */
  {    20,      9,     12,     47,     32,     20,      0, }, /* 135 */
  {    20,      9,     12,     55,     32,     20,      0, }, /* 136 */
  {    20,      9,     12,     30,     32,     20,      0, }, /* 137 */
  {    20,      9,     12,     43,     32,     20,      0, }, /* 138 */
  {    20,      9,     12,     96,     32,     20,      0, }, /* 139 */
  {    20,      5,     12,      0,    -38,     20,      0, }, /* 140 */
  {    20,      5,     12,      0,    -37,     20,      0, }, /* 141 */
  {    20,      5,     12,      0,    -32,     20,      0, }, /* 142 */
  {    20,      5,     12,     34,    -32,     20,      0, }, /* 143 */
  {    20,      5,     12,     59,    -32,     20,      0, }, /* 144 */
  {    20,      5,     12,     38,    -32,     20,      0, }, /* 145 */
  {    20,      5,     12,     21,   -116,     20,      0, }, /* 146 */
  {    20,      5,     12,     51,    -32,     20,      0, }, /* 147 */
  {    20,      5,     12,     26,   -775,     20,      0, }, /* 148 */
  {    20,      5,     12,     47,    -32,     20,      0, }, /* 149 */
  {    20,      5,     12,     55,    -32,     20,      0, }, /* 150 */
  {    20,      5,     12,     30,      1,     20,      0, }, /* 151 */
  {    20,      5,     12,     30,    -32,     20,      0, }, /* 152 */
  {    20,      5,     12,     43,    -32,     20,      0, }, /* 153 */
  {    20,      5,     12,     96,    -32,     20,      0, }, /* 154 */
  {    20,      5,     12,      0,    -64,     20,      0, }, /* 155 */
  {    20,      5,     12,      0,    -63,     20,      0, }, /* 156 */
  {    20,      9,     12,      0,      8,     20,      0, }, /* 157 */
  {    20,      5,     12,     34,    -30,     20,      0, }, /* 158 */
  {    20,      5,     12,     38,    -25,     20,      0, }, /* 159 */
  {    20,      9,     12,      0,      0,     20,      0, }, /* 160 */
  {    20,      5,     12,     43,    -15,     20,      0, }, /* 161 */
  {    20,      5,     12,     47,    -22,     20,      0, }, /* 162 */
  {    20,      5,     12,      0,     -8,     20,      0, }, /* 163 */
  {    11,      9,     12,      0,      1,     11,      0, }, /* 164 */
  {    11,      5,     12,      0,     -1,     11,      0, }, /* 165 */
  {    20,      5,     12,     51,    -54,     20,      0, }, /* 166 */
  {    20,      5,     12,     55,    -48,     20,      0, }, /* 167 */
  {    20,      5,     12,      0,      7,     20,      0, }, /* 168 */
  {    20,      5,     12,      0,   -116,     20,      0, }, /* 169 */
  {    20,      9,     12,     38,    -60,     20,      0, }, /* 170 */
  {    20,      5,     12,     59,    -64,     20,      0, }, /* 171 */
  {    20,     25,     12,      0,      0,     20,      0, }, /* 172 */
  {    20,      9,     12,      0,     -7,     20,      0, }, /* 173 */
  {    20,      9,     12,      0,   -130,     20,      0, }, /* 174 */
  {    13,      9,     12,      0,     80,     13,      0, }, /* 175 */
  {    13,      9,     12,      0,     32,     13,      0, }, /* 176 */
  {    13,      9,     12,     63,     32,     13,      0, }, /* 177 */
  {    13,      9,     12,     67,     32,     13,      0, }, /* 178 */
  {    13,      9,     12,     71,     32,     13,      0, }, /* 179 */
  {    13,      9,     12,     75,     32,     13,      0, }, /* 180 */
  {    13,      9,     12,     79,     32,     13,      0, }, /* 181 */
  {    13,      9,     12,     84,     32,     13,      0, }, /* 182 */
  {    13,      5,     12,      0,    -32,     13,      0, }, /* 183 */
  {    13,      5,     12,     63,    -32,     13,      0, }, /* 184 */
  {    13,      5,     12,     67,    -32,     13,      0, }, /* 185 */
  {    13,      5,     12,     71,    -32,     13,      0, }, /* 186 */
  {    13,      5,     12,     75,    -32,     13,      0, }, /* 187 */
  {    13,      5,     12,     79,    -32,     13,      0, }, /* 188 */
  {    13,      5,     12,     84,    -32,     13,      0, }, /* 189 */
  {    13,      5,     12,      0,    -80,     13,      0, }, /* 190 */
  {    13,      9,     12,      0,      1,     13,      0, }, /* 191 */
  {    13,      5,     12,      0,     -1,     13,      0, }, /* 192 */
  {    13,      9,     12,     88,      1,     13,      0, }, /* 193 */
  {    13,      5,     12,     88,     -1,     13,      0, }, /* 194 */
  {    13,     26,     12,      0,      0,     13,      0, }, /* 195 */
  {    13,     12,      3,      0,      0,    -34,      0, }, /* 196 */
  {    13,     12,      3,      0,      0,    -28,      0, }, /* 197 */
  {    28,     12,      3,      0,      0,    -31,      0, }, /* 198 */
  {    13,     11,      3,      0,      0,     13,      0, }, /* 199 */
  {    13,      9,     12,      0,     15,     13,      0, }, /* 200 */
  {    13,      5,     12,      0,    -15,     13,      0, }, /* 201 */
  {     2,      9,     12,      0,     48,      2,      0, }, /* 202 */
  {     2,      6,     12,      0,      0,      2,      0, }, /* 203 */
  {     2,     21,     12,      0,      0,      2,      0, }, /* 204 */
  {     2,      5,     12,      0,      0,      2,      0, }, /* 205 */
  {     2,      5,     12,      0,    -48,      2,      0, }, /* 206 */
  {    10,     21,     12,      0,      0,    -13,      0, }, /* 207 */
  {     2,     17,     12,      0,      0,      2,      0, }, /* 208 */
  {     2,     26,     12,      0,      0,      2,      0, }, /* 209 */
  {     2,     23,     12,      0,      0,      2,      0, }, /* 210 */
  {    26,     12,      3,      0,      0,     26,      0, }, /* 211 */
  {    26,     17,     12,      0,      0,     26,      0, }, /* 212 */
  {    26,     21,     12,      0,      0,     26,      0, }, /* 213 */
  {    26,      7,     12,      0,      0,     26,      0, }, /* 214 */
  {     1,      1,      4,      0,      0,      1,      0, }, /* 215 */
  {    10,      1,      4,      0,      0,     10,      0, }, /* 216 */
  {     1,     25,     12,      0,      0,      1,      0, }, /* 217 */
  {     1,     21,     12,      0,      0,      1,      0, }, /* 218 */
  {     1,     23,     12,      0,      0,      1,      0, }, /* 219 */
  {    10,     21,     12,      0,      0,    -96,      0, }, /* 220 */
  {     1,     26,     12,      0,      0,      1,      0, }, /* 221 */
  {     1,     12,      3,      0,      0,      1,      0, }, /* 222 */
  {     1,      1,      2,      0,      0,    -64,      0, }, /* 223 */
  {     1,      7,     12,      0,      0,      1,      0, }, /* 224 */
  {    10,      6,     12,      0,      0,   -136,      0, }, /* 225 */
  {    28,     12,      3,      0,      0,     -7,      0, }, /* 226 */
  {     1,     13,     12,      0,      0,    -10,      0, }, /* 227 */
  {     1,     21,     12,      0,      0,     -4,      0, }, /* 228 */
  {     1,      6,     12,      0,      0,      1,      0, }, /* 229 */
  {     1,     13,     12,      0,      0,      1,      0, }, /* 230 */
  {    50,     21,     12,      0,      0,     50,      0, }, /* 231 */
  {    50,      1,      4,      0,      0,     50,      0, }, /* 232 */
  {    50,      7,     12,      0,      0,     50,      0, }, /* 233 */
  {    50,     12,      3,      0,      0,     50,      0, }, /* 234 */
  {    56,      7,     12,      0,      0,     56,      0, }, /* 235 */
  {    56,     12,      3,      0,      0,     56,      0, }, /* 236 */
  {    64,     13,     12,      0,      0,     64,      0, }, /* 237 */
  {    64,      7,     12,      0,      0,     64,      0, }, /* 238 */
  {    64,     12,      3,      0,      0,     64,      0, }, /* 239 */
  {    64,      6,     12,      0,      0,     64,      0, }, /* 240 */
  {    64,     26,     12,      0,      0,     64,      0, }, /* 241 */
  {    64,     21,     12,      0,      0,     64,      0, }, /* 242 */
  {    64,     23,     12,      0,      0,     64,      0, }, /* 243 */
  {    90,      7,     12,      0,      0,     90,      0, }, /* 244 */
  {    90,     12,      3,      0,      0,     90,      0, }, /* 245 */
  {    90,      6,     12,      0,      0,     90,      0, }, /* 246 */
  {    90,     21,     12,      0,      0,     90,      0, }, /* 247 */
  {    95,      7,     12,      0,      0,     95,      0, }, /* 248 */
  {    95,     12,      3,      0,      0,     95,      0, }, /* 249 */
  {    95,     21,     12,      0,      0,     95,      0, }, /* 250 */
  {    15,     12,      3,      0,      0,     15,      0, }, /* 251 */
  {    15,     10,      5,      0,      0,     15,      0, }, /* 252 */
  {    15,      7,     12,      0,      0,     15,      0, }, /* 253 */
  {    28,     12,      3,      0,      0,   -183,      0, }, /* 254 */
  {    28,     12,      3,      0,      0,   -157,      0, }, /* 255 */
  {    10,     21,     12,      0,      0,   -211,      0, }, /* 256 */
  {    10,     21,     12,      0,      0,   -230,      0, }, /* 257 */
  {    15,     13,     12,      0,      0,   -111,      0, }, /* 258 */
  {    15,     21,     12,      0,      0,     15,      0, }, /* 259 */
  {    15,      6,     12,      0,      0,     15,      0, }, /* 260 */
  {     3,      7,     12,      0,      0,      3,      0, }, /* 261 */
  {     3,     12,      3,      0,      0,      3,      0, }, /* 262 */
  {     3,     10,      5,      0,      0,      3,      0, }, /* 263 */
  {     3,     10,      3,      0,      0,      3,      0, }, /* 264 */
  {     3,     13,     12,      0,      0,    -68,      0, }, /* 265 */
  {     3,     23,     12,      0,      0,      3,      0, }, /* 266 */
  {     3,     15,     12,      0,      0,      3,      0, }, /* 267 */
  {     3,     26,     12,      0,      0,      3,      0, }, /* 268 */
  {     3,     21,     12,      0,      0,      3,      0, }, /* 269 */
  {    22,     12,      3,      0,      0,     22,      0, }, /* 270 */
  {    22,     10,      5,      0,      0,     22,      0, }, /* 271 */
  {    22,      7,     12,      0,      0,     22,      0, }, /* 272 */
  {    22,     13,     12,      0,      0,    -55,      0, }, /* 273 */
  {    22,     21,     12,      0,      0,     22,      0, }, /* 274 */
  {    21,     12,      3,      0,      0,     21,      0, }, /* 275 */
  {    21,     10,      5,      0,      0,     21,      0, }, /* 276 */
  {    21,      7,     12,      0,      0,     21,      0, }, /* 277 */
  {    21,     13,     12,      0,      0,    -52,      0, }, /* 278 */
  {    21,     21,     12,      0,      0,     21,      0, }, /* 279 */
  {    21,     23,     12,      0,      0,     21,      0, }, /* 280 */
  {    44,     12,      3,      0,      0,     44,      0, }, /* 281 */
  {    44,     10,      5,      0,      0,     44,      0, }, /* 282 */
  {    44,      7,     12,      0,      0,     44,      0, }, /* 283 */
  {    44,     10,      3,      0,      0,     44,      0, }, /* 284 */
  {    44,     13,     12,      0,      0,     44,      0, }, /* 285 */
  {    44,     26,     12,      0,      0,     44,      0, }, /* 286 */
  {    44,     15,     12,      0,      0,     44,      0, }, /* 287 */
  {    54,     12,      3,      0,      0,     54,      0, }, /* 288 */
  {    54,      7,     12,      0,      0,     54,      0, }, /* 289 */
  {    54,     10,      3,      0,      0,     54,      0, }, /* 290 */
  {    54,     10,      5,      0,      0,     54,      0, }, /* 291 */
  {    54,     13,     12,      0,      0,    -49,      0, }, /* 292 */
  {    54,     15,     12,      0,      0,    -49,      0, }, /* 293 */
  {    54,     26,     12,      0,      0,    -49,      0, }, /* 294 */
  {    54,     26,     12,      0,      0,     54,      0, }, /* 295 */
  {    54,     23,     12,      0,      0,     54,      0, }, /* 296 */
  {    55,     12,      3,      0,      0,     55,      0, }, /* 297 */
  {    55,     10,      5,      0,      0,     55,      0, }, /* 298 */
  {    55,      7,     12,      0,      0,     55,      0, }, /* 299 */
  {    55,     13,     12,      0,      0,     55,      0, }, /* 300 */
  {    55,     15,     12,      0,      0,     55,      0, }, /* 301 */
  {    55,     26,     12,      0,      0,     55,      0, }, /* 302 */
  {    29,      7,     12,      0,      0,     29,      0, }, /* 303 */
  {    29,     12,      3,      0,      0,     29,      0, }, /* 304 */
  {    29,     10,      5,      0,      0,     29,      0, }, /* 305 */
  {    29,     21,     12,      0,      0,     29,      0, }, /* 306 */
  {    29,     10,      3,      0,      0,     29,      0, }, /* 307 */
  {    29,     13,     12,      0,      0,     29,      0, }, /* 308 */
  {    37,     12,      3,      0,      0,     37,      0, }, /* 309 */
  {    37,     10,      5,      0,      0,     37,      0, }, /* 310 */
  {    37,      7,     12,      0,      0,     37,      0, }, /* 311 */
  {    37,     10,      3,      0,      0,     37,      0, }, /* 312 */
  {    37,      7,      4,      0,      0,     37,      0, }, /* 313 */
  {    37,     26,     12,      0,      0,     37,      0, }, /* 314 */
  {    37,     15,     12,      0,      0,     37,      0, }, /* 315 */
  {    37,     13,     12,      0,      0,     37,      0, }, /* 316 */
  {    48,     10,      5,      0,      0,     48,      0, }, /* 317 */
  {    48,      7,     12,      0,      0,     48,      0, }, /* 318 */
  {    48,     12,      3,      0,      0,     48,      0, }, /* 319 */
  {    48,     10,      3,      0,      0,     48,      0, }, /* 320 */
  {    48,     13,     12,      0,      0,     48,      0, }, /* 321 */
  {    48,     21,     12,      0,      0,     48,      0, }, /* 322 */
  {    57,      7,     12,      0,      0,     57,      0, }, /* 323 */
  {    57,     12,      3,      0,      0,     57,      0, }, /* 324 */
  {    57,      7,      5,      0,      0,     57,      0, }, /* 325 */
  {    57,      6,     12,      0,      0,     57,      0, }, /* 326 */
  {    57,     21,     12,      0,      0,     57,      0, }, /* 327 */
  {    57,     13,     12,      0,      0,     57,      0, }, /* 328 */
  {    33,      7,     12,      0,      0,     33,      0, }, /* 329 */
  {    33,     12,      3,      0,      0,     33,      0, }, /* 330 */
  {    33,      7,      5,      0,      0,     33,      0, }, /* 331 */
  {    33,      6,     12,      0,      0,     33,      0, }, /* 332 */
  {    33,     13,     12,      0,      0,     33,      0, }, /* 333 */
  {    58,      7,     12,      0,      0,     58,      0, }, /* 334 */
  {    58,     26,     12,      0,      0,     58,      0, }, /* 335 */
  {    58,     21,     12,      0,      0,     58,      0, }, /* 336 */
  {    58,     12,      3,      0,      0,     58,      0, }, /* 337 */
  {    58,     13,     12,      0,      0,     58,      0, }, /* 338 */
  {    58,     15,     12,      0,      0,     58,      0, }, /* 339 */
  {    58,     22,     12,      0,      0,     58,      0, }, /* 340 */
  {    58,     18,     12,      0,      0,     58,      0, }, /* 341 */
  {    58,     10,      5,      0,      0,     58,      0, }, /* 342 */
  {    39,      7,     12,      0,      0,     39,      0, }, /* 343 */
  {    39,     10,     12,      0,      0,     39,      0, }, /* 344 */
  {    39,     12,      3,      0,      0,     39,      0, }, /* 345 */
  {    39,     10,      5,      0,      0,     39,      0, }, /* 346 */
  {    39,     13,     12,      0,      0,    -72,      0, }, /* 347 */
  {    39,     21,     12,      0,      0,     39,      0, }, /* 348 */
  {    39,     13,     12,      0,      0,     39,      0, }, /* 349 */
  {    39,     26,     12,      0,      0,     39,      0, }, /* 350 */
  {    17,      9,     12,      0,   7264,     17,      0, }, /* 351 */
  {    17,      5,     12,      0,   3008,     17,      0, }, /* 352 */
  {    10,     21,     12,      0,      0,    -46,      0, }, /* 353 */
  {    17,      6,     12,      0,      0,     17,      0, }, /* 354 */
  {    24,      7,      6,      0,      0,     24,      0, }, /* 355 */
  {    24,      7,      7,      0,      0,     24,      0, }, /* 356 */
  {    24,      7,      8,      0,      0,     24,      0, }, /* 357 */
  {    16,      7,     12,      0,      0,     16,      0, }, /* 358 */
  {    16,     12,      3,      0,      0,     16,      0, }, /* 359 */
  {    16,     21,     12,      0,      0,     16,      0, }, /* 360 */
  {    16,     15,     12,      0,      0,     16,      0, }, /* 361 */
  {    16,     26,     12,      0,      0,     16,      0, }, /* 362 */
  {     9,      9,     12,      0,  38864,      9,      0, }, /* 363 */
  {     9,      9,     12,      0,      8,      9,      0, }, /* 364 */
  {     9,      5,     12,      0,     -8,      9,      0, }, /* 365 */
  {     8,     17,     12,      0,      0,      8,      0, }, /* 366 */
  {     8,      7,     12,      0,      0,      8,      0, }, /* 367 */
  {     8,     21,     12,      0,      0,      8,      0, }, /* 368 */
  {    41,     29,     12,      0,      0,     41,      0, }, /* 369 */
  {    41,      7,     12,      0,      0,     41,      0, }, /* 370 */
  {    41,     22,     12,      0,      0,     41,      0, }, /* 371 */
  {    41,     18,     12,      0,      0,     41,      0, }, /* 372 */
  {    46,      7,     12,      0,      0,     46,      0, }, /* 373 */
  {    46,     14,     12,      0,      0,     46,      0, }, /* 374 */
  {    51,      7,     12,      0,      0,     51,      0, }, /* 375 */
  {    51,     12,      3,      0,      0,     51,      0, }, /* 376 */
  {    25,      7,     12,      0,      0,     25,      0, }, /* 377 */
  {    25,     12,      3,      0,      0,     25,      0, }, /* 378 */
  {    10,     21,     12,      0,      0,   -106,      0, }, /* 379 */
  {     7,      7,     12,      0,      0,      7,      0, }, /* 380 */
  {     7,     12,      3,      0,      0,      7,      0, }, /* 381 */
  {    52,      7,     12,      0,      0,     52,      0, }, /* 382 */
  {    52,     12,      3,      0,      0,     52,      0, }, /* 383 */
  {    32,      7,     12,      0,      0,     32,      0, }, /* 384 */
  {    32,     12,      3,      0,      0,     32,      0, }, /* 385 */
  {    32,     10,      5,      0,      0,     32,      0, }, /* 386 */
  {    32,     21,     12,      0,      0,     32,      0, }, /* 387 */
  {    32,      6,     12,      0,      0,     32,      0, }, /* 388 */
  {    32,     23,     12,      0,      0,     32,      0, }, /* 389 */
  {    32,     13,     12,      0,      0,     32,      0, }, /* 390 */
  {    32,     15,     12,      0,      0,     32,      0, }, /* 391 */
  {    38,     21,     12,      0,      0,     38,      0, }, /* 392 */
  {    10,     21,     12,      0,      0,    -61,      0, }, /* 393 */
  {    38,     17,     12,      0,      0,     38,      0, }, /* 394 */
  {    38,     12,      3,      0,      0,     38,      0, }, /* 395 */
  {    38,      1,      2,      0,      0,     38,      0, }, /* 396 */
  {    38,     13,     12,      0,      0,     38,      0, }, /* 397 */
  {    38,      7,     12,      0,      0,     38,      0, }, /* 398 */
  {    38,      6,     12,      0,      0,     38,      0, }, /* 399 */
  {    35,      7,     12,      0,      0,     35,      0, }, /* 400 */
  {    35,     12,      3,      0,      0,     35,      0, }, /* 401 */
  {    35,     10,      5,      0,      0,     35,      0, }, /* 402 */
  {    35,     26,     12,      0,      0,     35,      0, }, /* 403 */
  {    35,     21,     12,      0,      0,     35,      0, }, /* 404 */
  {    35,     13,     12,      0,      0,     35,      0, }, /* 405 */
  {    53,      7,     12,      0,      0,     53,      0, }, /* 406 */
  {    40,      7,     12,      0,      0,     40,      0, }, /* 407 */
  {    40,     13,     12,      0,      0,     40,      0, }, /* 408 */
  {    40,     15,     12,      0,      0,     40,      0, }, /* 409 */
  {    40,     26,     12,      0,      0,     40,      0, }, /* 410 */
  {    32,     26,     12,      0,      0,     32,      0, }, /* 411 */
  {     6,      7,     12,      0,      0,      6,      0, }, /* 412 */
  {     6,     12,      3,      0,      0,      6,      0, }, /* 413 */
  {     6,     10,      5,      0,      0,      6,      0, }, /* 414 */
  {     6,     21,     12,      0,      0,      6,      0, }, /* 415 */
  {    91,      7,     12,      0,      0,     91,      0, }, /* 416 */
  {    91,     10,      5,      0,      0,     91,      0, }, /* 417 */
  {    91,     12,      3,      0,      0,     91,      0, }, /* 418 */
  {    91,     10,     12,      0,      0,     91,      0, }, /* 419 */
  {    91,     13,     12,      0,      0,     91,      0, }, /* 420 */
  {    91,     21,     12,      0,      0,     91,      0, }, /* 421 */
  {    91,      6,     12,      0,      0,     91,      0, }, /* 422 */
  {    28,     11,      3,      0,      0,     28,      0, }, /* 423 */
  {    62,     12,      3,      0,      0,     62,      0, }, /* 424 */
  {    62,     10,      5,      0,      0,     62,      0, }, /* 425 */
  {    62,      7,     12,      0,      0,     62,      0, }, /* 426 */
  {    62,     13,     12,      0,      0,     62,      0, }, /* 427 */
  {    62,     21,     12,      0,      0,     62,      0, }, /* 428 */
  {    62,     26,     12,      0,      0,     62,      0, }, /* 429 */
  {    76,     12,      3,      0,      0,     76,      0, }, /* 430 */
  {    76,     10,      5,      0,      0,     76,      0, }, /* 431 */
  {    76,      7,     12,      0,      0,     76,      0, }, /* 432 */
  {    76,     13,     12,      0,      0,     76,      0, }, /* 433 */
  {    93,      7,     12,      0,      0,     93,      0, }, /* 434 */
  {    93,     12,      3,      0,      0,     93,      0, }, /* 435 */
  {    93,     10,      5,      0,      0,     93,      0, }, /* 436 */
  {    93,     21,     12,      0,      0,     93,      0, }, /* 437 */
  {    70,      7,     12,      0,      0,     70,      0, }, /* 438 */
  {    70,     10,      5,      0,      0,     70,      0, }, /* 439 */
  {    70,     12,      3,      0,      0,     70,      0, }, /* 440 */
  {    70,     21,     12,      0,      0,     70,      0, }, /* 441 */
  {    70,     13,     12,      0,      0,     70,      0, }, /* 442 */
  {    73,     13,     12,      0,      0,     73,      0, }, /* 443 */
  {    73,      7,     12,      0,      0,     73,      0, }, /* 444 */
  {    73,      6,     12,      0,      0,     73,      0, }, /* 445 */
  {    73,     21,     12,      0,      0,     73,      0, }, /* 446 */
  {    13,      5,     12,     63,  -6222,     13,      0, }, /* 447 */
  {    13,      5,     12,     67,  -6221,     13,      0, }, /* 448 */
  {    13,      5,     12,     71,  -6212,     13,      0, }, /* 449 */
  {    13,      5,     12,     75,  -6210,     13,      0, }, /* 450 */
  {    13,      5,     12,     79,  -6210,     13,      0, }, /* 451 */
  {    13,      5,     12,     79,  -6211,     13,      0, }, /* 452 */
  {    13,      5,     12,     84,  -6204,     13,      0, }, /* 453 */
  {    13,      5,     12,     88,  -6180,     13,      0, }, /* 454 */
  {    13,      5,     12,    108,  35267,     13,      0, }, /* 455 */
  {    17,      9,     12,      0,  -3008,     17,      0, }, /* 456 */
  {    76,     21,     12,      0,      0,     76,      0, }, /* 457 */
  {    28,     12,      3,      0,      0,   -101,      0, }, /* 458 */
  {    28,     12,      3,      0,      0,     15,      0, }, /* 459 */
  {    10,     21,     12,      0,      0,    -37,      0, }, /* 460 */
  {    28,     12,      3,      0,      0,    -16,      0, }, /* 461 */
  {    28,     12,      3,      0,      0,    -40,      0, }, /* 462 */
  {    28,     12,      3,      0,      0,   -129,      0, }, /* 463 */
  {    10,     10,      5,      0,      0,    -16,      0, }, /* 464 */
  {    10,      7,     12,      0,      0,     15,      0, }, /* 465 */
  {    10,      7,     12,      0,      0,    -16,      0, }, /* 466 */
  {    10,     10,      5,      0,      0,    -37,      0, }, /* 467 */
  {    28,     12,      3,      0,      0,    -80,      0, }, /* 468 */
  {    10,     10,      5,      0,      0,      3,      0, }, /* 469 */
  {    28,     12,      3,      0,      0,    -37,      0, }, /* 470 */
  {    13,      5,     12,      0,      0,     13,      0, }, /* 471 */
  {    13,      6,     12,      0,      0,     13,      0, }, /* 472 */
  {    34,      5,     12,      0,  35332,     34,      0, }, /* 473 */
  {    34,      5,     12,      0,   3814,     34,      0, }, /* 474 */
  {    34,      9,     12,     92,      1,     34,      0, }, /* 475 */
  {    34,      5,     12,     92,     -1,     34,      0, }, /* 476 */
  {    34,      5,     12,     92,    -58,     34,      0, }, /* 477 */
  {    34,      9,     12,      0,  -7615,     34,      0, }, /* 478 */
  {    20,      5,     12,      0,      8,     20,      0, }, /* 479 */
  {    20,      9,     12,      0,     -8,     20,      0, }, /* 480 */
  {    20,      5,     12,      0,     74,     20,      0, }, /* 481 */
  {    20,      5,     12,      0,     86,     20,      0, }, /* 482 */
  {    20,      5,     12,      0,    100,     20,      0, }, /* 483 */
  {    20,      5,     12,      0,    128,     20,      0, }, /* 484 */
  {    20,      5,     12,      0,    112,     20,      0, }, /* 485 */
  {    20,      5,     12,      0,    126,     20,      0, }, /* 486 */
  {    20,      8,     12,      0,     -8,     20,      0, }, /* 487 */
  {    20,      5,     12,      0,      9,     20,      0, }, /* 488 */
  {    20,      9,     12,      0,    -74,     20,      0, }, /* 489 */
  {    20,      8,     12,      0,     -9,     20,      0, }, /* 490 */
  {    20,      5,     12,     21,  -7173,     20,      0, }, /* 491 */
  {    20,      9,     12,      0,    -86,     20,      0, }, /* 492 */
  {    20,      9,     12,      0,   -100,     20,      0, }, /* 493 */
  {    20,      9,     12,      0,   -112,     20,      0, }, /* 494 */
  {    20,      9,     12,      0,   -128,     20,      0, }, /* 495 */
  {    20,      9,     12,      0,   -126,     20,      0, }, /* 496 */
  {    28,      1,      3,      0,      0,     28,      0, }, /* 497 */
  {    28,      1,     13,      0,      0,     28,      0, }, /* 498 */
  {    10,     27,      2,      0,      0,     10,      0, }, /* 499 */
  {    10,     28,      2,      0,      0,     10,      0, }, /* 500 */
  {    10,     21,     14,      0,      0,     10,      0, }, /* 501 */
  {     0,      2,      2,      0,      0,      0,      0, }, /* 502 */
  {    28,     12,      3,      0,      0,    -84,      0, }, /* 503 */
  {    10,      9,     12,      0,      0,     10,      0, }, /* 504 */
  {    10,      5,     12,      0,      0,     10,      0, }, /* 505 */
  {    20,      9,     12,     96,  -7517,     20,      0, }, /* 506 */
  {    34,      9,     12,    100,  -8383,     34,      0, }, /* 507 */
  {    34,      9,     12,    104,  -8262,     34,      0, }, /* 508 */
  {    34,      9,     12,      0,     28,     34,      0, }, /* 509 */
  {    10,      7,     12,      0,      0,     10,      0, }, /* 510 */
  {    10,      5,     14,      0,      0,     10,      0, }, /* 511 */
  {    34,      5,     12,      0,    -28,     34,      0, }, /* 512 */
  {    34,     14,     12,      0,     16,     34,      0, }, /* 513 */
  {    34,     14,     12,      0,    -16,     34,      0, }, /* 514 */
  {    34,     14,     12,      0,      0,     34,      0, }, /* 515 */
  {    10,     25,     14,      0,      0,     10,      0, }, /* 516 */
  {    10,     26,     12,      0,     26,     10,      0, }, /* 517 */
  {    10,     26,     14,      0,     26,     10,      0, }, /* 518 */
  {    10,     26,     12,      0,    -26,     10,      0, }, /* 519 */
  {     5,     26,     12,      0,      0,      5,      0, }, /* 520 */
  {    18,      9,     12,      0,     48,     18,      0, }, /* 521 */
  {    18,      5,     12,      0,    -48,     18,      0, }, /* 522 */
  {    34,      9,     12,      0, -10743,     34,      0, }, /* 523 */
  {    34,      9,     12,      0,  -3814,     34,      0, }, /* 524 */
  {    34,      9,     12,      0, -10727,     34,      0, }, /* 525 */
  {    34,      5,     12,      0, -10795,     34,      0, }, /* 526 */
  {    34,      5,     12,      0, -10792,     34,      0, }, /* 527 */
  {    34,      9,     12,      0, -10780,     34,      0, }, /* 528 */
  {    34,      9,     12,      0, -10749,     34,      0, }, /* 529 */
  {    34,      9,     12,      0, -10783,     34,      0, }, /* 530 */
  {    34,      9,     12,      0, -10782,     34,      0, }, /* 531 */
  {    34,      9,     12,      0, -10815,     34,      0, }, /* 532 */
  {    11,      5,     12,      0,      0,     11,      0, }, /* 533 */
  {    11,     26,     12,      0,      0,     11,      0, }, /* 534 */
  {    11,     12,      3,      0,      0,     11,      0, }, /* 535 */
  {    11,     21,     12,      0,      0,     11,      0, }, /* 536 */
  {    11,     15,     12,      0,      0,     11,      0, }, /* 537 */
  {    17,      5,     12,      0,  -7264,     17,      0, }, /* 538 */
  {    59,      7,     12,      0,      0,     59,      0, }, /* 539 */
  {    59,      6,     12,      0,      0,     59,      0, }, /* 540 */
  {    59,     21,     12,      0,      0,     59,      0, }, /* 541 */
  {    59,     12,      3,      0,      0,     59,      0, }, /* 542 */
  {    13,     12,      3,      0,      0,     13,      0, }, /* 543 */
  {    10,     21,     12,      0,      0,    -28,      0, }, /* 544 */
  {    23,     26,     12,      0,      0,     23,      0, }, /* 545 */
  {    10,     21,     12,      0,      0,   -122,      0, }, /* 546 */
  {    10,     21,     12,      0,      0,   -116,      0, }, /* 547 */
  {    23,      6,     12,      0,      0,     23,      0, }, /* 548 */
  {    10,      7,     12,      0,      0,     23,      0, }, /* 549 */
  {    23,     14,     12,      0,      0,     23,      0, }, /* 550 */
  {    10,     22,     12,      0,      0,   -122,      0, }, /* 551 */
  {    10,     18,     12,      0,      0,   -122,      0, }, /* 552 */
  {    10,     26,     12,      0,      0,   -116,      0, }, /* 553 */
  {    10,     17,     12,      0,      0,   -116,      0, }, /* 554 */
  {    10,     22,     12,      0,      0,   -116,      0, }, /* 555 */
  {    10,     18,     12,      0,      0,   -116,      0, }, /* 556 */
  {    28,     12,      3,      0,      0,    -19,      0, }, /* 557 */
  {    24,     10,      3,      0,      0,     24,      0, }, /* 558 */
  {    10,     17,     14,      0,      0,   -116,      0, }, /* 559 */
  {    10,      6,     12,      0,      0,    -58,      0, }, /* 560 */
  {    10,      7,     12,      0,      0,    -88,      0, }, /* 561 */
  {    10,     21,     14,      0,      0,    -88,      0, }, /* 562 */
  {    10,     26,     12,      0,      0,     23,      0, }, /* 563 */
  {    27,      7,     12,      0,      0,     27,      0, }, /* 564 */
  {    28,     12,      3,      0,      0,    -58,      0, }, /* 565 */
  {    10,     24,     12,      0,      0,    -58,      0, }, /* 566 */
  {    27,      6,     12,      0,      0,     27,      0, }, /* 567 */
  {    10,     17,     12,      0,      0,    -58,      0, }, /* 568 */
  {    30,      7,     12,      0,      0,     30,      0, }, /* 569 */
  {    30,      6,     12,      0,      0,     30,      0, }, /* 570 */
  {     4,      7,     12,      0,      0,      4,      0, }, /* 571 */
  {    24,      7,     12,      0,      0,     24,      0, }, /* 572 */
  {    10,     15,     12,      0,      0,     23,      0, }, /* 573 */
  {    24,     26,     12,      0,      0,     24,      0, }, /* 574 */
  {    10,     26,     14,      0,      0,     23,      0, }, /* 575 */
  {    30,     26,     12,      0,      0,     30,      0, }, /* 576 */
  {    23,      7,     12,      0,      0,     23,      0, }, /* 577 */
  {    61,      7,     12,      0,      0,     61,      0, }, /* 578 */
  {    61,      6,     12,      0,      0,     61,      0, }, /* 579 */
  {    61,     26,     12,      0,      0,     61,      0, }, /* 580 */
  {    86,      7,     12,      0,      0,     86,      0, }, /* 581 */
  {    86,      6,     12,      0,      0,     86,      0, }, /* 582 */
  {    86,     21,     12,      0,      0,     86,      0, }, /* 583 */
  {    77,      7,     12,      0,      0,     77,      0, }, /* 584 */
  {    77,      6,     12,      0,      0,     77,      0, }, /* 585 */
  {    77,     21,     12,      0,      0,     77,      0, }, /* 586 */
  {    77,     13,     12,      0,      0,     77,      0, }, /* 587 */
  {    13,      9,     12,    108,      1,     13,      0, }, /* 588 */
  {    13,      5,     12,    108, -35267,     13,      0, }, /* 589 */
  {    13,      7,     12,      0,      0,     13,      0, }, /* 590 */
  {    13,     21,     12,      0,      0,     13,      0, }, /* 591 */
  {    79,      7,     12,      0,      0,     79,      0, }, /* 592 */
  {    79,     14,     12,      0,      0,     79,      0, }, /* 593 */
  {    79,     12,      3,      0,      0,     79,      0, }, /* 594 */
  {    79,     21,     12,      0,      0,     79,      0, }, /* 595 */
  {    34,      9,     12,      0, -35332,     34,      0, }, /* 596 */
  {    34,      9,     12,      0, -42280,     34,      0, }, /* 597 */
  {    34,      9,     12,      0, -42308,     34,      0, }, /* 598 */
  {    34,      9,     12,      0, -42319,     34,      0, }, /* 599 */
  {    34,      9,     12,      0, -42315,     34,      0, }, /* 600 */
  {    34,      9,     12,      0, -42305,     34,      0, }, /* 601 */
  {    34,      9,     12,      0, -42258,     34,      0, }, /* 602 */
  {    34,      9,     12,      0, -42282,     34,      0, }, /* 603 */
  {    34,      9,     12,      0, -42261,     34,      0, }, /* 604 */
  {    34,      9,     12,      0,    928,     34,      0, }, /* 605 */
  {    49,      7,     12,      0,      0,     49,      0, }, /* 606 */
  {    49,     12,      3,      0,      0,     49,      0, }, /* 607 */
  {    49,     10,      5,      0,      0,     49,      0, }, /* 608 */
  {    49,     26,     12,      0,      0,     49,      0, }, /* 609 */
  {    10,     15,     12,      0,      0,   -197,      0, }, /* 610 */
  {    10,     15,     12,      0,      0,   -170,      0, }, /* 611 */
  {    10,     26,     12,      0,      0,   -145,      0, }, /* 612 */
  {    10,     23,     12,      0,      0,   -145,      0, }, /* 613 */
  {    65,      7,     12,      0,      0,     65,      0, }, /* 614 */
  {    65,     21,     12,      0,      0,     65,      0, }, /* 615 */
  {    75,     10,      5,      0,      0,     75,      0, }, /* 616 */
  {    75,      7,     12,      0,      0,     75,      0, }, /* 617 */
  {    75,     12,      3,      0,      0,     75,      0, }, /* 618 */
  {    75,     21,     12,      0,      0,     75,      0, }, /* 619 */
  {    75,     13,     12,      0,      0,     75,      0, }, /* 620 */
  {    15,     12,      3,      0,      0,    -16,      0, }, /* 621 */
  {    15,      7,     12,      0,      0,    -43,      0, }, /* 622 */
  {    69,     13,     12,      0,      0,     69,      0, }, /* 623 */
  {    69,      7,     12,      0,      0,     69,      0, }, /* 624 */
  {    69,     12,      3,      0,      0,     69,      0, }, /* 625 */
  {    10,     21,     12,      0,      0,    -92,      0, }, /* 626 */
  {    69,     21,     12,      0,      0,     69,      0, }, /* 627 */
  {    74,      7,     12,      0,      0,     74,      0, }, /* 628 */
  {    74,     12,      3,      0,      0,     74,      0, }, /* 629 */
  {    74,     10,      5,      0,      0,     74,      0, }, /* 630 */
  {    74,     21,     12,      0,      0,     74,      0, }, /* 631 */
  {    84,     12,      3,      0,      0,     84,      0, }, /* 632 */
  {    84,     10,      5,      0,      0,     84,      0, }, /* 633 */
  {    84,      7,     12,      0,      0,     84,      0, }, /* 634 */
  {    84,     21,     12,      0,      0,     84,      0, }, /* 635 */
  {    10,      6,     12,      0,      0,    -22,      0, }, /* 636 */
  {    84,     13,     12,      0,      0,     84,      0, }, /* 637 */
  {    39,      6,     12,      0,      0,     39,      0, }, /* 638 */
  {    68,      7,     12,      0,      0,     68,      0, }, /* 639 */
  {    68,     12,      3,      0,      0,     68,      0, }, /* 640 */
  {    68,     10,      5,      0,      0,     68,      0, }, /* 641 */
  {    68,     13,     12,      0,      0,     68,      0, }, /* 642 */
  {    68,     21,     12,      0,      0,     68,      0, }, /* 643 */
  {    92,      7,     12,      0,      0,     92,      0, }, /* 644 */
  {    92,     12,      3,      0,      0,     92,      0, }, /* 645 */
  {    92,      6,     12,      0,      0,     92,      0, }, /* 646 */
  {    92,     21,     12,      0,      0,     92,      0, }, /* 647 */
  {    87,      7,     12,      0,      0,     87,      0, }, /* 648 */
  {    87,     10,      5,      0,      0,     87,      0, }, /* 649 */
  {    87,     12,      3,      0,      0,     87,      0, }, /* 650 */
  {    87,     21,     12,      0,      0,     87,      0, }, /* 651 */
  {    87,      6,     12,      0,      0,     87,      0, }, /* 652 */
  {    34,      5,     12,      0,   -928,     34,      0, }, /* 653 */
  {     9,      5,     12,      0, -38864,      9,      0, }, /* 654 */
  {    87,     13,     12,      0,      0,     87,      0, }, /* 655 */
  {    24,      7,      9,      0,      0,     24,      0, }, /* 656 */
  {    24,      7,     10,      0,      0,     24,      0, }, /* 657 */
  {     0,      4,      2,      0,      0,      0,      0, }, /* 658 */
  {     0,      3,     12,      0,      0,      0,      0, }, /* 659 */
  {    26,     25,     12,      0,      0,     26,      0, }, /* 660 */
  {     1,     24,     12,      0,      0,      1,      0, }, /* 661 */
  {     1,      7,     12,      0,      0,    -10,      0, }, /* 662 */
  {     1,     26,     12,      0,      0,    -10,      0, }, /* 663 */
  {    10,      6,      3,      0,      0,    -58,      0, }, /* 664 */
  {    36,      7,     12,      0,      0,     36,      0, }, /* 665 */
  {    10,     21,     12,      0,      0,    -25,      0, }, /* 666 */
  {    10,     15,     12,      0,      0,    -76,      0, }, /* 667 */
  {    10,     26,     12,      0,      0,    -25,      0, }, /* 668 */
  {    20,     14,     12,      0,      0,     20,      0, }, /* 669 */
  {    20,     15,     12,      0,      0,     20,      0, }, /* 670 */
  {    20,     26,     12,      0,      0,     20,      0, }, /* 671 */
  {    71,      7,     12,      0,      0,     71,      0, }, /* 672 */
  {    67,      7,     12,      0,      0,     67,      0, }, /* 673 */
  {    28,     12,      3,      0,      0,     -1,      0, }, /* 674 */
  {    10,     15,     12,      0,      0,     -1,      0, }, /* 675 */
  {    42,      7,     12,      0,      0,     42,      0, }, /* 676 */
  {    42,     15,     12,      0,      0,     42,      0, }, /* 677 */
  {    19,      7,     12,      0,      0,     19,      0, }, /* 678 */
  {    19,     14,     12,      0,      0,     19,      0, }, /* 679 */
  {   118,      7,     12,      0,      0,    118,      0, }, /* 680 */
  {   118,     12,      3,      0,      0,    118,      0, }, /* 681 */
  {    60,      7,     12,      0,      0,     60,      0, }, /* 682 */
  {    60,     21,     12,      0,      0,     60,      0, }, /* 683 */
  {    43,      7,     12,      0,      0,     43,      0, }, /* 684 */
  {    43,     21,     12,      0,      0,     43,      0, }, /* 685 */
  {    43,     14,     12,      0,      0,     43,      0, }, /* 686 */
  {    14,      9,     12,      0,     40,     14,      0, }, /* 687 */
  {    14,      5,     12,      0,    -40,     14,      0, }, /* 688 */
  {    47,      7,     12,      0,      0,     47,      0, }, /* 689 */
  {    45,      7,     12,      0,      0,     45,      0, }, /* 690 */
  {    45,     13,     12,      0,      0,     45,      0, }, /* 691 */
  {   136,      9,     12,      0,     40,    136,      0, }, /* 692 */
  {   136,      5,     12,      0,    -40,    136,      0, }, /* 693 */
  {   106,      7,     12,      0,      0,    106,      0, }, /* 694 */
  {   104,      7,     12,      0,      0,    104,      0, }, /* 695 */
  {   104,     21,     12,      0,      0,    104,      0, }, /* 696 */
  {   110,      7,     12,      0,      0,    110,      0, }, /* 697 */
  {    12,      7,     12,      0,      0,     12,      0, }, /* 698 */
  {    81,      7,     12,      0,      0,     81,      0, }, /* 699 */
  {    81,     21,     12,      0,      0,     81,      0, }, /* 700 */
  {    81,     15,     12,      0,      0,     81,      0, }, /* 701 */
  {   120,      7,     12,      0,      0,    120,      0, }, /* 702 */
  {   120,     26,     12,      0,      0,    120,      0, }, /* 703 */
  {   120,     15,     12,      0,      0,    120,      0, }, /* 704 */
  {   116,      7,     12,      0,      0,    116,      0, }, /* 705 */
  {   116,     15,     12,      0,      0,    116,      0, }, /* 706 */
  {   128,      7,     12,      0,      0,    128,      0, }, /* 707 */
  {   128,     15,     12,      0,      0,    128,      0, }, /* 708 */
  {    66,      7,     12,      0,      0,     66,      0, }, /* 709 */
  {    66,     15,     12,      0,      0,     66,      0, }, /* 710 */
  {    66,     21,     12,      0,      0,     66,      0, }, /* 711 */
  {    72,      7,     12,      0,      0,     72,      0, }, /* 712 */
  {    72,     21,     12,      0,      0,     72,      0, }, /* 713 */
  {    98,      7,     12,      0,      0,     98,      0, }, /* 714 */
  {    97,      7,     12,      0,      0,     97,      0, }, /* 715 */
  {    97,     15,     12,      0,      0,     97,      0, }, /* 716 */
  {    31,      7,     12,      0,      0,     31,      0, }, /* 717 */
  {    31,     12,      3,      0,      0,     31,      0, }, /* 718 */
  {    31,     15,     12,      0,      0,     31,      0, }, /* 719 */
  {    31,     21,     12,      0,      0,     31,      0, }, /* 720 */
  {    88,      7,     12,      0,      0,     88,      0, }, /* 721 */
  {    88,     15,     12,      0,      0,     88,      0, }, /* 722 */
  {    88,     21,     12,      0,      0,     88,      0, }, /* 723 */
  {   117,      7,     12,      0,      0,    117,      0, }, /* 724 */
  {   117,     15,     12,      0,      0,    117,      0, }, /* 725 */
  {   112,      7,     12,      0,      0,    112,      0, }, /* 726 */
  {   112,     26,     12,      0,      0,    112,      0, }, /* 727 */
  {   112,     12,      3,      0,      0,    112,      0, }, /* 728 */
  {   112,     15,     12,      0,      0,    112,      0, }, /* 729 */
  {   112,     21,     12,      0,      0,    112,      0, }, /* 730 */
  {    78,      7,     12,      0,      0,     78,      0, }, /* 731 */
  {    78,     21,     12,      0,      0,     78,      0, }, /* 732 */
  {    83,      7,     12,      0,      0,     83,      0, }, /* 733 */
  {    83,     15,     12,      0,      0,     83,      0, }, /* 734 */
  {    82,      7,     12,      0,      0,     82,      0, }, /* 735 */
  {    82,     15,     12,      0,      0,     82,      0, }, /* 736 */
  {   121,      7,     12,      0,      0,    121,      0, }, /* 737 */
  {   121,     21,     12,      0,      0,    121,      0, }, /* 738 */
  {   121,     15,     12,      0,      0,    121,      0, }, /* 739 */
  {    89,      7,     12,      0,      0,     89,      0, }, /* 740 */
  {   130,      9,     12,      0,     64,    130,      0, }, /* 741 */
  {   130,      5,     12,      0,    -64,    130,      0, }, /* 742 */
  {   130,     15,     12,      0,      0,    130,      0, }, /* 743 */
  {   144,      7,     12,      0,      0,    144,      0, }, /* 744 */
  {   144,     12,      3,      0,      0,    144,      0, }, /* 745 */
  {   144,     13,     12,      0,      0,    144,      0, }, /* 746 */
  {     1,     15,     12,      0,      0,      1,      0, }, /* 747 */
  {   147,      7,     12,      0,      0,    147,      0, }, /* 748 */
  {   147,     15,     12,      0,      0,    147,      0, }, /* 749 */
  {   148,      7,     12,      0,      0,    148,      0, }, /* 750 */
  {   148,     12,      3,      0,      0,    148,      0, }, /* 751 */
  {   148,     15,     12,      0,      0,    148,      0, }, /* 752 */
  {   148,     21,     12,      0,      0,    148,      0, }, /* 753 */
  {    94,     10,      5,      0,      0,     94,      0, }, /* 754 */
  {    94,     12,      3,      0,      0,     94,      0, }, /* 755 */
  {    94,      7,     12,      0,      0,     94,      0, }, /* 756 */
  {    94,     21,     12,      0,      0,     94,      0, }, /* 757 */
  {    94,     15,     12,      0,      0,     94,      0, }, /* 758 */
  {    94,     13,     12,      0,      0,     94,      0, }, /* 759 */
  {    85,     12,      3,      0,      0,     85,      0, }, /* 760 */
  {    85,     10,      5,      0,      0,     85,      0, }, /* 761 */
  {    85,      7,     12,      0,      0,     85,      0, }, /* 762 */
  {    85,     21,     12,      0,      0,     85,      0, }, /* 763 */
  {    85,      1,      4,      0,      0,     85,      0, }, /* 764 */
  {   101,      7,     12,      0,      0,    101,      0, }, /* 765 */
  {   101,     13,     12,      0,      0,    101,      0, }, /* 766 */
  {    96,     12,      3,      0,      0,     96,      0, }, /* 767 */
  {    96,      7,     12,      0,      0,     96,      0, }, /* 768 */
  {    96,     10,      5,      0,      0,     96,      0, }, /* 769 */
  {    96,     13,     12,      0,      0,     96,      0, }, /* 770 */
  {    96,     21,     12,      0,      0,     96,      0, }, /* 771 */
  {   111,      7,     12,      0,      0,    111,      0, }, /* 772 */
  {   111,     12,      3,      0,      0,    111,      0, }, /* 773 */
  {   111,     21,     12,      0,      0,    111,      0, }, /* 774 */
  {   100,     12,      3,      0,      0,    100,      0, }, /* 775 */
  {   100,     10,      5,      0,      0,    100,      0, }, /* 776 */
  {   100,      7,     12,      0,      0,    100,      0, }, /* 777 */
  {   100,      7,      4,      0,      0,    100,      0, }, /* 778 */
  {   100,     21,     12,      0,      0,    100,      0, }, /* 779 */
  {   100,     13,     12,      0,      0,    100,      0, }, /* 780 */
  {    48,     15,     12,      0,      0,     48,      0, }, /* 781 */
  {   108,      7,     12,      0,      0,    108,      0, }, /* 782 */
  {   108,     10,      5,      0,      0,    108,      0, }, /* 783 */
  {   108,     12,      3,      0,      0,    108,      0, }, /* 784 */
  {   108,     21,     12,      0,      0,    108,      0, }, /* 785 */
  {   129,      7,     12,      0,      0,    129,      0, }, /* 786 */
  {   129,     21,     12,      0,      0,    129,      0, }, /* 787 */
  {   109,      7,     12,      0,      0,    109,      0, }, /* 788 */
  {   109,     12,      3,      0,      0,    109,      0, }, /* 789 */
  {   109,     10,      5,      0,      0,    109,      0, }, /* 790 */
  {   109,     13,     12,      0,      0,    109,      0, }, /* 791 */
  {   107,     12,      3,      0,      0,    107,      0, }, /* 792 */
  {   107,     12,      3,      0,      0,    -49,      0, }, /* 793 */
  {   107,     10,      5,      0,      0,    107,      0, }, /* 794 */
  {   107,     10,      5,      0,      0,    -49,      0, }, /* 795 */
  {   107,      7,     12,      0,      0,    107,      0, }, /* 796 */
  {    28,     12,      3,      0,      0,    -49,      0, }, /* 797 */
  {   107,     10,      3,      0,      0,    107,      0, }, /* 798 */
  {   135,      7,     12,      0,      0,    135,      0, }, /* 799 */
  {   135,     10,      5,      0,      0,    135,      0, }, /* 800 */
  {   135,     12,      3,      0,      0,    135,      0, }, /* 801 */
  {   135,     21,     12,      0,      0,    135,      0, }, /* 802 */
  {   135,     13,     12,      0,      0,    135,      0, }, /* 803 */
  {   124,      7,     12,      0,      0,    124,      0, }, /* 804 */
  {   124,     10,      3,      0,      0,    124,      0, }, /* 805 */
  {   124,     10,      5,      0,      0,    124,      0, }, /* 806 */
  {   124,     12,      3,      0,      0,    124,      0, }, /* 807 */
  {   124,     21,     12,      0,      0,    124,      0, }, /* 808 */
  {   124,     13,     12,      0,      0,    124,      0, }, /* 809 */
  {   123,      7,     12,      0,      0,    123,      0, }, /* 810 */
  {   123,     10,      3,      0,      0,    123,      0, }, /* 811 */
  {   123,     10,      5,      0,      0,    123,      0, }, /* 812 */
  {   123,     12,      3,      0,      0,    123,      0, }, /* 813 */
  {   123,     21,     12,      0,      0,    123,      0, }, /* 814 */
  {   114,      7,     12,      0,      0,    114,      0, }, /* 815 */
  {   114,     10,      5,      0,      0,    114,      0, }, /* 816 */
  {   114,     12,      3,      0,      0,    114,      0, }, /* 817 */
  {   114,     21,     12,      0,      0,    114,      0, }, /* 818 */
  {   114,     13,     12,      0,      0,    114,      0, }, /* 819 */
  {   102,      7,     12,      0,      0,    102,      0, }, /* 820 */
  {   102,     12,      3,      0,      0,    102,      0, }, /* 821 */
  {   102,     10,      5,      0,      0,    102,      0, }, /* 822 */
  {   102,     13,     12,      0,      0,    102,      0, }, /* 823 */
  {   126,      7,     12,      0,      0,    126,      0, }, /* 824 */
  {   126,     12,      3,      0,      0,    126,      0, }, /* 825 */
  {   126,     10,      5,      0,      0,    126,      0, }, /* 826 */
  {   126,     13,     12,      0,      0,    126,      0, }, /* 827 */
  {   126,     15,     12,      0,      0,    126,      0, }, /* 828 */
  {   126,     21,     12,      0,      0,    126,      0, }, /* 829 */
  {   126,     26,     12,      0,      0,    126,      0, }, /* 830 */
  {   142,      7,     12,      0,      0,    142,      0, }, /* 831 */
  {   142,     10,      5,      0,      0,    142,      0, }, /* 832 */
  {   142,     12,      3,      0,      0,    142,      0, }, /* 833 */
  {   142,     21,     12,      0,      0,    142,      0, }, /* 834 */
  {   125,      9,     12,      0,     32,    125,      0, }, /* 835 */
  {   125,      5,     12,      0,    -32,    125,      0, }, /* 836 */
  {   125,     13,     12,      0,      0,    125,      0, }, /* 837 */
  {   125,     15,     12,      0,      0,    125,      0, }, /* 838 */
  {   125,      7,     12,      0,      0,    125,      0, }, /* 839 */
  {   141,      7,     12,      0,      0,    141,      0, }, /* 840 */
  {   141,     12,      3,      0,      0,    141,      0, }, /* 841 */
  {   141,     10,      5,      0,      0,    141,      0, }, /* 842 */
  {   141,      7,      4,      0,      0,    141,      0, }, /* 843 */
  {   141,     21,     12,      0,      0,    141,      0, }, /* 844 */
  {   140,      7,     12,      0,      0,    140,      0, }, /* 845 */
  {   140,     12,      3,      0,      0,    140,      0, }, /* 846 */
  {   140,     10,      5,      0,      0,    140,      0, }, /* 847 */
  {   140,      7,      4,      0,      0,    140,      0, }, /* 848 */
  {   140,     21,     12,      0,      0,    140,      0, }, /* 849 */
  {   122,      7,     12,      0,      0,    122,      0, }, /* 850 */
  {   133,      7,     12,      0,      0,    133,      0, }, /* 851 */
  {   133,     10,      5,      0,      0,    133,      0, }, /* 852 */
  {   133,     12,      3,      0,      0,    133,      0, }, /* 853 */
  {   133,     21,     12,      0,      0,    133,      0, }, /* 854 */
  {   133,     13,     12,      0,      0,    133,      0, }, /* 855 */
  {   133,     15,     12,      0,      0,    133,      0, }, /* 856 */
  {   134,     21,     12,      0,      0,    134,      0, }, /* 857 */
  {   134,      7,     12,      0,      0,    134,      0, }, /* 858 */
  {   134,     12,      3,      0,      0,    134,      0, }, /* 859 */
  {   134,     10,      5,      0,      0,    134,      0, }, /* 860 */
  {   138,      7,     12,      0,      0,    138,      0, }, /* 861 */
  {   138,     12,      3,      0,      0,    138,      0, }, /* 862 */
  {   138,      7,      4,      0,      0,    138,      0, }, /* 863 */
  {   138,     13,     12,      0,      0,    138,      0, }, /* 864 */
  {   143,      7,     12,      0,      0,    143,      0, }, /* 865 */
  {   143,     10,      5,      0,      0,    143,      0, }, /* 866 */
  {   143,     12,      3,      0,      0,    143,      0, }, /* 867 */
  {   143,     13,     12,      0,      0,    143,      0, }, /* 868 */
  {   145,      7,     12,      0,      0,    145,      0, }, /* 869 */
  {   145,     12,      3,      0,      0,    145,      0, }, /* 870 */
  {   145,     10,      5,      0,      0,    145,      0, }, /* 871 */
  {   145,     21,     12,      0,      0,    145,      0, }, /* 872 */
  {    63,      7,     12,      0,      0,     63,      0, }, /* 873 */
  {    63,     14,     12,      0,      0,     63,      0, }, /* 874 */
  {    63,     21,     12,      0,      0,     63,      0, }, /* 875 */
  {    80,      7,     12,      0,      0,     80,      0, }, /* 876 */
  {   127,      7,     12,      0,      0,    127,      0, }, /* 877 */
  {   115,      7,     12,      0,      0,    115,      0, }, /* 878 */
  {   115,     13,     12,      0,      0,    115,      0, }, /* 879 */
  {   115,     21,     12,      0,      0,    115,      0, }, /* 880 */
  {   103,      7,     12,      0,      0,    103,      0, }, /* 881 */
  {   103,     12,      3,      0,      0,    103,      0, }, /* 882 */
  {   103,     21,     12,      0,      0,    103,      0, }, /* 883 */
  {   119,      7,     12,      0,      0,    119,      0, }, /* 884 */
  {   119,     12,      3,      0,      0,    119,      0, }, /* 885 */
  {   119,     21,     12,      0,      0,    119,      0, }, /* 886 */
  {   119,     26,     12,      0,      0,    119,      0, }, /* 887 */
  {   119,      6,     12,      0,      0,    119,      0, }, /* 888 */
  {   119,     13,     12,      0,      0,    119,      0, }, /* 889 */
  {   119,     15,     12,      0,      0,    119,      0, }, /* 890 */
  {   146,      9,     12,      0,     32,    146,      0, }, /* 891 */
  {   146,      5,     12,      0,    -32,    146,      0, }, /* 892 */
  {   146,     15,     12,      0,      0,    146,      0, }, /* 893 */
  {   146,     21,     12,      0,      0,    146,      0, }, /* 894 */
  {    99,      7,     12,      0,      0,     99,      0, }, /* 895 */
  {    99,     10,      5,      0,      0,     99,      0, }, /* 896 */
  {    99,     12,      3,      0,      0,     99,      0, }, /* 897 */
  {    99,      6,     12,      0,      0,     99,      0, }, /* 898 */
  {   137,      6,     12,      0,      0,    137,      0, }, /* 899 */
  {   139,      6,     12,      0,      0,    139,      0, }, /* 900 */
  {   137,      7,     12,      0,      0,    137,      0, }, /* 901 */
  {   139,      7,     12,      0,      0,    139,      0, }, /* 902 */
  {   105,      7,     12,      0,      0,    105,      0, }, /* 903 */
  {   105,     26,     12,      0,      0,    105,      0, }, /* 904 */
  {   105,     12,      3,      0,      0,    105,      0, }, /* 905 */
  {   105,     21,     12,      0,      0,    105,      0, }, /* 906 */
  {    10,      1,      2,      0,      0,    105,      0, }, /* 907 */
  {    10,     10,      3,      0,      0,     10,      0, }, /* 908 */
  {    10,     10,      5,      0,      0,     10,      0, }, /* 909 */
  {    20,     12,      3,      0,      0,     20,      0, }, /* 910 */
  {   131,     26,     12,      0,      0,    131,      0, }, /* 911 */
  {   131,     12,      3,      0,      0,    131,      0, }, /* 912 */
  {   131,     21,     12,      0,      0,    131,      0, }, /* 913 */
  {    18,     12,      3,      0,      0,     18,      0, }, /* 914 */
  {   113,      7,     12,      0,      0,    113,      0, }, /* 915 */
  {   113,     15,     12,      0,      0,    113,      0, }, /* 916 */
  {   113,     12,      3,      0,      0,    113,      0, }, /* 917 */
  {   132,      9,     12,      0,     34,    132,      0, }, /* 918 */
  {   132,      5,     12,      0,    -34,    132,      0, }, /* 919 */
  {   132,     12,      3,      0,      0,    132,      0, }, /* 920 */
  {   132,     13,     12,      0,      0,    132,      0, }, /* 921 */
  {   132,     21,     12,      0,      0,    132,      0, }, /* 922 */
  {     0,      2,     14,      0,      0,      0,      0, }, /* 923 */
  {    10,     26,     11,      0,      0,     10,      0, }, /* 924 */
  {    27,     26,     12,      0,      0,     27,      0, }, /* 925 */
  {    10,     24,      3,      0,      0,     10,      0, }, /* 926 */
  {    10,      1,      3,      0,      0,     10,      0, }, /* 927 */
};

const uint16_t PRIV(ucd_stage1)[] = { /* 17408 bytes */
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, /* U+0000 */
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, /* U+0800 */
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 41, 41, 42, 43, 44, 45, /* U+1000 */
 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, /* U+1800 */
 62, 63, 64, 65, 66, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, /* U+2000 */
 77, 77, 78, 79, 66, 66, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, /* U+2800 */
 90, 91, 92, 93, 94, 95, 96, 97, 98, 98, 98, 98, 98, 98, 98, 98, /* U+3000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+3800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+4000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 98, 98, 98, 98, /* U+4800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+5000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+5800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+6000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+6800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+7000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+7800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+8000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+8800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+9000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,100, /* U+9800 */
101,102,102,102,102,102,102,102,102,103,104,104,105,106,107,108, /* U+A000 */
109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,117, /* U+A800 */
118,119,120,121,122,123,117,118,119,120,121,122,123,117,118,119, /* U+B000 */
120,121,122,123,117,118,119,120,121,122,123,117,118,119,120,121, /* U+B800 */
122,123,117,118,119,120,121,122,123,117,118,119,120,121,122,123, /* U+C000 */
117,118,119,120,121,122,123,117,118,119,120,121,122,123,117,118, /* U+C800 */
119,120,121,122,123,117,118,119,120,121,122,123,117,118,119,124, /* U+D000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+D800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+E000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+E800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F000 */
126,126, 98, 98,127,128,129,130,131,131,132,133,134,135,136,137, /* U+F800 */
138,139,140,141,142,143,144,145,146,147,148,142,149,149,150,142, /* U+10000 */
151,152,153,154,155,156,157,158,159,160,161,142,162,142,163,142, /* U+10800 */
164,165,166,167,168,169,170,142,171,172,142,173,174,175,176,142, /* U+11000 */
177,178,142,142,179,180,142,142,181,182,183,184,142,185,142,142, /* U+11800 */
186,186,186,186,186,186,186,187,188,186,189,142,142,142,142,142, /* U+12000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+12800 */
190,190,190,190,190,190,190,190,191,142,142,142,142,142,142,142, /* U+13000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+13800 */
142,142,142,142,142,142,142,142,192,192,192,192,193,142,142,142, /* U+14000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+14800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+15000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+15800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+16000 */
194,194,194,194,195,196,197,198,142,142,142,142,199,200,201,202, /* U+16800 */
203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,203, /* U+17000 */
203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,203, /* U+17800 */
203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,204, /* U+18000 */
203,203,203,203,203,205,142,142,142,142,142,142,142,142,142,142, /* U+18800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+19000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+19800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1A800 */
206,207,208,209,209,210,142,142,142,142,142,142,142,142,142,142, /* U+1B000 */
142,142,142,142,142,142,142,142,211,212,142,142,142,142,142,142, /* U+1B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1C800 */
 71,213,214,215,216,217,218,142,219,220,221,222,223,224,225,226, /* U+1D000 */
227,227,227,227,228,229,142,142,142,142,142,142,142,142,142,142, /* U+1D800 */
230,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1E000 */
231,232,233,142,142,142,142,142,234,235,142,142,236,237,142,142, /* U+1E800 */
238,239,240,241,242,243,244,245,244,244,246,244,247,248,249,250, /* U+1F000 */
251,252,253,254,255,243,243,243,243,243,243,243,243,243,243,256, /* U+1F800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+20000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+20800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+21000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+21800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+22000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+22800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+23000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+23800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+24000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+24800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+25000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+25800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+26000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+26800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+27000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+27800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+28000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+28800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+29000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+29800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,257, 98, 98, /* U+2A000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2A800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,258, 98, /* U+2B000 */
259, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2B800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2C000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,260, 98, 98, /* U+2C800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2D000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2D800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2E000 */
 98, 98, 98, 98, 98, 98, 98,261,142,142,142,142,142,142,142,142, /* U+2E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+2F000 */
 98, 98, 98, 98,262,142,142,142,142,142,142,142,142,142,142,142, /* U+2F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+30000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+30800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+31000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+31800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+32000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+32800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+33000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+33800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+34000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+34800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+35000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+35800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+36000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+36800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+37000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+37800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+38000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+38800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+39000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+39800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+40000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+40800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+41000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+41800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+42000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+42800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+43000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+43800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+44000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+44800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+45000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+45800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+46000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+46800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+47000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+47800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+48000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+48800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+49000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+49800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+50000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+50800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+51000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+51800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+52000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+52800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+53000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+53800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+54000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+54800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+55000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+55800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+56000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+56800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+57000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+57800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+58000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+58800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+59000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+59800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+60000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+60800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+61000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+61800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+62000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+62800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+63000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+63800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+64000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+64800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+65000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+65800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+66000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+66800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+67000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+67800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+68000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+68800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+69000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+69800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+70000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+70800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+71000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+71800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+72000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+72800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+73000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+73800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+74000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+74800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+75000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+75800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+76000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+76800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+77000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+77800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+78000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+78800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+79000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+79800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+80000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+80800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+81000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+81800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+82000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+82800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+83000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+83800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+84000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+84800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+85000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+85800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+86000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+86800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+87000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+87800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+88000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+88800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+89000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+89800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+90000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+90800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+91000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+91800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+92000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+92800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+93000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+93800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+94000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+94800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+95000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+95800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+96000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+96800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+97000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+97800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+98000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+98800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+99000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+99800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AF800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BF800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CF800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DF800 */
263,264,265,266,264,264,264,264,264,264,264,264,264,264,264,264, /* U+E0000 */
264,264,264,264,264,264,264,264,264,264,264,264,264,264,264,264, /* U+E0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+ED000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+ED800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EF800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F0000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F0800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F1000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F1800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F2000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F2800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F3000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F3800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F4000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F4800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F5000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F5800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F6000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F6800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F7000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F7800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F8000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F8800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F9000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F9800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FA000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FA800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FB000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FB800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FC000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FC800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FD000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FD800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FE000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FE800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FF000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,267, /* U+FF800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+100000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+100800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+101000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+101800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+102000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+102800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+103000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+103800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+104000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+104800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+105000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+105800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+106000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+106800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+107000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+107800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+108000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+108800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+109000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+109800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10A000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10A800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10B000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10B800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10C000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10C800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10D000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10D800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10E000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10E800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10F000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,267, /* U+10F800 */
};

const uint16_t PRIV(ucd_stage2)[] = { /* 68608 bytes, block = 128 */
/* block 0 */
  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  1,  1,  3,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  4,  5,  5,  5,  6,  5,  5,  5,  7,  8,  5,  9,  5, 10,  5,  5,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  5,  5,  9,  9,  9,  5,
  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12,
 12, 12, 12, 14, 12, 12, 12, 12, 12, 12, 12,  7,  5,  8, 15, 16,
 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17, 17, 17, 17,
 17, 17, 17, 19, 17, 17, 17, 17, 17, 17, 17,  7,  9,  8,  9,  1,

/* block 1 */
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  4,  5,  6,  6,  6,  6, 20,  5, 15, 21, 22, 23,  9, 24, 21, 15,
 20,  9, 25, 25, 15, 26,  5,  5, 15, 25, 22, 27, 25, 25, 25,  5,
 12, 12, 12, 12, 12, 28, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12,  9, 12, 12, 12, 12, 12, 12, 12, 29,
 17, 17, 17, 17, 17, 30, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17,  9, 17, 17, 17, 17, 17, 17, 17, 31,

/* block 2 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 34, 35, 32, 33, 32, 33, 32, 33, 35, 32, 33, 32, 33, 32, 33, 32,
 33, 32, 33, 32, 33, 32, 33, 32, 33, 35, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 36, 32, 33, 32, 33, 32, 33, 37,

/* block 3 */
 38, 39, 32, 33, 32, 33, 40, 32, 33, 41, 41, 32, 33, 35, 42, 43,
 44, 32, 33, 41, 45, 46, 47, 48, 32, 33, 49, 35, 47, 50, 51, 52,
 32, 33, 32, 33, 32, 33, 53, 32, 33, 53, 35, 35, 32, 33, 53, 32,
 33, 54, 54, 32, 33, 32, 33, 55, 32, 33, 35, 22, 32, 33, 35, 56,
 22, 22, 22, 22, 57, 58, 59, 60, 61, 62, 63, 64, 65, 32, 33, 32,
 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 66, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 35, 67, 68, 69, 32, 33, 70, 71, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 4 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 72, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 35, 35, 35, 35, 35, 35, 73, 32, 33, 74, 75, 76,
 76, 32, 33, 77, 78, 79, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 80, 81, 82, 83, 84, 35, 85, 85, 35, 86, 35, 87, 88, 35, 35, 35,
 85, 89, 35, 90, 35, 91, 92, 35, 93, 94, 92, 95, 96, 35, 35, 94,
 35, 97, 98, 35, 35, 99, 35, 35, 35, 35, 35, 35, 35,100, 35, 35,

/* block 5 */
101, 35, 35,101, 35, 35, 35,102,101,103,104,104,105, 35, 35, 35,
 35, 35,106, 35, 22, 35, 35, 35, 35, 35, 35, 35, 35,107,108, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
109,109,109,109,109,109,109,109,109,110,110,110,110,110,110,110,
110,110, 15, 15, 15, 15,110,110,110,110,110,110,110,110,110,110,
110,110, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
109,109,109,109,109, 15, 15, 15, 15, 15,111,111,110, 15,110, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,

/* block 6 */
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,113,112,112,114,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,115,115,115,115,115,115,115,115,115,115,115,115,115,
116,117,116,117,110,118,116,117,119,119,120,121,121,121,  5,122,

/* block 7 */
119,119,119,119,118, 15,123,  5,124,124,124,119,125,119,126,126,
127,128,129,128,128,130,128,128,131,132,133,128,134,128,128,128,
135,136,119,137,128,128,138,128,128,139,128,128,140,141,141,141,
127,142,143,142,142,144,142,142,145,146,147,142,148,142,142,142,
149,150,151,152,142,142,153,142,142,154,142,142,155,156,156,157,
158,159,160,160,160,161,162,163,116,117,116,117,116,117,116,117,
116,117,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
166,167,168,169,170,171,172,116,117,173,116,117,127,174,174,174,

/* block 8 */
175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,
176,176,177,176,178,176,176,176,176,176,176,176,176,176,179,176,
176,180,181,176,176,176,176,176,176,176,182,176,176,176,176,176,
183,183,184,183,185,183,183,183,183,183,183,183,183,183,186,183,
183,187,188,183,183,183,183,183,183,183,189,183,183,183,183,183,
190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,
191,192,193,194,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,

/* block 9 */
191,192,195,196,197,198,198,197,199,199,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
200,191,192,191,192,191,192,191,192,191,192,191,192,191,192,201,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,

/* block 10 */
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
119,202,202,202,202,202,202,202,202,202,202,202,202,202,202,202,
202,202,202,202,202,202,202,202,202,202,202,202,202,202,202,202,
202,202,202,202,202,202,202,119,119,203,204,204,204,204,204,204,
205,206,206,206,206,206,206,206,206,206,206,206,206,206,206,206,
206,206,206,206,206,206,206,206,206,206,206,206,206,206,206,206,

/* block 11 */
206,206,206,206,206,206,206,205,205,207,208,119,119,209,209,210,
119,211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,
211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,
211,211,211,211,211,211,211,211,211,211,211,211,211,211,212,211,
213,211,211,213,211,211,213,211,119,119,119,119,119,119,119,119,
214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,
214,214,214,214,214,214,214,214,214,214,214,119,119,119,119,214,
214,214,214,213,213,119,119,119,119,119,119,119,119,119,119,119,

/* block 12 */
215,215,215,215,215,216,217,217,217,218,218,219,220,218,221,221,
222,222,222,222,222,222,222,222,222,222,222,220,223,119,218,220,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
225,224,224,224,224,224,224,224,224,224,224,226,226,226,226,226,
226,226,226,226,226,226,222,222,222,222,222,222,222,222,222,222,
227,227,227,227,227,227,227,227,227,227,218,218,218,218,224,224,
226,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,

/* block 13 */
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,228,224,222,222,222,222,222,222,222,216,221,222,
222,222,222,222,222,229,229,222,222,221,222,222,222,222,224,224,
230,230,230,230,230,230,230,230,230,230,224,224,224,221,221,224,

/* block 14 */
231,231,231,231,231,231,231,231,231,231,231,231,231,231,119,232,
233,234,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,119,119,233,233,233,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,

/* block 15 */
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,236,236,236,236,236,236,236,236,236,236,
236,235,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
237,237,237,237,237,237,237,237,237,237,238,238,238,238,238,238,
238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,
238,238,238,238,238,238,238,238,238,238,238,239,239,239,239,239,
239,239,239,239,240,240,241,242,242,242,240,119,119,239,243,243,

/* block 16 */
244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
244,244,244,244,244,244,245,245,245,245,246,245,245,245,245,245,
245,245,245,245,246,245,245,245,246,245,245,245,245,245,119,119,
247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,119,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,249,249,249,119,119,250,119,
233,233,233,233,233,233,233,233,233,233,233,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 17 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,119,224,224,224,224,224,224,224,224,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,222,222,222,222,222,222,222,222,222,222,222,222,222,
222,222,216,222,222,222,222,222,222,222,222,222,222,222,222,222,
222,222,222,222,222,222,222,222,222,222,222,222,222,222,222,222,

/* block 18 */
251,251,251,252,253,253,253,253,253,253,253,253,253,253,253,253,
253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
253,253,253,253,253,253,253,253,253,253,251,252,251,253,252,252,
252,251,251,251,251,251,251,251,251,252,252,252,252,251,252,252,
253,254,255,251,251,251,251,251,253,253,253,253,253,253,253,253,
253,253,251,251,256,257,258,258,258,258,258,258,258,258,258,258,
259,260,253,253,253,253,253,253,253,253,253,253,253,253,253,253,

/* block 19 */
261,262,263,263,119,261,261,261,261,261,261,261,261,119,119,261,
261,119,119,261,261,261,261,261,261,261,261,261,261,261,261,261,
261,261,261,261,261,261,261,261,261,119,261,261,261,261,261,261,
261,119,261,119,119,119,261,261,261,261,119,119,262,261,264,263,
263,262,262,262,262,119,119,263,263,119,119,263,263,262,261,119,
119,119,119,119,119,119,119,264,119,119,119,119,261,261,119,261,
261,261,262,262,119,119,265,265,265,265,265,265,265,265,265,265,
261,261,266,266,267,267,267,267,267,267,268,266,261,269,262,119,

/* block 20 */
119,270,270,271,119,272,272,272,272,272,272,119,119,119,119,272,
272,119,119,272,272,272,272,272,272,272,272,272,272,272,272,272,
272,272,272,272,272,272,272,272,272,119,272,272,272,272,272,272,
272,119,272,272,119,272,272,119,272,272,119,119,270,119,271,271,
271,270,270,119,119,119,119,270,270,119,119,270,270,270,119,119,
119,270,119,119,119,119,119,119,119,272,272,272,272,119,272,119,
119,119,119,119,119,119,273,273,273,273,273,273,273,273,273,273,
270,270,272,272,272,270,274,119,119,119,119,119,119,119,119,119,

/* block 21 */
119,275,275,276,119,277,277,277,277,277,277,277,277,277,119,277,
277,277,119,277,277,277,277,277,277,277,277,277,277,277,277,277,
277,277,277,277,277,277,277,277,277,119,277,277,277,277,277,277,
277,119,277,277,119,277,277,277,277,277,119,119,275,277,276,276,
276,275,275,275,275,275,119,275,275,276,119,276,276,275,119,119,
277,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
277,277,275,275,119,119,278,278,278,278,278,278,278,278,278,278,
279,280,119,119,119,119,119,119,119,277,275,275,275,275,275,275,

/* block 22 */
119,281,282,282,119,283,283,283,283,283,283,283,283,119,119,283,
283,119,119,283,283,283,283,283,283,283,283,283,283,283,283,283,
283,283,283,283,283,283,283,283,283,119,283,283,283,283,283,283,
283,119,283,283,119,283,283,283,283,283,119,119,281,283,284,281,
282,281,281,281,281,119,119,282,282,119,119,282,282,281,119,119,
119,119,119,119,119,119,281,284,119,119,119,119,283,283,119,283,
283,283,281,281,119,119,285,285,285,285,285,285,285,285,285,285,
286,283,287,287,287,287,287,287,119,119,119,119,119,119,119,119,

/* block 23 */
119,119,288,289,119,289,289,289,289,289,289,119,119,119,289,289,
289,119,289,289,289,289,119,119,119,289,289,119,289,119,289,289,
119,119,119,289,289,119,119,119,289,289,289,119,119,119,289,289,
289,289,289,289,289,289,289,289,289,289,119,119,119,119,290,291,
288,291,291,119,119,119,291,291,291,119,291,291,291,288,119,119,
289,119,119,119,119,119,119,290,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,292,292,292,292,292,292,292,292,292,292,
293,293,293,294,295,295,295,295,295,296,295,119,119,119,119,119,

/* block 24 */
297,298,298,298,297,299,299,299,299,299,299,299,299,119,299,299,
299,119,299,299,299,299,299,299,299,299,299,299,299,299,299,299,
299,299,299,299,299,299,299,299,299,119,299,299,299,299,299,299,
299,299,299,299,299,299,299,299,299,299,119,119,119,299,297,297,
297,298,298,298,298,119,297,297,297,119,297,297,297,297,119,119,
119,119,119,119,119,297,297,119,299,299,299,119,119,119,119,119,
299,299,297,297,119,119,300,300,300,300,300,300,300,300,300,300,
119,119,119,119,119,119,119,119,301,301,301,301,301,301,301,302,

/* block 25 */
303,304,305,305,306,303,303,303,303,303,303,303,303,119,303,303,
303,119,303,303,303,303,303,303,303,303,303,303,303,303,303,303,
303,303,303,303,303,303,303,303,303,119,303,303,303,303,303,303,
303,303,303,303,119,303,303,303,303,303,119,119,304,303,305,304,
305,305,307,305,305,119,304,305,305,119,305,305,304,304,119,119,
119,119,119,119,119,307,307,119,119,119,119,119,119,119,303,119,
303,303,304,304,119,119,308,308,308,308,308,308,308,308,308,308,
119,303,303,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 26 */
309,309,310,310,119,311,311,311,311,311,311,311,311,119,311,311,
311,119,311,311,311,311,311,311,311,311,311,311,311,311,311,311,
311,311,311,311,311,311,311,311,311,311,311,311,311,311,311,311,
311,311,311,311,311,311,311,311,311,311,311,309,309,311,312,310,
310,309,309,309,309,119,310,310,310,119,310,310,310,309,313,314,
119,119,119,119,311,311,311,312,315,315,315,315,315,315,315,311,
311,311,309,309,119,119,316,316,316,316,316,316,316,316,316,316,
315,315,315,315,315,315,315,315,315,314,311,311,311,311,311,311,

/* block 27 */
119,119,317,317,119,318,318,318,318,318,318,318,318,318,318,318,
318,318,318,318,318,318,318,119,119,119,318,318,318,318,318,318,
318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,
318,318,119,318,318,318,318,318,318,318,318,318,119,318,119,119,
318,318,318,318,318,318,318,119,119,119,319,119,119,119,119,320,
317,317,319,319,319,119,319,119,317,317,317,317,317,317,317,320,
119,119,119,119,119,119,321,321,321,321,321,321,321,321,321,321,
119,119,317,317,322,119,119,119,119,119,119,119,119,119,119,119,

/* block 28 */
119,323,323,323,323,323,323,323,323,323,323,323,323,323,323,323,
323,323,323,323,323,323,323,323,323,323,323,323,323,323,323,323,
323,323,323,323,323,323,323,323,323,323,323,323,323,323,323,323,
323,324,323,325,324,324,324,324,324,324,324,119,119,119,119,  6,
323,323,323,323,323,323,326,324,324,324,324,324,324,324,324,327,
328,328,328,328,328,328,328,328,328,328,327,327,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 29 */
119,329,329,119,329,119,119,329,329,119,329,119,119,329,119,119,
119,119,119,119,329,329,329,329,119,329,329,329,329,329,329,329,
119,329,329,329,119,329,119,329,119,119,329,329,119,329,329,329,
329,330,329,331,330,330,330,330,330,330,119,330,330,329,119,119,
329,329,329,329,329,119,332,119,330,330,330,330,330,330,119,119,
333,333,333,333,333,333,333,333,333,333,119,119,329,329,329,329,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 30 */
334,335,335,335,336,336,336,336,336,336,336,336,336,336,336,336,
336,336,336,335,336,335,335,335,337,337,335,335,335,335,335,335,
338,338,338,338,338,338,338,338,338,338,339,339,339,339,339,339,
339,339,339,339,335,337,335,337,335,337,340,341,340,341,342,342,
334,334,334,334,334,334,334,334,119,334,334,334,334,334,334,334,
334,334,334,334,334,334,334,334,334,334,334,334,334,334,334,334,
334,334,334,334,334,334,334,334,334,334,334,334,334,119,119,119,
119,337,337,337,337,337,337,337,337,337,337,337,337,337,337,342,

/* block 31 */
337,337,337,337,337,336,337,337,334,334,334,334,334,337,337,337,
337,337,337,337,337,337,337,337,119,337,337,337,337,337,337,337,
337,337,337,337,337,337,337,337,337,337,337,337,337,337,337,337,
337,337,337,337,337,337,337,337,337,337,337,337,337,119,335,335,
335,335,335,335,335,335,337,335,335,335,335,335,335,119,335,335,
336,336,336,336,336, 20, 20, 20, 20,336,336,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 32 */
343,343,343,343,343,343,343,343,343,343,343,343,343,343,343,343,
343,343,343,343,343,343,343,343,343,343,343,343,343,343,343,343,
343,343,343,343,343,343,343,343,343,343,343,344,344,345,345,345,
345,346,345,345,345,345,345,345,344,345,345,346,346,345,345,343,
347,347,347,347,347,347,347,347,347,347,348,348,348,348,348,348,
343,343,343,343,343,343,346,346,345,345,343,343,343,343,345,345,
345,343,344,344,344,343,343,344,344,344,344,344,344,344,343,343,
343,345,345,345,345,343,343,343,343,343,343,343,343,343,343,343,

/* block 33 */
343,343,345,344,346,345,345,344,344,344,344,344,344,345,343,344,
349,349,349,349,349,349,349,349,349,349,344,344,344,345,350,350,
351,351,351,351,351,351,351,351,351,351,351,351,351,351,351,351,
351,351,351,351,351,351,351,351,351,351,351,351,351,351,351,351,
351,351,351,351,351,351,119,351,119,119,119,119,119,351,119,119,
352,352,352,352,352,352,352,352,352,352,352,352,352,352,352,352,
352,352,352,352,352,352,352,352,352,352,352,352,352,352,352,352,
352,352,352,352,352,352,352,352,352,352,352,353,354,352,352,352,

/* block 34 */
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,
356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,

/* block 35 */
356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,
356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,
356,356,356,356,356,356,356,356,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,

/* block 36 */
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,119,358,358,358,358,119,119,
358,358,358,358,358,358,358,119,358,119,358,358,358,358,119,119,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,

/* block 37 */
358,358,358,358,358,358,358,358,358,119,358,358,358,358,119,119,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,119,358,358,358,358,119,119,358,358,358,358,358,358,358,119,
358,119,358,358,358,358,119,119,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,119,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,

/* block 38 */
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,119,358,358,358,358,119,119,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,119,119,359,359,359,
360,360,360,360,360,360,360,360,360,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,119,119,119,

/* block 39 */
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
362,362,362,362,362,362,362,362,362,362,119,119,119,119,119,119,
363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,
363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,
363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,
363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,
363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,363,
364,364,364,364,364,364,119,119,365,365,365,365,365,365,119,119,

/* block 40 */
366,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,

/* block 41 */
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,

/* block 42 */
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,368,368,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,

/* block 43 */
369,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,371,372,119,119,119,
373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,
373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,
373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,
373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,
373,373,373,373,373,373,373,373,373,373,373,  5,  5,  5,374,374,
374,373,373,373,373,373,373,373,373,119,119,119,119,119,119,119,

/* block 44 */
375,375,375,375,375,375,375,375,375,375,375,375,375,119,375,375,
375,375,376,376,376,119,119,119,119,119,119,119,119,119,119,119,
377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,
377,377,378,378,378,379,379,119,119,119,119,119,119,119,119,119,
380,380,380,380,380,380,380,380,380,380,380,380,380,380,380,380,
380,380,381,381,119,119,119,119,119,119,119,119,119,119,119,119,
382,382,382,382,382,382,382,382,382,382,382,382,382,119,382,382,
382,119,383,383,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 45 */
384,384,384,384,384,384,384,384,384,384,384,384,384,384,384,384,
384,384,384,384,384,384,384,384,384,384,384,384,384,384,384,384,
384,384,384,384,384,384,384,384,384,384,384,384,384,384,384,384,
384,384,384,384,385,385,386,385,385,385,385,385,385,385,386,386,
386,386,386,386,386,386,385,386,386,385,385,385,385,385,385,385,
385,385,385,385,387,387,387,388,387,387,387,389,384,385,119,119,
390,390,390,390,390,390,390,390,390,390,119,119,119,119,119,119,
391,391,391,391,391,391,391,391,391,391,119,119,119,119,119,119,

/* block 46 */
392,392,393,393,392,393,394,392,392,392,392,395,395,395,396,119,
397,397,397,397,397,397,397,397,397,397,119,119,119,119,119,119,
398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,
398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,
398,398,398,399,398,398,398,398,398,398,398,398,398,398,398,398,
398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,
398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,
398,398,398,398,398,398,398,398,398,119,119,119,119,119,119,119,

/* block 47 */
398,398,398,398,398,395,395,398,398,398,398,398,398,398,398,398,
398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,398,
398,398,398,398,398,398,398,398,398,395,398,119,119,119,119,119,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,119,119,119,119,119,119,119,119,119,119,

/* block 48 */
400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,
400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,119,
401,401,401,402,402,402,402,401,401,402,402,402,119,119,119,119,
402,402,401,402,402,402,402,402,402,401,401,401,119,119,119,119,
403,119,119,119,404,404,405,405,405,405,405,405,405,405,405,405,
406,406,406,406,406,406,406,406,406,406,406,406,406,406,406,406,
406,406,406,406,406,406,406,406,406,406,406,406,406,406,119,119,
406,406,406,406,406,119,119,119,119,119,119,119,119,119,119,119,

/* block 49 */
407,407,407,407,407,407,407,407,407,407,407,407,407,407,407,407,
407,407,407,407,407,407,407,407,407,407,407,407,407,407,407,407,
407,407,407,407,407,407,407,407,407,407,407,407,119,119,119,119,
407,407,407,407,407,407,407,407,407,407,407,407,407,407,407,407,
407,407,407,407,407,407,407,407,407,407,119,119,119,119,119,119,
408,408,408,408,408,408,408,408,408,408,409,119,119,119,410,410,
411,411,411,411,411,411,411,411,411,411,411,411,411,411,411,411,
411,411,411,411,411,411,411,411,411,411,411,411,411,411,411,411,

/* block 50 */
412,412,412,412,412,412,412,412,412,412,412,412,412,412,412,412,
412,412,412,412,412,412,412,413,413,414,414,413,119,119,415,415,
416,416,416,416,416,416,416,416,416,416,416,416,416,416,416,416,
416,416,416,416,416,416,416,416,416,416,416,416,416,416,416,416,
416,416,416,416,416,416,416,416,416,416,416,416,416,416,416,416,
416,416,416,416,416,417,418,417,418,418,418,418,418,418,418,119,
418,419,418,419,419,418,418,418,418,418,418,418,418,417,417,417,
417,417,417,418,418,418,418,418,418,418,418,418,418,119,119,418,

/* block 51 */
420,420,420,420,420,420,420,420,420,420,119,119,119,119,119,119,
420,420,420,420,420,420,420,420,420,420,119,119,119,119,119,119,
421,421,421,421,421,421,421,422,421,421,421,421,421,421,119,119,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,423,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 52 */
424,424,424,424,425,426,426,426,426,426,426,426,426,426,426,426,
426,426,426,426,426,426,426,426,426,426,426,426,426,426,426,426,
426,426,426,426,426,426,426,426,426,426,426,426,426,426,426,426,
426,426,426,426,424,425,424,424,424,424,424,425,424,425,425,425,
425,425,424,425,425,426,426,426,426,426,426,426,119,119,119,119,
427,427,427,427,427,427,427,427,427,427,428,428,428,428,428,428,
428,429,429,429,429,429,429,429,429,429,429,424,424,424,424,424,
424,424,424,424,429,429,429,429,429,429,429,429,429,119,119,119,

/* block 53 */
430,430,431,432,432,432,432,432,432,432,432,432,432,432,432,432,
432,432,432,432,432,432,432,432,432,432,432,432,432,432,432,432,
432,431,430,430,430,430,431,431,430,430,431,430,430,430,432,432,
433,433,433,433,433,433,433,433,433,433,432,432,432,432,432,432,
434,434,434,434,434,434,434,434,434,434,434,434,434,434,434,434,
434,434,434,434,434,434,434,434,434,434,434,434,434,434,434,434,
434,434,434,434,434,434,435,436,435,435,436,436,436,435,436,435,
435,435,436,436,119,119,119,119,119,119,119,119,437,437,437,437,

/* block 54 */
438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,
438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,
438,438,438,438,439,439,439,439,439,439,439,439,440,440,440,440,
440,440,440,440,439,439,440,440,119,119,119,441,441,441,441,441,
442,442,442,442,442,442,442,442,442,442,119,119,119,438,438,438,
443,443,443,443,443,443,443,443,443,443,444,444,444,444,444,444,
444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,444,
444,444,444,444,444,444,444,444,445,445,445,445,445,445,446,446,

/* block 55 */
447,448,449,450,451,452,453,454,455,119,119,119,119,119,119,119,
456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,
456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,456,
456,456,456,456,456,456,456,456,456,456,456,119,119,456,456,456,
457,457,457,457,457,457,457,457,119,119,119,119,119,119,119,119,
458,459,458,460,459,461,461,462,461,462,463,459,462,462,459,459,
462,464,459,459,459,459,459,459,459,465,466,465,465,461,465,465,
465,465,467,467,468,466,466,469,470,470,119,119,119,119,119,119,

/* block 56 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35,127,127,127,127,127,471,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,120,120,120,
120,120,109,109,109,109,120,120,120,120,120, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35,472,473, 35, 35, 35,474, 35, 35,

/* block 57 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,120,
113,113,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,119,112,112,112,112,112,

/* block 58 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
475,476, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 59 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 35, 35, 35, 35, 35,477, 35, 35,478, 35,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 60 */
479,479,479,479,479,479,479,479,480,480,480,480,480,480,480,480,
479,479,479,479,479,479,119,119,480,480,480,480,480,480,119,119,
479,479,479,479,479,479,479,479,480,480,480,480,480,480,480,480,
479,479,479,479,479,479,479,479,480,480,480,480,480,480,480,480,
479,479,479,479,479,479,119,119,480,480,480,480,480,480,119,119,
127,479,127,479,127,479,127,479,119,480,119,480,119,480,119,480,
479,479,479,479,479,479,479,479,480,480,480,480,480,480,480,480,
481,481,482,482,482,482,483,483,484,484,485,485,486,486,119,119,

/* block 61 */
479,479,479,479,479,479,479,479,487,487,487,487,487,487,487,487,
479,479,479,479,479,479,479,479,487,487,487,487,487,487,487,487,
479,479,479,479,479,479,479,479,487,487,487,487,487,487,487,487,
479,479,127,488,127,119,127,127,480,480,489,489,490,118,491,118,
118,118,127,488,127,119,127,127,492,492,492,492,490,118,118,118,
479,479,127,127,119,119,127,127,480,480,493,493,119,118,118,118,
479,479,127,127,127,168,127,127,480,480,494,494,173,118,118,118,
119,119,127,488,127,119,127,127,495,495,496,496,490,118,118,119,

/* block 62 */
  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4, 24,497,498, 24, 24,
 10, 10, 10, 10, 10, 10,  5,  5, 23, 27,  7, 23, 23, 27,  7, 23,
  5,  5,  5,  5,  5,  5,  5,  5,499,500, 24, 24, 24, 24, 24,  4,
  5,  5,  5,  5,  5,  5,  5,  5,  5, 23, 27,  5,501,  5,  5, 16,
 16,  5,  5,  5,  9,  7,  8,  5,  5,501,  5,  5,  5,  5,  5,  5,
  5,  5,  9,  5, 16,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  4,
 24, 24, 24, 24, 24,502, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 25,109,119,119, 25, 25, 25, 25, 25, 25,  9,  9,  9,  7,  8,109,

/* block 63 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,  9,  9,  9,  7,  8,119,
109,109,109,109,109,109,109,109,109,109,109,109,109,119,119,119,
  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
112,112,112,112,112,112,112,112,112,112,112,112,112,423,423,423,
423,112,423,423,423,112,112,112,112,112,112,112,112,112,112,112,
503,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 64 */
 20, 20,504, 20, 20, 20, 20,504, 20, 20,505,504,504,504,505,505,
504,504,504,505, 20,504, 20, 20,  9,504,504,504,504,504, 20, 20,
 20, 20, 21, 20,504, 20,506, 20,504, 20,507,508,504,504, 20,505,
504,504,509,504,505,510,510,510,510,511, 20, 20,505,505,504,504,
  9,  9,  9,  9,  9,504,505,505,505,505, 20,  9, 20, 20,512, 20,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,

/* block 65 */
515,515,515, 32, 33,515,515,515,515, 25, 20, 20,119,119,119,119,
  9,  9,  9,  9,516, 21, 21, 21, 21, 21,  9,  9, 20, 20, 20, 20,
  9, 20, 20,  9, 20, 20,  9, 20, 20, 21, 21, 20, 20, 20,  9, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,
 20, 20,  9, 20,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 66 */
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 67 */
 20, 20, 20, 20, 20, 20, 20, 20,  7,  8,  7,  8, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20,
  9,  9, 20, 20, 20, 20, 20, 20, 21,  7,  8, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9, 20, 20, 20,

/* block 68 */
 20, 20, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,  9,
  9,  9, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 20, 20, 20, 20, 21, 21, 21, 20, 20, 20, 20, 20,

/* block 69 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 70 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,517,517,517,517,517,517,517,517,517,517,
517,517,518,517,517,517,517,517,517,517,517,517,517,517,517,517,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 71 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 72 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 21,  9, 20, 20, 20, 20, 20, 20, 20, 20,
 21,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,516,516,516,516,  9,

/* block 73 */
 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,516,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 74 */
 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 75 */
 21, 21, 21, 21, 21, 21, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 20, 21, 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 20,
 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 21, 20, 20, 21, 20, 20, 20, 20, 21, 20, 21, 20,
 20, 20, 20, 21, 21, 21, 20, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 21, 21, 21, 21, 21,  7,  8,  7,  8,  7,  8,  7,  8,
  7,  8,  7,  8,  7,  8, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 76 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 20, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
  9,  9,  9,  9,  9,  7,  8,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 77 */
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,
520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,520,

/* block 78 */
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,516,516,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 79 */
  9,  9,  9,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,
  8,  7,  8,  7,  8,  7,  8,  7,  8,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  7,  8,  7,  8,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  7,  8,  9,  9,

/* block 80 */
 20, 20, 20, 20, 20, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 20, 20,  9,  9,  9,  9,  9,  9, 20, 20, 20,
 21, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,119,119, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 81 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,119,119, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,119, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,119,

/* block 82 */
521,521,521,521,521,521,521,521,521,521,521,521,521,521,521,521,
521,521,521,521,521,521,521,521,521,521,521,521,521,521,521,521,
521,521,521,521,521,521,521,521,521,521,521,521,521,521,521,119,
522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,
522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,
522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,119,
 32, 33,523,524,525,526,527, 32, 33, 32, 33, 32, 33,528,529,530,
531, 35, 32, 33, 35, 32, 33, 35, 35, 35, 35, 35,109,109,532,532,

/* block 83 */
164,165,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
164,165,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
164,165,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
164,165,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
164,165,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
164,165,164,165,164,165,164,165,164,165,164,165,164,165,164,165,
164,165,164,165,533,534,534,534,534,534,534,164,165,164,165,535,
535,535,164,165,119,119,119,119,119,536,536,536,536,537,536,536,

/* block 84 */
538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,
538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,
538,538,538,538,538,538,119,538,119,119,119,119,119,538,119,119,
539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,
539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,
539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,
539,539,539,539,539,539,539,539,119,119,119,119,119,119,119,540,
541,119,119,119,119,119,119,119,119,119,119,119,119,119,119,542,

/* block 85 */
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,119,119,119,119,119,119,119,119,119,
358,358,358,358,358,358,358,119,358,358,358,358,358,358,358,119,
358,358,358,358,358,358,358,119,358,358,358,358,358,358,358,119,
358,358,358,358,358,358,358,119,358,358,358,358,358,358,358,119,
358,358,358,358,358,358,358,119,358,358,358,358,358,358,358,119,
543,543,543,543,543,543,543,543,543,543,543,543,543,543,543,543,
543,543,543,543,543,543,543,543,543,543,543,543,543,543,543,543,

/* block 86 */
  5,  5, 23, 27, 23, 27,  5,  5,  5, 23, 27,  5, 23, 27,  5,  5,
  5,  5,  5,  5,  5,  5,  5, 10,  5,  5, 10,  5, 23, 27,  5,  5,
 23, 27,  7,  8,  7,  8,  7,  8,  7,  8,  5,  5,  5,  5,  5,110,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 10, 10,  5,  5,  5,  5,
 10,  5,  7,544,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 87 */
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,119,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 88 */
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,

/* block 89 */
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,119,119,119,119,

/* block 90 */
  4,546,546,547, 20,548,549,550,551,552,551,552,551,552,551,552,
551,552, 20,553,551,552,551,552,551,552,551,552,554,555,556,556,
 20,550,550,550,550,550,550,550,550,550,557,557,557,557,558,558,
559,560,560,560,560,560, 20,553,550,550,550,548,561,562,563,563,
119,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,

/* block 91 */
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,119,119,565,565,566,566,567,567,564,
568,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,
569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,
569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,
569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,
569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,
569,569,569,569,569,569,569,569,569,569,569,546,560,570,570,569,

/* block 92 */
119,119,119,119,119,571,571,571,571,571,571,571,571,571,571,571,
571,571,571,571,571,571,571,571,571,571,571,571,571,571,571,571,
571,571,571,571,571,571,571,571,571,571,571,571,571,571,571,571,
119,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,

/* block 93 */
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,119,
563,563,573,573,573,573,563,563,563,563,563,563,563,563,563,563,
571,571,571,571,571,571,571,571,571,571,571,571,571,571,571,571,
571,571,571,571,571,571,571,571,571,571,571,119,119,119,119,119,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563,563,563,563,119,119,119,119,119,119,119,119,119,119,119,119,
569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,

/* block 94 */
574,574,574,574,574,574,574,574,574,574,574,574,574,574,574,574,
574,574,574,574,574,574,574,574,574,574,574,574,574,574,574,119,
573,573,573,573,573,573,573,573,573,573,563,563,563,563,563,563,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563,563,563,563,563,563,563,563, 25, 25, 25, 25, 25, 25, 25, 25,
 20, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
574,574,574,574,574,574,574,574,574,574,574,574,574,574,574,574,
574,574,574,574,574,574,574,574,574,574,574,574,574,574,574, 20,

/* block 95 */
573,573,573,573,573,573,573,573,573,573,563,563,563,563,563,563,
563,563,563,563,563,563,563,575,563,575,563,563,563,563,563,563,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
563,563,563,563,563,563,563,563,563,563,563,563, 20, 20, 20, 20,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,119,

/* block 96 */
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,576,
576,576,576,576,576,576,576,576,563,563,563,563,563,563,563,563,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,563,563,563,563,563,

/* block 97 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563, 20,

/* block 98 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,

/* block 99 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,119,119,119,119,119,119,119,119,119,119,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 100 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 101 */
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,579,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 102 */
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 103 */
578,578,578,578,578,578,578,578,578,578,578,578,578,119,119,119,
580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,
580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,
580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,
580,580,580,580,580,580,580,119,119,119,119,119,119,119,119,119,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,582,582,582,582,582,582,583,583,

/* block 104 */
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,

/* block 105 */
584,584,584,584,584,584,584,584,584,584,584,584,585,586,586,586,
584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,584,
587,587,587,587,587,587,587,587,587,587,584,584,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
191,192,191,192,191,192,191,192,191,192,588,589,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,191,192,590,197,
199,199,199,591,543,543,543,543,543,543,543,543,543,543,591,472,

/* block 106 */
191,192,191,192,191,192,191,192,191,192,191,192,191,192,191,192,
191,192,191,192,191,192,191,192,191,192,191,192,472,472,543,543,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,593,593,593,593,593,593,593,593,593,593,
594,594,595,595,595,595,595,595,119,119,119,119,119,119,119,119,

/* block 107 */
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15,110,110,110,110,110,110,110,110,110,
 15, 15, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 35, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
109, 35, 35, 35, 35, 35, 35, 35, 35, 32, 33, 32, 33,596, 32, 33,

/* block 108 */
 32, 33, 32, 33, 32, 33, 32, 33,110, 15, 15, 32, 33,597, 35, 22,
 32, 33, 32, 33, 35, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,598,599,600,601,598, 35,
602,603,604,605, 32, 33, 32, 33, 32, 33,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119, 22,109,109, 35, 22, 22, 22, 22, 22,

/* block 109 */
606,606,607,606,606,606,607,606,606,606,606,607,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,608,608,607,607,608,609,609,609,609,119,119,119,119,
610,610,610,611,611,611,612,612,613,612,119,119,119,119,119,119,
614,614,614,614,614,614,614,614,614,614,614,614,614,614,614,614,
614,614,614,614,614,614,614,614,614,614,614,614,614,614,614,614,
614,614,614,614,614,614,614,614,614,614,614,614,614,614,614,614,
614,614,614,614,615,615,615,615,119,119,119,119,119,119,119,119,

/* block 110 */
616,616,617,617,617,617,617,617,617,617,617,617,617,617,617,617,
617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,
617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,
617,617,617,617,616,616,616,616,616,616,616,616,616,616,616,616,
616,616,616,616,618,618,119,119,119,119,119,119,119,119,619,619,
620,620,620,620,620,620,620,620,620,620,119,119,119,119,119,119,
251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,
251,621,253,622,253,253,253,253,259,259,259,253,259,253,253,251,

/* block 111 */
623,623,623,623,623,623,623,623,623,623,624,624,624,624,624,624,
624,624,624,624,624,624,624,624,624,624,624,624,624,624,624,624,
624,624,624,624,624,624,625,625,625,625,625,625,625,625,626,627,
628,628,628,628,628,628,628,628,628,628,628,628,628,628,628,628,
628,628,628,628,628,628,628,629,629,629,629,629,629,629,629,629,
629,629,630,630,119,119,119,119,119,119,119,119,119,119,119,631,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,119,119,119,

/* block 112 */
632,632,632,633,634,634,634,634,634,634,634,634,634,634,634,634,
634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,
634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,
634,634,634,632,633,633,632,632,632,632,633,633,632,633,633,633,
633,635,635,635,635,635,635,635,635,635,635,635,635,635,119,636,
637,637,637,637,637,637,637,637,637,637,119,119,119,119,635,635,
343,343,343,343,343,345,638,343,343,343,343,343,343,343,343,343,
349,349,349,349,349,349,349,349,349,349,343,343,343,343,343,119,

/* block 113 */
639,639,639,639,639,639,639,639,639,639,639,639,639,639,639,639,
639,639,639,639,639,639,639,639,639,639,639,639,639,639,639,639,
639,639,639,639,639,639,639,639,639,640,640,640,640,640,640,641,
641,640,640,641,641,640,640,119,119,119,119,119,119,119,119,119,
639,639,639,640,639,639,639,639,639,639,639,639,640,641,119,119,
642,642,642,642,642,642,642,642,642,642,119,119,643,643,643,643,
343,343,343,343,343,343,343,343,343,343,343,343,343,343,343,343,
638,343,343,343,343,343,343,350,350,350,343,344,345,344,343,343,

/* block 114 */
644,644,644,644,644,644,644,644,644,644,644,644,644,644,644,644,
644,644,644,644,644,644,644,644,644,644,644,644,644,644,644,644,
644,644,644,644,644,644,644,644,644,644,644,644,644,644,644,644,
645,644,645,645,645,644,644,645,645,644,644,644,644,644,645,645,
644,645,644,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,644,644,646,647,647,
648,648,648,648,648,648,648,648,648,648,648,649,650,650,649,649,
651,651,648,652,652,649,650,119,119,119,119,119,119,119,119,119,

/* block 115 */
119,358,358,358,358,358,358,119,119,358,358,358,358,358,358,119,
119,358,358,358,358,358,358,119,119,119,119,119,119,119,119,119,
358,358,358,358,358,358,358,119,358,358,358,358,358,358,358,119,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35,653, 35, 35, 35, 35, 35, 35, 35, 15,109,109,109,109,
 35, 35, 35, 35, 35,127,119,119,119,119,119,119,119,119,119,119,
654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,

/* block 116 */
654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,
654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,
654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,
654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,654,
648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,
648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,
648,648,648,649,649,650,649,649,650,649,649,651,649,650,119,119,
655,655,655,655,655,655,655,655,655,655,119,119,119,119,119,119,

/* block 117 */
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,

/* block 118 */
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,

/* block 119 */
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,

/* block 120 */
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,

/* block 121 */
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,

/* block 122 */
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,

/* block 123 */
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
656,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,656,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,656,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,

/* block 124 */
657,657,657,657,657,657,657,657,656,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,119,119,119,119,119,119,119,119,119,119,119,119,
356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,356,
356,356,356,356,356,356,356,119,119,119,119,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,119,119,119,119,

/* block 125 */
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,

/* block 126 */
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,

/* block 127 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,119,119,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,

/* block 128 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 129 */
 35, 35, 35, 35, 35, 35, 35,119,119,119,119,119,119,119,119,119,
119,119,119,205,205,205,205,205,119,119,119,119,119,214,211,214,
214,214,214,214,214,214,214,214,214,660,214,214,214,214,214,214,
214,214,214,214,214,214,214,119,214,214,214,214,214,119,214,119,
214,214,119,214,214,119,214,214,214,214,214,214,214,214,214,214,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,

/* block 130 */
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,661,661,661,661,661,661,661,661,661,661,661,661,661,661,
661,661,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,

/* block 131 */
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,

/* block 132 */
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,  8,  7,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,

/* block 133 */
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
119,119,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
224,224,662,224,224,224,224,224,224,224,224,224,219,663,119,119,

/* block 134 */
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
  5,  5,  5,  5,  5,  5,  5,  7,  8,  5,119,119,119,119,119,119,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,543,543,
  5, 10, 10, 16, 16,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,
  8,  7,  8,  7,  8,547,547,  7,  8,  5,  5,  5,  5, 16, 16, 16,
  5,  5,  5,119,  5,  5,  5,  5, 10,  7,  8,  7,  8,  7,  8,  5,
  5,  5,  9, 10,  9,  9,  9,119,  5,  6,  5,  5,119,119,119,119,
224,224,224,224,224,119,224,224,224,224,224,224,224,224,224,224,

/* block 135 */
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,119,119, 24,

/* block 136 */
119,  5,  5,  5,  6,  5,  5,  5,  7,  8,  5,  9,  5, 10,  5,  5,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  5,  5,  9,  9,  9,  5,
  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  7,  5,  8, 15, 16,
 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,  7,  9,  8,  9,  7,
  8,546,551,552,546,546,569,569,569,569,569,569,569,569,569,569,
560,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,

/* block 137 */
569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,569,
569,569,569,569,569,569,569,569,569,569,569,569,569,569,664,664,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,119,
119,119,572,572,572,572,572,572,119,119,572,572,572,572,572,572,
119,119,572,572,572,572,572,572,119,119,572,572,572,119,119,119,
  6,  6,  9, 15, 20,  6,  6,119, 20,  9,  9,  9,  9, 20, 20,119,
502,502,502,502,502,502,502,502,502, 24, 24, 24, 20, 20,119,119,

/* block 138 */
665,665,665,665,665,665,665,665,665,665,665,665,119,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,119,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,119,665,665,119,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,119,119,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 139 */
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,665,
665,665,665,665,665,665,665,665,665,665,665,119,119,119,119,119,

/* block 140 */
666,666,666,119,119,119,119,667,667,667,667,667,667,667,667,667,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,667,119,119,119,668,668,668,668,668,668,668,668,668,
669,669,669,669,669,669,669,669,669,669,669,669,669,669,669,669,
669,669,669,669,669,669,669,669,669,669,669,669,669,669,669,669,
669,669,669,669,669,669,669,669,669,669,669,669,669,669,669,669,
669,669,669,669,669,670,670,670,670,671,671,671,671,671,671,671,

/* block 141 */
671,671,671,671,671,671,671,671,671,671,670,670,671,671,671,119,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,119,119,119,119,
671,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,112,119,119,

/* block 142 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 143 */
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,119,119,119,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
673,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
674,675,675,675,675,675,675,675,675,675,675,675,675,675,675,675,
675,675,675,675,675,675,675,675,675,675,675,675,119,119,119,119,

/* block 144 */
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
677,677,677,677,119,119,119,119,119,119,119,119,119,676,676,676,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,679,678,678,678,678,678,678,678,678,679,119,119,119,119,119,
680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,
680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,
680,680,680,680,680,680,681,681,681,681,681,119,119,119,119,119,

/* block 145 */
682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,
682,682,682,682,682,682,682,682,682,682,682,682,682,682,119,683,
684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,
684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,
684,684,684,684,119,119,119,119,684,684,684,684,684,684,684,684,
685,686,686,686,686,686,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 146 */
687,687,687,687,687,687,687,687,687,687,687,687,687,687,687,687,
687,687,687,687,687,687,687,687,687,687,687,687,687,687,687,687,
687,687,687,687,687,687,687,687,688,688,688,688,688,688,688,688,
688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,
688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,
689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,
689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,
689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,

/* block 147 */
690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,
690,690,690,690,690,690,690,690,690,690,690,690,690,690,119,119,
691,691,691,691,691,691,691,691,691,691,119,119,119,119,119,119,
692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,
692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,
692,692,692,692,119,119,119,119,693,693,693,693,693,693,693,693,
693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,
693,693,693,693,693,693,693,693,693,693,693,693,119,119,119,119,

/* block 148 */
694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,
694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,
694,694,694,694,694,694,694,694,119,119,119,119,119,119,119,119,
695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,
695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,
695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,
695,695,695,695,119,119,119,119,119,119,119,119,119,119,119,696,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 149 */
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,

/* block 150 */
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,119,119,119,119,119,119,119,119,119,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,119,119,119,119,119,119,119,119,119,119,
697,697,697,697,697,697,697,697,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 151 */
698,698,698,698,698,698,119,119,698,119,698,698,698,698,698,698,
698,698,698,698,698,698,698,698,698,698,698,698,698,698,698,698,
698,698,698,698,698,698,698,698,698,698,698,698,698,698,698,698,
698,698,698,698,698,698,119,698,698,119,119,119,698,119,119,698,
699,699,699,699,699,699,699,699,699,699,699,699,699,699,699,699,
699,699,699,699,699,699,119,700,701,701,701,701,701,701,701,701,
702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,
702,702,702,702,702,702,702,703,703,704,704,704,704,704,704,704,

/* block 152 */
705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,
705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,119,
119,119,119,119,119,119,119,706,706,706,706,706,706,706,706,706,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
707,707,707,707,707,707,707,707,707,707,707,707,707,707,707,707,
707,707,707,119,707,707,119,119,119,119,119,708,708,708,708,708,

/* block 153 */
709,709,709,709,709,709,709,709,709,709,709,709,709,709,709,709,
709,709,709,709,709,709,710,710,710,710,710,710,119,119,119,711,
712,712,712,712,712,712,712,712,712,712,712,712,712,712,712,712,
712,712,712,712,712,712,712,712,712,712,119,119,119,119,119,713,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 154 */
714,714,714,714,714,714,714,714,714,714,714,714,714,714,714,714,
714,714,714,714,714,714,714,714,714,714,714,714,714,714,714,714,
715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,
715,715,715,715,715,715,715,715,119,119,119,119,716,716,715,715,
716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,
119,119,716,716,716,716,716,716,716,716,716,716,716,716,716,716,
716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,
716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,

/* block 155 */
717,718,718,718,119,718,718,119,119,119,119,119,718,718,718,718,
717,717,717,717,119,717,717,717,119,717,717,717,717,717,717,717,
717,717,717,717,717,717,717,717,717,717,717,717,717,717,717,717,
717,717,717,717,717,717,119,119,718,718,718,119,119,119,119,718,
719,719,719,719,719,719,719,719,719,119,119,119,119,119,119,119,
720,720,720,720,720,720,720,720,720,119,119,119,119,119,119,119,
721,721,721,721,721,721,721,721,721,721,721,721,721,721,721,721,
721,721,721,721,721,721,721,721,721,721,721,721,721,722,722,723,

/* block 156 */
724,724,724,724,724,724,724,724,724,724,724,724,724,724,724,724,
724,724,724,724,724,724,724,724,724,724,724,724,724,725,725,725,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
726,726,726,726,726,726,726,726,727,726,726,726,726,726,726,726,
726,726,726,726,726,726,726,726,726,726,726,726,726,726,726,726,
726,726,726,726,726,728,728,119,119,119,119,729,729,729,729,729,
730,730,730,730,730,730,730,119,119,119,119,119,119,119,119,119,

/* block 157 */
731,731,731,731,731,731,731,731,731,731,731,731,731,731,731,731,
731,731,731,731,731,731,731,731,731,731,731,731,731,731,731,731,
731,731,731,731,731,731,731,731,731,731,731,731,731,731,731,731,
731,731,731,731,731,731,119,119,119,732,732,732,732,732,732,732,
733,733,733,733,733,733,733,733,733,733,733,733,733,733,733,733,
733,733,733,733,733,733,119,119,734,734,734,734,734,734,734,734,
735,735,735,735,735,735,735,735,735,735,735,735,735,735,735,735,
735,735,735,119,119,119,119,119,736,736,736,736,736,736,736,736,

/* block 158 */
737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,
737,737,119,119,119,119,119,119,119,738,738,738,738,119,119,119,
119,119,119,119,119,119,119,119,119,739,739,739,739,739,739,739,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 159 */
740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,
740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,
740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,
740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,
740,740,740,740,740,740,740,740,740,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 160 */
741,741,741,741,741,741,741,741,741,741,741,741,741,741,741,741,
741,741,741,741,741,741,741,741,741,741,741,741,741,741,741,741,
741,741,741,741,741,741,741,741,741,741,741,741,741,741,741,741,
741,741,741,119,119,119,119,119,119,119,119,119,119,119,119,119,
742,742,742,742,742,742,742,742,742,742,742,742,742,742,742,742,
742,742,742,742,742,742,742,742,742,742,742,742,742,742,742,742,
742,742,742,742,742,742,742,742,742,742,742,742,742,742,742,742,
742,742,742,119,119,119,119,119,119,119,743,743,743,743,743,743,

/* block 161 */
744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,
744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,
744,744,744,744,745,745,745,745,119,119,119,119,119,119,119,119,
746,746,746,746,746,746,746,746,746,746,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 162 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,
747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,119,

/* block 163 */
748,748,748,748,748,748,748,748,748,748,748,748,748,748,748,748,
748,748,748,748,748,748,748,748,748,748,748,748,748,749,749,749,
749,749,749,749,749,749,749,748,119,119,119,119,119,119,119,119,
750,750,750,750,750,750,750,750,750,750,750,750,750,750,750,750,
750,750,750,750,750,750,751,751,751,751,751,751,751,751,751,751,
751,752,752,752,752,753,753,753,753,753,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 164 */
754,755,754,756,756,756,756,756,756,756,756,756,756,756,756,756,
756,756,756,756,756,756,756,756,756,756,756,756,756,756,756,756,
756,756,756,756,756,756,756,756,756,756,756,756,756,756,756,756,
756,756,756,756,756,756,756,756,755,755,755,755,755,755,755,755,
755,755,755,755,755,755,755,757,757,757,757,757,757,757,119,119,
119,119,758,758,758,758,758,758,758,758,758,758,758,758,758,758,
758,758,758,758,758,758,759,759,759,759,759,759,759,759,759,759,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,755,

/* block 165 */
760,760,761,762,762,762,762,762,762,762,762,762,762,762,762,762,
762,762,762,762,762,762,762,762,762,762,762,762,762,762,762,762,
762,762,762,762,762,762,762,762,762,762,762,762,762,762,762,762,
761,761,761,760,760,760,760,761,761,760,760,763,763,764,763,763,
763,763,119,119,119,119,119,119,119,119,119,119,119,764,119,119,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,119,119,119,119,119,119,119,
766,766,766,766,766,766,766,766,766,766,119,119,119,119,119,119,

/* block 166 */
767,767,767,768,768,768,768,768,768,768,768,768,768,768,768,768,
768,768,768,768,768,768,768,768,768,768,768,768,768,768,768,768,
768,768,768,768,768,768,768,767,767,767,767,767,769,767,767,767,
767,767,767,767,767,119,770,770,770,770,770,770,770,770,770,770,
771,771,771,771,768,769,769,119,119,119,119,119,119,119,119,119,
772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,
772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,
772,772,772,773,774,774,772,119,119,119,119,119,119,119,119,119,

/* block 167 */
775,775,776,777,777,777,777,777,777,777,777,777,777,777,777,777,
777,777,777,777,777,777,777,777,777,777,777,777,777,777,777,777,
777,777,777,777,777,777,777,777,777,777,777,777,777,777,777,777,
777,777,777,776,776,776,775,775,775,775,775,775,775,775,775,776,
776,777,778,778,777,779,779,779,779,775,775,775,775,779,119,119,
780,780,780,780,780,780,780,780,780,780,777,779,777,779,779,779,
119,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,119,119,119,119,119,119,119,119,119,119,119,

/* block 168 */
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,119,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,783,783,783,784,
784,784,783,783,784,783,784,784,785,785,785,785,785,785,784,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 169 */
786,786,786,786,786,786,786,119,786,119,786,786,786,786,119,786,
786,786,786,786,786,786,786,786,786,786,786,786,786,786,119,786,
786,786,786,786,786,786,786,786,786,787,119,119,119,119,119,119,
788,788,788,788,788,788,788,788,788,788,788,788,788,788,788,788,
788,788,788,788,788,788,788,788,788,788,788,788,788,788,788,788,
788,788,788,788,788,788,788,788,788,788,788,788,788,788,788,789,
790,790,790,789,789,789,789,789,789,789,789,119,119,119,119,119,
791,791,791,791,791,791,791,791,791,791,119,119,119,119,119,119,

/* block 170 */
792,793,794,795,119,796,796,796,796,796,796,796,796,119,119,796,
796,119,119,796,796,796,796,796,796,796,796,796,796,796,796,796,
796,796,796,796,796,796,796,796,796,119,796,796,796,796,796,796,
796,119,796,796,119,796,796,796,796,796,119,797,793,796,798,794,
792,794,794,794,794,119,119,794,794,119,119,794,794,794,119,119,
796,119,119,119,119,119,119,798,119,119,119,119,119,796,796,796,
796,796,794,794,119,119,792,792,792,792,792,792,792,119,119,119,
792,792,792,792,792,119,119,119,119,119,119,119,119,119,119,119,

/* block 171 */
799,799,799,799,799,799,799,799,799,799,799,799,799,799,799,799,
799,799,799,799,799,799,799,799,799,799,799,799,799,799,799,799,
799,799,799,799,799,799,799,799,799,799,799,799,799,799,799,799,
799,799,799,799,799,800,800,800,801,801,801,801,801,801,801,801,
800,800,801,801,801,800,801,799,799,799,799,802,802,802,802,802,
803,803,803,803,803,803,803,803,803,803,119,802,119,802,801,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 172 */
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
805,806,806,807,807,807,807,807,807,806,807,806,806,805,806,807,
807,806,807,807,804,804,808,804,119,119,119,119,119,119,119,119,
809,809,809,809,809,809,809,809,809,809,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 173 */
810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,
810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,
810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,811,
812,812,813,813,813,813,119,119,812,812,812,812,813,813,812,813,
813,814,814,814,814,814,814,814,814,814,814,814,814,814,814,814,
814,814,814,814,814,814,814,814,810,810,810,810,813,813,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 174 */
815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,
815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,
815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,
816,816,816,817,817,817,817,817,817,817,817,816,816,817,816,817,
817,818,818,818,815,119,119,119,119,119,119,119,119,119,119,119,
819,819,819,819,819,819,819,819,819,819,119,119,119,119,119,119,
392,392,392,392,392,392,392,392,392,392,392,392,392,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 175 */
820,820,820,820,820,820,820,820,820,820,820,820,820,820,820,820,
820,820,820,820,820,820,820,820,820,820,820,820,820,820,820,820,
820,820,820,820,820,820,820,820,820,820,820,821,822,821,822,822,
821,821,821,821,821,821,822,821,119,119,119,119,119,119,119,119,
823,823,823,823,823,823,823,823,823,823,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 176 */
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,119,119,825,825,825,
826,826,825,825,825,825,826,825,825,825,825,825,119,119,119,119,
827,827,827,827,827,827,827,827,827,827,828,828,829,829,829,830,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 177 */
831,831,831,831,831,831,831,831,831,831,831,831,831,831,831,831,
831,831,831,831,831,831,831,831,831,831,831,831,831,831,831,831,
831,831,831,831,831,831,831,831,831,831,831,831,832,832,832,833,
833,833,833,833,833,833,833,833,832,833,833,834,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 178 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
835,835,835,835,835,835,835,835,835,835,835,835,835,835,835,835,
835,835,835,835,835,835,835,835,835,835,835,835,835,835,835,835,
836,836,836,836,836,836,836,836,836,836,836,836,836,836,836,836,
836,836,836,836,836,836,836,836,836,836,836,836,836,836,836,836,
837,837,837,837,837,837,837,837,837,837,838,838,838,838,838,838,
838,838,838,119,119,119,119,119,119,119,119,119,119,119,119,839,

/* block 179 */
840,841,841,841,841,841,841,841,841,841,841,840,840,840,840,840,
840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,
840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,
840,840,840,841,841,841,841,841,841,842,843,841,841,841,841,844,
844,844,844,844,844,844,844,841,119,119,119,119,119,119,119,119,
845,846,846,846,846,846,846,847,847,846,846,846,845,845,845,845,
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,

/* block 180 */
845,845,845,845,119,119,848,848,848,848,846,846,846,846,846,846,
846,846,846,846,846,846,846,847,846,846,849,849,849,845,849,849,
849,849,849,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,
850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,
850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,
850,850,850,850,850,850,850,850,850,119,119,119,119,119,119,119,

/* block 181 */
851,851,851,851,851,851,851,851,851,119,851,851,851,851,851,851,
851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,
851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,852,
853,853,853,853,853,853,853,119,853,853,853,853,853,853,852,853,
851,854,854,854,854,854,119,119,119,119,119,119,119,119,119,119,
855,855,855,855,855,855,855,855,855,855,856,856,856,856,856,856,
856,856,856,856,856,856,856,856,856,856,856,856,856,119,119,119,
857,857,858,858,858,858,858,858,858,858,858,858,858,858,858,858,

/* block 182 */
858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,
119,119,859,859,859,859,859,859,859,859,859,859,859,859,859,859,
859,859,859,859,859,859,859,859,119,860,859,859,859,859,859,859,
859,860,859,859,860,859,859,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 183 */
861,861,861,861,861,861,861,119,861,861,119,861,861,861,861,861,
861,861,861,861,861,861,861,861,861,861,861,861,861,861,861,861,
861,861,861,861,861,861,861,861,861,861,861,861,861,861,861,861,
861,862,862,862,862,862,862,119,119,119,862,119,862,862,119,862,
862,862,862,862,862,862,863,862,119,119,119,119,119,119,119,119,
864,864,864,864,864,864,864,864,864,864,119,119,119,119,119,119,
865,865,865,865,865,865,119,865,865,119,865,865,865,865,865,865,
865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,

/* block 184 */
865,865,865,865,865,865,865,865,865,865,866,866,866,866,866,119,
867,867,119,866,866,867,866,867,865,119,119,119,119,119,119,119,
868,868,868,868,868,868,868,868,868,868,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 185 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
869,869,869,869,869,869,869,869,869,869,869,869,869,869,869,869,
869,869,869,870,870,871,871,872,872,119,119,119,119,119,119,119,

/* block 186 */
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,

/* block 187 */
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 188 */
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,874,874,119,
875,875,875,875,875,119,119,119,119,119,119,119,119,119,119,119,

/* block 189 */
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,873,
873,873,873,873,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 190 */
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,

/* block 191 */
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 192 */
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,

/* block 193 */
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 194 */
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,

/* block 195 */
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,119,119,119,119,119,119,119,
878,878,878,878,878,878,878,878,878,878,878,878,878,878,878,878,
878,878,878,878,878,878,878,878,878,878,878,878,878,878,878,119,
879,879,879,879,879,879,879,879,879,879,119,119,119,119,880,880,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 196 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
881,881,881,881,881,881,881,881,881,881,881,881,881,881,881,881,
881,881,881,881,881,881,881,881,881,881,881,881,881,881,119,119,
882,882,882,882,882,883,119,119,119,119,119,119,119,119,119,119,

/* block 197 */
884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,
884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,
884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,
885,885,885,885,885,885,885,886,886,886,886,886,887,887,887,887,
888,888,888,888,886,887,119,119,119,119,119,119,119,119,119,119,
889,889,889,889,889,889,889,889,889,889,119,890,890,890,890,890,
890,890,119,884,884,884,884,884,884,884,884,884,884,884,884,884,
884,884,884,884,884,884,884,884,119,119,119,119,119,884,884,884,

/* block 198 */
884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,884,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 199 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,
892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,

/* block 200 */
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,894,894,894,894,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 201 */
895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,
895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,
895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,
895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,895,
895,895,895,895,895,119,119,119,119,119,119,119,119,119,119,119,
895,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,119,

/* block 202 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,897,
897,897,897,898,898,898,898,898,898,898,898,898,898,898,898,898,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
899,900,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 203 */
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,

/* block 204 */
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 205 */
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 206 */
569,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,

/* block 207 */
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,

/* block 208 */
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,
564,564,564,564,564,564,564,564,564,564,564,564,564,564,564,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,

/* block 209 */
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,

/* block 210 */
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,119,119,119,119,

/* block 211 */
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,119,119,119,119,119,
903,903,903,903,903,903,903,903,903,903,903,903,903,119,119,119,

/* block 212 */
903,903,903,903,903,903,903,903,903,119,119,119,119,119,119,119,
903,903,903,903,903,903,903,903,903,903,119,119,904,905,905,906,
907,907,907,907,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 213 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,119,119,119,119,119,119,119,119,119,119,

/* block 214 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,119,119, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20,908,909,112,112,112, 20, 20, 20,909,908,908,
908,908,908, 24, 24, 24, 24, 24, 24, 24, 24,112,112,112,112,112,

/* block 215 */
112,112,112, 20, 20,112,112,112,112,112,112,112, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,112,112,112,112, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 216 */
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,910,910,910,671,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 217 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 218 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,119,119,119,119,119,119,119,119,119,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573, 25, 25, 25, 25, 25, 25, 25,119,119,119,119,119,119,119,

/* block 219 */
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,505,505,
505,505,505,505,505,119,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,

/* block 220 */
504,504,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,504,119,504,504,
119,119,504,119,119,504,504,119,119,504,504,504,504,119,504,504,
504,504,504,504,504,504,505,505,505,505,119,505,119,505,505,505,
505,505,505,505,119,505,505,505,505,505,505,505,505,505,505,505,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,

/* block 221 */
505,505,505,505,504,504,119,504,504,504,504,119,119,504,504,504,
504,504,504,504,504,119,504,504,504,504,504,504,504,119,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,504,504,119,504,504,504,504,119,
504,504,504,504,504,119,504,119,119,119,504,504,504,504,504,504,
504,119,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,

/* block 222 */
504,504,504,504,504,504,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,

/* block 223 */
505,505,505,505,505,505,505,505,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,

/* block 224 */
504,504,504,504,504,504,504,504,504,504,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,119,119,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,  9,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,  9,505,505,505,505,
505,505,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,  9,505,505,505,505,

/* block 225 */
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,  9,505,505,505,505,505,505,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,  9,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,  9,
505,505,505,505,505,505,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,  9,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,

/* block 226 */
505,505,505,505,505,505,505,505,505,  9,505,505,505,505,505,505,
504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,504,
504,504,504,504,504,504,504,504,504,  9,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,  9,505,505,505,505,505,505,504,505,119,119, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,

/* block 227 */
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,

/* block 228 */
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
912,912,912,912,912,912,912,911,911,911,911,912,912,912,912,912,
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
912,912,912,912,912,912,912,912,912,912,912,912,912,911,911,911,
911,911,911,911,911,912,911,911,911,911,911,911,911,911,911,911,

/* block 229 */
911,911,911,911,912,911,911,913,913,913,913,913,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,912,912,912,912,912,
119,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 230 */
914,914,914,914,914,914,914,119,914,914,914,914,914,914,914,914,
914,914,914,914,914,914,914,914,914,119,119,914,914,914,914,914,
914,914,119,914,914,119,914,914,914,914,914,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 231 */
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,

/* block 232 */
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,915,915,119,119,916,916,916,916,916,916,916,916,916,
917,917,917,917,917,917,917,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 233 */
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,919,919,919,919,919,919,919,919,919,919,919,919,919,919,
919,919,919,919,919,919,919,919,919,919,919,919,919,919,919,919,
919,919,919,919,920,920,920,920,920,920,920,119,119,119,119,119,
921,921,921,921,921,921,921,921,921,921,119,119,119,119,922,922,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 234 */
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 235 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 25, 25, 25,
  6, 25, 25, 25, 25,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 236 */
224,224,224,224,119,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
119,224,224,119,224,119,119,224,119,224,224,224,224,224,224,224,
224,224,224,119,224,224,224,224,119,224,119,224,119,119,119,119,
119,119,224,119,119,119,119,224,119,224,119,224,119,224,224,224,
119,224,224,119,224,119,119,224,119,224,119,224,119,224,119,224,
119,224,224,119,224,119,119,224,224,224,224,119,224,224,224,224,
224,224,224,119,224,224,224,224,119,224,224,224,224,119,224,119,

/* block 237 */
224,224,224,224,224,224,224,224,224,224,119,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,119,119,119,119,
119,224,224,224,119,224,224,224,224,224,119,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
217,217,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 238 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 239 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21,923,923,923,923,923,923,923,923,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,923,
923, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
923, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
923, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21,923,923,923,923,923,923,923,923,923,923,

/* block 240 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,
 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21,

/* block 241 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 20,
 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,

/* block 242 */
925, 21, 21,923,923,923,923,923,923,923,923,923,923,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20,923,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,923,923,923,
575,575,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
 21, 21, 21, 21, 21, 21,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 243 */
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 244 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 245 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,926,926,926,926,926,

/* block 246 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20,
 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 247 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 248 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21,923,923,923,923,923,923,923,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,923,923,923,923,923,923,

/* block 249 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 250 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 21, 21, 21, 21,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 251 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,923,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 252 */
 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,923,923,923,923,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 253 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 21, 21, 21,923,
 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21,923,923, 21, 21, 21, 21,923,923,923, 21,923, 21, 21, 21, 21,

/* block 254 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21,923,923,923,923,923,923,923,923,923,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,923,923,923,923,923,923,
 21, 21, 21,923,923,923,923,923,923,923,923,923,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 255 */
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 256 */
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,119,119,

/* block 257 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 258 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,119,119,119,119,119,119,119,119,119,119,119,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,

/* block 259 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,119,119,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,

/* block 260 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,

/* block 261 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 262 */
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,

/* block 263 */
502, 24,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,
927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,
927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,
927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,
927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,
927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,927,

/* block 264 */
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,

/* block 265 */
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,

/* block 266 */
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,502,

/* block 267 */
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,659,
659,659,659,659,659,659,659,659,659,659,659,659,659,659,119,119,

};

#if UCD_BLOCK_SIZE != 128
#error Please correct UCD_BLOCK_SIZE in pcre2_internal.h
#endif
#endif  /* SUPPORT_UNICODE */

#endif  /* PCRE2_PCRE2TEST */
