# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'icudata',
      'type': 'none',
      'direct_dependent_settings': {
        'cflags': [
          '<!@(pkg-config --cflags icu-uc)',
        ],
        'defines': [
          'U_USING_ICU_NAMESPACE=0',
        ],
      },
      'link_settings': {
        'ldflags': [
          '<!@(pkg-config --libs-only-L --libs-only-other icu-uc)',
        ],
        'libraries': [
          '<!@(pkg-config --libs-only-l icu-uc)',
        ],
      },
    },
    {
      'target_name': 'icui18n',
      'type': 'none',
      'toolsets': ['host', 'target'],
      'direct_dependent_settings': {
        'cflags': [
          '<!@(pkg-config --cflags icu-i18n)',
        ],
        'defines': [
          'U_USING_ICU_NAMESPACE=0',
        ],
      },
      'link_settings': {
        'ldflags': [
          '<!@(pkg-config --libs-only-L --libs-only-other icu-i18n)',
        ],
        'libraries': [
          '<!@(pkg-config --libs-only-l icu-i18n)',
        ],
      },
      'variables': {
        'headers_root_path': 'source/i18n',
        'header_filenames': [
          # This list can easily be updated using the command below:
          # find third_party/icu/source/i18n/unicode -iname '*.h' \
          # -printf "'%p',\n" | \
          # sed -e 's|third_party/icu/source/i18n/||' | sort -u
          'unicode/basictz.h',
          'unicode/bmsearch.h',
          'unicode/bms.h',
          'unicode/calendar.h',
          'unicode/choicfmt.h',
          'unicode/coleitr.h',
          'unicode/colldata.h',
          'unicode/coll.h',
          'unicode/curramt.h',
          'unicode/currpinf.h',
          'unicode/currunit.h',
          'unicode/datefmt.h',
          'unicode/dcfmtsym.h',
          'unicode/decimfmt.h',
          'unicode/dtfmtsym.h',
          'unicode/dtitvfmt.h',
          'unicode/dtitvinf.h',
          'unicode/dtptngen.h',
          'unicode/dtrule.h',
          'unicode/fieldpos.h',
          'unicode/fmtable.h',
          'unicode/format.h',
          'unicode/fpositer.h',
          'unicode/gregocal.h',
          'unicode/locdspnm.h',
          'unicode/measfmt.h',
          'unicode/measunit.h',
          'unicode/measure.h',
          'unicode/msgfmt.h',
          'unicode/numfmt.h',
          'unicode/numsys.h',
          'unicode/plurfmt.h',
          'unicode/plurrule.h',
          'unicode/rbnf.h',
          'unicode/rbtz.h',
          'unicode/regex.h',
          'unicode/search.h',
          'unicode/selfmt.h',
          'unicode/simpletz.h',
          'unicode/smpdtfmt.h',
          'unicode/sortkey.h',
          'unicode/stsearch.h',
          'unicode/tblcoll.h',
          'unicode/timezone.h',
          'unicode/tmunit.h',
          'unicode/tmutamt.h',
          'unicode/tmutfmt.h',
          'unicode/translit.h',
          'unicode/tzrule.h',
          'unicode/tztrans.h',
          'unicode/ucal.h',
          'unicode/ucoleitr.h',
          'unicode/ucol.h',
          'unicode/ucsdet.h',
          'unicode/ucurr.h',
          'unicode/udat.h',
          'unicode/udatpg.h',
          'unicode/uldnames.h',
          'unicode/ulocdata.h',
          'unicode/umsg.h',
          'unicode/unirepl.h',
          'unicode/unum.h',
          'unicode/uregex.h',
          'unicode/usearch.h',
          'unicode/uspoof.h',
          'unicode/utmscale.h',
          'unicode/utrans.h',
          'unicode/vtzone.h',
        ],
      },
      'includes': [
        '../../build/shim_headers.gypi',
      ],
    },
    {
      'target_name': 'icuuc',
      'type': 'none',
      'toolsets': ['host', 'target'],
      'direct_dependent_settings': {
        'cflags': [
          '<!@(pkg-config --cflags icu-uc)',
        ],
        'defines': [
          'U_USING_ICU_NAMESPACE=0',
        ],
      },
      'link_settings': {
        'ldflags': [
          '<!@(pkg-config --libs-only-L --libs-only-other icu-uc)',
        ],
        'libraries': [
          '<!@(pkg-config --libs-only-l icu-uc)',
        ],
      },
      'variables': {
        'headers_root_path': 'source/common',
        'header_filenames': [
          # This list can easily be updated using the command below:
          # find third_party/icu/source/common/unicode -iname '*.h' \
          # -printf "'%p',\n" | \
          # sed -e 's|third_party/icu/source/common/||' | sort -u
          'unicode/brkiter.h',
          'unicode/bytestream.h',
          'unicode/caniter.h',
          'unicode/chariter.h',
          'unicode/dbbi.h',
          'unicode/docmain.h',
          'unicode/dtintrv.h',
          'unicode/errorcode.h',
          'unicode/icudataver.h',
          'unicode/icuplug.h',
          'unicode/idna.h',
          'unicode/localpointer.h',
          'unicode/locid.h',
          'unicode/normalizer2.h',
          'unicode/normlzr.h',
          'unicode/pandroid.h',
          'unicode/parseerr.h',
          'unicode/parsepos.h',
          'unicode/pfreebsd.h',
          'unicode/plinux.h',
          'unicode/pmac.h',
          'unicode/popenbsd.h',
          'unicode/ppalmos.h',
          'unicode/ptypes.h',
          'unicode/putil.h',
          'unicode/pwin32.h',
          'unicode/rbbi.h',
          'unicode/rep.h',
          'unicode/resbund.h',
          'unicode/schriter.h',
          'unicode/std_string.h',
          'unicode/strenum.h',
          'unicode/stringpiece.h',
          'unicode/symtable.h',
          'unicode/ubidi.h',
          'unicode/ubrk.h',
          'unicode/ucasemap.h',
          'unicode/ucat.h',
          'unicode/uchar.h',
          'unicode/uchriter.h',
          'unicode/uclean.h',
          'unicode/ucnv_cb.h',
          'unicode/ucnv_err.h',
          'unicode/ucnv.h',
          'unicode/ucnvsel.h',
          'unicode/uconfig.h',
          'unicode/udata.h',
          'unicode/udeprctd.h',
          'unicode/udraft.h',
          'unicode/uenum.h',
          'unicode/uidna.h',
          'unicode/uintrnal.h',
          'unicode/uiter.h',
          'unicode/uloc.h',
          'unicode/umachine.h',
          'unicode/umisc.h',
          'unicode/unifilt.h',
          'unicode/unifunct.h',
          'unicode/unimatch.h',
          'unicode/uniset.h',
          'unicode/unistr.h',
          'unicode/unorm2.h',
          'unicode/unorm.h',
          'unicode/uobject.h',
          'unicode/uobslete.h',
          'unicode/urename.h',
          'unicode/urep.h',
          'unicode/ures.h',
          'unicode/uscript.h',
          'unicode/uset.h',
          'unicode/usetiter.h',
          'unicode/ushape.h',
          'unicode/usprep.h',
          'unicode/ustring.h',
          'unicode/usystem.h',
          'unicode/utext.h',
          'unicode/utf16.h',
          'unicode/utf32.h',
          'unicode/utf8.h',
          'unicode/utf.h',
          'unicode/utf_old.h',
          'unicode/utrace.h',
          'unicode/utypeinfo.h',
          'unicode/utypes.h',
          'unicode/uvernum.h',
          'unicode/uversion.h',
        ],
      },
      'includes': [
        '../../build/shim_headers.gypi',
      ],
    },
  ],
}
