/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.Assignment;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import com.google.javascript.rhino.head.ast.Name;
import com.google.javascript.rhino.head.ast.ObjectProperty;
import com.google.javascript.rhino.head.ast.VariableInitializer;

public class AstUtil {
    private static final String PROTOTYPE_SUFFIX = ".prototype";

    static AstNode parentOfType(AstNode astNode, int n) {
        AstNode astNode2 = astNode.getParent();
        return astNode2 == null || astNode2.getType() != n ? null : astNode2;
    }

    static AstNode getFunctionNameNode(FunctionNode functionNode) {
        Name name = functionNode.getFunctionName();
        if (name != null) {
            return name;
        }
        AstNode astNode = functionNode.getParent();
        block5: while (astNode != null) {
            switch (astNode.getType()) {
                case 103: {
                    return ((ObjectProperty)astNode).getLeft();
                }
                case 90: {
                    Assignment assignment = (Assignment)astNode;
                    if (assignment.getRight() == functionNode && assignment.getLeft().getType() == 39) {
                        return assignment.getLeft();
                    }
                    astNode = assignment.getParent();
                    continue block5;
                }
                case 122: {
                    return ((VariableInitializer)astNode).getTarget();
                }
            }
            return null;
        }
        return null;
    }

    static String getTypeNameFromPrototype(String string) {
        return string.substring(0, string.length() - PROTOTYPE_SUFFIX.length());
    }

    static boolean isPrototypeName(String string) {
        return string.endsWith(PROTOTYPE_SUFFIX);
    }

    static AstNode getAssignedTypeNameNode(Assignment assignment) {
        AstNode astNode = assignment.getLeft();
        if (astNode.getType() != 33 && astNode.getType() != 39) {
            return null;
        }
        return astNode;
    }

    static Comment getJsDocNode(AstNode astNode) {
        if (astNode.getType() == 109) {
            return AstUtil.getJsDocNode((FunctionNode)astNode);
        }
        return astNode.getJsDocNode();
    }

    static Comment getJsDocNode(FunctionNode functionNode) {
        Comment comment = functionNode.getJsDocNode();
        if (comment != null) {
            return comment;
        }
        AstNode astNode = functionNode.getParent();
        block5: while (astNode != null) {
            switch (astNode.getType()) {
                case 103: {
                    return ((ObjectProperty)astNode).getLeft().getJsDocNode();
                }
                case 90: {
                    Assignment assignment = (Assignment)astNode;
                    if (assignment.getJsDocNode() != null) {
                        return assignment.getJsDocNode();
                    }
                    astNode = assignment.getParent();
                    continue block5;
                }
                case 122: {
                    return astNode.getParent().getJsDocNode();
                }
            }
            return null;
        }
        return null;
    }

    private AstUtil() {
    }
}

