/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineWrappingHandler;

public class MethodCallHandler
extends ExpressionHandler {
    public MethodCallHandler(IndentationCheck aIndentCheck, DetailAST aAST, ExpressionHandler aParent) {
        super(aIndentCheck, aAST.getType() == 27 ? "method call" : "ctor call", aAST, aParent);
    }

    protected IndentLevel getLevelImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)this.getParent();
            if (container != null) {
                if (MethodCallHandler.areOnSameLine(container.getMainAst(), this.getMainAst())) {
                    return container.getLevel();
                }
                DetailAST main = this.getMainAst();
                DetailAST dot = main.getFirstChild();
                DetailAST target = dot.getFirstChild();
                if (dot.getType() == 60 && target.getType() == 27) {
                    DetailAST dot1 = target.getFirstChild();
                    DetailAST target1 = dot1.getFirstChild();
                    if (dot1.getType() == 60 && target1.getType() == 27) {
                        return container.getLevel();
                    }
                }
                return new IndentLevel(container.getLevel(), this.getBasicOffset());
            }
            ExpressionHandler p = this.getParent();
            while (p instanceof MethodCallHandler) {
                p = p.getParent();
            }
            return p.suggestedChildLevel(this);
        }
        LineSet lines = new LineSet();
        this.findSubtreeLines(lines, this.getMainAst().getFirstChild(), true);
        int firstCol = lines.firstLineCol();
        int lineStart = this.getLineStart(this.getFirstAst(this.getMainAst()));
        if (lineStart != firstCol) {
            return new IndentLevel(lineStart);
        }
        return super.getLevelImpl();
    }

    private DetailAST getFirstAst(DetailAST aAst) {
        DetailAST ast;
        for (ast = aAst.getFirstChild(); ast != null && ast.getType() == 60; ast = ast.getFirstChild()) {
        }
        if (ast == null) {
            ast = aAst;
        }
        return ast;
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler aChild) {
        DetailAST first = this.getMainAst().getFirstChild();
        int indentLevel = this.getLineStart(first);
        if (!MethodCallHandler.areOnSameLine(aChild.getMainAst().getFirstChild(), this.getMainAst().getFirstChild())) {
            indentLevel += this.getBasicOffset();
        }
        return new IndentLevel(indentLevel);
    }

    public void checkIndentation() {
        DetailAST exprNode = this.getMainAst().getParent();
        if (exprNode.getParent().getType() != 73 && exprNode.getParent().getType() != 7) {
            return;
        }
        DetailAST methodName = this.getMainAst().getFirstChild();
        this.checkExpressionSubtree(methodName, this.getLevel(), false, false);
        DetailAST lparen = this.getMainAst();
        DetailAST rparen = this.getMainAst().findFirstToken(78);
        this.checkLParen(lparen);
        if (rparen.getLineNo() == lparen.getLineNo()) {
            return;
        }
        this.checkExpressionSubtree(this.getMainAst().findFirstToken(35), new IndentLevel(this.getLevel(), this.getBasicOffset()), false, true);
        this.checkRParen(lparen, rparen);
        LineWrappingHandler lineWrap = new LineWrappingHandler(this.getIndentCheck(), this.getMainAst()){

            public DetailAST findLastNode(DetailAST aFirstNode) {
                DetailAST lastNode = this.getFirstNode().getNextSibling() == null ? this.getFirstNode().getLastChild() : this.getFirstNode().getNextSibling();
                return lastNode;
            }

            public int getCurrentIndentation() {
                DetailAST curNode = this.getFirstNode();
                while (curNode.getType() != 59) {
                    curNode = curNode.getFirstChild();
                }
                return curNode.getColumnNo() + this.getIndentLevel();
            }
        };
        lineWrap.checkIndentation();
    }

    protected boolean shouldIncreaseIndent() {
        return false;
    }
}

