/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;

public class DesignForExtensionCheck
extends Check {
    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST aAST) {
        if (ScopeUtils.inInterfaceOrAnnotationBlock(aAST)) {
            return;
        }
        DetailAST modifiers = aAST.findFirstToken(5);
        if (modifiers.branchContains(62) || modifiers.branchContains(41) || modifiers.branchContains(40) || modifiers.branchContains(65)) {
            return;
        }
        if (!ScopeUtils.getSurroundingScope(aAST).isIn(Scope.PROTECTED)) {
            return;
        }
        DetailAST implementation = aAST.findFirstToken(7);
        if (implementation != null && implementation.getFirstChild().getType() == 74) {
            return;
        }
        DetailAST classDef = this.findContainingClass(aAST);
        DetailAST classMods = classDef.findFirstToken(5);
        if (classDef.getType() == 156 || classMods.branchContains(40)) {
            return;
        }
        DetailAST objBlock = classDef.findFirstToken(6);
        boolean hasDefaultConstructor = true;
        boolean hasExplNonPrivateCtor = false;
        for (DetailAST candidate = objBlock.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            if (candidate.getType() != 8) continue;
            hasDefaultConstructor = false;
            DetailAST ctorMods = candidate.findFirstToken(5);
            if (ctorMods.branchContains(62)) continue;
            hasExplNonPrivateCtor = true;
            break;
        }
        if (hasDefaultConstructor || hasExplNonPrivateCtor) {
            String name = aAST.findFirstToken(59).getText();
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "design.forExtension", name);
        }
    }

    private DetailAST findContainingClass(DetailAST aAST) {
        DetailAST searchAST = aAST;
        while (searchAST.getType() != 14 && searchAST.getType() != 156) {
            searchAST = searchAST.getParent();
        }
        return searchAST;
    }
}

