// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_BASE_NETWORK_CHANGE_NOTIFIER_LINUX_H_
#define NET_BASE_NETWORK_CHANGE_NOTIFIER_LINUX_H_

#include "base/basictypes.h"
#include "base/compiler_specific.h"
#include "base/memory/scoped_ptr.h"
#include "net/base/net_export.h"
#include "net/base/network_change_notifier.h"

namespace net {

class NET_EXPORT_PRIVATE NetworkChangeNotifierLinux
    : public NetworkChangeNotifier {
 public:
  static NetworkChangeNotifierLinux* Create();

 private:
  class Thread;

  NetworkChangeNotifierLinux();
  ~NetworkChangeNotifierLinux() override;
  static NetworkChangeCalculatorParams NetworkChangeCalculatorParamsLinux();

  // NetworkChangeNotifier:
  ConnectionType GetCurrentConnectionType() const override;

  const internal::AddressTrackerLinux* GetAddressTrackerInternal()
      const override;

  // The thread used to listen for notifications.  This relays the notification
  // to the registered observers without posting back to the thread the object
  // was created on.
  // Also used for DnsConfigService which requires TYPE_IO message loop.
  scoped_ptr<Thread> notifier_thread_;

  DISALLOW_COPY_AND_ASSIGN(NetworkChangeNotifierLinux);
};

}  // namespace net

#endif  // NET_BASE_NETWORK_CHANGE_NOTIFIER_LINUX_H_
