

(function() {

  Polymer({

    is: 'paper-input-char-counter',

    behaviors: [
      Polymer.PaperInputAddonBehavior
    ],

    properties: {

      _charCounterStr: {
        type: String,
        value: '0'
      }

    },

    update: function(state) {
      if (!state.inputElement) {
        return;
      }

      state.value = state.value || '';

      // Account for the textarea's new lines.
      var str = state.value.replace(/(\r\n|\n|\r)/g, '--').length;

      if (state.inputElement.hasAttribute('maxlength')) {
        str += '/' + state.inputElement.getAttribute('maxlength');
      }
      this._charCounterStr = str;
    }

  });

})();

