/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public class PackageNameCheck
extends AbstractFormatCheck {
    public PackageNameCheck() {
        super("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{16};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        FullIdent full = FullIdent.createFullIdent(nameAST);
        if (!this.getRegexp().matcher(full.getText()).find()) {
            this.log(full.getLineNo(), full.getColumnNo(), "name.invalidPattern", full.getText(), this.getFormat());
        }
    }
}

